/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.AbstractBidib;
import org.bidib.jbidibc.core.BidibInterface;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.NodeListener;
import org.bidib.jbidibc.core.node.NodeRegistry;
import org.bidib.jbidibc.core.node.RootNode;
import org.bidib.jbidibc.core.node.listener.TransferListener;
import org.bidib.jbidibc.messages.ConnectionListener;
import org.bidib.jbidibc.messages.MessageReceiver;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.ProtocolVersion;
import org.bidib.jbidibc.messages.base.AbstractBaseBidib;
import org.bidib.jbidibc.messages.base.RawMessageListener;
import org.bidib.jbidibc.messages.enums.NetBidibRole;
import org.bidib.jbidibc.messages.enums.NetBidibSocketType;
import org.bidib.jbidibc.messages.enums.PairingResult;
import org.bidib.jbidibc.messages.exception.EstablishCommunicationFailedException;
import org.bidib.jbidibc.messages.exception.NoAnswerException;
import org.bidib.jbidibc.messages.exception.PairingFailedException;
import org.bidib.jbidibc.messages.exception.PortNotFoundException;
import org.bidib.jbidibc.messages.exception.PortNotOpenedException;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.message.BidibCommand;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.BidibResponseFactory;
import org.bidib.jbidibc.messages.message.LocalLogonRejectedMessage;
import org.bidib.jbidibc.messages.message.ResponseFactory;
import org.bidib.jbidibc.messages.message.netbidib.BidibLinkData;
import org.bidib.jbidibc.messages.message.netbidib.LocalLinkMessage;
import org.bidib.jbidibc.messages.message.netbidib.NetBidibLinkData;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.jbidibc.netbidib.client.DefaultNetMessageHandler;
import org.bidib.jbidibc.netbidib.client.NetBidibClientPort;
import org.bidib.jbidibc.netbidib.client.NetBidibPort;
import org.bidib.jbidibc.netbidib.client.NetMessageHandler;
import org.bidib.jbidibc.netbidib.client.NetMessageReceiver;
import org.bidib.jbidibc.netbidib.client.listener.NetBidibPortConnectionStatusListener;
import org.bidib.jbidibc.netbidib.client.pairingstates.DefaultPairingStateHandler;
import org.bidib.jbidibc.netbidib.client.pairingstates.NetBidibMessageSender;
import org.bidib.jbidibc.netbidib.client.pairingstates.PairingInteractionPublisher;
import org.bidib.jbidibc.netbidib.client.pairingstates.PairingStateHandler;
import org.bidib.jbidibc.netbidib.client.pairingstates.PairingStateInteractionHandler;
import org.bidib.jbidibc.netbidib.pairingstore.PairingStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetBidibClient
extends AbstractBidib<NetMessageReceiver> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetBidibClient.class);
    public static final int NET_BIDIB_PORT_NUMBER = 62875;
    private NetBidibPort port;
    private final Object portLock = new Object();
    private NetMessageHandler netMessageHandler;
    private final ScheduledExecutorService portWorker;
    private final ScheduledExecutorService logonReceivedPublisherWorker;
    private String connectedPortName;
    private InetAddress address;
    private int portNumber;
    private String protocol;
    private ConnectionListener connectionListenerDelegate;
    private NetConnector connector;
    private final NetBidibLinkData remotePartnerLinkData;
    private final NetBidibLinkData clientLinkData;
    private BidibResponseFactory responseFactory;
    private ByteArrayOutputStream output = new ByteArrayOutputStream(100);
    private PairingStateHandler netBidibPairingStateHandler;
    private static final Logger MSG_TX_LOGGER = LoggerFactory.getLogger((String)"TX");

    protected NetBidibClient() {
        LOGGER.info("Create new instance of plain tcp NetBidib.");
        this.clientLinkData = new NetBidibLinkData(NetBidibLinkData.PartnerType.LOCAL);
        this.remotePartnerLinkData = new NetBidibLinkData(NetBidibLinkData.PartnerType.REMOTE);
        this.portWorker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("portWorkers-thread-%d").build());
        this.logonReceivedPublisherWorker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("logonReceivedPublisherWorkers-thread-%d").build());
    }

    protected boolean isNetBidib() {
        return true;
    }

    protected NetMessageReceiver createMessageReceiver(NodeRegistry nodeRegistry, RawMessageListener rawMessageListener, Context context) {
        NetBidibMessageSender netBidibMessageSender = new NetBidibMessageSender(){

            @Override
            public void publishNetBidibMessage(BidibCommand message) throws ProtocolException {
                try {
                    NetBidibClient.this.sendNetBidibMessage(message);
                }
                catch (IOException ex) {
                    LOGGER.warn("Send the netBidibMessage failed.", (Throwable)ex);
                    throw new ProtocolException("Send the netBidibMessage failed.");
                }
            }
        };
        PairingInteractionPublisher pairingInteractionPublisher = new PairingInteractionPublisher(){

            @Override
            public void publishUserAction(String actionKey, Context context) {
                LOGGER.info("Publish the user action, actionKey: {}", (Object)actionKey);
                NetBidibClient.this.logonReceivedPublisherWorker.submit(() -> NetBidibClient.this.publishUserAction(actionKey, context));
            }

            @Override
            public void publishPairingFinished(PairingResult pairingResult, long uniqueId) {
                NetBidibClient.this.logonReceivedPublisherWorker.submit(() -> NetBidibClient.this.publishPairingFinished(pairingResult, uniqueId));
            }

            @Override
            public void publishLocalLogon(int localNodeAddr, long uniqueId) {
                LOGGER.info("Publish the logon received from a different thread, localNodeAddr: {}, uniqueId: {}", (Object)localNodeAddr, (Object)ByteUtils.formatHexUniqueId((long)uniqueId));
                NetBidibClient.this.logonReceivedPublisherWorker.submit(() -> NetBidibClient.this.publishLogonReceived(localNodeAddr, uniqueId));
            }

            @Override
            public void publishLocalLogoff(long uniqueId) {
                LOGGER.info("Publish the logoff received from a different thread.");
                NetBidibClient.this.logonReceivedPublisherWorker.submit(() -> NetBidibClient.this.publishLogoffReceived(uniqueId));
            }

            @Override
            public void handleError(RuntimeException ex) {
                NetBidibClient.this.logonReceivedPublisherWorker.submit(() -> NetBidibClient.this.handleError(ex));
            }
        };
        this.netBidibPairingStateHandler = new DefaultPairingStateHandler(netBidibMessageSender, pairingInteractionPublisher, this.getRequestFactory());
        PairingStore pairingStore = (PairingStore)context.get("pairingStore", PairingStore.class, null);
        this.netBidibPairingStateHandler.initialize((BidibLinkData)this.remotePartnerLinkData, (BidibLinkData)this.clientLinkData, pairingStore);
        NetMessageReceiver messageReceiver = new NetMessageReceiver(nodeRegistry, (ResponseFactory)this.responseFactory, false);
        messageReceiver.setNetBidibLocalMessageListener(this.netBidibPairingStateHandler);
        messageReceiver.setRawMessageListener(rawMessageListener);
        messageReceiver.init(context);
        return messageReceiver;
    }

    public void setConnectionListener(final ConnectionListener connectionListener) {
        this.connectionListenerDelegate = new ConnectionListener(){

            public void status(String messageKey, Context context) {
                LOGGER.info("The status was signalled: {}, context: {}", (Object)messageKey, (Object)context);
                connectionListener.status(messageKey, context);
            }

            public void actionRequired(String messageKey, Context context) {
                connectionListener.actionRequired(messageKey, context);
            }

            public void opened(String port) {
                LOGGER.info("The port of the netBiDiB connection was opened: {}", (Object)port);
                connectionListener.opened(port);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void closed(String portName) {
                LOGGER.info("The port was closed: {}", (Object)portName);
                connectionListener.closed(portName);
                LOGGER.info("Free the remotePartnerLinkData: {}", (Object)NetBidibClient.this.remotePartnerLinkData);
                NetBidibClient.this.remotePartnerLinkData.clear(true);
                NetBidibClient.this.clientLinkData.clear(true);
                Object object = NetBidibClient.this.portLock;
                synchronized (object) {
                    LOGGER.info("Release the port instance.");
                    NetBidibClient.this.port = null;
                }
            }

            public void stall(boolean stall) {
                connectionListener.stall(stall);
            }

            public void pairingFinished(PairingResult pairingResult, long uniqueId) {
                connectionListener.pairingFinished(pairingResult, uniqueId);
            }

            public void logonReceived(int localNodeAddr, long uniqueId) {
                LOGGER.info("The logon was received.");
                NetBidibClient.this.connector.logonReceived();
                connectionListener.logonReceived(localNodeAddr, uniqueId);
            }

            public void logoffReceived(long uniqueId) {
                LOGGER.info("The logoff was received, uniqueId: {}", (Object)ByteUtils.formatHexUniqueId((long)uniqueId));
                connectionListener.logoffReceived(uniqueId);
            }

            public void handleError(RuntimeException ex) {
                connectionListener.handleError(ex);
            }
        };
        super.setConnectionListener(this.connectionListenerDelegate);
    }

    public static BidibInterface createInstance(Context context) {
        LOGGER.info("Create new instance of NetBidibClient.");
        NetBidibClient instance = new NetBidibClient();
        instance.initialize(context);
        return instance;
    }

    public void initialize(Context context) {
        LOGGER.info("Initialize. Create the connector.");
        NetBidibLinkData providedClientLinkData = (NetBidibLinkData)context.get("netBidibClientLinkData", NetBidibLinkData.class, null);
        this.clientLinkData.setRequestorName("BiDiB-Wizard2-Client");
        byte[] uniqueId = new byte[]{0, 0, 13, -6, 1, 3, -13};
        this.clientLinkData.setUniqueId(Long.valueOf(ByteUtils.convertUniqueIdToLong((byte[])uniqueId)));
        this.clientLinkData.setProdString("BiDiB-Wizard-Client");
        this.clientLinkData.setUserString("Client");
        this.clientLinkData.setProtocolVersion(ProtocolVersion.VERSION_0_8);
        this.clientLinkData.setNetBidibRole(NetBidibRole.INTERFACE);
        this.clientLinkData.setRequestedPairingTimeout(Integer.valueOf(30));
        if (providedClientLinkData != null) {
            if (StringUtils.isNotBlank((CharSequence)providedClientLinkData.getRequestorName())) {
                this.clientLinkData.setRequestorName(providedClientLinkData.getRequestorName());
            }
            if (providedClientLinkData.getUniqueId() != null) {
                this.clientLinkData.setUniqueId(providedClientLinkData.getUniqueId());
            }
            if (StringUtils.isNotBlank((CharSequence)providedClientLinkData.getProdString())) {
                this.clientLinkData.setProdString(providedClientLinkData.getProdString());
            }
            if (StringUtils.isNotBlank((CharSequence)providedClientLinkData.getUserString())) {
                this.clientLinkData.setUserString(providedClientLinkData.getUserString());
            }
            if (providedClientLinkData.getProtocolVersion() != null) {
                this.clientLinkData.setProtocolVersion(providedClientLinkData.getProtocolVersion());
            }
            if (providedClientLinkData.getNetBidibRole() != null) {
                this.clientLinkData.setNetBidibRole(providedClientLinkData.getNetBidibRole());
            }
            if (providedClientLinkData.getRequestedPairingTimeout() != null) {
                this.clientLinkData.setRequestedPairingTimeout(providedClientLinkData.getRequestedPairingTimeout());
            }
        }
        this.responseFactory = new BidibResponseFactory();
        this.responseFactory.initialize();
        super.initialize(context);
        this.connector = new NetConnector();
        NetMessageReceiver messageReceiver = (NetMessageReceiver)this.getMessageReceiver();
        this.connector.setMessageReceiver((MessageReceiver)messageReceiver);
        this.initializeConnector(this.connector);
    }

    protected BidibRequestFactory createRequestFactory() {
        LOGGER.info("Create the BidibRequestFactory.");
        BidibRequestFactory bidibRequestFactory = new BidibRequestFactory();
        return bidibRequestFactory;
    }

    public void open(String portName, ConnectionListener connectionListener, Set<NodeListener> nodeListeners, Set<MessageListener> messageListeners, Set<TransferListener> transferListeners, Context context) throws PortNotFoundException, PortNotOpenedException {
        LOGGER.info("Open port: {}", portName);
        Integer netBidibPairingTimeout = this.clientLinkData.getRequestedPairingTimeout();
        if (netBidibPairingTimeout == null) {
            netBidibPairingTimeout = 30;
            LOGGER.info("The netBidibPairingTimeout is not provided. Set the default value: {}s", (Object)netBidibPairingTimeout);
        }
        this.setConnectionListener(connectionListener);
        this.registerListeners(nodeListeners, messageListeners, transferListeners);
        if (this.port == null) {
            LOGGER.info("Open port with name: {}", portName);
            if (portName == null || ((String)portName).trim().isEmpty()) {
                throw new PortNotFoundException("");
            }
            if (((String)portName).indexOf(":") < 0) {
                portName = (String)portName + ":62875";
                LOGGER.info("Added portnumber to portName: {}", portName);
            }
            this.netBidibPairingStateHandler.setNetBidibSocketType(NetBidibSocketType.clientSocket);
            try {
                this.connectedPortName = portName;
                this.port = this.internalOpen((String)portName, context);
                LOGGER.info("Port is opened, send the startup sequence. The connected port is: {}", (Object)this.connectedPortName);
                this.sendNetBidibStartupSequence(netBidibPairingTimeout);
                LOGGER.info("Startup sequence is finished. Notify the connection listener that we are finished.");
                this.getConnectionListener().opened((String)portName);
            }
            catch (PairingFailedException ex) {
                LOGGER.warn("Pairing with remote netBiDiB partner failed.", (Throwable)ex);
                this.close();
                throw ex;
            }
            catch (EstablishCommunicationFailedException ex) {
                LOGGER.warn("Establish communication with bidib interface failed.", (Throwable)ex);
                this.close();
                throw new PortNotOpenedException((String)portName, "establishCommunicationFailed").withFailureReason(PortNotOpenedException.FailureReason.ESTABLISH_COMMUNICATION_FAILED);
            }
            catch (ConnectException ex) {
                LOGGER.warn("Open port failed because connect failed.", (Throwable)ex);
                this.close();
                throw new PortNotOpenedException((String)portName, "connectFailed").withFailureReason(PortNotOpenedException.FailureReason.CONNECT_FAILED);
            }
            catch (SocketException | SocketTimeoutException | ProtocolException ex) {
                LOGGER.warn("Open port and send magic failed.", ex);
                this.close();
                throw new PortNotOpenedException((String)portName, ex.getMessage());
            }
            catch (Exception ex) {
                LOGGER.warn("Open port and send magic failed.", (Throwable)ex);
                this.close();
                throw new PortNotOpenedException((String)portName, "unknown");
            }
            LOGGER.info("Open port passed: {}", portName);
        } else {
            LOGGER.warn("Port is already opened.");
        }
    }

    protected void parsePortName(String portName) {
        int lastIndex = portName.lastIndexOf(":");
        if (lastIndex > -1) {
            this.portNumber = Integer.parseInt(portName.substring(lastIndex + 1));
            String prefix = portName.substring(0, lastIndex);
            LOGGER.info("Remaining prefix: {}", (Object)prefix);
            try {
                this.address = InetAddress.getByName(prefix);
            }
            catch (UnknownHostException ex) {
                LOGGER.warn("Parse IPv6 address failed from prefix: {}", (Object)prefix, (Object)ex);
                throw new IllegalArgumentException("Parse IPv6 address failed");
            }
        } else {
            throw new IllegalArgumentException("No valid IPv6 address provided");
        }
        this.protocol = "tcp";
    }

    private NetBidibPort internalOpen(String portName, Context context) throws IOException, PortNotOpenedException, PortNotFoundException {
        LOGGER.info("Internal open port: {}", (Object)portName);
        try {
            this.parsePortName(portName);
        }
        catch (Exception ex) {
            LOGGER.warn("Parse portName failed.", (Throwable)ex);
            String[] hostAndPort = portName.split(":");
            if (hostAndPort.length > 2) {
                this.protocol = hostAndPort[0];
                this.address = InetAddress.getByName(hostAndPort[1]);
                this.portNumber = Integer.parseInt(hostAndPort[2]);
            }
            this.protocol = "tcp";
            this.address = InetAddress.getByName(hostAndPort[0]);
            this.portNumber = Integer.parseInt(hostAndPort[1]);
        }
        LOGGER.info("Configured address: {}, portNumber: {}, protocol: {}", new Object[]{this.address, this.portNumber, this.protocol});
        this.connector.internalOpen(portName, context);
        NetMessageReceiver messageReceiver = (NetMessageReceiver)this.getMessageReceiver();
        messageReceiver.enable();
        this.netMessageHandler = new DefaultNetMessageHandler((MessageReceiver)messageReceiver, this.address, this.portNumber, this.connectionListenerDelegate);
        final CountDownLatch startupLock = new CountDownLatch(1);
        NetBidibClientPort netBidibPort = new NetBidibClientPort(this.address, this.portNumber, this.netMessageHandler);
        netBidibPort.addConnectionStatusListener(new NetBidibPortConnectionStatusListener(){

            @Override
            public void opened() {
                LOGGER.info("Opened with countDown latch.");
                startupLock.countDown();
            }

            @Override
            public void closed() {
                LOGGER.info("Connection is closed.");
            }

            @Override
            public void clientAccepted(String remoteAddress) {
                LOGGER.info("Client accepted, remoteAddress: {}", (Object)remoteAddress);
                try {
                    NetBidibClient.this.sendNetBidibStartupSequence(30);
                }
                catch (EstablishCommunicationFailedException ex) {
                    LOGGER.warn("Establish communication with bidib interface failed.", (Throwable)ex);
                }
                catch (PairingFailedException ex) {
                    LOGGER.warn("Pairing failed.", (Throwable)ex);
                }
                catch (ProtocolException ex) {
                    LOGGER.warn("Pairing failed.", (Throwable)ex);
                }
                catch (IOException ex) {
                    LOGGER.warn("Pairing failed.", (Throwable)ex);
                }
            }
        });
        LOGGER.info("Prepare and start the port worker for netBidibPort: {}", (Object)netBidibPort);
        this.connector.startReceiverAndQueues((MessageReceiver)((NetMessageReceiver)this.getMessageReceiver()), context);
        this.portWorker.submit(netBidibPort);
        try {
            LOGGER.info("Wait for startup of netBidibPort instance.");
            boolean completed = startupLock.await(5000L, TimeUnit.MILLISECONDS);
            LOGGER.info("Startup of netBidibPort instance passed and has completed: {}", (Object)completed);
            if (!completed) {
                throw new PortNotOpenedException("Startup of netBidibPort instance did not complete in 5s", "");
            }
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait for startup of netBidibPort instance failed.", (Throwable)ex);
            throw new PortNotOpenedException();
        }
        return netBidibPort;
    }

    public boolean isOpened() {
        return this.port != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LOGGER.info("Close the port.");
        Object object = this.portLock;
        synchronized (object) {
            if (this.port != null) {
                LOGGER.info("Stop the port: {}", (Object)this.port);
                NetBidibPort portToClose = this.port;
                try {
                    LOGGER.info("Send a MSG_LOCAL_LOGON_REJECTED to the server, clientLinkData: {}", (Object)this.clientLinkData);
                    LocalLogonRejectedMessage bidibCommand = this.getRequestFactory().createLocalLogonRejected(this.clientLinkData.getUniqueId().longValue());
                    bidibCommand.setAddr(Node.ROOTNODE_ADDR);
                    this.sendNetBidibMessage((BidibCommand)bidibCommand);
                    Thread.sleep(10L);
                    LOGGER.info("Waited for 10ms to allow sendQueue to send out the MSG_LOCAL_LOGON_REJECTED message.");
                }
                catch (Exception ex) {
                    LOGGER.warn("Send MSG_LOCAL_LOGON_REJECTED failed.", (Throwable)ex);
                }
                for (int retry = 0; retry < 2; ++retry) {
                    if (this.connector.isSendQueueEmpty()) {
                        LOGGER.info("The sendQueue is empty. Close the port. Current retry: {}", (Object)retry);
                        break;
                    }
                    try {
                        Thread.sleep(10L);
                        continue;
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Wait for empty sendQueue was interrupted.", (Throwable)ex);
                        break;
                    }
                }
                this.port = null;
                portToClose.stop();
                if (this.portWorker != null) {
                    ScheduledExecutorService scheduledExecutorService = this.portWorker;
                    synchronized (scheduledExecutorService) {
                        LOGGER.info("Shutdown the port worker. Current thread is interrupted: {}", (Object)Thread.currentThread().isInterrupted());
                        try {
                            if (!Thread.currentThread().isInterrupted()) {
                                this.portWorker.shutdown();
                                this.portWorker.awaitTermination(5000L, TimeUnit.MILLISECONDS);
                            } else {
                                this.portWorker.shutdownNow();
                            }
                        }
                        catch (InterruptedException ex) {
                            LOGGER.warn("Wait for termination of port worker failed.", (Throwable)ex);
                        }
                    }
                }
                if (this.logonReceivedPublisherWorker != null) {
                    ScheduledExecutorService scheduledExecutorService = this.logonReceivedPublisherWorker;
                    synchronized (scheduledExecutorService) {
                        try {
                            this.logonReceivedPublisherWorker.shutdownNow();
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Shutdown the logonReceivedPublisherWorker failed.", (Throwable)ex);
                        }
                    }
                }
            } else {
                LOGGER.info("No port to close available.");
            }
        }
        this.connector.stopReceiverAndQueues(null);
        if (this.connectedPortName != null) {
            String connectedPortNameToClose = this.connectedPortName;
            this.connectedPortName = null;
            this.fireConnectionClosed(connectedPortNameToClose);
        } else {
            LOGGER.info("No connectedPortName to signal as closed available.");
        }
        super.close();
        this.cleanupAfterClose(null);
        LOGGER.info("Close the port has finished.");
    }

    private void publishUserAction(String actionKey, Context context) {
        LOGGER.info("Publish the user action, actionKey: {}, context: {}", (Object)actionKey, (Object)context);
        this.connectionListenerDelegate.actionRequired(actionKey, context);
    }

    private void publishPairingFinished(PairingResult pairingResult, long uniqueId) {
        LOGGER.info("Publish the pairing result: {}", (Object)pairingResult);
        this.connectionListenerDelegate.pairingFinished(pairingResult, uniqueId);
    }

    private void publishLogonReceived(int localNodeAddr, long uniqueId) {
        LOGGER.info("Publish the logon received, localNodeAddr: {}, uniqueId: {}", (Object)localNodeAddr, (Object)ByteUtils.formatHexUniqueId((long)uniqueId));
        this.connectionListenerDelegate.logonReceived(localNodeAddr, uniqueId);
    }

    private void publishLogoffReceived(long uniqueId) {
        LOGGER.info("Publish the logoff received.");
        this.connectionListenerDelegate.logoffReceived(uniqueId);
    }

    private void handleError(RuntimeException ex) {
        this.connectionListenerDelegate.handleError(ex);
    }

    public void signalUserAction(String actionKey, Context context) {
        LOGGER.info("Signal the user action, actionKey: {}, context: {}", (Object)actionKey, (Object)context);
        block4 : switch (actionKey) {
            case "pairingStatus": {
                NetBidibLinkData.PairingStatus pairingStatus = (NetBidibLinkData.PairingStatus)context.get("pairingStatus", NetBidibLinkData.PairingStatus.class, (Object)NetBidibLinkData.PairingStatus.UNPAIRED);
                Long uniqueId = (Long)context.get("uniqueId", Long.class, null);
                if (NetBidibLinkData.PairingStatus.PAIRING_REQUESTED == this.remotePartnerLinkData.getPairingStatus()) {
                    LOGGER.info("The client has sent the pairing requested message to the remote partner. Now send the pairing status: {}", (Object)pairingStatus);
                    switch (pairingStatus) {
                        case PAIRED: {
                            ((PairingStateInteractionHandler)((Object)this.netBidibPairingStateHandler)).pairingResult(uniqueId, PairingResult.PAIRED);
                            break block4;
                        }
                    }
                    ((PairingStateInteractionHandler)((Object)this.netBidibPairingStateHandler)).pairingResult(uniqueId, PairingResult.UNPAIRED);
                    break;
                }
                LOGGER.info("The pairing status is not sent because the pairing status of the remote partner is: {}", (Object)this.remotePartnerLinkData);
                break;
            }
            case "pairingRequest": {
                if (this.netBidibPairingStateHandler instanceof PairingStateInteractionHandler) {
                    LOGGER.info("Initiate the pairing.");
                    ((PairingStateInteractionHandler)((Object)this.netBidibPairingStateHandler)).initiatePairing();
                    break;
                }
                LOGGER.warn("The netBidibPairingStateHandler is not of expected type. Check configuration.");
                break;
            }
            default: {
                LOGGER.warn("Unhandled user action: {}, context: {}", (Object)actionKey, (Object)context);
            }
        }
    }

    private void sendNetBidibStartupSequence(Integer pairingTimeout) throws ProtocolException, IOException, PairingFailedException, EstablishCommunicationFailedException {
        LOGGER.info("Send the initial startup sequence, pairingTimeout: {}s", (Object)pairingTimeout);
        this.clientLinkData.setRequestedPairingTimeout(pairingTimeout);
        ((PairingStateInteractionHandler)((Object)this.netBidibPairingStateHandler)).sendNetBidibStartupSequence();
    }

    public void attach(Long uniqueId) {
        if (uniqueId != null && Objects.equals(uniqueId, this.clientLinkData.getUniqueId())) {
            try {
                LocalLinkMessage message = this.getRequestFactory().createLocalLinkStatusPaired(this.clientLinkData.getUniqueId().longValue(), this.remotePartnerLinkData.getUniqueId().longValue());
                this.sendNetBidibMessage((BidibCommand)message);
            }
            catch (Exception ex) {
                LOGGER.warn("Send the status paired to partner failed.", (Throwable)ex);
            }
        } else {
            LOGGER.warn("No uniqueId to attach available.");
        }
    }

    public void setResponseTimeout(int timeout) {
        LOGGER.info("Set the response timeout to: {}", (Object)timeout);
        super.setResponseTimeout(timeout);
    }

    public List<String> getPortIdentifiers() {
        return Collections.emptyList();
    }

    public void send(byte[] data) {
        this.connector.send(data);
    }

    private void sendNetBidibMessage(BidibCommand message) throws IOException {
        byte[] data = message.getContent();
        if (MSG_TX_LOGGER.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder(">> ");
            sb.append(message);
            sb.append(" : ");
            sb.append(ByteUtils.bytesToHex((byte[])data));
            MSG_TX_LOGGER.info(sb.toString());
        }
        this.connector.send(data);
    }

    protected int contactInterface() {
        LOGGER.info("Contact the interface node.");
        try {
            int magic = this.sendDisableAndMagic();
            LOGGER.info("The root node returned the magic: {}", (Object)ByteUtils.magicToHex((int)magic));
            return magic;
        }
        catch (ProtocolException ex) {
            throw new NoAnswerException("Contact the interface node failed.", (Throwable)ex);
        }
    }

    private int sendDisableAndMagic() throws ProtocolException {
        RootNode rootNode = this.getRootNode();
        LOGGER.info("Send sysDisable to the rootNode.");
        rootNode.sysDisable();
        try {
            LOGGER.info("Wait 300ms before send the magic request.");
            Thread.sleep(300L);
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait before send the magic request failed.", (Throwable)ex);
        }
        LOGGER.info("Send the magic request.");
        int magic = rootNode.getMagic(Integer.valueOf(1500));
        LOGGER.debug("The node returned magic: {}", (Object)magic);
        return magic;
    }

    private class NetConnector
    extends AbstractBaseBidib<NetMessageReceiver> {
        private NetConnector() {
        }

        protected void internalOpen(String portName, Context context) throws PortNotFoundException, PortNotOpenedException {
            super.internalOpen(portName, context);
        }

        protected void sendData(ByteArrayOutputStream data, RawMessageListener rawMessageListener) {
            if (NetBidibClient.this.port != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Send message to net message handler: {}, port: {}", (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)data), (Object)NetBidibClient.this.port);
                }
                try {
                    data.writeTo(NetBidibClient.this.output);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Send, after encoding: {}", (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)NetBidibClient.this.output));
                    }
                    if (rawMessageListener != null) {
                        rawMessageListener.notifySend(NetBidibClient.this.output.toByteArray());
                    }
                    NetBidibClient.this.netMessageHandler.send(NetBidibClient.this.port, NetBidibClient.this.output.toByteArray());
                }
                catch (Exception ex) {
                    LOGGER.warn("Forward message to send with netMessageReceiver failed.", (Throwable)ex);
                    throw new RuntimeException("Forward message to send with netMessageReceiver failed.", ex);
                }
                finally {
                    NetBidibClient.this.output.reset();
                }
            } else {
                LOGGER.warn("Send not possible, the port is closed.");
            }
        }

        public void logonReceived() {
            LOGGER.info("Logon was received. Set the connected flag to contact the root node.");
            this.setConnected(true);
        }
    }
}

