/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.jbidibc.netbidib.client.NetBidibClientSocketHandler;
import org.bidib.jbidibc.netbidib.client.NetBidibPort;
import org.bidib.jbidibc.netbidib.client.NetMessageHandler;
import org.bidib.jbidibc.netbidib.client.listener.NetBidibPortConnectionStatusListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetBidibClientPort
implements NetBidibPort {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetBidibClientPort.class);
    private final NetMessageHandler netMessageHandler;
    private Socket socket;
    private final Set<NetBidibPortConnectionStatusListener> connectionStatusListeners = new HashSet<NetBidibPortConnectionStatusListener>();
    private final ScheduledExecutorService socketWorker;
    private String targetAddress;
    private AtomicBoolean acceptorRunEnabled = new AtomicBoolean();
    private NetBidibClientSocketHandler netBidibClientSocketHandler;
    private static final Logger MSG_RAW_LOGGER = LoggerFactory.getLogger((String)"RAW");

    public NetBidibClientPort(InetAddress address, int portNumber, NetMessageHandler netMessageHandler) throws IOException {
        if (address == null) {
            throw new IllegalArgumentException("address must not be null!");
        }
        this.netMessageHandler = netMessageHandler;
        this.targetAddress = address.toString() + ":" + portNumber;
        this.socketWorker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("netBidibClientSocketWorkers-thread-%d").build());
        int connectTimeout = 5000;
        LOGGER.info("Created TCP socket for address: {}, port number: {}, connectTimeout: {}", new Object[]{address, portNumber, 5000});
        this.socket = new Socket();
        this.socket.setTcpNoDelay(true);
        try {
            this.socket.connect(new InetSocketAddress(address, portNumber), 5000);
        }
        catch (ConnectException ex) {
            LOGGER.warn("Connect socket failed, address: {}, portNumber: {}", new Object[]{address, portNumber, ex});
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex1) {
                LOGGER.warn("Wait for reconnect was interrupted. Throw the connect exception.", (Throwable)ex1);
                throw ex;
            }
            this.socket.connect(new InetSocketAddress(address, portNumber), 5000);
        }
        LOGGER.info("Create TCP socket passed for address: {}, port number: {}", (Object)address, (Object)portNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionStatusListener(NetBidibPortConnectionStatusListener listener) {
        Set<NetBidibPortConnectionStatusListener> set = this.connectionStatusListeners;
        synchronized (set) {
            this.connectionStatusListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnectionStatusListener(NetBidibPortConnectionStatusListener listener) {
        Set<NetBidibPortConnectionStatusListener> set = this.connectionStatusListeners;
        synchronized (set) {
            this.connectionStatusListeners.remove(listener);
        }
    }

    @Override
    public void run() {
        this.processSocketTraffic(this.socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processSocketTraffic(Socket socket) {
        LOGGER.info("Start processing the TCP socket.");
        LOGGER.info("Start client receiver handler.");
        try {
            InputStream socketInputStream = socket.getInputStream();
            InetAddress remoteAddress = socket.getInetAddress();
            int portNumber = socket.getPort();
            this.netBidibClientSocketHandler = new NetBidibClientSocketHandler(socketInputStream, remoteAddress, portNumber, this.netMessageHandler);
            this.socketWorker.submit(this.netBidibClientSocketHandler);
            LOGGER.info("Start client receiver handler has passed.");
            Set<NetBidibPortConnectionStatusListener> set = this.connectionStatusListeners;
            synchronized (set) {
                for (NetBidibPortConnectionStatusListener listener : this.connectionStatusListeners) {
                    listener.opened();
                }
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Get the inputStream of the socket failed.", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        LOGGER.info("Stop the TCP packet receiver, socket: {}", (Object)this.socket);
        this.acceptorRunEnabled.set(false);
        if (this.netBidibClientSocketHandler != null) {
            try {
                this.netBidibClientSocketHandler.stop();
            }
            catch (Exception ex) {
                LOGGER.warn("Stop the netBidibClientSocketHandler failed.", (Throwable)ex);
            }
            this.netBidibClientSocketHandler = null;
        }
        if (this.socket != null) {
            LOGGER.info("Close the client socket.");
            try {
                this.socket.close();
                LOGGER.info("Close the client socket has passed.");
            }
            catch (IOException ex) {
                LOGGER.warn("Close socket failed.", (Throwable)ex);
            }
            this.socket = null;
        }
        try {
            this.socketWorker.shutdownNow();
            LOGGER.info("Shutdown the socketWorker passed.");
        }
        catch (Exception ex) {
            LOGGER.warn("Shutdown the socketWorker failed.", (Throwable)ex);
        }
        Set<NetBidibPortConnectionStatusListener> set = this.connectionStatusListeners;
        synchronized (set) {
            for (NetBidibPortConnectionStatusListener listener : this.connectionStatusListeners) {
                listener.closed();
            }
        }
    }

    @Override
    public void send(byte[] sendData, InetAddress address, int portNumber) throws IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Send data to socket, port: {}, bytes: {}", (Object)portNumber, (Object)ByteUtils.bytesToHex((byte[])sendData));
        }
        if (MSG_RAW_LOGGER.isInfoEnabled()) {
            MSG_RAW_LOGGER.info(">> {}", (Object)ByteUtils.bytesToHex((byte[])sendData));
        }
        this.socket.getOutputStream().write(sendData);
        this.socket.getOutputStream().flush();
    }

    public String toString() {
        return "NetBidibPlainTcpPort[" + this.targetAddress + "]";
    }
}

