/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.client;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.netbidib.client.DataPacket;
import org.bidib.jbidibc.netbidib.client.NetMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetBidibClientSocketHandler
implements Callable<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetBidibClientSocketHandler.class);
    protected static final Logger MSG_RAW_LOGGER = LoggerFactory.getLogger((String)"RAW");
    private final InputStream socketInputStream;
    private final NetMessageHandler netMessageHandler;
    private AtomicBoolean runEnabled = new AtomicBoolean();
    private ByteArrayOutputStream receiveBuffer = new ByteArrayOutputStream(2048);
    private final InetAddress remoteAddress;
    private final int portNumber;
    private ByteArrayOutputStream outputBuffer = new ByteArrayOutputStream(100);

    public NetBidibClientSocketHandler(InputStream socketInputStream, InetAddress remoteAddress, int portNumber, NetMessageHandler netMessageHandler) {
        this.socketInputStream = socketInputStream;
        this.netMessageHandler = netMessageHandler;
        this.remoteAddress = remoteAddress;
        this.portNumber = portNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() {
        this.runEnabled.set(true);
        byte[] receiveData = new byte[1024];
        try (BufferedInputStream in = new BufferedInputStream(this.socketInputStream);){
            int receivedCount = 0;
            while ((receivedCount = in.read(receiveData)) > 0 && this.runEnabled.get()) {
                if (this.netMessageHandler != null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Received data: {}", (Object)ByteUtils.bytesToHex((byte[])receiveData, (int)receivedCount));
                    }
                    this.receiveBuffer.write(receiveData, 0, receivedCount);
                    try {
                        this.parsePackets(this.receiveBuffer, this.netMessageHandler, this.remoteAddress, this.portNumber);
                        continue;
                    }
                    catch (Exception pex) {
                        LOGGER.warn("Receive message failed.", (Throwable)pex);
                        continue;
                    }
                    finally {
                        this.receiveBuffer.reset();
                        continue;
                    }
                }
                LOGGER.warn("No message receiver configured, data: {}", (Object)ByteUtils.bytesToHex((byte[])receiveData, (int)receivedCount));
            }
        }
        catch (IOException ex) {
            if (this.runEnabled.get()) {
                LOGGER.warn("--- Interrupt NetBidibTcpPort-run", (Throwable)ex);
            } else {
                LOGGER.info("The NetBidibTcpPort worker is terminating.");
            }
        }
        finally {
            LOGGER.info("The socket connection was closed.");
            if (this.netMessageHandler != null) {
                LOGGER.info("Cleanup the messageReceiver.");
                String remoteHost = this.remoteAddress.getHostAddress() + ":" + this.portNumber;
                this.netMessageHandler.cleanup(remoteHost);
            }
            LOGGER.info("Cleanup work after close socked has finished.");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parsePackets(ByteArrayOutputStream output, NetMessageHandler netMessageHandler, InetAddress address, int portNumber) throws ProtocolException {
        try {
            this.parseInput(output, netMessageHandler, address, portNumber);
        }
        catch (RuntimeException pex) {
            LOGGER.warn("Receive message failed, reason: {}", (Object)pex.getMessage());
        }
        finally {
            output.reset();
        }
    }

    private void processMessages(ByteArrayOutputStream output, NetMessageHandler netMessageHandler, InetAddress address, int portNumber) throws ProtocolException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Process messages will put data into DataPacket: {}", (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)output));
        }
        DataPacket receivedPacket = new DataPacket(output.toByteArray(), 0, output.size(), address, portNumber);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Received data: {}", (Object)ByteUtils.bytesToHex((byte[])receivedPacket.getData()));
        }
        netMessageHandler.receive(receivedPacket);
    }

    protected void parseInput(ByteArrayOutputStream receiveData, NetMessageHandler netMessageHandler, InetAddress address, int portNumber) throws ProtocolException {
        if (receiveData != null) {
            int receivedCount = receiveData.size();
            byte[] receivedData = receiveData.toByteArray();
            MSG_RAW_LOGGER.info("<<<< len: {}, data: {}", (Object)receivedCount, (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)receiveData));
            try {
                this.outputBuffer.write(receivedData);
            }
            catch (IOException ex) {
                LOGGER.warn("Copy received data to output buffer failed.", (Throwable)ex);
                throw new ProtocolException("Copy received data to output buffer failed.");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Received raw message: {}", (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)this.outputBuffer));
            }
            if (MSG_RAW_LOGGER.isInfoEnabled()) {
                MSG_RAW_LOGGER.info("<< [{}] - {}", (Object)this.outputBuffer.size(), (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)this.outputBuffer));
            }
            try {
                this.processMessages(this.outputBuffer, netMessageHandler, address, portNumber);
                this.outputBuffer.reset();
            }
            catch (ProtocolException ex) {
                LOGGER.warn("Process messages failed.", (Throwable)ex);
            }
        } else {
            LOGGER.error("No input available.");
        }
    }

    public void stop() {
        LOGGER.info("Stop the socket handler.");
        this.runEnabled.set(false);
    }
}

