/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.client;

import java.io.ByteArrayOutputStream;
import org.bidib.jbidibc.core.AbstractMessageReceiver;
import org.bidib.jbidibc.core.node.NodeRegistry;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.LocalLogoffMessage;
import org.bidib.jbidibc.messages.message.LocalLogonAckMessage;
import org.bidib.jbidibc.messages.message.LocalLogonMessage;
import org.bidib.jbidibc.messages.message.ResponseFactory;
import org.bidib.jbidibc.messages.message.netbidib.LocalLinkMessage;
import org.bidib.jbidibc.messages.message.netbidib.LocalProtocolSignatureMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.netbidib.client.listener.NetBidibLocalMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetMessageReceiver
extends AbstractMessageReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetMessageReceiver.class);
    private ByteArrayOutputStream output = new ByteArrayOutputStream(2048);
    private NetBidibLocalMessageListener netBidibLocalMessageListener;

    public NetMessageReceiver(NodeRegistry nodeRegistry, ResponseFactory responseFactory, boolean checkCRC) {
        super(nodeRegistry, responseFactory, checkCRC);
    }

    public void setNetBidibLocalMessageListener(NetBidibLocalMessageListener netBidibLocalMessageListener) {
        this.netBidibLocalMessageListener = netBidibLocalMessageListener;
    }

    public void enable() {
        LOGGER.info("enable is called.");
        MSG_RAW_LOGGER.info("++++ Enable the message receiver.");
        try {
            this.output.reset();
        }
        catch (Exception ex) {
            LOGGER.warn("Reset buffered received data failed.", (Throwable)ex);
        }
        super.enable();
    }

    public void disable() {
        LOGGER.info("Disable is called.");
        super.disable();
        MSG_RAW_LOGGER.info("++++ Disable the message receiver.");
    }

    private void logRX(BidibMessageInterface bidibCommand, byte[] messageArray) {
        if (MSG_RX_LOGGER.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder("<< ");
            sb.append(bidibCommand);
            sb.append(" : ");
            sb.append(ByteUtils.bytesToHex((byte[])messageArray));
            MSG_RX_LOGGER.info(sb.toString());
        }
    }

    protected void processMessage(byte[] messageArray) throws ProtocolException {
        Object message = null;
        try {
            BidibMessageInterface bidibCommand = this.getResponseFactory().create(messageArray);
            LOGGER.trace("Received command: {}", (Object)bidibCommand);
            switch (ByteUtils.getInt((byte)bidibCommand.getType())) {
                case 254: {
                    this.logRX(bidibCommand, messageArray);
                    LocalProtocolSignatureMessage localProtocolSignatureMessage = (LocalProtocolSignatureMessage)bidibCommand;
                    String requestor = localProtocolSignatureMessage.getRequestorName();
                    LOGGER.info("Received MSG_LOCAL_PROTOCOL_SIGNATURE from requestor: {}", (Object)requestor);
                    if (this.netBidibLocalMessageListener != null) {
                        this.netBidibLocalMessageListener.onLocalProtocolSignature(localProtocolSignatureMessage);
                        break;
                    }
                    LOGGER.warn("No netBidibLocalMessageListener available. Discard message.");
                    break;
                }
                case 255: {
                    this.logRX(bidibCommand, messageArray);
                    LocalLinkMessage localLinkMessage = (LocalLinkMessage)bidibCommand;
                    this.processMsgLocalLink(localLinkMessage);
                    break;
                }
                case 112: {
                    this.logRX(bidibCommand, messageArray);
                    super.processMessage(bidibCommand);
                    LocalLogonAckMessage localLogonAckMessage = (LocalLogonAckMessage)bidibCommand;
                    this.processMsgLocalLogonAck(localLogonAckMessage);
                    break;
                }
                case 240: {
                    this.logRX(bidibCommand, messageArray);
                    super.processMessage(bidibCommand);
                    LocalLogonMessage localLogonMessage = (LocalLogonMessage)bidibCommand;
                    this.processMsgLocalLogon(localLogonMessage);
                    break;
                }
                case 242: {
                    this.logRX(bidibCommand, messageArray);
                    super.processMessage(bidibCommand);
                    LocalLogoffMessage localLogoffMessage = (LocalLogoffMessage)bidibCommand;
                    this.processMsgLocalLogoff(localLogoffMessage);
                    break;
                }
                default: {
                    LOGGER.trace("Processing BiDiB node related command: {}", (Object)bidibCommand);
                    this.logRX(bidibCommand, messageArray);
                    super.processMessage(bidibCommand);
                    break;
                }
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Process received messages failed: {}", (Object)ByteUtils.bytesToHex((byte[])messageArray), (Object)ex);
            StringBuilder sb = new StringBuilder("<< received invalid: ");
            sb.append((Object)message);
            sb.append(" : ");
            sb.append(ByteUtils.bytesToHex((byte[])messageArray));
            MSG_RX_LOGGER.warn(sb.toString());
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.warn("Process received messages failed: {}", (Object)ByteUtils.bytesToHex((byte[])messageArray), (Object)ex);
        }
    }

    private void processMsgLocalLink(LocalLinkMessage localLinkMessage) throws ProtocolException {
        LOGGER.info("Received MSG_LOCAL_LINK: {}", (Object)localLinkMessage);
        if (this.netBidibLocalMessageListener != null) {
            this.netBidibLocalMessageListener.onLocalLink(localLinkMessage);
        } else {
            LOGGER.warn("No netBidibLocalMessageListener available. Discard message.");
        }
    }

    private void processMsgLocalLogonAck(LocalLogonAckMessage localLogonAckMessage) {
        LOGGER.info("Received MSG_LOCAL_LOGON_ACK: {}", (Object)localLogonAckMessage);
        int nodeAddress = localLogonAckMessage.getNodeAddress();
        long uniqueId = localLogonAckMessage.getSenderUniqueId();
        LOGGER.info("Current nodeAddress: {}, uniqueId: {}", (Object)nodeAddress, (Object)ByteUtils.formatHexUniqueId((long)uniqueId));
        if (this.netBidibLocalMessageListener != null) {
            this.netBidibLocalMessageListener.onLocalLogonAck(localLogonAckMessage);
        } else {
            LOGGER.warn("No netBidibLocalMessageListener available. Discard message.");
        }
    }

    private void processMsgLocalLogon(LocalLogonMessage localLogonMessage) {
        LOGGER.info("Received MSG_LOCAL_LOGON: {}", (Object)localLogonMessage);
        long uniqueId = localLogonMessage.getSenderUniqueId();
        LOGGER.info("Current uniqueId: {}", (Object)ByteUtils.formatHexUniqueId((long)uniqueId));
        if (this.netBidibLocalMessageListener != null) {
            this.netBidibLocalMessageListener.onLocalLogon(localLogonMessage);
        } else {
            LOGGER.warn("No netBidibLocalMessageListener available. Discard message.");
        }
    }

    private void processMsgLocalLogoff(LocalLogoffMessage localLogoffMessage) {
        LOGGER.info("Received MSG_LOCAL_LOGOFF: {}", (Object)localLogoffMessage);
        Long uniqueId = localLogoffMessage.getSenderUniqueId();
        LOGGER.info("Current uniqueId: {}", (Object)ByteUtils.formatHexUniqueId((Long)uniqueId));
        if (this.netBidibLocalMessageListener != null) {
            this.netBidibLocalMessageListener.onLocalLogoff(localLogoffMessage);
        } else {
            LOGGER.warn("No netBidibLocalMessageListener available. Discard message.");
        }
    }
}

