/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.client.pairingstates;

import org.bidib.jbidibc.messages.enums.NetBidibSocketType;
import org.bidib.jbidibc.messages.enums.PairingResult;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.LocalLogoffMessage;
import org.bidib.jbidibc.messages.message.LocalLogonAckMessage;
import org.bidib.jbidibc.messages.message.LocalLogonMessage;
import org.bidib.jbidibc.messages.message.netbidib.BidibLinkData;
import org.bidib.jbidibc.messages.message.netbidib.LocalLinkMessage;
import org.bidib.jbidibc.messages.message.netbidib.LocalProtocolSignatureMessage;
import org.bidib.jbidibc.messages.message.netbidib.NetBidibLinkData;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.netbidib.client.pairingstates.DefaultPairingStateHandler;
import org.bidib.jbidibc.netbidib.client.pairingstates.PairingState;
import org.bidib.jbidibc.netbidib.client.pairingstates.PairingStateEnum;
import org.bidib.jbidibc.netbidib.client.pairingstates.ProxyBidibLinkData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPairingState
implements PairingState {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPairingState.class);
    protected final BidibLinkData remotePartnerLinkData;
    protected final ProxyBidibLinkData clientLinkData;
    private final DefaultPairingStateHandler pairingStateHandler;

    protected AbstractPairingState(DefaultPairingStateHandler pairingStateHandler, BidibLinkData remotePartnerLinkData, ProxyBidibLinkData clientLinkData) {
        this.pairingStateHandler = pairingStateHandler;
        this.remotePartnerLinkData = remotePartnerLinkData;
        this.clientLinkData = clientLinkData;
    }

    protected boolean isActiveInitiatedConnection() {
        return this.pairingStateHandler.getSocketType() == NetBidibSocketType.clientSocket;
    }

    protected BidibRequestFactory getRequestFactory() {
        return this.pairingStateHandler.getRequestFactory();
    }

    protected boolean isPaired(BidibLinkData bidibLinkData) {
        return this.pairingStateHandler.isPaired(bidibLinkData);
    }

    protected void setNextPairingState(PairingStateEnum pairingState) {
        this.pairingStateHandler.setCurrentPairingState(pairingState);
    }

    protected void publishMessage(BidibCommandMessage message) throws ProtocolException {
        LOGGER.trace("Publish the message: {}", (Object)message);
        this.pairingStateHandler.publishMessage(message);
    }

    protected void publishLocalLogon(int localNodeAddr, long uniqueId) {
        LOGGER.trace("Publish the local logon message was received, localNodeAddr: {}, uniqueId: {}", (Object)localNodeAddr, (Object)ByteUtils.formatHexUniqueId((long)uniqueId));
        this.pairingStateHandler.publishLocalLogon(localNodeAddr, uniqueId);
    }

    protected void publishLocalLogoff(long uniqueId) {
        LOGGER.trace("Publish the local logoff message was received.");
        this.pairingStateHandler.publishLocalLogoff(uniqueId);
    }

    protected void signalPairingRequest() {
        LOGGER.trace("Signal the pairing request, remotePartnerLinkData: {}", (Object)this.remotePartnerLinkData);
        this.pairingStateHandler.signalPairingRequest(this.remotePartnerLinkData);
    }

    protected void signalPairingResult(NetBidibLinkData.PairingStatus pairingStatus) {
        LOGGER.info("Signal the pairing result: {}", (Object)pairingStatus);
        this.remotePartnerLinkData.setPairingStatus(pairingStatus);
    }

    public void onLocalProtocolSignature(LocalProtocolSignatureMessage localProtocolSignatureMessage) {
        LOGGER.info("onLocalProtocolSignature, localProtocolSignatureMessage: {}, currentPairingState: {}", (Object)localProtocolSignatureMessage, (Object)this.pairingStateHandler.getCurrentPairingState());
    }

    public void onLocalLogonAck(LocalLogonAckMessage localLogonAckMessage) {
        LOGGER.info("onLocalLogonAck, localLogonAckMessage: {}, currentPairingState: {}", (Object)localLogonAckMessage, (Object)this.pairingStateHandler.getCurrentPairingState());
    }

    public void onLocalLogon(LocalLogonMessage localLogonMessage) {
        LOGGER.info("onLocalLogon, localLogonMessage: {}, currentPairingState: {}", (Object)localLogonMessage, (Object)this.pairingStateHandler.getCurrentPairingState());
    }

    public void onLocalLogoff(LocalLogoffMessage localLogoffMessage) {
        LOGGER.info("onLocalLogoff, localLogoffMessage: {}, currentPairingState: {}", (Object)localLogoffMessage, (Object)this.pairingStateHandler.getCurrentPairingState());
    }

    public void onLocalLink(LocalLinkMessage localLinkMessage) {
        LOGGER.info("onLocalLink, localLinkMessage: {}, currentPairingState: {}", (Object)localLinkMessage, (Object)this.pairingStateHandler.getCurrentPairingState());
        switch (localLinkMessage.getLinkDescriptor()) {
            case 128: {
                LOGGER.info("Received the partner P_VERSION: {}", (Object)localLinkMessage.getProtocolVersion());
                this.remotePartnerLinkData.setProtocolVersion(localLinkMessage.getProtocolVersion());
                break;
            }
            case 0: {
                LOGGER.info("Received the partner PROD_STRING: {}", (Object)localLinkMessage.getProdString());
                this.remotePartnerLinkData.setProdString(localLinkMessage.getProdString());
                break;
            }
            case 1: {
                LOGGER.info("Received the partner USER_STRING: {}", (Object)localLinkMessage.getProdString());
                this.remotePartnerLinkData.setUserString(localLinkMessage.getProdString());
                break;
            }
            case 127: {
                LOGGER.info("Received the partner ROLE: {}", (Object)localLinkMessage.getNetBidibRole());
                this.remotePartnerLinkData.setNetBidibRole(localLinkMessage.getNetBidibRole());
                break;
            }
        }
    }

    @Override
    public void initiatePairing(int timeout) {
        LOGGER.info("initPairing, timeout: {}", (Object)timeout);
    }

    @Override
    public void pairingResult(PairingResult pairingResult) {
        LOGGER.info("pairingResult, pairingResult: {}", (Object)pairingResult);
    }

    @Override
    public void timeoutPairing() {
        LOGGER.info("timeout the pairing.");
    }

    @Override
    public void sendNetBidibStartupSequence() {
        LOGGER.info("Send the startup sequence.");
    }
}

