/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.client.pairingstates;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.bidib.jbidibc.messages.enums.NetBidibSocketType;
import org.bidib.jbidibc.messages.enums.PairingResult;
import org.bidib.jbidibc.messages.exception.EstablishCommunicationFailedException;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.helpers.DefaultContext;
import org.bidib.jbidibc.messages.message.BidibCommand;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.LocalLogoffMessage;
import org.bidib.jbidibc.messages.message.LocalLogonAckMessage;
import org.bidib.jbidibc.messages.message.LocalLogonMessage;
import org.bidib.jbidibc.messages.message.netbidib.BidibLinkData;
import org.bidib.jbidibc.messages.message.netbidib.LocalLinkMessage;
import org.bidib.jbidibc.messages.message.netbidib.LocalProtocolSignatureMessage;
import org.bidib.jbidibc.messages.message.netbidib.NetBidibLinkData;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.netbidib.client.pairingstates.AbstractPairingState;
import org.bidib.jbidibc.netbidib.client.pairingstates.InitialPairingState;
import org.bidib.jbidibc.netbidib.client.pairingstates.MyRequestPairingState;
import org.bidib.jbidibc.netbidib.client.pairingstates.NetBidibMessageSender;
import org.bidib.jbidibc.netbidib.client.pairingstates.PairedPairingState;
import org.bidib.jbidibc.netbidib.client.pairingstates.PairingInteractionPublisher;
import org.bidib.jbidibc.netbidib.client.pairingstates.PairingStateEnum;
import org.bidib.jbidibc.netbidib.client.pairingstates.PairingStateHandler;
import org.bidib.jbidibc.netbidib.client.pairingstates.PairingStateInteractionHandler;
import org.bidib.jbidibc.netbidib.client.pairingstates.ProxyBidibLinkData;
import org.bidib.jbidibc.netbidib.client.pairingstates.TheirRequestPairingState;
import org.bidib.jbidibc.netbidib.client.pairingstates.UnpairedPairingState;
import org.bidib.jbidibc.netbidib.client.pairingstates.WithdrawnPairingState;
import org.bidib.jbidibc.netbidib.pairingstore.LocalPairingStore;
import org.bidib.jbidibc.netbidib.pairingstore.PairingStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPairingStateHandler
implements PairingStateHandler,
PairingStateInteractionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPairingStateHandler.class);
    public static final String PROPERTY_CURRENTPAIRINGSTATE = "currentPairingState";
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private PairingStateEnum currentPairingState = PairingStateEnum.Initial;
    private Map<PairingStateEnum, AbstractPairingState> pairingStateMap = new HashMap<PairingStateEnum, AbstractPairingState>();
    private ProxyBidibLinkData remotePartnerLinkData;
    private ProxyBidibLinkData clientLinkData;
    private final NetBidibMessageSender netBidibMessageSender;
    private final PairingInteractionPublisher pairingInteractionPublisher;
    private final BidibRequestFactory bidibRequestFactory;
    private Object pairingStoreLock = new Object();
    private PairingStore pairingStore;
    private NetBidibSocketType socketType;
    private CountDownLatch initialResponseLock;

    public DefaultPairingStateHandler(NetBidibMessageSender netBidibMessageSender, PairingInteractionPublisher pairingInteractionPublisher, BidibRequestFactory bidibRequestFactory) {
        this.netBidibMessageSender = netBidibMessageSender;
        this.pairingInteractionPublisher = pairingInteractionPublisher;
        this.bidibRequestFactory = bidibRequestFactory;
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public void setNetBidibSocketType(NetBidibSocketType socketType) {
        this.socketType = socketType;
    }

    protected NetBidibSocketType getSocketType() {
        return this.socketType;
    }

    @Override
    public void initialize(BidibLinkData remotePartnerLinkData, BidibLinkData clientLinkData, PairingStore pairingStore) {
        this.remotePartnerLinkData = new ProxyBidibLinkData(remotePartnerLinkData);
        this.clientLinkData = new ProxyBidibLinkData(clientLinkData);
        this.pairingStore = pairingStore;
        LOGGER.info("Current pairingStore content: {}", (Object)this.pairingStore);
        this.pairingStore.checkValid();
        this.pairingStateMap.put(PairingStateEnum.Initial, new InitialPairingState(this, this.remotePartnerLinkData, this.clientLinkData));
        this.pairingStateMap.put(PairingStateEnum.Unpaired, new UnpairedPairingState(this, this.remotePartnerLinkData, this.clientLinkData));
        this.pairingStateMap.put(PairingStateEnum.MyRequest, new MyRequestPairingState(this, this.remotePartnerLinkData, this.clientLinkData));
        this.pairingStateMap.put(PairingStateEnum.TheirRequest, new TheirRequestPairingState(this, this.remotePartnerLinkData, this.clientLinkData));
        this.pairingStateMap.put(PairingStateEnum.Paired, new PairedPairingState(this, this.remotePartnerLinkData, this.clientLinkData));
        this.pairingStateMap.put(PairingStateEnum.Withdrawn, new WithdrawnPairingState(this, this.remotePartnerLinkData, this.clientLinkData));
        this.addPropertyChangeListener(PROPERTY_CURRENTPAIRINGSTATE, evt -> {
            PairingStateEnum currentPairingState = this.getCurrentPairingState();
            LOGGER.info("The pairing state has changed, currentPairingState: {}, clientLinkData.pairingStatus: {}", (Object)currentPairingState, (Object)this.clientLinkData.getPairingStatus());
            switch (currentPairingState) {
                case Paired: {
                    LOGGER.info("We are in paired state.");
                    this.signalPairingFinished(PairingResult.PAIRED, this.remotePartnerLinkData);
                    break;
                }
                case Unpaired: {
                    LOGGER.info("We are in unpaired state.");
                    if (this.clientLinkData.getPairingStatus() != NetBidibLinkData.PairingStatus.PAIRING_REQUESTED) break;
                    LOGGER.info("The remote partner has rejected the pairing.");
                    this.signalPairingFinished(PairingResult.UNPAIRED, this.remotePartnerLinkData);
                    break;
                }
                case Withdrawn: {
                    LOGGER.info("We are in withdrawn state.");
                    if (this.clientLinkData.getPairingStatus() != NetBidibLinkData.PairingStatus.PAIRING_REQUESTED && this.clientLinkData.getPairingStatus() != NetBidibLinkData.PairingStatus.PAIRED) break;
                    LOGGER.info("The remote partner has withdrawn the pairing.");
                    this.signalPairingFinished(PairingResult.UNPAIRED, this.remotePartnerLinkData);
                    break;
                }
                default: {
                    LOGGER.info("Ignored change of pairing state: {}", (Object)currentPairingState);
                }
            }
        });
        this.clientLinkData.addPropertyChangeListener("pairingStatus", evt -> {
            NetBidibLinkData.PairingStatus pairingStatus = this.clientLinkData.getPairingStatus();
            LOGGER.info("The pairing status of the client has changed, pairingState: {}", (Object)pairingStatus);
            switch (pairingStatus) {
                case PAIRED: {
                    LOGGER.info("The client signalled the paired state.");
                    break;
                }
                case UNPAIRED: {
                    LOGGER.info("The client signalled the unpaired state.");
                    break;
                }
            }
        });
        this.remotePartnerLinkData.addPropertyChangeListener("pairingStatus", evt -> {
            NetBidibLinkData.PairingStatus pairingStatus = this.remotePartnerLinkData.getPairingStatus();
            LOGGER.info("The pairing status of the remote partner has changed, pairingState: {}", (Object)pairingStatus);
            switch (pairingStatus) {
                case PAIRED: {
                    LOGGER.info("The remote partner signalled the paired state.");
                    this.signalPairingState(PairingStateEnum.Paired, this.remotePartnerLinkData, this.clientLinkData);
                    break;
                }
                case UNPAIRED: {
                    LOGGER.info("The remote partner signalled the unpaired state.");
                    this.signalPairingState(PairingStateEnum.Unpaired, this.remotePartnerLinkData, this.clientLinkData);
                    break;
                }
                case PAIRING_REQUESTED: {
                    LOGGER.info("The remote partner signalled the pairing requested.");
                    this.updatePairingStoreLinkData(this.remotePartnerLinkData);
                    break;
                }
                case WITHDRAWN: {
                    LOGGER.info("The remote partner signalled the witdrawn state.");
                    this.updatePairingStoreLinkData(this.remotePartnerLinkData);
                    break;
                }
            }
        });
    }

    protected BidibRequestFactory getRequestFactory() {
        return this.bidibRequestFactory;
    }

    protected PairingStateEnum getCurrentPairingState() {
        return this.currentPairingState;
    }

    protected void setCurrentPairingState(PairingStateEnum pairingState) {
        LOGGER.info("Set the new pairingState: {}", (Object)pairingState);
        PairingStateEnum oldValue = this.currentPairingState;
        this.currentPairingState = pairingState;
        this.pcs.firePropertyChange(PROPERTY_CURRENTPAIRINGSTATE, (Object)oldValue, (Object)this.currentPairingState);
    }

    public ProxyBidibLinkData getRemotePartnerLinkData() {
        return this.remotePartnerLinkData;
    }

    public ProxyBidibLinkData getClientLinkData() {
        return this.clientLinkData;
    }

    protected void publishMessage(BidibCommandMessage message) throws ProtocolException {
        LOGGER.info("Publish the message: {}", (Object)message);
        this.netBidibMessageSender.publishNetBidibMessage((BidibCommand)message);
    }

    protected void signalPairingRequest(BidibLinkData remotePartnerLinkData) {
        LOGGER.info("Signal the pairing request, remotePartnerLinkData: {}", (Object)remotePartnerLinkData);
        Integer pairingTimeout = remotePartnerLinkData.getRequestedPairingTimeout();
        DefaultContext context = new DefaultContext();
        context.register("REQUESTOR_NAME", (Object)remotePartnerLinkData.getRequestorName());
        context.register("DESCRIPTOR_UID", (Object)remotePartnerLinkData.getUniqueId());
        context.register("DESCRIPTOR_PROD_STRING", (Object)remotePartnerLinkData.getProdString());
        context.register("DESCRIPTOR_USER_STRING", (Object)remotePartnerLinkData.getUserString());
        context.register("PAIRING_TIMEOUT", (Object)pairingTimeout);
        if (this.getSocketType() == NetBidibSocketType.clientSocket) {
            context.register("CONNECTION_TYPE", (Object)"client");
        } else {
            context.register("CONNECTION_TYPE", (Object)"server");
        }
        String actionKey = "pairing-requested";
        LOGGER.info("Publish the user action actionKey: {}, with context: {}", (Object)actionKey, (Object)context);
        this.pairingInteractionPublisher.publishUserAction(actionKey, (Context)context);
    }

    protected void signalPairingFinished(PairingResult pairingResult, BidibLinkData remotePartnerLinkData) {
        this.updatePairingStore(remotePartnerLinkData.getUniqueId(), pairingResult);
        this.pairingInteractionPublisher.publishPairingFinished(pairingResult, remotePartnerLinkData.getUniqueId());
    }

    protected void publishLocalLogon(int localNodeAddr, long uniqueId) {
        this.pairingInteractionPublisher.publishLocalLogon(localNodeAddr, uniqueId);
    }

    protected void publishLocalLogoff(long uniqueId) {
        this.pairingInteractionPublisher.publishLocalLogoff(uniqueId);
    }

    protected void signalPairingState(PairingStateEnum pairingState, ProxyBidibLinkData remotePartnerLinkData, ProxyBidibLinkData clientLinkData) {
        LOGGER.info("Signal the pairing state, pairingState: {}, remotePartnerLinkData: {}, final BidibLinkData remotePartnerLinkData: {}", new Object[]{pairingState, remotePartnerLinkData, clientLinkData});
        DefaultContext context = new DefaultContext();
        Integer pairingTimeout = clientLinkData.getRequestedPairingTimeout();
        context.register("REQUESTOR_NAME", (Object)remotePartnerLinkData.getRequestorName());
        context.register("DESCRIPTOR_UID", (Object)remotePartnerLinkData.getUniqueId());
        context.register("DESCRIPTOR_PROD_STRING", (Object)remotePartnerLinkData.getProdString());
        context.register("DESCRIPTOR_USER_STRING", (Object)remotePartnerLinkData.getUserString());
        context.register("PAIRING_STATE", (Object)pairingState);
        context.register("PAIRING_TIMEOUT", (Object)pairingTimeout);
        if (this.getSocketType() == NetBidibSocketType.clientSocket) {
            context.register("CONNECTION_TYPE", (Object)"client");
        } else {
            context.register("CONNECTION_TYPE", (Object)"server");
        }
        String actionKey = "pairing-state";
        LOGGER.info("Publish the user action actionKey: {}, with context: {}", (Object)actionKey, (Object)context);
        this.pairingInteractionPublisher.publishUserAction(actionKey, (Context)context);
    }

    @Override
    public void onLocalProtocolSignature(LocalProtocolSignatureMessage localProtocolSignatureMessage) {
        AbstractPairingState currentState = this.pairingStateMap.get((Object)this.currentPairingState);
        if (currentState != null) {
            if (this.initialResponseLock != null) {
                LOGGER.info("The initial localProtocolSignature was received.");
                this.initialResponseLock.countDown();
            }
            currentState.onLocalProtocolSignature(localProtocolSignatureMessage);
        } else {
            LOGGER.error("No pairing state configured for current pairing state: {}", (Object)this.currentPairingState);
        }
    }

    @Override
    public void onLocalLink(LocalLinkMessage localLinkMessage) {
        AbstractPairingState currentState = this.pairingStateMap.get((Object)this.currentPairingState);
        if (currentState != null) {
            currentState.onLocalLink(localLinkMessage);
        } else {
            LOGGER.error("No pairing state configured for current pairing state: {}", (Object)this.currentPairingState);
        }
    }

    @Override
    public void onLocalLogonAck(LocalLogonAckMessage localLogonAckMessage) {
        AbstractPairingState currentState = this.pairingStateMap.get((Object)this.currentPairingState);
        if (currentState != null) {
            currentState.onLocalLogonAck(localLogonAckMessage);
        } else {
            LOGGER.error("No pairing state configured for current pairing state: {}", (Object)this.currentPairingState);
        }
    }

    @Override
    public void onLocalLogon(LocalLogonMessage localLogonMessage) {
        AbstractPairingState currentState = this.pairingStateMap.get((Object)this.currentPairingState);
        if (currentState != null) {
            currentState.onLocalLogon(localLogonMessage);
        } else {
            LOGGER.error("No pairing state configured for current pairing state: {}", (Object)this.currentPairingState);
        }
    }

    @Override
    public void onLocalLogoff(LocalLogoffMessage localLogoffMessage) {
        AbstractPairingState currentState = this.pairingStateMap.get((Object)this.currentPairingState);
        if (currentState != null) {
            currentState.onLocalLogoff(localLogoffMessage);
        } else {
            LOGGER.error("No pairing state configured for current pairing state: {}", (Object)this.currentPairingState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isPaired(BidibLinkData bidibLinkData) {
        LOGGER.info("Check if the remote partner is paired: {}", (Object)bidibLinkData);
        LocalPairingStore.PairingLookupResult isPaired = LocalPairingStore.PairingLookupResult.UNPAIRED;
        if (this.pairingStore != null) {
            isPaired = this.pairingStore.isPaired(bidibLinkData.getUniqueId());
            if (LocalPairingStore.PairingLookupResult.MISSING == isPaired) {
                try {
                    Object object = this.pairingStoreLock;
                    synchronized (object) {
                        this.pairingStore.setPaired(bidibLinkData.getUniqueId(), bidibLinkData.getRequestorName(), bidibLinkData.getProdString(), bidibLinkData.getUserString(), bidibLinkData.getProtocolVersion(), false);
                        this.pairingStore.store();
                    }
                }
                catch (InvalidConfigurationException ex) {
                    LOGGER.warn("Set the pairing result in the pairing store failed.", (Throwable)ex);
                    this.pairingInteractionPublisher.handleError((RuntimeException)((Object)ex));
                }
                catch (Exception ex) {
                    LOGGER.warn("Set the pairing result in the pairing store failed.", (Throwable)ex);
                    this.pairingInteractionPublisher.handleError(new RuntimeException("Set the pairing result in the pairing store failed.", ex));
                }
                isPaired = LocalPairingStore.PairingLookupResult.UNPAIRED;
            }
        } else {
            LOGGER.warn("No pairing store configured!");
        }
        LOGGER.info("isPaired: {}, uniqueId: {}", (Object)isPaired, (Object)ByteUtils.formatHexUniqueId((Long)bidibLinkData.getUniqueId()));
        return LocalPairingStore.PairingLookupResult.PAIRED == isPaired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePairingStore(Long uniqueId, PairingResult pairingResult) {
        LOGGER.info("Update the pairing store, uniqueId: {}, pairingResult: {}", (Object)ByteUtils.getUniqueIdAsString((Long)uniqueId), (Object)pairingResult);
        if (this.pairingStore != null) {
            try {
                Object object = this.pairingStoreLock;
                synchronized (object) {
                    this.pairingStore.setPaired(uniqueId, PairingResult.PAIRED == pairingResult);
                    this.pairingStore.store();
                }
            }
            catch (InvalidConfigurationException ex) {
                LOGGER.warn("Set the pairing result in the pairing store failed.", (Throwable)ex);
                this.pairingInteractionPublisher.handleError((RuntimeException)((Object)ex));
            }
            catch (Exception ex) {
                LOGGER.warn("Set the pairing result in the pairing store failed.", (Throwable)ex);
                this.pairingInteractionPublisher.handleError(new RuntimeException("Set the pairing result in the pairing store failed.", ex));
            }
        } else {
            LOGGER.warn("No pairing store configured!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePairingStoreLinkData(BidibLinkData bidibLinkData) {
        LOGGER.info("Update the pairing store, bidibLinkData: {}", (Object)bidibLinkData);
        if (this.pairingStore != null) {
            try {
                Object object = this.pairingStoreLock;
                synchronized (object) {
                    this.pairingStore.updateLinkData(bidibLinkData);
                    this.pairingStore.store();
                }
            }
            catch (InvalidConfigurationException ex) {
                LOGGER.warn("Set the pairing result in the pairing store failed.", (Throwable)ex);
                this.pairingInteractionPublisher.handleError((RuntimeException)((Object)ex));
            }
            catch (Exception ex) {
                LOGGER.warn("Set the pairing result in the pairing store failed.", (Throwable)ex);
                this.pairingInteractionPublisher.handleError(new RuntimeException("Set the pairing result in the pairing store failed.", ex));
            }
        } else {
            LOGGER.warn("No pairing store configured!");
        }
    }

    @Override
    public void initiatePairing() {
        AbstractPairingState currentState = this.pairingStateMap.get((Object)this.currentPairingState);
        if (currentState != null) {
            currentState.initiatePairing(this.clientLinkData.getRequestedPairingTimeout());
        } else {
            LOGGER.error("No pairing state configured for current pairing state: {}", (Object)this.currentPairingState);
        }
    }

    @Override
    public void pairingResult(Long uniqueId, PairingResult pairingResult) {
        AbstractPairingState currentState = this.pairingStateMap.get((Object)this.currentPairingState);
        if (currentState != null) {
            LOGGER.info("Set the pairing result: {}, uniqueId: {}", (Object)pairingResult, (Object)ByteUtils.getUniqueIdAsString((Long)uniqueId));
            this.updatePairingStore(uniqueId, pairingResult);
            currentState.pairingResult(pairingResult);
        } else {
            LOGGER.error("No pairing state configured for current pairing state: {}", (Object)this.currentPairingState);
        }
    }

    @Override
    public void timeoutPairing() {
        AbstractPairingState currentState = this.pairingStateMap.get((Object)this.currentPairingState);
        if (currentState != null) {
            currentState.timeoutPairing();
        } else {
            LOGGER.error("No pairing state configured for current pairing state: {}", (Object)this.currentPairingState);
        }
    }

    @Override
    public void sendNetBidibStartupSequence() throws EstablishCommunicationFailedException {
        AbstractPairingState currentState = this.pairingStateMap.get((Object)this.currentPairingState);
        if (currentState != null) {
            this.initialResponseLock = new CountDownLatch(1);
            currentState.sendNetBidibStartupSequence();
            try {
                LOGGER.info("Wait for startup of netBidibPort instance.");
                boolean completed = this.initialResponseLock.await(3000L, TimeUnit.MILLISECONDS);
                LOGGER.info("Establish communication with bidib interface passed and has completed: {}", (Object)completed);
                if (!completed) {
                    throw new EstablishCommunicationFailedException("Establish communication with bidib interface did not complete in 3s", "");
                }
                this.initialResponseLock = null;
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Wait for establish communication with bidib interface was interrupted.", (Throwable)ex);
                throw new EstablishCommunicationFailedException("Wait for establish communication with bidib interface was interrupted.", "");
            }
        } else {
            LOGGER.error("No pairing state configured for current pairing state: {}", (Object)this.currentPairingState);
        }
    }
}

