/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.client.pairingstates;

import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.netbidib.BidibLinkData;
import org.bidib.jbidibc.messages.message.netbidib.LocalLinkMessage;
import org.bidib.jbidibc.messages.message.netbidib.LocalProtocolSignatureMessage;
import org.bidib.jbidibc.messages.message.netbidib.NetBidibLinkData;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.StringUtils;
import org.bidib.jbidibc.netbidib.client.pairingstates.AbstractPairingState;
import org.bidib.jbidibc.netbidib.client.pairingstates.DefaultPairingStateHandler;
import org.bidib.jbidibc.netbidib.client.pairingstates.PairingStateEnum;
import org.bidib.jbidibc.netbidib.client.pairingstates.ProxyBidibLinkData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitialPairingState
extends AbstractPairingState {
    private static final Logger LOGGER = LoggerFactory.getLogger(InitialPairingState.class);
    private final Object emitterLock = new Object();

    public InitialPairingState(DefaultPairingStateHandler pairingStateHandler, BidibLinkData remotePartnerLinkData, ProxyBidibLinkData clientLinkData) {
        super(pairingStateHandler, remotePartnerLinkData, clientLinkData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendNetBidibStartupSequence() {
        String requestorName = this.clientLinkData.getRequestorName();
        LOGGER.info("Send the startup sequence. Configured local requestor: {}", (Object)requestorName);
        try {
            LocalProtocolSignatureMessage localProtocolSignatureMessage = this.getRequestFactory().createLocalProtocolSignature(requestorName);
            Object object = this.emitterLock;
            synchronized (object) {
                this.publishMessage((BidibCommandMessage)localProtocolSignatureMessage);
                this.clientLinkData.setInitialEmitterSent(true);
                if (StringUtils.isNotBlank((CharSequence)this.remotePartnerLinkData.getRequestorName())) {
                    LOGGER.info("The requestorName of the remote partner is available already: {}", (Object)this.remotePartnerLinkData.getRequestorName());
                    this.publishInitialLinkData();
                }
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Send LocalProtocolSignature to remote partner failed.", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLocalProtocolSignature(LocalProtocolSignatureMessage localProtocolSignatureMessage) {
        LOGGER.info("onLocalProtocolSignature, localProtocolSignatureMessage: {}", (Object)localProtocolSignatureMessage);
        String requestorName = localProtocolSignatureMessage.getRequestorName();
        Object object = this.emitterLock;
        synchronized (object) {
            this.remotePartnerLinkData.setRequestorName(requestorName);
            LOGGER.info("Set the requestor in remotePartnerLinkData: {}", (Object)this.remotePartnerLinkData);
            if (this.clientLinkData.getInitialEmitterSent()) {
                LOGGER.info("The emitter was published already. Publish the initial link data.");
                this.publishInitialLinkData();
            }
        }
    }

    private void publishInitialLinkData() {
        try {
            long uniqueId = this.clientLinkData.getUniqueId();
            LOGGER.info("Publish the initial link data, uniqueId: {}", (Object)uniqueId);
            LocalLinkMessage bidibCommand = this.getRequestFactory().createLocalLinkDescriptorUid(uniqueId);
            this.publishMessage((BidibCommandMessage)bidibCommand);
            bidibCommand = this.getRequestFactory().createLocalLinkProdString(this.clientLinkData.getProdString());
            this.publishMessage((BidibCommandMessage)bidibCommand);
            bidibCommand = this.getRequestFactory().createLocalLinkUserString(this.clientLinkData.getUserString());
            this.publishMessage((BidibCommandMessage)bidibCommand);
            bidibCommand = this.getRequestFactory().createLocalLinkProtocolVersion(this.clientLinkData.getProtocolVersion());
            this.publishMessage((BidibCommandMessage)bidibCommand);
            bidibCommand = this.getRequestFactory().createLocalLinkNetBidibRole(this.clientLinkData.getNetBidibRole());
            this.publishMessage((BidibCommandMessage)bidibCommand);
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Send descriptor UID to remote partner failed.", (Throwable)ex);
        }
        LOGGER.info("Send the link data uniqueId, prod string, user string and protocol version to the server.");
    }

    @Override
    public void onLocalLink(LocalLinkMessage localLinkMessage) {
        switch (localLinkMessage.getLinkDescriptor()) {
            case 255: {
                LOGGER.info("Received the partner UID: {}", (Object)ByteUtils.formatHexUniqueId((long)localLinkMessage.getSenderUniqueId()));
                this.remotePartnerLinkData.setUniqueId(Long.valueOf(localLinkMessage.getSenderUniqueId()));
                boolean forcePaired = false;
                if (forcePaired || this.isPaired(this.remotePartnerLinkData)) {
                    LOGGER.info("The remote partner is paired already. Send the status paired.");
                    try {
                        LocalLinkMessage bidibCommand = this.getRequestFactory().createLocalLinkStatusPaired(this.clientLinkData.getUniqueId().longValue(), this.remotePartnerLinkData.getUniqueId().longValue());
                        this.publishMessage((BidibCommandMessage)bidibCommand);
                        this.clientLinkData.setPairingStatus(NetBidibLinkData.PairingStatus.PAIRED);
                        this.setNextPairingState(PairingStateEnum.MyRequest);
                    }
                    catch (ProtocolException ex) {
                        LOGGER.warn("Send LocalLinkStatusPaired to remote partner failed.", (Throwable)ex);
                    }
                    break;
                }
                LOGGER.info("Send the status unpaired.");
                try {
                    LocalLinkMessage bidibCommand = this.getRequestFactory().createLocalLinkStatusUnpaired(this.clientLinkData.getUniqueId().longValue(), this.remotePartnerLinkData.getUniqueId().longValue());
                    this.publishMessage((BidibCommandMessage)bidibCommand);
                    this.setNextPairingState(PairingStateEnum.Unpaired);
                }
                catch (ProtocolException ex) {
                    LOGGER.warn("Send LocalLinkStatusUnPaired to remote partner failed.", (Throwable)ex);
                }
                break;
            }
            case 128: {
                LOGGER.info("Received the partner P_VERSION: {}", (Object)localLinkMessage.getProtocolVersion());
                this.remotePartnerLinkData.setProtocolVersion(localLinkMessage.getProtocolVersion());
                break;
            }
            case 0: {
                LOGGER.info("Received the partner PROD_STRING: {}", (Object)localLinkMessage.getProdString());
                this.remotePartnerLinkData.setProdString(localLinkMessage.getProdString());
                break;
            }
            case 1: {
                LOGGER.info("Received the partner USER_STRING: {}", (Object)localLinkMessage.getProdString());
                this.remotePartnerLinkData.setUserString(localLinkMessage.getProdString());
                break;
            }
            case 127: {
                LOGGER.info("Received the partner ROLE: {}", (Object)localLinkMessage.getNetBidibRole());
                this.remotePartnerLinkData.setNetBidibRole(localLinkMessage.getNetBidibRole());
                break;
            }
            default: {
                super.onLocalLink(localLinkMessage);
            }
        }
    }
}

