/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.client.pairingstates;

import org.bidib.jbidibc.messages.enums.PairingResult;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.netbidib.BidibLinkData;
import org.bidib.jbidibc.messages.message.netbidib.LocalLinkMessage;
import org.bidib.jbidibc.messages.message.netbidib.NetBidibLinkData;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.netbidib.client.pairingstates.AbstractPairingState;
import org.bidib.jbidibc.netbidib.client.pairingstates.DefaultPairingStateHandler;
import org.bidib.jbidibc.netbidib.client.pairingstates.PairingStateEnum;
import org.bidib.jbidibc.netbidib.client.pairingstates.ProxyBidibLinkData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyRequestPairingState
extends AbstractPairingState {
    private static final Logger LOGGER = LoggerFactory.getLogger(MyRequestPairingState.class);

    public MyRequestPairingState(DefaultPairingStateHandler pairingStateHandler, BidibLinkData remotePartnerLinkData, ProxyBidibLinkData clientLinkData) {
        super(pairingStateHandler, remotePartnerLinkData, clientLinkData);
    }

    @Override
    public void onLocalLink(LocalLinkMessage localLinkMessage) {
        switch (localLinkMessage.getLinkDescriptor()) {
            case 252: {
                LOGGER.info("Received a pairing request, senderUID: {}, receiverUID: {}, pairingTimeout: {}", new Object[]{ByteUtils.formatHexUniqueId((long)localLinkMessage.getSenderUniqueId()), ByteUtils.formatHexUniqueId((long)localLinkMessage.getReceiverUniqueId()), localLinkMessage.getPairingTimeout()});
                this.signalPairingResult(NetBidibLinkData.PairingStatus.PAIRING_REQUESTED);
                this.remotePartnerLinkData.setRequestedPairingTimeout(localLinkMessage.getPairingTimeout());
                this.signalPairingRequest();
                break;
            }
            case 253: {
                LOGGER.info("Received the status unpaired from remote partner: {}", (Object)ByteUtils.formatHexUniqueId((long)localLinkMessage.getSenderUniqueId()));
                this.signalPairingResult(NetBidibLinkData.PairingStatus.UNPAIRED);
                this.setNextPairingState(PairingStateEnum.Unpaired);
                break;
            }
            case 254: {
                LOGGER.info("Received the status paired from remote partner: {}", (Object)ByteUtils.formatHexUniqueId((long)localLinkMessage.getSenderUniqueId()));
                if (this.clientLinkData.getPairingStatus() != NetBidibLinkData.PairingStatus.PAIRED) {
                    LOGGER.info("Send the paired state to the remote partner.");
                    try {
                        LocalLinkMessage pairedStateMessage = this.getRequestFactory().createLocalLinkStatusPaired(this.clientLinkData.getUniqueId().longValue(), this.remotePartnerLinkData.getUniqueId().longValue());
                        this.publishMessage((BidibCommandMessage)pairedStateMessage);
                    }
                    catch (ProtocolException ex) {
                        LOGGER.warn("Send LocalLinkStatusPaired to remote partner failed.", (Throwable)ex);
                    }
                }
                this.signalPairingResult(NetBidibLinkData.PairingStatus.PAIRED);
                this.setNextPairingState(PairingStateEnum.Paired);
                break;
            }
            default: {
                super.onLocalLink(localLinkMessage);
            }
        }
    }

    @Override
    public void pairingResult(PairingResult pairingResult) {
        LOGGER.info("pairingResult, pairingResult: {}", (Object)pairingResult);
        if (PairingResult.PAIRED == pairingResult) {
            LOGGER.info("Pairing request was accepted by user.");
            this.clientLinkData.setPairingStatus(NetBidibLinkData.PairingStatus.PAIRED);
            try {
                LocalLinkMessage pairedMessage = this.getRequestFactory().createLocalLinkStatusPaired(this.clientLinkData.getUniqueId().longValue(), this.remotePartnerLinkData.getUniqueId().longValue());
                this.publishMessage((BidibCommandMessage)pairedMessage);
            }
            catch (ProtocolException ex) {
                LOGGER.warn("Send LocalLinkStatusPaired to remote partner failed.", (Throwable)ex);
            }
        } else {
            LOGGER.warn("Pairing request was not accepted by user.");
            this.clientLinkData.setPairingStatus(NetBidibLinkData.PairingStatus.UNPAIRED);
            try {
                LocalLinkMessage unpairedMessage = this.getRequestFactory().createLocalLinkStatusUnpaired(this.clientLinkData.getUniqueId().longValue(), this.remotePartnerLinkData.getUniqueId().longValue());
                this.publishMessage((BidibCommandMessage)unpairedMessage);
                this.setNextPairingState(PairingStateEnum.Unpaired);
            }
            catch (ProtocolException ex) {
                LOGGER.warn("Send LocalLinkStatusUnpaired to remote partner failed.", (Throwable)ex);
            }
        }
    }
}

