/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.client.pairingstates;

import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.LocalLogoffMessage;
import org.bidib.jbidibc.messages.message.LocalLogonAckMessage;
import org.bidib.jbidibc.messages.message.LocalLogonMessage;
import org.bidib.jbidibc.messages.message.netbidib.BidibLinkData;
import org.bidib.jbidibc.messages.message.netbidib.LocalLinkMessage;
import org.bidib.jbidibc.messages.message.netbidib.NetBidibLinkData;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.netbidib.client.pairingstates.AbstractPairingState;
import org.bidib.jbidibc.netbidib.client.pairingstates.DefaultPairingStateHandler;
import org.bidib.jbidibc.netbidib.client.pairingstates.PairingStateEnum;
import org.bidib.jbidibc.netbidib.client.pairingstates.ProxyBidibLinkData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PairedPairingState
extends AbstractPairingState {
    private static final Logger LOGGER = LoggerFactory.getLogger(PairedPairingState.class);

    public PairedPairingState(DefaultPairingStateHandler pairingStateHandler, BidibLinkData remotePartnerLinkData, ProxyBidibLinkData clientLinkData) {
        super(pairingStateHandler, remotePartnerLinkData, clientLinkData);
    }

    @Override
    public void onLocalLink(LocalLinkMessage localLinkMessage) {
        switch (localLinkMessage.getLinkDescriptor()) {
            case 253: {
                LOGGER.info("Received the status unpaired from remote partner: {}", (Object)ByteUtils.formatHexUniqueId((long)localLinkMessage.getSenderUniqueId()));
                this.signalPairingResult(NetBidibLinkData.PairingStatus.WITHDRAWN);
                this.setNextPairingState(PairingStateEnum.Withdrawn);
                break;
            }
            default: {
                super.onLocalLink(localLinkMessage);
            }
        }
    }

    @Override
    public void onLocalLogon(LocalLogonMessage localLogonMessage) {
        LOGGER.info("onLocalLogon, localLogonMessage: {}", (Object)localLogonMessage);
        super.onLocalLogon(localLogonMessage);
        int localNodeAddr = 0;
        long uniqueId = localLogonMessage.getSenderUniqueId();
        LOGGER.info("LocalLogonMessage uniqueId: {}, remotePartnerLinkData.uniqueId: {}, use localNodeAddr: {}", new Object[]{uniqueId, this.remotePartnerLinkData.getUniqueId(), localNodeAddr});
        try {
            LocalLogonAckMessage message = this.getRequestFactory().createLocalLogonAckRequest(localNodeAddr, uniqueId);
            this.publishMessage((BidibCommandMessage)message);
            this.remotePartnerLinkData.setLogonStatus(NetBidibLinkData.LogonStatus.LOGGED_ON);
        }
        catch (Exception ex) {
            LOGGER.warn("Send the status paired to partner failed.", (Throwable)ex);
        }
        this.publishLocalLogon(localNodeAddr, uniqueId);
    }

    @Override
    public void onLocalLogoff(LocalLogoffMessage localLogoffMessage) {
        LOGGER.info("onLocalLogoff, localLogoffMessage: {}", (Object)localLogoffMessage);
        super.onLocalLogoff(localLogoffMessage);
        this.remotePartnerLinkData.setLogonStatus(NetBidibLinkData.LogonStatus.LOGGED_OFF);
        this.publishLocalLogoff(localLogoffMessage.getSenderUniqueId());
    }
}

