/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.client.pairingstates;

import org.bidib.jbidibc.messages.enums.PairingResult;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.netbidib.BidibLinkData;
import org.bidib.jbidibc.messages.message.netbidib.LocalLinkMessage;
import org.bidib.jbidibc.messages.message.netbidib.LocalProtocolSignatureMessage;
import org.bidib.jbidibc.messages.message.netbidib.NetBidibLinkData;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.netbidib.client.pairingstates.AbstractPairingState;
import org.bidib.jbidibc.netbidib.client.pairingstates.DefaultPairingStateHandler;
import org.bidib.jbidibc.netbidib.client.pairingstates.PairingStateEnum;
import org.bidib.jbidibc.netbidib.client.pairingstates.ProxyBidibLinkData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TheirRequestPairingState
extends AbstractPairingState {
    private static final Logger LOGGER = LoggerFactory.getLogger(TheirRequestPairingState.class);

    public TheirRequestPairingState(DefaultPairingStateHandler pairingStateHandler, BidibLinkData remotePartnerLinkData, ProxyBidibLinkData clientLinkData) {
        super(pairingStateHandler, remotePartnerLinkData, clientLinkData);
    }

    @Override
    public void onLocalProtocolSignature(LocalProtocolSignatureMessage localProtocolSignatureMessage) {
        LOGGER.info("onLocalProtocolSignature, localProtocolSignatureMessage: {}", (Object)localProtocolSignatureMessage);
        String requestorName = localProtocolSignatureMessage.getRequestorName();
        this.remotePartnerLinkData.setRequestorName(requestorName);
        LOGGER.info("Set the requestor in remotePartnerLinkData: {}", (Object)this.remotePartnerLinkData);
    }

    @Override
    public void onLocalLink(LocalLinkMessage localLinkMessage) {
        switch (localLinkMessage.getLinkDescriptor()) {
            case 253: {
                LOGGER.info("Received the status unpaired from remote partner: {}", (Object)ByteUtils.formatHexUniqueId((long)localLinkMessage.getSenderUniqueId()));
                this.signalPairingResult(NetBidibLinkData.PairingStatus.UNPAIRED);
                this.setNextPairingState(PairingStateEnum.Unpaired);
                break;
            }
            default: {
                super.onLocalLink(localLinkMessage);
            }
        }
    }

    @Override
    public void pairingResult(PairingResult pairingResult) {
        LOGGER.info("Handle the pairingResult: {}, current partnerType: {}", (Object)pairingResult, (Object)this.clientLinkData.getPartnerType());
        if (PairingResult.PAIRED == pairingResult) {
            try {
                int timeout = this.clientLinkData.getRequestedPairingTimeout();
                LocalLinkMessage pairingRequestMessage = this.getRequestFactory().createLocalLinkPairingRequest(this.clientLinkData.getUniqueId().longValue(), this.remotePartnerLinkData.getUniqueId().longValue(), timeout);
                this.publishMessage((BidibCommandMessage)pairingRequestMessage);
                this.clientLinkData.setPairingStatus(NetBidibLinkData.PairingStatus.PAIRING_REQUESTED);
                this.clientLinkData.setRequestedPairingTimeout(timeout);
                LOGGER.info("Send the status paired to the remote partner.");
                LocalLinkMessage statusPairedMessage = this.getRequestFactory().createLocalLinkStatusPaired(this.clientLinkData.getUniqueId().longValue(), this.remotePartnerLinkData.getUniqueId().longValue());
                this.publishMessage((BidibCommandMessage)statusPairedMessage);
                this.clientLinkData.setPairingStatus(NetBidibLinkData.PairingStatus.PAIRED);
                this.setNextPairingState(PairingStateEnum.MyRequest);
            }
            catch (Exception ex) {
                LOGGER.warn("Send the status paired to partner failed.", (Throwable)ex);
            }
        } else {
            try {
                LOGGER.info("Send the status unpaired to the remote partner.");
                LocalLinkMessage unpairedRequest = this.getRequestFactory().createLocalLinkStatusUnpaired(this.clientLinkData.getUniqueId().longValue(), this.remotePartnerLinkData.getUniqueId().longValue());
                this.publishMessage((BidibCommandMessage)unpairedRequest);
                this.clientLinkData.setPairingStatus(NetBidibLinkData.PairingStatus.UNPAIRED);
                this.setNextPairingState(PairingStateEnum.Unpaired);
            }
            catch (Exception ex) {
                LOGGER.warn("Send the status paired to partner failed.", (Throwable)ex);
            }
        }
    }
}

