/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.client.pairingstates;

import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.netbidib.BidibLinkData;
import org.bidib.jbidibc.messages.message.netbidib.LocalLinkMessage;
import org.bidib.jbidibc.messages.message.netbidib.LocalProtocolSignatureMessage;
import org.bidib.jbidibc.messages.message.netbidib.NetBidibLinkData;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.netbidib.client.pairingstates.AbstractPairingState;
import org.bidib.jbidibc.netbidib.client.pairingstates.DefaultPairingStateHandler;
import org.bidib.jbidibc.netbidib.client.pairingstates.PairingStateEnum;
import org.bidib.jbidibc.netbidib.client.pairingstates.ProxyBidibLinkData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnpairedPairingState
extends AbstractPairingState {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnpairedPairingState.class);

    public UnpairedPairingState(DefaultPairingStateHandler pairingStateHandler, BidibLinkData remotePartnerLinkData, ProxyBidibLinkData clientLinkData) {
        super(pairingStateHandler, remotePartnerLinkData, clientLinkData);
    }

    @Override
    public void onLocalProtocolSignature(LocalProtocolSignatureMessage localProtocolSignatureMessage) {
        LOGGER.info("onLocalProtocolSignature, localProtocolSignatureMessage: {}", (Object)localProtocolSignatureMessage);
        String requestorName = localProtocolSignatureMessage.getRequestorName();
        this.remotePartnerLinkData.setRequestorName(requestorName);
        LOGGER.info("Set the requestor in remotePartnerLinkData: {}", (Object)this.remotePartnerLinkData);
    }

    @Override
    public void onLocalLink(LocalLinkMessage localLinkMessage) {
        switch (localLinkMessage.getLinkDescriptor()) {
            case 255: {
                LOGGER.info("Received the partner UID: {}", (Object)ByteUtils.formatHexUniqueId((long)localLinkMessage.getSenderUniqueId()));
                this.remotePartnerLinkData.setUniqueId(Long.valueOf(localLinkMessage.getSenderUniqueId()));
                break;
            }
            case 128: {
                LOGGER.info("Received the partner P_VERSION: {}", (Object)localLinkMessage.getProtocolVersion());
                this.remotePartnerLinkData.setProtocolVersion(localLinkMessage.getProtocolVersion());
                break;
            }
            case 0: {
                LOGGER.info("Received the partner PROD_STRING: {}", (Object)localLinkMessage.getProdString());
                this.remotePartnerLinkData.setProdString(localLinkMessage.getProdString());
                break;
            }
            case 1: {
                LOGGER.info("Received the partner USER_STRING: {}", (Object)localLinkMessage.getProdString());
                this.remotePartnerLinkData.setUserString(localLinkMessage.getProdString());
                break;
            }
            case 252: {
                LOGGER.info("Received a pairing request, senderUID: {}, receiverUID: {}, pairingTimeout: {}", new Object[]{ByteUtils.formatHexUniqueId((long)localLinkMessage.getSenderUniqueId()), ByteUtils.formatHexUniqueId((long)localLinkMessage.getReceiverUniqueId()), localLinkMessage.getPairingTimeout()});
                this.remotePartnerLinkData.setPairingStatus(NetBidibLinkData.PairingStatus.PAIRING_REQUESTED);
                this.remotePartnerLinkData.setRequestedPairingTimeout(localLinkMessage.getPairingTimeout());
                this.setNextPairingState(PairingStateEnum.TheirRequest);
                this.signalPairingRequest();
                break;
            }
            case 253: {
                LOGGER.info("Received the status unpaired from remote partner: {}", (Object)ByteUtils.formatHexUniqueId((long)localLinkMessage.getSenderUniqueId()));
                this.signalPairingResult(NetBidibLinkData.PairingStatus.UNPAIRED);
                break;
            }
            case 254: {
                LOGGER.info("Received the status paired from remote partner: {}", (Object)ByteUtils.formatHexUniqueId((long)localLinkMessage.getSenderUniqueId()));
                this.signalPairingResult(NetBidibLinkData.PairingStatus.UNPAIRED);
                break;
            }
            default: {
                super.onLocalLink(localLinkMessage);
            }
        }
    }

    @Override
    public void initiatePairing(int timeout) {
        LOGGER.info("initPairing. Prepare the pairing request and send it to the remote partner, timeout: {}", (Object)timeout);
        try {
            LocalLinkMessage pairingRequestMessage = this.getRequestFactory().createLocalLinkPairingRequest(this.clientLinkData.getUniqueId().longValue(), this.remotePartnerLinkData.getUniqueId().longValue(), timeout);
            this.publishMessage((BidibCommandMessage)pairingRequestMessage);
            this.clientLinkData.setPairingStatus(NetBidibLinkData.PairingStatus.PAIRING_REQUESTED);
            this.clientLinkData.setRequestedPairingTimeout(timeout);
            this.setNextPairingState(PairingStateEnum.MyRequest);
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Send LocalLinkPairingRequest to remote partner failed.", (Throwable)ex);
        }
    }
}

