/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.debug;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.bidib.jbidibc.debug.DebugMessageReceiver;
import org.bidib.jbidibc.messages.ConnectionListener;
import org.bidib.jbidibc.messages.MessageReceiver;
import org.bidib.jbidibc.messages.exception.PortNotOpenedException;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.jbidibc.netbidib.client.DefaultNetMessageHandler;
import org.bidib.jbidibc.netbidib.client.NetBidibClientPort;
import org.bidib.jbidibc.netbidib.client.NetBidibPort;
import org.bidib.jbidibc.netbidib.client.NetMessageHandler;
import org.bidib.jbidibc.netbidib.client.listener.NetBidibPortConnectionStatusListener;
import org.bidib.jbidibc.netbidib.debug.NetBidibDebugClientInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetBidibDebugClient
implements NetBidibDebugClientInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetBidibDebugClient.class);
    private String connectedPortName;
    private InetAddress address;
    private int portNumber;
    private String protocol;
    private NetBidibPort port;
    private final DebugMessageReceiver messageReceiver;
    private NetMessageHandler netMessageHandler;
    private final ScheduledExecutorService portWorker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("netBidibDebugPortWorkers-thread-%d").build());

    public NetBidibDebugClient(DebugMessageReceiver debugMessageReceiver) {
        this.messageReceiver = debugMessageReceiver;
    }

    @Override
    public void open(String portName, final ConnectionListener connectionListener) throws PortNotOpenedException {
        NetBidibClientPort netBidibPort;
        LOGGER.info("Internal open port: {}", (Object)portName);
        String[] hostAndPort = portName.split(":");
        if (hostAndPort.length > 2) {
            this.protocol = hostAndPort[0];
            try {
                this.address = InetAddress.getByName(hostAndPort[1]);
            }
            catch (UnknownHostException ex) {
                throw new PortNotOpenedException("The provided host is not vaild.", hostAndPort[1]);
            }
            this.portNumber = Integer.parseInt(hostAndPort[2]);
        } else {
            this.protocol = "tcp";
            try {
                this.address = InetAddress.getByName(hostAndPort[0]);
            }
            catch (UnknownHostException ex) {
                throw new PortNotOpenedException("The provided host is not vaild.", hostAndPort[0]);
            }
            this.portNumber = Integer.parseInt(hostAndPort[1]);
        }
        this.connectedPortName = portName;
        LOGGER.info("Configured address: {}, portNumber: {}, protocol: {}", new Object[]{this.address, this.portNumber, this.protocol});
        MessageReceiver messageReceiverDelegate = new MessageReceiver(){

            public void cleanup() {
            }

            public void receive(ByteArrayOutputStream data) {
                NetBidibDebugClient.this.messageReceiver.processMessages(data);
            }
        };
        this.netMessageHandler = new DefaultNetMessageHandler(messageReceiverDelegate, this.address, this.portNumber, connectionListener);
        final CountDownLatch startupLock = new CountDownLatch(1);
        try {
            netBidibPort = new NetBidibClientPort(this.address, this.portNumber, this.netMessageHandler);
            netBidibPort.addConnectionStatusListener(new NetBidibPortConnectionStatusListener(){

                @Override
                public void opened() {
                    LOGGER.info("Opened with countDown latch.");
                    startupLock.countDown();
                    if (connectionListener != null) {
                        connectionListener.opened(NetBidibDebugClient.this.connectedPortName);
                    }
                }

                @Override
                public void closed() {
                    LOGGER.info("The netBidib connection was closed.");
                    if (connectionListener != null) {
                        connectionListener.closed(NetBidibDebugClient.this.connectedPortName);
                    }
                }

                @Override
                public void clientAccepted(String remoteAddress) {
                    LOGGER.info("Client accepted, remoteAddress: {}", (Object)remoteAddress);
                }
            });
            LOGGER.info("Prepare and start the port worker for netBidibPort: {}", (Object)netBidibPort);
            this.portWorker.submit(netBidibPort);
        }
        catch (IOException ex) {
            LOGGER.warn("Open netBidib port failed.", (Throwable)ex);
            throw new PortNotOpenedException("Open netBidib port failed.", ex.getMessage());
        }
        LOGGER.info("The netBidib port was opened: {}", (Object)netBidibPort);
        this.port = netBidibPort;
    }

    @Override
    public boolean isOpened() {
        return this.port != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LOGGER.info("Close the port.");
        if (this.port != null) {
            LOGGER.info("Stop the port.");
            NetBidibPort portToClose = this.port;
            this.port = null;
            portToClose.stop();
            if (this.portWorker != null) {
                ScheduledExecutorService scheduledExecutorService = this.portWorker;
                synchronized (scheduledExecutorService) {
                    try {
                        this.portWorker.shutdown();
                        this.portWorker.awaitTermination(5000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException ex) {
                        LOGGER.warn("Wait for termination of port worker failed.", (Throwable)ex);
                    }
                }
            }
        } else {
            LOGGER.info("No port to close available.");
        }
    }

    @Override
    public void send(byte[] data) {
        if (this.port != null) {
            try {
                this.port.send(data, this.address, this.portNumber);
            }
            catch (IOException ex) {
                LOGGER.warn("Send data to port failed.", (Throwable)ex);
            }
        }
    }
}

