/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.pairingstore;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.bidib.jbidibc.messages.ProtocolVersion;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.jbidibc.messages.message.netbidib.BidibLinkData;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.netbidib.pairingstore.PairingStore;
import org.bidib.jbidibc.netbidib.pairingstore.PairingStoreEntry;
import org.bidib.jbidibc.netbidib.pairingstore.PairingStoreProtocolVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalPairingStore
implements PairingStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalPairingStore.class);
    private Map<Long, PairingStoreEntry> pairingMap = new HashMap<Long, PairingStoreEntry>();
    private final transient ObjectMapper mapper;
    private final transient File pairingStore;

    public LocalPairingStore(File pairingStore) {
        this.pairingStore = pairingStore;
        this.mapper = new ObjectMapper();
        this.mapper.registerModule((Module)new JavaTimeModule());
    }

    @Override
    public File getPairingStore() {
        return this.pairingStore;
    }

    @Override
    public void checkValid() {
        LOGGER.info("Validate the pairing store at location: {}", (Object)this.pairingStore.getPath());
        try {
            FileUtils.forceMkdirParent((File)this.pairingStore);
            if (!this.pairingStore.getParentFile().exists() || !this.pairingStore.getParentFile().canWrite()) {
                throw new InvalidConfigurationException("Validate the pairing store failed from location: " + this.pairingStore.getPath());
            }
            this.mapper.readValue(this.pairingStore, PairingStoreEntry[].class);
        }
        catch (FileNotFoundException ex) {
            LOGGER.warn("Validate the pairing store failed because the file is not available: {}", (Object)ex.getMessage());
        }
        catch (IOException ex) {
            LOGGER.warn("Validate the pairing store failed.", (Throwable)ex);
            throw new InvalidConfigurationException("Validate the pairing store failed from location: " + this.pairingStore.getPath(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() {
        LocalPairingStore localPairingStore = this;
        synchronized (localPairingStore) {
            this.pairingMap.clear();
            try {
                PairingStoreEntry[] entries;
                for (PairingStoreEntry entry : entries = (PairingStoreEntry[])this.mapper.readValue(this.pairingStore, PairingStoreEntry[].class)) {
                    this.pairingMap.put(ByteUtils.parseHexUniqueId((String)entry.getUid()), entry);
                }
            }
            catch (FileNotFoundException ex) {
                LOGGER.warn("Load the pairing store failed because the file was not found: {}", (Object)ex.getMessage());
            }
            catch (IOException ex) {
                LOGGER.warn("Load the pairing store failed.", (Throwable)ex);
                throw new InvalidConfigurationException("Load the pairing store failed.");
            }
            LOGGER.debug("Current pairingMap: {}", this.pairingMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store() {
        LOGGER.info("Store the pairing store to file.");
        LocalPairingStore localPairingStore = this;
        synchronized (localPairingStore) {
            try {
                FileUtils.forceMkdirParent((File)this.pairingStore);
                this.mapper.writerWithDefaultPrettyPrinter().writeValue(this.pairingStore, (Object)this.pairingMap.values().toArray(new PairingStoreEntry[0]));
            }
            catch (IOException ex) {
                LOGGER.warn("Store pairing store failed.", (Throwable)ex);
                throw new InvalidConfigurationException("Store the pairing store failed. Location: " + this.pairingStore.getPath());
            }
            catch (Exception ex) {
                LOGGER.warn("Store pairing store failed.", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        LOGGER.info("Clear the pairing store.");
        LocalPairingStore localPairingStore = this;
        synchronized (localPairingStore) {
            this.pairingMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PairingLookupResult isPaired(long uniqueId) {
        Long lookupValue = uniqueId;
        PairingStoreEntry pairingStatus = null;
        LocalPairingStore localPairingStore = this;
        synchronized (localPairingStore) {
            if (this.pairingMap.isEmpty()) {
                return PairingLookupResult.MISSING;
            }
            pairingStatus = this.pairingMap.get(lookupValue);
        }
        if (pairingStatus == null) {
            return PairingLookupResult.MISSING;
        }
        return pairingStatus.isPaired() ? PairingLookupResult.PAIRED : PairingLookupResult.UNPAIRED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPaired(long uniqueId, String requestorName, String productName, String userName, ProtocolVersion protocolVersion, boolean pairingStatus) {
        LOGGER.info("Set the pairing status, uniqueId: {}, requestorName: {}, productName: {}, userName: {}, protocolVersion: {}, pairingStatus: {}", new Object[]{ByteUtils.formatHexUniqueId((long)uniqueId), requestorName, productName, userName, protocolVersion, pairingStatus});
        LocalPairingStore localPairingStore = this;
        synchronized (localPairingStore) {
            PairingStoreEntry entry = this.pairingMap.getOrDefault(uniqueId, new PairingStoreEntry(ByteUtils.formatHexUniqueId((long)uniqueId), pairingStatus));
            if (requestorName != null) {
                entry.setRequestorName(requestorName);
            }
            if (productName != null) {
                entry.setProductName(productName);
            }
            if (userName != null) {
                entry.setUserName(userName);
            }
            if (protocolVersion != null) {
                entry.setProtocolVersion(new PairingStoreProtocolVersion(protocolVersion));
            }
            entry.setPaired(pairingStatus);
            entry.setLastSeen(LocalDateTime.now());
            this.pairingMap.put(uniqueId, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPaired(long uniqueId, boolean pairingStatus) {
        LOGGER.info("Set the pairing status, uniqueId: {}, pairingStatus: {}", (Object)ByteUtils.formatHexUniqueId((long)uniqueId), (Object)pairingStatus);
        LocalPairingStore localPairingStore = this;
        synchronized (localPairingStore) {
            PairingStoreEntry entry = this.pairingMap.getOrDefault(uniqueId, new PairingStoreEntry(ByteUtils.formatHexUniqueId((long)uniqueId), pairingStatus));
            entry.setPaired(pairingStatus);
            entry.setLastSeen(LocalDateTime.now());
            this.pairingMap.put(uniqueId, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLinkData(BidibLinkData bidibLinkData) {
        LOGGER.info("Update the link data, bidibLinkData: {}", (Object)bidibLinkData);
        long uniqueId = bidibLinkData.getUniqueId();
        LocalPairingStore localPairingStore = this;
        synchronized (localPairingStore) {
            PairingStoreEntry entry = this.pairingMap.getOrDefault(uniqueId, new PairingStoreEntry(ByteUtils.formatHexUniqueId((long)uniqueId), false));
            if (bidibLinkData.getRequestorName() != null) {
                entry.setRequestorName(bidibLinkData.getRequestorName());
            }
            if (bidibLinkData.getProdString() != null) {
                entry.setProductName(bidibLinkData.getProdString());
            }
            if (bidibLinkData.getUserString() != null) {
                entry.setUserName(bidibLinkData.getUserString());
            }
            if (bidibLinkData.getProtocolVersion() != null) {
                entry.setProtocolVersion(new PairingStoreProtocolVersion(bidibLinkData.getProtocolVersion()));
            }
            entry.setLastSeen(LocalDateTime.now());
            this.pairingMap.put(uniqueId, entry);
        }
    }

    protected Map<Long, PairingStoreEntry> getPairingMap() {
        return this.pairingMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PairingStoreEntry> getPairingStoreEntries() {
        LinkedList<PairingStoreEntry> pairingStoreEntries = new LinkedList<PairingStoreEntry>();
        LocalPairingStore localPairingStore = this;
        synchronized (localPairingStore) {
            pairingStoreEntries.addAll(this.pairingMap.values());
        }
        return pairingStoreEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPairings(List<PairingStoreEntry> pairings) {
        LocalPairingStore localPairingStore = this;
        synchronized (localPairingStore) {
            this.pairingMap.clear();
            for (PairingStoreEntry entry : pairings) {
                this.pairingMap.put(ByteUtils.parseHexUniqueId((String)entry.getUid()), entry);
            }
        }
    }

    public static enum PairingLookupResult {
        MISSING,
        UNPAIRED,
        PAIRED;

    }
}

