/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.pairingstore;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.bidib.jbidibc.messages.ProtocolVersion;
import org.bidib.jbidibc.netbidib.pairingstore.ProtocolVersionDeserializer;
import org.bidib.jbidibc.netbidib.pairingstore.ProtocolVersionSerializer;

@JsonDeserialize(using=ProtocolVersionDeserializer.class)
@JsonSerialize(using=ProtocolVersionSerializer.class)
public class PairingStoreProtocolVersion {
    public static final String JSON_FIELDNAME = "protocolVersion";
    private int majorVersion;
    private int minorVersion;

    public PairingStoreProtocolVersion() {
    }

    public PairingStoreProtocolVersion(ProtocolVersion protocolVersion) {
        this.majorVersion = protocolVersion.getMajorVersion();
        this.minorVersion = protocolVersion.getMinorVersion();
    }

    public PairingStoreProtocolVersion(int majorVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public ProtocolVersion toProtocolVersion() {
        ProtocolVersion protocolVersion = new ProtocolVersion(this.majorVersion, this.minorVersion);
        return protocolVersion;
    }

    public String toString() {
        return this.majorVersion + "." + this.minorVersion;
    }
}

