/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.pairingstore;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.bidib.jbidibc.netbidib.pairingstore.PairingStoreProtocolVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolVersionDeserializer
extends StdDeserializer<PairingStoreProtocolVersion> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolVersionDeserializer.class);

    public ProtocolVersionDeserializer() {
        this(null);
    }

    public ProtocolVersionDeserializer(Class<?> vc) {
        super(vc);
    }

    public PairingStoreProtocolVersion deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        LOGGER.debug("Current node: {}", (Object)node);
        int majorVersion = 0;
        int minorVersion = 0;
        if (node instanceof ObjectNode) {
            majorVersion = (Integer)((IntNode)node.findValue("major")).numberValue();
            minorVersion = (Integer)((IntNode)node.findValue("minor")).numberValue();
        } else {
            String[] values = node.textValue().split("\\.");
            majorVersion = Integer.valueOf(values[0]);
            minorVersion = Integer.valueOf(values[1]);
        }
        return new PairingStoreProtocolVersion(majorVersion, minorVersion);
    }
}

