// this script referenced in page generated by JmriJFrameServlet.java, which also inserts some variables used here
// sets up a click listener plus a time-based refresh loop.  click listener sends click position to server

$(function () {

    //setup infinite image refresh loop
    setInterval(function () {
        reloadImage();
    },  noclickRetryTime * 1000);  //set refresh time in milliseconds

    //protect from updates if requested
    if (protect != true) {

        //add an image for showing cursor click position
        $('body').append("<img style='position:absolute;display:none;' id='crosshair' src='/images/crosshair.png'/>");

        //set up to handle click on image div
        $('div#frame_image_wrapper').click(function(event) {

            //show a momentary crosshair to point out cursor click position
            $('#crosshair').css({'top':event.pageY-7,'left':event.pageX-7}).show().fadeOut('slow');

            //send request to frameserver as if user clicked on imagemap
            $.get("/frame/" + frameName + ".html?" + event.pageX + "," + event.pageY, function(data) {
                reloadImage();  //ignore response value, but update the image
            });
        });
    } else {
        //turn off the pointer cursor when protected
        $('div#frame_image_wrapper').css({'cursor':'auto'});
    }

});

//perform the image reload, including gray-out on error
function reloadImage() {
    var img = new Image();
    $(img).load(function () {
        $("div#frame_image_wrapper").html(this)  //load updated image into wrapper
        .css("opacity","1.0");  //set the opacity to full on success
    }).error(function () {
        $("div#frame_image_wrapper").css("opacity","0.25"); //gray out image on error
    }).attr("src", "/frame/" + frameName + ".png?r="+ Math.floor(Math.random()*9999)); //include rand to force browser rtv
}
