# Bash and Zsh Completion for slpkg

To enable slpkg's command-line completion for Bash and Zsh, follow the instructions below for your preferred shell.

## Bash Completion for slpkg

To enable slpkg's Bash command-line completion, ensure you have the `bash-completion` package installed. If you don't have it yet, you can install it using slpkg:

```bash
$ slpkg install bash-completion -o slack_extra
```

Once `bash-completion` is installed:

- If Bash is your default login shell, simply restart your terminal session (or open a new one). Your Bash shell will automatically load the necessary completion scripts, including slpkg's, upon startup.

- If you start your session with another shell (e.g., Zsh) and then switch to Bash within that session (e.g., by typing `bash`), you'll need to manually source the completion scripts in the new Bash session:

```bash
$ source /etc/profile.d/bash_completion.sh
```

This will activate Bash completion for slpkg, allowing you to use tab-completion for commands and package names.

### Examples of Bash Completion:

- Completing a command:
  ```bash
  $ slpkg in
  ```
  Bash will complete to: `slpkg install`

- Completing a package name after 'install' (default repo):
  ```bash
  $ slpkg install py
  ```
  Bash might suggest: `python3`, `pyqt5`, `pygments`, etc.

- Completing a package name with a specified repository:
  ```bash
  $ slpkg install -o sbo n
  ```
  Bash might suggest packages like: `nginx`, `nodejs`, `nmap`, etc. from the 'sbo' repository.

## Zsh Completion for slpkg

To enable slpkg's command-line completion in Zsh, you need to ensure the Zsh completion system is properly configured. The slpkg package automatically installs the `_slpkg` completion script to the correct location (`/usr/share/zsh/site-functions/`).

### Ensure Zsh Completion System is Loaded:
For slpkg completion to work, Zsh's built-in completion system must be loaded. Most modern Zsh setups include these by default. However, if slpkg completion isn't working for you, check your `~/.zshrc` file. Make sure it contains (or similar lines that achieve the same purpose):

```zsh
# Set up Zsh completion system
fpath=(/usr/share/zsh/site-functions $fpath) # Tell Zsh where to find completion files
autoload -Uz compinit                      # Load the completion system
compinit -C                                # Initialize and cache completions
```

If these lines are missing from your `~/.zshrc` (or if your Zsh completion isn't working generally), add them.

**Important:** After modifying your `~/.zshrc`, you'll need to source it or open a new terminal for changes to take effect:

```bash
$ source ~/.zshrc
```

### Ensure Python Helper Script is Present:
Confirm that your Python completion helper script is located at `/usr/libexec/slpkg/shell_completion.py` and contains the final, working code we developed.

### Examples of Zsh Completion:

- Completing a command:
  ```bash
  $ slpkg
  ```
  Zsh will list all available slpkg commands:
  `update`, `upgrade`, `config`, `repo-info`, `clean-tmp`, `self-check`, `build`, `install`, `remove`, `download`, `list`, `info`, `search`, `dependees`, `tracking`, `changelog`, `version`, `help`

- Completing a command fragment:
  ```bash
  $ slpkg up
  ```
  Zsh will complete to: `slpkg update`

- Completing a package name after 'install' (default repo):
  ```bash
  $ slpkg install py
  ```
  Zsh might suggest: `python3`, `pyqt5`, `pygments`, `pyside2`, etc.

- Completing a package name with a specified repository:
  ```bash
  $ slpkg install -o sbo n
  ```
  Zsh might suggest packages like: `nginx`, `nodejs`, `nmap`, `nano`, `netdata`, etc. from the 'sbo' repository.

After following these steps and restarting your Zsh session (or opening a new one), slpkg completion should work correctly, providing suggestions for both commands and package names.