#include <protocols/dumprestore.h>

union u_spcl u_spcl;
union u_data u_data;

long long u_spcl_c_tapea() {
  return spcl.c_tapea_lo | (((uint64_t)spcl.c_tapea_hi) << 32);
}

void u_spcl_c_tapea_set(uint64_t v) {
  spcl.c_tapea_lo = v & 0xffffffffull;
  spcl.c_tapea_hi = v >> 32;
}

void u_spcl_c_tapea_add(uint64_t inc) {
  u_spcl_c_tapea_set(u_spcl_c_tapea() + inc);
}

long long u_spcl_c_firstrec(const struct s_spcl *buf) {
  return buf->c_firstrec_lo | (((uint64_t)buf->c_firstrec_hi) << 32);
}

void u_spcl_c_firstrec_set(uint64_t v) {
  spcl.c_firstrec_lo = v & 0xffffffffull;
  spcl.c_firstrec_hi = v >> 32;
}
