/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGADSBDemodAircraftState.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGADSBDemodAircraftState::SWGADSBDemodAircraftState(QString* json) {
    init();
    this->fromJson(*json);
}

SWGADSBDemodAircraftState::SWGADSBDemodAircraftState() {
    icao = nullptr;
    m_icao_isSet = false;
    callsign = nullptr;
    m_callsign_isSet = false;
    latitude = 0.0f;
    m_latitude_isSet = false;
    longitude = 0.0f;
    m_longitude_isSet = false;
    altitude = 0;
    m_altitude_isSet = false;
    ground_speed = 0;
    m_ground_speed_isSet = false;
}

SWGADSBDemodAircraftState::~SWGADSBDemodAircraftState() {
    this->cleanup();
}

void
SWGADSBDemodAircraftState::init() {
    icao = new QString("");
    m_icao_isSet = false;
    callsign = new QString("");
    m_callsign_isSet = false;
    latitude = 0.0f;
    m_latitude_isSet = false;
    longitude = 0.0f;
    m_longitude_isSet = false;
    altitude = 0;
    m_altitude_isSet = false;
    ground_speed = 0;
    m_ground_speed_isSet = false;
}

void
SWGADSBDemodAircraftState::cleanup() {
    if(icao != nullptr) { 
        delete icao;
    }
    if(callsign != nullptr) { 
        delete callsign;
    }




}

SWGADSBDemodAircraftState*
SWGADSBDemodAircraftState::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGADSBDemodAircraftState::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&icao, pJson["icao"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&callsign, pJson["callsign"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&latitude, pJson["latitude"], "float", "");
    
    ::SWGSDRangel::setValue(&longitude, pJson["longitude"], "float", "");
    
    ::SWGSDRangel::setValue(&altitude, pJson["altitude"], "qint32", "");
    
    ::SWGSDRangel::setValue(&ground_speed, pJson["groundSpeed"], "qint32", "");
    
}

QString
SWGADSBDemodAircraftState::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGADSBDemodAircraftState::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(icao != nullptr && *icao != QString("")){
        toJsonValue(QString("icao"), icao, obj, QString("QString"));
    }
    if(callsign != nullptr && *callsign != QString("")){
        toJsonValue(QString("callsign"), callsign, obj, QString("QString"));
    }
    if(m_latitude_isSet){
        obj->insert("latitude", QJsonValue(latitude));
    }
    if(m_longitude_isSet){
        obj->insert("longitude", QJsonValue(longitude));
    }
    if(m_altitude_isSet){
        obj->insert("altitude", QJsonValue(altitude));
    }
    if(m_ground_speed_isSet){
        obj->insert("groundSpeed", QJsonValue(ground_speed));
    }

    return obj;
}

QString*
SWGADSBDemodAircraftState::getIcao() {
    return icao;
}
void
SWGADSBDemodAircraftState::setIcao(QString* icao) {
    this->icao = icao;
    this->m_icao_isSet = true;
}

QString*
SWGADSBDemodAircraftState::getCallsign() {
    return callsign;
}
void
SWGADSBDemodAircraftState::setCallsign(QString* callsign) {
    this->callsign = callsign;
    this->m_callsign_isSet = true;
}

float
SWGADSBDemodAircraftState::getLatitude() {
    return latitude;
}
void
SWGADSBDemodAircraftState::setLatitude(float latitude) {
    this->latitude = latitude;
    this->m_latitude_isSet = true;
}

float
SWGADSBDemodAircraftState::getLongitude() {
    return longitude;
}
void
SWGADSBDemodAircraftState::setLongitude(float longitude) {
    this->longitude = longitude;
    this->m_longitude_isSet = true;
}

qint32
SWGADSBDemodAircraftState::getAltitude() {
    return altitude;
}
void
SWGADSBDemodAircraftState::setAltitude(qint32 altitude) {
    this->altitude = altitude;
    this->m_altitude_isSet = true;
}

qint32
SWGADSBDemodAircraftState::getGroundSpeed() {
    return ground_speed;
}
void
SWGADSBDemodAircraftState::setGroundSpeed(qint32 ground_speed) {
    this->ground_speed = ground_speed;
    this->m_ground_speed_isSet = true;
}


bool
SWGADSBDemodAircraftState::isSet(){
    bool isObjectUpdated = false;
    do{
        if(icao && *icao != QString("")){
            isObjectUpdated = true; break;
        }
        if(callsign && *callsign != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_latitude_isSet){
            isObjectUpdated = true; break;
        }
        if(m_longitude_isSet){
            isObjectUpdated = true; break;
        }
        if(m_altitude_isSet){
            isObjectUpdated = true; break;
        }
        if(m_ground_speed_isSet){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

