/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGAudioCATSISOSettings.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGAudioCATSISOSettings::SWGAudioCATSISOSettings(QString* json) {
    init();
    this->fromJson(*json);
}

SWGAudioCATSISOSettings::SWGAudioCATSISOSettings() {
    rx_center_frequency = 0L;
    m_rx_center_frequency_isSet = false;
    rx_sample_rate = 0;
    m_rx_sample_rate_isSet = false;
    tx_center_frequency = 0L;
    m_tx_center_frequency_isSet = false;
    tx_sample_rate = 0;
    m_tx_sample_rate_isSet = false;
    transverter_mode = 0;
    m_transverter_mode_isSet = false;
    transverter_delta_frequency = 0L;
    m_transverter_delta_frequency_isSet = false;
    iq_order = 0;
    m_iq_order_isSet = false;
    tx_enable = 0;
    m_tx_enable_isSet = false;
    ptt_spectrum_link = 0;
    m_ptt_spectrum_link_isSet = false;
    rx_device_name = nullptr;
    m_rx_device_name_isSet = false;
    rx_iq_mapping = 0;
    m_rx_iq_mapping_isSet = false;
    log2_decim = 0;
    m_log2_decim_isSet = false;
    fc_pos_rx = 0;
    m_fc_pos_rx_isSet = false;
    dc_block = 0;
    m_dc_block_isSet = false;
    iq_correction = 0;
    m_iq_correction_isSet = false;
    rx_volume = 0.0f;
    m_rx_volume_isSet = false;
    tx_device_name = nullptr;
    m_tx_device_name_isSet = false;
    tx_iq_mapping = 0;
    m_tx_iq_mapping_isSet = false;
    tx_volume = 0;
    m_tx_volume_isSet = false;
    cat_speed_index = 0;
    m_cat_speed_index_isSet = false;
    cat_data_bits_index = 0;
    m_cat_data_bits_index_isSet = false;
    cat_stop_bits_index = 0;
    m_cat_stop_bits_index_isSet = false;
    cat_handshake_index = 0;
    m_cat_handshake_index_isSet = false;
    cat_ptt_method_index = 0;
    m_cat_ptt_method_index_isSet = false;
    cat_dtr_high = 0;
    m_cat_dtr_high_isSet = false;
    cat_rts_high = 0;
    m_cat_rts_high_isSet = false;
    cat_polling_ms = 0;
    m_cat_polling_ms_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = nullptr;
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_device_index = 0;
    m_reverse_api_device_index_isSet = false;
}

SWGAudioCATSISOSettings::~SWGAudioCATSISOSettings() {
    this->cleanup();
}

void
SWGAudioCATSISOSettings::init() {
    rx_center_frequency = 0L;
    m_rx_center_frequency_isSet = false;
    rx_sample_rate = 0;
    m_rx_sample_rate_isSet = false;
    tx_center_frequency = 0L;
    m_tx_center_frequency_isSet = false;
    tx_sample_rate = 0;
    m_tx_sample_rate_isSet = false;
    transverter_mode = 0;
    m_transverter_mode_isSet = false;
    transverter_delta_frequency = 0L;
    m_transverter_delta_frequency_isSet = false;
    iq_order = 0;
    m_iq_order_isSet = false;
    tx_enable = 0;
    m_tx_enable_isSet = false;
    ptt_spectrum_link = 0;
    m_ptt_spectrum_link_isSet = false;
    rx_device_name = new QString("");
    m_rx_device_name_isSet = false;
    rx_iq_mapping = 0;
    m_rx_iq_mapping_isSet = false;
    log2_decim = 0;
    m_log2_decim_isSet = false;
    fc_pos_rx = 0;
    m_fc_pos_rx_isSet = false;
    dc_block = 0;
    m_dc_block_isSet = false;
    iq_correction = 0;
    m_iq_correction_isSet = false;
    rx_volume = 0.0f;
    m_rx_volume_isSet = false;
    tx_device_name = new QString("");
    m_tx_device_name_isSet = false;
    tx_iq_mapping = 0;
    m_tx_iq_mapping_isSet = false;
    tx_volume = 0;
    m_tx_volume_isSet = false;
    cat_speed_index = 0;
    m_cat_speed_index_isSet = false;
    cat_data_bits_index = 0;
    m_cat_data_bits_index_isSet = false;
    cat_stop_bits_index = 0;
    m_cat_stop_bits_index_isSet = false;
    cat_handshake_index = 0;
    m_cat_handshake_index_isSet = false;
    cat_ptt_method_index = 0;
    m_cat_ptt_method_index_isSet = false;
    cat_dtr_high = 0;
    m_cat_dtr_high_isSet = false;
    cat_rts_high = 0;
    m_cat_rts_high_isSet = false;
    cat_polling_ms = 0;
    m_cat_polling_ms_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = new QString("");
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_device_index = 0;
    m_reverse_api_device_index_isSet = false;
}

void
SWGAudioCATSISOSettings::cleanup() {









    if(rx_device_name != nullptr) { 
        delete rx_device_name;
    }






    if(tx_device_name != nullptr) { 
        delete tx_device_name;
    }











    if(reverse_api_address != nullptr) { 
        delete reverse_api_address;
    }


}

SWGAudioCATSISOSettings*
SWGAudioCATSISOSettings::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGAudioCATSISOSettings::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&rx_center_frequency, pJson["rxCenterFrequency"], "qint64", "");
    
    ::SWGSDRangel::setValue(&rx_sample_rate, pJson["rxSampleRate"], "qint32", "");
    
    ::SWGSDRangel::setValue(&tx_center_frequency, pJson["txCenterFrequency"], "qint64", "");
    
    ::SWGSDRangel::setValue(&tx_sample_rate, pJson["txSampleRate"], "qint32", "");
    
    ::SWGSDRangel::setValue(&transverter_mode, pJson["transverterMode"], "qint32", "");
    
    ::SWGSDRangel::setValue(&transverter_delta_frequency, pJson["transverterDeltaFrequency"], "qint64", "");
    
    ::SWGSDRangel::setValue(&iq_order, pJson["iqOrder"], "qint32", "");
    
    ::SWGSDRangel::setValue(&tx_enable, pJson["txEnable"], "qint32", "");
    
    ::SWGSDRangel::setValue(&ptt_spectrum_link, pJson["pttSpectrumLink"], "qint32", "");
    
    ::SWGSDRangel::setValue(&rx_device_name, pJson["rxDeviceName"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&rx_iq_mapping, pJson["rxIQMapping"], "qint32", "");
    
    ::SWGSDRangel::setValue(&log2_decim, pJson["log2Decim"], "qint32", "");
    
    ::SWGSDRangel::setValue(&fc_pos_rx, pJson["fcPosRx"], "qint32", "");
    
    ::SWGSDRangel::setValue(&dc_block, pJson["dcBlock"], "qint32", "");
    
    ::SWGSDRangel::setValue(&iq_correction, pJson["iqCorrection"], "qint32", "");
    
    ::SWGSDRangel::setValue(&rx_volume, pJson["rxVolume"], "float", "");
    
    ::SWGSDRangel::setValue(&tx_device_name, pJson["txDeviceName"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&tx_iq_mapping, pJson["txIQMapping"], "qint32", "");
    
    ::SWGSDRangel::setValue(&tx_volume, pJson["txVolume"], "qint32", "");
    
    ::SWGSDRangel::setValue(&cat_speed_index, pJson["catSpeedIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&cat_data_bits_index, pJson["catDataBitsIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&cat_stop_bits_index, pJson["catStopBitsIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&cat_handshake_index, pJson["catHandshakeIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&cat_ptt_method_index, pJson["catPTTMethodIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&cat_dtr_high, pJson["catDTRHigh"], "qint32", "");
    
    ::SWGSDRangel::setValue(&cat_rts_high, pJson["catRTSHigh"], "qint32", "");
    
    ::SWGSDRangel::setValue(&cat_polling_ms, pJson["catPollingMs"], "qint32", "");
    
    ::SWGSDRangel::setValue(&use_reverse_api, pJson["useReverseAPI"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_address, pJson["reverseAPIAddress"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&reverse_api_port, pJson["reverseAPIPort"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_device_index, pJson["reverseAPIDeviceIndex"], "qint32", "");
    
}

QString
SWGAudioCATSISOSettings::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGAudioCATSISOSettings::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_rx_center_frequency_isSet){
        obj->insert("rxCenterFrequency", QJsonValue(rx_center_frequency));
    }
    if(m_rx_sample_rate_isSet){
        obj->insert("rxSampleRate", QJsonValue(rx_sample_rate));
    }
    if(m_tx_center_frequency_isSet){
        obj->insert("txCenterFrequency", QJsonValue(tx_center_frequency));
    }
    if(m_tx_sample_rate_isSet){
        obj->insert("txSampleRate", QJsonValue(tx_sample_rate));
    }
    if(m_transverter_mode_isSet){
        obj->insert("transverterMode", QJsonValue(transverter_mode));
    }
    if(m_transverter_delta_frequency_isSet){
        obj->insert("transverterDeltaFrequency", QJsonValue(transverter_delta_frequency));
    }
    if(m_iq_order_isSet){
        obj->insert("iqOrder", QJsonValue(iq_order));
    }
    if(m_tx_enable_isSet){
        obj->insert("txEnable", QJsonValue(tx_enable));
    }
    if(m_ptt_spectrum_link_isSet){
        obj->insert("pttSpectrumLink", QJsonValue(ptt_spectrum_link));
    }
    if(rx_device_name != nullptr && *rx_device_name != QString("")){
        toJsonValue(QString("rxDeviceName"), rx_device_name, obj, QString("QString"));
    }
    if(m_rx_iq_mapping_isSet){
        obj->insert("rxIQMapping", QJsonValue(rx_iq_mapping));
    }
    if(m_log2_decim_isSet){
        obj->insert("log2Decim", QJsonValue(log2_decim));
    }
    if(m_fc_pos_rx_isSet){
        obj->insert("fcPosRx", QJsonValue(fc_pos_rx));
    }
    if(m_dc_block_isSet){
        obj->insert("dcBlock", QJsonValue(dc_block));
    }
    if(m_iq_correction_isSet){
        obj->insert("iqCorrection", QJsonValue(iq_correction));
    }
    if(m_rx_volume_isSet){
        obj->insert("rxVolume", QJsonValue(rx_volume));
    }
    if(tx_device_name != nullptr && *tx_device_name != QString("")){
        toJsonValue(QString("txDeviceName"), tx_device_name, obj, QString("QString"));
    }
    if(m_tx_iq_mapping_isSet){
        obj->insert("txIQMapping", QJsonValue(tx_iq_mapping));
    }
    if(m_tx_volume_isSet){
        obj->insert("txVolume", QJsonValue(tx_volume));
    }
    if(m_cat_speed_index_isSet){
        obj->insert("catSpeedIndex", QJsonValue(cat_speed_index));
    }
    if(m_cat_data_bits_index_isSet){
        obj->insert("catDataBitsIndex", QJsonValue(cat_data_bits_index));
    }
    if(m_cat_stop_bits_index_isSet){
        obj->insert("catStopBitsIndex", QJsonValue(cat_stop_bits_index));
    }
    if(m_cat_handshake_index_isSet){
        obj->insert("catHandshakeIndex", QJsonValue(cat_handshake_index));
    }
    if(m_cat_ptt_method_index_isSet){
        obj->insert("catPTTMethodIndex", QJsonValue(cat_ptt_method_index));
    }
    if(m_cat_dtr_high_isSet){
        obj->insert("catDTRHigh", QJsonValue(cat_dtr_high));
    }
    if(m_cat_rts_high_isSet){
        obj->insert("catRTSHigh", QJsonValue(cat_rts_high));
    }
    if(m_cat_polling_ms_isSet){
        obj->insert("catPollingMs", QJsonValue(cat_polling_ms));
    }
    if(m_use_reverse_api_isSet){
        obj->insert("useReverseAPI", QJsonValue(use_reverse_api));
    }
    if(reverse_api_address != nullptr && *reverse_api_address != QString("")){
        toJsonValue(QString("reverseAPIAddress"), reverse_api_address, obj, QString("QString"));
    }
    if(m_reverse_api_port_isSet){
        obj->insert("reverseAPIPort", QJsonValue(reverse_api_port));
    }
    if(m_reverse_api_device_index_isSet){
        obj->insert("reverseAPIDeviceIndex", QJsonValue(reverse_api_device_index));
    }

    return obj;
}

qint64
SWGAudioCATSISOSettings::getRxCenterFrequency() {
    return rx_center_frequency;
}
void
SWGAudioCATSISOSettings::setRxCenterFrequency(qint64 rx_center_frequency) {
    this->rx_center_frequency = rx_center_frequency;
    this->m_rx_center_frequency_isSet = true;
}

qint32
SWGAudioCATSISOSettings::getRxSampleRate() {
    return rx_sample_rate;
}
void
SWGAudioCATSISOSettings::setRxSampleRate(qint32 rx_sample_rate) {
    this->rx_sample_rate = rx_sample_rate;
    this->m_rx_sample_rate_isSet = true;
}

qint64
SWGAudioCATSISOSettings::getTxCenterFrequency() {
    return tx_center_frequency;
}
void
SWGAudioCATSISOSettings::setTxCenterFrequency(qint64 tx_center_frequency) {
    this->tx_center_frequency = tx_center_frequency;
    this->m_tx_center_frequency_isSet = true;
}

qint32
SWGAudioCATSISOSettings::getTxSampleRate() {
    return tx_sample_rate;
}
void
SWGAudioCATSISOSettings::setTxSampleRate(qint32 tx_sample_rate) {
    this->tx_sample_rate = tx_sample_rate;
    this->m_tx_sample_rate_isSet = true;
}

qint32
SWGAudioCATSISOSettings::getTransverterMode() {
    return transverter_mode;
}
void
SWGAudioCATSISOSettings::setTransverterMode(qint32 transverter_mode) {
    this->transverter_mode = transverter_mode;
    this->m_transverter_mode_isSet = true;
}

qint64
SWGAudioCATSISOSettings::getTransverterDeltaFrequency() {
    return transverter_delta_frequency;
}
void
SWGAudioCATSISOSettings::setTransverterDeltaFrequency(qint64 transverter_delta_frequency) {
    this->transverter_delta_frequency = transverter_delta_frequency;
    this->m_transverter_delta_frequency_isSet = true;
}

qint32
SWGAudioCATSISOSettings::getIqOrder() {
    return iq_order;
}
void
SWGAudioCATSISOSettings::setIqOrder(qint32 iq_order) {
    this->iq_order = iq_order;
    this->m_iq_order_isSet = true;
}

qint32
SWGAudioCATSISOSettings::getTxEnable() {
    return tx_enable;
}
void
SWGAudioCATSISOSettings::setTxEnable(qint32 tx_enable) {
    this->tx_enable = tx_enable;
    this->m_tx_enable_isSet = true;
}

qint32
SWGAudioCATSISOSettings::getPttSpectrumLink() {
    return ptt_spectrum_link;
}
void
SWGAudioCATSISOSettings::setPttSpectrumLink(qint32 ptt_spectrum_link) {
    this->ptt_spectrum_link = ptt_spectrum_link;
    this->m_ptt_spectrum_link_isSet = true;
}

QString*
SWGAudioCATSISOSettings::getRxDeviceName() {
    return rx_device_name;
}
void
SWGAudioCATSISOSettings::setRxDeviceName(QString* rx_device_name) {
    this->rx_device_name = rx_device_name;
    this->m_rx_device_name_isSet = true;
}

qint32
SWGAudioCATSISOSettings::getRxIqMapping() {
    return rx_iq_mapping;
}
void
SWGAudioCATSISOSettings::setRxIqMapping(qint32 rx_iq_mapping) {
    this->rx_iq_mapping = rx_iq_mapping;
    this->m_rx_iq_mapping_isSet = true;
}

qint32
SWGAudioCATSISOSettings::getLog2Decim() {
    return log2_decim;
}
void
SWGAudioCATSISOSettings::setLog2Decim(qint32 log2_decim) {
    this->log2_decim = log2_decim;
    this->m_log2_decim_isSet = true;
}

qint32
SWGAudioCATSISOSettings::getFcPosRx() {
    return fc_pos_rx;
}
void
SWGAudioCATSISOSettings::setFcPosRx(qint32 fc_pos_rx) {
    this->fc_pos_rx = fc_pos_rx;
    this->m_fc_pos_rx_isSet = true;
}

qint32
SWGAudioCATSISOSettings::getDcBlock() {
    return dc_block;
}
void
SWGAudioCATSISOSettings::setDcBlock(qint32 dc_block) {
    this->dc_block = dc_block;
    this->m_dc_block_isSet = true;
}

qint32
SWGAudioCATSISOSettings::getIqCorrection() {
    return iq_correction;
}
void
SWGAudioCATSISOSettings::setIqCorrection(qint32 iq_correction) {
    this->iq_correction = iq_correction;
    this->m_iq_correction_isSet = true;
}

float
SWGAudioCATSISOSettings::getRxVolume() {
    return rx_volume;
}
void
SWGAudioCATSISOSettings::setRxVolume(float rx_volume) {
    this->rx_volume = rx_volume;
    this->m_rx_volume_isSet = true;
}

QString*
SWGAudioCATSISOSettings::getTxDeviceName() {
    return tx_device_name;
}
void
SWGAudioCATSISOSettings::setTxDeviceName(QString* tx_device_name) {
    this->tx_device_name = tx_device_name;
    this->m_tx_device_name_isSet = true;
}

qint32
SWGAudioCATSISOSettings::getTxIqMapping() {
    return tx_iq_mapping;
}
void
SWGAudioCATSISOSettings::setTxIqMapping(qint32 tx_iq_mapping) {
    this->tx_iq_mapping = tx_iq_mapping;
    this->m_tx_iq_mapping_isSet = true;
}

qint32
SWGAudioCATSISOSettings::getTxVolume() {
    return tx_volume;
}
void
SWGAudioCATSISOSettings::setTxVolume(qint32 tx_volume) {
    this->tx_volume = tx_volume;
    this->m_tx_volume_isSet = true;
}

qint32
SWGAudioCATSISOSettings::getCatSpeedIndex() {
    return cat_speed_index;
}
void
SWGAudioCATSISOSettings::setCatSpeedIndex(qint32 cat_speed_index) {
    this->cat_speed_index = cat_speed_index;
    this->m_cat_speed_index_isSet = true;
}

qint32
SWGAudioCATSISOSettings::getCatDataBitsIndex() {
    return cat_data_bits_index;
}
void
SWGAudioCATSISOSettings::setCatDataBitsIndex(qint32 cat_data_bits_index) {
    this->cat_data_bits_index = cat_data_bits_index;
    this->m_cat_data_bits_index_isSet = true;
}

qint32
SWGAudioCATSISOSettings::getCatStopBitsIndex() {
    return cat_stop_bits_index;
}
void
SWGAudioCATSISOSettings::setCatStopBitsIndex(qint32 cat_stop_bits_index) {
    this->cat_stop_bits_index = cat_stop_bits_index;
    this->m_cat_stop_bits_index_isSet = true;
}

qint32
SWGAudioCATSISOSettings::getCatHandshakeIndex() {
    return cat_handshake_index;
}
void
SWGAudioCATSISOSettings::setCatHandshakeIndex(qint32 cat_handshake_index) {
    this->cat_handshake_index = cat_handshake_index;
    this->m_cat_handshake_index_isSet = true;
}

qint32
SWGAudioCATSISOSettings::getCatPttMethodIndex() {
    return cat_ptt_method_index;
}
void
SWGAudioCATSISOSettings::setCatPttMethodIndex(qint32 cat_ptt_method_index) {
    this->cat_ptt_method_index = cat_ptt_method_index;
    this->m_cat_ptt_method_index_isSet = true;
}

qint32
SWGAudioCATSISOSettings::getCatDtrHigh() {
    return cat_dtr_high;
}
void
SWGAudioCATSISOSettings::setCatDtrHigh(qint32 cat_dtr_high) {
    this->cat_dtr_high = cat_dtr_high;
    this->m_cat_dtr_high_isSet = true;
}

qint32
SWGAudioCATSISOSettings::getCatRtsHigh() {
    return cat_rts_high;
}
void
SWGAudioCATSISOSettings::setCatRtsHigh(qint32 cat_rts_high) {
    this->cat_rts_high = cat_rts_high;
    this->m_cat_rts_high_isSet = true;
}

qint32
SWGAudioCATSISOSettings::getCatPollingMs() {
    return cat_polling_ms;
}
void
SWGAudioCATSISOSettings::setCatPollingMs(qint32 cat_polling_ms) {
    this->cat_polling_ms = cat_polling_ms;
    this->m_cat_polling_ms_isSet = true;
}

qint32
SWGAudioCATSISOSettings::getUseReverseApi() {
    return use_reverse_api;
}
void
SWGAudioCATSISOSettings::setUseReverseApi(qint32 use_reverse_api) {
    this->use_reverse_api = use_reverse_api;
    this->m_use_reverse_api_isSet = true;
}

QString*
SWGAudioCATSISOSettings::getReverseApiAddress() {
    return reverse_api_address;
}
void
SWGAudioCATSISOSettings::setReverseApiAddress(QString* reverse_api_address) {
    this->reverse_api_address = reverse_api_address;
    this->m_reverse_api_address_isSet = true;
}

qint32
SWGAudioCATSISOSettings::getReverseApiPort() {
    return reverse_api_port;
}
void
SWGAudioCATSISOSettings::setReverseApiPort(qint32 reverse_api_port) {
    this->reverse_api_port = reverse_api_port;
    this->m_reverse_api_port_isSet = true;
}

qint32
SWGAudioCATSISOSettings::getReverseApiDeviceIndex() {
    return reverse_api_device_index;
}
void
SWGAudioCATSISOSettings::setReverseApiDeviceIndex(qint32 reverse_api_device_index) {
    this->reverse_api_device_index = reverse_api_device_index;
    this->m_reverse_api_device_index_isSet = true;
}


bool
SWGAudioCATSISOSettings::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_rx_center_frequency_isSet){
            isObjectUpdated = true; break;
        }
        if(m_rx_sample_rate_isSet){
            isObjectUpdated = true; break;
        }
        if(m_tx_center_frequency_isSet){
            isObjectUpdated = true; break;
        }
        if(m_tx_sample_rate_isSet){
            isObjectUpdated = true; break;
        }
        if(m_transverter_mode_isSet){
            isObjectUpdated = true; break;
        }
        if(m_transverter_delta_frequency_isSet){
            isObjectUpdated = true; break;
        }
        if(m_iq_order_isSet){
            isObjectUpdated = true; break;
        }
        if(m_tx_enable_isSet){
            isObjectUpdated = true; break;
        }
        if(m_ptt_spectrum_link_isSet){
            isObjectUpdated = true; break;
        }
        if(rx_device_name && *rx_device_name != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_rx_iq_mapping_isSet){
            isObjectUpdated = true; break;
        }
        if(m_log2_decim_isSet){
            isObjectUpdated = true; break;
        }
        if(m_fc_pos_rx_isSet){
            isObjectUpdated = true; break;
        }
        if(m_dc_block_isSet){
            isObjectUpdated = true; break;
        }
        if(m_iq_correction_isSet){
            isObjectUpdated = true; break;
        }
        if(m_rx_volume_isSet){
            isObjectUpdated = true; break;
        }
        if(tx_device_name && *tx_device_name != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_tx_iq_mapping_isSet){
            isObjectUpdated = true; break;
        }
        if(m_tx_volume_isSet){
            isObjectUpdated = true; break;
        }
        if(m_cat_speed_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_cat_data_bits_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_cat_stop_bits_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_cat_handshake_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_cat_ptt_method_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_cat_dtr_high_isSet){
            isObjectUpdated = true; break;
        }
        if(m_cat_rts_high_isSet){
            isObjectUpdated = true; break;
        }
        if(m_cat_polling_ms_isSet){
            isObjectUpdated = true; break;
        }
        if(m_use_reverse_api_isSet){
            isObjectUpdated = true; break;
        }
        if(reverse_api_address && *reverse_api_address != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_port_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_device_index_isSet){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

