/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGChirpChatModReport.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGChirpChatModReport::SWGChirpChatModReport(QString* json) {
    init();
    this->fromJson(*json);
}

SWGChirpChatModReport::SWGChirpChatModReport() {
    channel_power_db = 0.0f;
    m_channel_power_db_isSet = false;
    channel_sample_rate = 0;
    m_channel_sample_rate_isSet = false;
    symbol_time_ms = 0.0f;
    m_symbol_time_ms_isSet = false;
    payload_time_ms = 0.0f;
    m_payload_time_ms_isSet = false;
    total_time_ms = 0.0f;
    m_total_time_ms_isSet = false;
    playing = 0;
    m_playing_isSet = false;
}

SWGChirpChatModReport::~SWGChirpChatModReport() {
    this->cleanup();
}

void
SWGChirpChatModReport::init() {
    channel_power_db = 0.0f;
    m_channel_power_db_isSet = false;
    channel_sample_rate = 0;
    m_channel_sample_rate_isSet = false;
    symbol_time_ms = 0.0f;
    m_symbol_time_ms_isSet = false;
    payload_time_ms = 0.0f;
    m_payload_time_ms_isSet = false;
    total_time_ms = 0.0f;
    m_total_time_ms_isSet = false;
    playing = 0;
    m_playing_isSet = false;
}

void
SWGChirpChatModReport::cleanup() {






}

SWGChirpChatModReport*
SWGChirpChatModReport::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGChirpChatModReport::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&channel_power_db, pJson["channelPowerDB"], "float", "");
    
    ::SWGSDRangel::setValue(&channel_sample_rate, pJson["channelSampleRate"], "qint32", "");
    
    ::SWGSDRangel::setValue(&symbol_time_ms, pJson["symbolTimeMs"], "float", "");
    
    ::SWGSDRangel::setValue(&payload_time_ms, pJson["payloadTimeMs"], "float", "");
    
    ::SWGSDRangel::setValue(&total_time_ms, pJson["totalTimeMs"], "float", "");
    
    ::SWGSDRangel::setValue(&playing, pJson["playing"], "qint32", "");
    
}

QString
SWGChirpChatModReport::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGChirpChatModReport::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_channel_power_db_isSet){
        obj->insert("channelPowerDB", QJsonValue(channel_power_db));
    }
    if(m_channel_sample_rate_isSet){
        obj->insert("channelSampleRate", QJsonValue(channel_sample_rate));
    }
    if(m_symbol_time_ms_isSet){
        obj->insert("symbolTimeMs", QJsonValue(symbol_time_ms));
    }
    if(m_payload_time_ms_isSet){
        obj->insert("payloadTimeMs", QJsonValue(payload_time_ms));
    }
    if(m_total_time_ms_isSet){
        obj->insert("totalTimeMs", QJsonValue(total_time_ms));
    }
    if(m_playing_isSet){
        obj->insert("playing", QJsonValue(playing));
    }

    return obj;
}

float
SWGChirpChatModReport::getChannelPowerDb() {
    return channel_power_db;
}
void
SWGChirpChatModReport::setChannelPowerDb(float channel_power_db) {
    this->channel_power_db = channel_power_db;
    this->m_channel_power_db_isSet = true;
}

qint32
SWGChirpChatModReport::getChannelSampleRate() {
    return channel_sample_rate;
}
void
SWGChirpChatModReport::setChannelSampleRate(qint32 channel_sample_rate) {
    this->channel_sample_rate = channel_sample_rate;
    this->m_channel_sample_rate_isSet = true;
}

float
SWGChirpChatModReport::getSymbolTimeMs() {
    return symbol_time_ms;
}
void
SWGChirpChatModReport::setSymbolTimeMs(float symbol_time_ms) {
    this->symbol_time_ms = symbol_time_ms;
    this->m_symbol_time_ms_isSet = true;
}

float
SWGChirpChatModReport::getPayloadTimeMs() {
    return payload_time_ms;
}
void
SWGChirpChatModReport::setPayloadTimeMs(float payload_time_ms) {
    this->payload_time_ms = payload_time_ms;
    this->m_payload_time_ms_isSet = true;
}

float
SWGChirpChatModReport::getTotalTimeMs() {
    return total_time_ms;
}
void
SWGChirpChatModReport::setTotalTimeMs(float total_time_ms) {
    this->total_time_ms = total_time_ms;
    this->m_total_time_ms_isSet = true;
}

qint32
SWGChirpChatModReport::getPlaying() {
    return playing;
}
void
SWGChirpChatModReport::setPlaying(qint32 playing) {
    this->playing = playing;
    this->m_playing_isSet = true;
}


bool
SWGChirpChatModReport::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_channel_power_db_isSet){
            isObjectUpdated = true; break;
        }
        if(m_channel_sample_rate_isSet){
            isObjectUpdated = true; break;
        }
        if(m_symbol_time_ms_isSet){
            isObjectUpdated = true; break;
        }
        if(m_payload_time_ms_isSet){
            isObjectUpdated = true; break;
        }
        if(m_total_time_ms_isSet){
            isObjectUpdated = true; break;
        }
        if(m_playing_isSet){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

