/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGFeatureSettings.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGFeatureSettings::SWGFeatureSettings(QString* json) {
    init();
    this->fromJson(*json);
}

SWGFeatureSettings::SWGFeatureSettings() {
    feature_type = nullptr;
    m_feature_type_isSet = false;
    originator_feature_set_index = 0;
    m_originator_feature_set_index_isSet = false;
    originator_feature_index = 0;
    m_originator_feature_index_isSet = false;
    afc_settings = nullptr;
    m_afc_settings_isSet = false;
    ais_settings = nullptr;
    m_ais_settings_isSet = false;
    ambe_settings = nullptr;
    m_ambe_settings_isSet = false;
    antenna_tools_settings = nullptr;
    m_antenna_tools_settings_isSet = false;
    aprs_settings = nullptr;
    m_aprs_settings_isSet = false;
    demod_analyzer_settings = nullptr;
    m_demod_analyzer_settings_isSet = false;
    jogdial_controller_settings = nullptr;
    m_jogdial_controller_settings_isSet = false;
    gs232_controller_settings = nullptr;
    m_gs232_controller_settings_isSet = false;
    lime_rfe_settings = nullptr;
    m_lime_rfe_settings_isSet = false;
    map_settings = nullptr;
    m_map_settings_isSet = false;
    morse_decoder_settings = nullptr;
    m_morse_decoder_settings_isSet = false;
    per_tester_settings = nullptr;
    m_per_tester_settings_isSet = false;
    radiosonde_settings = nullptr;
    m_radiosonde_settings_isSet = false;
    rig_ctl_server_settings = nullptr;
    m_rig_ctl_server_settings_isSet = false;
    satellite_tracker_settings = nullptr;
    m_satellite_tracker_settings_isSet = false;
    sid_settings = nullptr;
    m_sid_settings_isSet = false;
    simple_ptt_settings = nullptr;
    m_simple_ptt_settings_isSet = false;
    sky_map_settings = nullptr;
    m_sky_map_settings_isSet = false;
    star_tracker_settings = nullptr;
    m_star_tracker_settings_isSet = false;
    vor_localizer_settings = nullptr;
    m_vor_localizer_settings_isSet = false;
}

SWGFeatureSettings::~SWGFeatureSettings() {
    this->cleanup();
}

void
SWGFeatureSettings::init() {
    feature_type = new QString("");
    m_feature_type_isSet = false;
    originator_feature_set_index = 0;
    m_originator_feature_set_index_isSet = false;
    originator_feature_index = 0;
    m_originator_feature_index_isSet = false;
    afc_settings = new SWGAFCSettings();
    m_afc_settings_isSet = false;
    ais_settings = new SWGAISSettings();
    m_ais_settings_isSet = false;
    ambe_settings = new SWGAMBESettings();
    m_ambe_settings_isSet = false;
    antenna_tools_settings = new SWGAntennaToolsSettings();
    m_antenna_tools_settings_isSet = false;
    aprs_settings = new SWGAPRSSettings();
    m_aprs_settings_isSet = false;
    demod_analyzer_settings = new SWGDemodAnalyzerSettings();
    m_demod_analyzer_settings_isSet = false;
    jogdial_controller_settings = new SWGJogdialControllerSettings();
    m_jogdial_controller_settings_isSet = false;
    gs232_controller_settings = new SWGGS232ControllerSettings();
    m_gs232_controller_settings_isSet = false;
    lime_rfe_settings = new SWGLimeRFESettings();
    m_lime_rfe_settings_isSet = false;
    map_settings = new SWGMapSettings();
    m_map_settings_isSet = false;
    morse_decoder_settings = new SWGMorseDecoderSettings();
    m_morse_decoder_settings_isSet = false;
    per_tester_settings = new SWGPERTesterSettings();
    m_per_tester_settings_isSet = false;
    radiosonde_settings = new SWGRadiosondeSettings();
    m_radiosonde_settings_isSet = false;
    rig_ctl_server_settings = new SWGRigCtlServerSettings();
    m_rig_ctl_server_settings_isSet = false;
    satellite_tracker_settings = new SWGSatelliteTrackerSettings();
    m_satellite_tracker_settings_isSet = false;
    sid_settings = new SWGSIDSettings();
    m_sid_settings_isSet = false;
    simple_ptt_settings = new SWGSimplePTTSettings();
    m_simple_ptt_settings_isSet = false;
    sky_map_settings = new SWGSkyMapSettings();
    m_sky_map_settings_isSet = false;
    star_tracker_settings = new SWGStarTrackerSettings();
    m_star_tracker_settings_isSet = false;
    vor_localizer_settings = new SWGVORLocalizerSettings();
    m_vor_localizer_settings_isSet = false;
}

void
SWGFeatureSettings::cleanup() {
    if(feature_type != nullptr) { 
        delete feature_type;
    }


    if(afc_settings != nullptr) { 
        delete afc_settings;
    }
    if(ais_settings != nullptr) { 
        delete ais_settings;
    }
    if(ambe_settings != nullptr) { 
        delete ambe_settings;
    }
    if(antenna_tools_settings != nullptr) { 
        delete antenna_tools_settings;
    }
    if(aprs_settings != nullptr) { 
        delete aprs_settings;
    }
    if(demod_analyzer_settings != nullptr) { 
        delete demod_analyzer_settings;
    }
    if(jogdial_controller_settings != nullptr) { 
        delete jogdial_controller_settings;
    }
    if(gs232_controller_settings != nullptr) { 
        delete gs232_controller_settings;
    }
    if(lime_rfe_settings != nullptr) { 
        delete lime_rfe_settings;
    }
    if(map_settings != nullptr) { 
        delete map_settings;
    }
    if(morse_decoder_settings != nullptr) { 
        delete morse_decoder_settings;
    }
    if(per_tester_settings != nullptr) { 
        delete per_tester_settings;
    }
    if(radiosonde_settings != nullptr) { 
        delete radiosonde_settings;
    }
    if(rig_ctl_server_settings != nullptr) { 
        delete rig_ctl_server_settings;
    }
    if(satellite_tracker_settings != nullptr) { 
        delete satellite_tracker_settings;
    }
    if(sid_settings != nullptr) { 
        delete sid_settings;
    }
    if(simple_ptt_settings != nullptr) { 
        delete simple_ptt_settings;
    }
    if(sky_map_settings != nullptr) { 
        delete sky_map_settings;
    }
    if(star_tracker_settings != nullptr) { 
        delete star_tracker_settings;
    }
    if(vor_localizer_settings != nullptr) { 
        delete vor_localizer_settings;
    }
}

SWGFeatureSettings*
SWGFeatureSettings::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGFeatureSettings::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&feature_type, pJson["featureType"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&originator_feature_set_index, pJson["originatorFeatureSetIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&originator_feature_index, pJson["originatorFeatureIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&afc_settings, pJson["AFCSettings"], "SWGAFCSettings", "SWGAFCSettings");
    
    ::SWGSDRangel::setValue(&ais_settings, pJson["AISSettings"], "SWGAISSettings", "SWGAISSettings");
    
    ::SWGSDRangel::setValue(&ambe_settings, pJson["AMBESettings"], "SWGAMBESettings", "SWGAMBESettings");
    
    ::SWGSDRangel::setValue(&antenna_tools_settings, pJson["AntennaToolsSettings"], "SWGAntennaToolsSettings", "SWGAntennaToolsSettings");
    
    ::SWGSDRangel::setValue(&aprs_settings, pJson["APRSSettings"], "SWGAPRSSettings", "SWGAPRSSettings");
    
    ::SWGSDRangel::setValue(&demod_analyzer_settings, pJson["DemodAnalyzerSettings"], "SWGDemodAnalyzerSettings", "SWGDemodAnalyzerSettings");
    
    ::SWGSDRangel::setValue(&jogdial_controller_settings, pJson["JogdialControllerSettings"], "SWGJogdialControllerSettings", "SWGJogdialControllerSettings");
    
    ::SWGSDRangel::setValue(&gs232_controller_settings, pJson["GS232ControllerSettings"], "SWGGS232ControllerSettings", "SWGGS232ControllerSettings");
    
    ::SWGSDRangel::setValue(&lime_rfe_settings, pJson["LimeRFESettings"], "SWGLimeRFESettings", "SWGLimeRFESettings");
    
    ::SWGSDRangel::setValue(&map_settings, pJson["MapSettings"], "SWGMapSettings", "SWGMapSettings");
    
    ::SWGSDRangel::setValue(&morse_decoder_settings, pJson["MorseDecoderSettings"], "SWGMorseDecoderSettings", "SWGMorseDecoderSettings");
    
    ::SWGSDRangel::setValue(&per_tester_settings, pJson["PERTesterSettings"], "SWGPERTesterSettings", "SWGPERTesterSettings");
    
    ::SWGSDRangel::setValue(&radiosonde_settings, pJson["RadiosondeSettings"], "SWGRadiosondeSettings", "SWGRadiosondeSettings");
    
    ::SWGSDRangel::setValue(&rig_ctl_server_settings, pJson["RigCtlServerSettings"], "SWGRigCtlServerSettings", "SWGRigCtlServerSettings");
    
    ::SWGSDRangel::setValue(&satellite_tracker_settings, pJson["SatelliteTrackerSettings"], "SWGSatelliteTrackerSettings", "SWGSatelliteTrackerSettings");
    
    ::SWGSDRangel::setValue(&sid_settings, pJson["SIDSettings"], "SWGSIDSettings", "SWGSIDSettings");
    
    ::SWGSDRangel::setValue(&simple_ptt_settings, pJson["SimplePTTSettings"], "SWGSimplePTTSettings", "SWGSimplePTTSettings");
    
    ::SWGSDRangel::setValue(&sky_map_settings, pJson["SkyMapSettings"], "SWGSkyMapSettings", "SWGSkyMapSettings");
    
    ::SWGSDRangel::setValue(&star_tracker_settings, pJson["StarTrackerSettings"], "SWGStarTrackerSettings", "SWGStarTrackerSettings");
    
    ::SWGSDRangel::setValue(&vor_localizer_settings, pJson["VORLocalizerSettings"], "SWGVORLocalizerSettings", "SWGVORLocalizerSettings");
    
}

QString
SWGFeatureSettings::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGFeatureSettings::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(feature_type != nullptr && *feature_type != QString("")){
        toJsonValue(QString("featureType"), feature_type, obj, QString("QString"));
    }
    if(m_originator_feature_set_index_isSet){
        obj->insert("originatorFeatureSetIndex", QJsonValue(originator_feature_set_index));
    }
    if(m_originator_feature_index_isSet){
        obj->insert("originatorFeatureIndex", QJsonValue(originator_feature_index));
    }
    if((afc_settings != nullptr) && (afc_settings->isSet())){
        toJsonValue(QString("AFCSettings"), afc_settings, obj, QString("SWGAFCSettings"));
    }
    if((ais_settings != nullptr) && (ais_settings->isSet())){
        toJsonValue(QString("AISSettings"), ais_settings, obj, QString("SWGAISSettings"));
    }
    if((ambe_settings != nullptr) && (ambe_settings->isSet())){
        toJsonValue(QString("AMBESettings"), ambe_settings, obj, QString("SWGAMBESettings"));
    }
    if((antenna_tools_settings != nullptr) && (antenna_tools_settings->isSet())){
        toJsonValue(QString("AntennaToolsSettings"), antenna_tools_settings, obj, QString("SWGAntennaToolsSettings"));
    }
    if((aprs_settings != nullptr) && (aprs_settings->isSet())){
        toJsonValue(QString("APRSSettings"), aprs_settings, obj, QString("SWGAPRSSettings"));
    }
    if((demod_analyzer_settings != nullptr) && (demod_analyzer_settings->isSet())){
        toJsonValue(QString("DemodAnalyzerSettings"), demod_analyzer_settings, obj, QString("SWGDemodAnalyzerSettings"));
    }
    if((jogdial_controller_settings != nullptr) && (jogdial_controller_settings->isSet())){
        toJsonValue(QString("JogdialControllerSettings"), jogdial_controller_settings, obj, QString("SWGJogdialControllerSettings"));
    }
    if((gs232_controller_settings != nullptr) && (gs232_controller_settings->isSet())){
        toJsonValue(QString("GS232ControllerSettings"), gs232_controller_settings, obj, QString("SWGGS232ControllerSettings"));
    }
    if((lime_rfe_settings != nullptr) && (lime_rfe_settings->isSet())){
        toJsonValue(QString("LimeRFESettings"), lime_rfe_settings, obj, QString("SWGLimeRFESettings"));
    }
    if((map_settings != nullptr) && (map_settings->isSet())){
        toJsonValue(QString("MapSettings"), map_settings, obj, QString("SWGMapSettings"));
    }
    if((morse_decoder_settings != nullptr) && (morse_decoder_settings->isSet())){
        toJsonValue(QString("MorseDecoderSettings"), morse_decoder_settings, obj, QString("SWGMorseDecoderSettings"));
    }
    if((per_tester_settings != nullptr) && (per_tester_settings->isSet())){
        toJsonValue(QString("PERTesterSettings"), per_tester_settings, obj, QString("SWGPERTesterSettings"));
    }
    if((radiosonde_settings != nullptr) && (radiosonde_settings->isSet())){
        toJsonValue(QString("RadiosondeSettings"), radiosonde_settings, obj, QString("SWGRadiosondeSettings"));
    }
    if((rig_ctl_server_settings != nullptr) && (rig_ctl_server_settings->isSet())){
        toJsonValue(QString("RigCtlServerSettings"), rig_ctl_server_settings, obj, QString("SWGRigCtlServerSettings"));
    }
    if((satellite_tracker_settings != nullptr) && (satellite_tracker_settings->isSet())){
        toJsonValue(QString("SatelliteTrackerSettings"), satellite_tracker_settings, obj, QString("SWGSatelliteTrackerSettings"));
    }
    if((sid_settings != nullptr) && (sid_settings->isSet())){
        toJsonValue(QString("SIDSettings"), sid_settings, obj, QString("SWGSIDSettings"));
    }
    if((simple_ptt_settings != nullptr) && (simple_ptt_settings->isSet())){
        toJsonValue(QString("SimplePTTSettings"), simple_ptt_settings, obj, QString("SWGSimplePTTSettings"));
    }
    if((sky_map_settings != nullptr) && (sky_map_settings->isSet())){
        toJsonValue(QString("SkyMapSettings"), sky_map_settings, obj, QString("SWGSkyMapSettings"));
    }
    if((star_tracker_settings != nullptr) && (star_tracker_settings->isSet())){
        toJsonValue(QString("StarTrackerSettings"), star_tracker_settings, obj, QString("SWGStarTrackerSettings"));
    }
    if((vor_localizer_settings != nullptr) && (vor_localizer_settings->isSet())){
        toJsonValue(QString("VORLocalizerSettings"), vor_localizer_settings, obj, QString("SWGVORLocalizerSettings"));
    }

    return obj;
}

QString*
SWGFeatureSettings::getFeatureType() {
    return feature_type;
}
void
SWGFeatureSettings::setFeatureType(QString* feature_type) {
    this->feature_type = feature_type;
    this->m_feature_type_isSet = true;
}

qint32
SWGFeatureSettings::getOriginatorFeatureSetIndex() {
    return originator_feature_set_index;
}
void
SWGFeatureSettings::setOriginatorFeatureSetIndex(qint32 originator_feature_set_index) {
    this->originator_feature_set_index = originator_feature_set_index;
    this->m_originator_feature_set_index_isSet = true;
}

qint32
SWGFeatureSettings::getOriginatorFeatureIndex() {
    return originator_feature_index;
}
void
SWGFeatureSettings::setOriginatorFeatureIndex(qint32 originator_feature_index) {
    this->originator_feature_index = originator_feature_index;
    this->m_originator_feature_index_isSet = true;
}

SWGAFCSettings*
SWGFeatureSettings::getAfcSettings() {
    return afc_settings;
}
void
SWGFeatureSettings::setAfcSettings(SWGAFCSettings* afc_settings) {
    this->afc_settings = afc_settings;
    this->m_afc_settings_isSet = true;
}

SWGAISSettings*
SWGFeatureSettings::getAisSettings() {
    return ais_settings;
}
void
SWGFeatureSettings::setAisSettings(SWGAISSettings* ais_settings) {
    this->ais_settings = ais_settings;
    this->m_ais_settings_isSet = true;
}

SWGAMBESettings*
SWGFeatureSettings::getAmbeSettings() {
    return ambe_settings;
}
void
SWGFeatureSettings::setAmbeSettings(SWGAMBESettings* ambe_settings) {
    this->ambe_settings = ambe_settings;
    this->m_ambe_settings_isSet = true;
}

SWGAntennaToolsSettings*
SWGFeatureSettings::getAntennaToolsSettings() {
    return antenna_tools_settings;
}
void
SWGFeatureSettings::setAntennaToolsSettings(SWGAntennaToolsSettings* antenna_tools_settings) {
    this->antenna_tools_settings = antenna_tools_settings;
    this->m_antenna_tools_settings_isSet = true;
}

SWGAPRSSettings*
SWGFeatureSettings::getAprsSettings() {
    return aprs_settings;
}
void
SWGFeatureSettings::setAprsSettings(SWGAPRSSettings* aprs_settings) {
    this->aprs_settings = aprs_settings;
    this->m_aprs_settings_isSet = true;
}

SWGDemodAnalyzerSettings*
SWGFeatureSettings::getDemodAnalyzerSettings() {
    return demod_analyzer_settings;
}
void
SWGFeatureSettings::setDemodAnalyzerSettings(SWGDemodAnalyzerSettings* demod_analyzer_settings) {
    this->demod_analyzer_settings = demod_analyzer_settings;
    this->m_demod_analyzer_settings_isSet = true;
}

SWGJogdialControllerSettings*
SWGFeatureSettings::getJogdialControllerSettings() {
    return jogdial_controller_settings;
}
void
SWGFeatureSettings::setJogdialControllerSettings(SWGJogdialControllerSettings* jogdial_controller_settings) {
    this->jogdial_controller_settings = jogdial_controller_settings;
    this->m_jogdial_controller_settings_isSet = true;
}

SWGGS232ControllerSettings*
SWGFeatureSettings::getGs232ControllerSettings() {
    return gs232_controller_settings;
}
void
SWGFeatureSettings::setGs232ControllerSettings(SWGGS232ControllerSettings* gs232_controller_settings) {
    this->gs232_controller_settings = gs232_controller_settings;
    this->m_gs232_controller_settings_isSet = true;
}

SWGLimeRFESettings*
SWGFeatureSettings::getLimeRfeSettings() {
    return lime_rfe_settings;
}
void
SWGFeatureSettings::setLimeRfeSettings(SWGLimeRFESettings* lime_rfe_settings) {
    this->lime_rfe_settings = lime_rfe_settings;
    this->m_lime_rfe_settings_isSet = true;
}

SWGMapSettings*
SWGFeatureSettings::getMapSettings() {
    return map_settings;
}
void
SWGFeatureSettings::setMapSettings(SWGMapSettings* map_settings) {
    this->map_settings = map_settings;
    this->m_map_settings_isSet = true;
}

SWGMorseDecoderSettings*
SWGFeatureSettings::getMorseDecoderSettings() {
    return morse_decoder_settings;
}
void
SWGFeatureSettings::setMorseDecoderSettings(SWGMorseDecoderSettings* morse_decoder_settings) {
    this->morse_decoder_settings = morse_decoder_settings;
    this->m_morse_decoder_settings_isSet = true;
}

SWGPERTesterSettings*
SWGFeatureSettings::getPerTesterSettings() {
    return per_tester_settings;
}
void
SWGFeatureSettings::setPerTesterSettings(SWGPERTesterSettings* per_tester_settings) {
    this->per_tester_settings = per_tester_settings;
    this->m_per_tester_settings_isSet = true;
}

SWGRadiosondeSettings*
SWGFeatureSettings::getRadiosondeSettings() {
    return radiosonde_settings;
}
void
SWGFeatureSettings::setRadiosondeSettings(SWGRadiosondeSettings* radiosonde_settings) {
    this->radiosonde_settings = radiosonde_settings;
    this->m_radiosonde_settings_isSet = true;
}

SWGRigCtlServerSettings*
SWGFeatureSettings::getRigCtlServerSettings() {
    return rig_ctl_server_settings;
}
void
SWGFeatureSettings::setRigCtlServerSettings(SWGRigCtlServerSettings* rig_ctl_server_settings) {
    this->rig_ctl_server_settings = rig_ctl_server_settings;
    this->m_rig_ctl_server_settings_isSet = true;
}

SWGSatelliteTrackerSettings*
SWGFeatureSettings::getSatelliteTrackerSettings() {
    return satellite_tracker_settings;
}
void
SWGFeatureSettings::setSatelliteTrackerSettings(SWGSatelliteTrackerSettings* satellite_tracker_settings) {
    this->satellite_tracker_settings = satellite_tracker_settings;
    this->m_satellite_tracker_settings_isSet = true;
}

SWGSIDSettings*
SWGFeatureSettings::getSidSettings() {
    return sid_settings;
}
void
SWGFeatureSettings::setSidSettings(SWGSIDSettings* sid_settings) {
    this->sid_settings = sid_settings;
    this->m_sid_settings_isSet = true;
}

SWGSimplePTTSettings*
SWGFeatureSettings::getSimplePttSettings() {
    return simple_ptt_settings;
}
void
SWGFeatureSettings::setSimplePttSettings(SWGSimplePTTSettings* simple_ptt_settings) {
    this->simple_ptt_settings = simple_ptt_settings;
    this->m_simple_ptt_settings_isSet = true;
}

SWGSkyMapSettings*
SWGFeatureSettings::getSkyMapSettings() {
    return sky_map_settings;
}
void
SWGFeatureSettings::setSkyMapSettings(SWGSkyMapSettings* sky_map_settings) {
    this->sky_map_settings = sky_map_settings;
    this->m_sky_map_settings_isSet = true;
}

SWGStarTrackerSettings*
SWGFeatureSettings::getStarTrackerSettings() {
    return star_tracker_settings;
}
void
SWGFeatureSettings::setStarTrackerSettings(SWGStarTrackerSettings* star_tracker_settings) {
    this->star_tracker_settings = star_tracker_settings;
    this->m_star_tracker_settings_isSet = true;
}

SWGVORLocalizerSettings*
SWGFeatureSettings::getVorLocalizerSettings() {
    return vor_localizer_settings;
}
void
SWGFeatureSettings::setVorLocalizerSettings(SWGVORLocalizerSettings* vor_localizer_settings) {
    this->vor_localizer_settings = vor_localizer_settings;
    this->m_vor_localizer_settings_isSet = true;
}


bool
SWGFeatureSettings::isSet(){
    bool isObjectUpdated = false;
    do{
        if(feature_type && *feature_type != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_originator_feature_set_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_originator_feature_index_isSet){
            isObjectUpdated = true; break;
        }
        if(afc_settings && afc_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(ais_settings && ais_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(ambe_settings && ambe_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(antenna_tools_settings && antenna_tools_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(aprs_settings && aprs_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(demod_analyzer_settings && demod_analyzer_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(jogdial_controller_settings && jogdial_controller_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(gs232_controller_settings && gs232_controller_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(lime_rfe_settings && lime_rfe_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(map_settings && map_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(morse_decoder_settings && morse_decoder_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(per_tester_settings && per_tester_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(radiosonde_settings && radiosonde_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(rig_ctl_server_settings && rig_ctl_server_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(satellite_tracker_settings && satellite_tracker_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(sid_settings && sid_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(simple_ptt_settings && simple_ptt_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(sky_map_settings && sky_map_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(star_tracker_settings && star_tracker_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(vor_localizer_settings && vor_localizer_settings->isSet()){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

