/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

/*
 * SWGILSDemodSettings.h
 *
 * ILSDemod
 */

#ifndef SWGILSDemodSettings_H_
#define SWGILSDemodSettings_H_

#include <QJsonObject>


#include "SWGChannelMarker.h"
#include "SWGGLScope.h"
#include "SWGRollupState.h"
#include <QString>

#include "SWGObject.h"
#include "export.h"

namespace SWGSDRangel {

class SWG_API SWGILSDemodSettings: public SWGObject {
public:
    SWGILSDemodSettings();
    SWGILSDemodSettings(QString* json);
    virtual ~SWGILSDemodSettings();
    void init();
    void cleanup();

    virtual QString asJson () override;
    virtual QJsonObject* asJsonObject() override;
    virtual void fromJsonObject(QJsonObject &json) override;
    virtual SWGILSDemodSettings* fromJson(QString &jsonString) override;

    qint64 getInputFrequencyOffset();
    void setInputFrequencyOffset(qint64 input_frequency_offset);

    float getRfBandwidth();
    void setRfBandwidth(float rf_bandwidth);

    qint32 getMode();
    void setMode(qint32 mode);

    qint32 getFrequencyIndex();
    void setFrequencyIndex(qint32 frequency_index);

    qint32 getSquelch();
    void setSquelch(qint32 squelch);

    float getVolume();
    void setVolume(float volume);

    qint32 getAudioMute();
    void setAudioMute(qint32 audio_mute);

    qint32 getAverage();
    void setAverage(qint32 average);

    qint32 getDdmUnits();
    void setDdmUnits(qint32 ddm_units);

    float getIdentThreshold();
    void setIdentThreshold(float ident_threshold);

    QString* getIdent();
    void setIdent(QString* ident);

    QString* getRunway();
    void setRunway(QString* runway);

    float getTrueBearing();
    void setTrueBearing(float true_bearing);

    QString* getLatitude();
    void setLatitude(QString* latitude);

    QString* getLongitude();
    void setLongitude(QString* longitude);

    qint32 getElevation();
    void setElevation(qint32 elevation);

    float getGlidePath();
    void setGlidePath(float glide_path);

    float getRefHeight();
    void setRefHeight(float ref_height);

    float getCourseWidth();
    void setCourseWidth(float course_width);

    qint32 getUdpEnabled();
    void setUdpEnabled(qint32 udp_enabled);

    QString* getUdpAddress();
    void setUdpAddress(QString* udp_address);

    qint32 getUdpPort();
    void setUdpPort(qint32 udp_port);

    QString* getLogFilename();
    void setLogFilename(QString* log_filename);

    qint32 getLogEnabled();
    void setLogEnabled(qint32 log_enabled);

    qint32 getRgbColor();
    void setRgbColor(qint32 rgb_color);

    QString* getTitle();
    void setTitle(QString* title);

    qint32 getStreamIndex();
    void setStreamIndex(qint32 stream_index);

    qint32 getUseReverseApi();
    void setUseReverseApi(qint32 use_reverse_api);

    QString* getReverseApiAddress();
    void setReverseApiAddress(QString* reverse_api_address);

    qint32 getReverseApiPort();
    void setReverseApiPort(qint32 reverse_api_port);

    qint32 getReverseApiDeviceIndex();
    void setReverseApiDeviceIndex(qint32 reverse_api_device_index);

    qint32 getReverseApiChannelIndex();
    void setReverseApiChannelIndex(qint32 reverse_api_channel_index);

    SWGGLScope* getScopeConfig();
    void setScopeConfig(SWGGLScope* scope_config);

    SWGChannelMarker* getChannelMarker();
    void setChannelMarker(SWGChannelMarker* channel_marker);

    SWGRollupState* getRollupState();
    void setRollupState(SWGRollupState* rollup_state);


    virtual bool isSet() override;

private:
    qint64 input_frequency_offset;
    bool m_input_frequency_offset_isSet;

    float rf_bandwidth;
    bool m_rf_bandwidth_isSet;

    qint32 mode;
    bool m_mode_isSet;

    qint32 frequency_index;
    bool m_frequency_index_isSet;

    qint32 squelch;
    bool m_squelch_isSet;

    float volume;
    bool m_volume_isSet;

    qint32 audio_mute;
    bool m_audio_mute_isSet;

    qint32 average;
    bool m_average_isSet;

    qint32 ddm_units;
    bool m_ddm_units_isSet;

    float ident_threshold;
    bool m_ident_threshold_isSet;

    QString* ident;
    bool m_ident_isSet;

    QString* runway;
    bool m_runway_isSet;

    float true_bearing;
    bool m_true_bearing_isSet;

    QString* latitude;
    bool m_latitude_isSet;

    QString* longitude;
    bool m_longitude_isSet;

    qint32 elevation;
    bool m_elevation_isSet;

    float glide_path;
    bool m_glide_path_isSet;

    float ref_height;
    bool m_ref_height_isSet;

    float course_width;
    bool m_course_width_isSet;

    qint32 udp_enabled;
    bool m_udp_enabled_isSet;

    QString* udp_address;
    bool m_udp_address_isSet;

    qint32 udp_port;
    bool m_udp_port_isSet;

    QString* log_filename;
    bool m_log_filename_isSet;

    qint32 log_enabled;
    bool m_log_enabled_isSet;

    qint32 rgb_color;
    bool m_rgb_color_isSet;

    QString* title;
    bool m_title_isSet;

    qint32 stream_index;
    bool m_stream_index_isSet;

    qint32 use_reverse_api;
    bool m_use_reverse_api_isSet;

    QString* reverse_api_address;
    bool m_reverse_api_address_isSet;

    qint32 reverse_api_port;
    bool m_reverse_api_port_isSet;

    qint32 reverse_api_device_index;
    bool m_reverse_api_device_index_isSet;

    qint32 reverse_api_channel_index;
    bool m_reverse_api_channel_index_isSet;

    SWGGLScope* scope_config;
    bool m_scope_config_isSet;

    SWGChannelMarker* channel_marker;
    bool m_channel_marker_isSet;

    SWGRollupState* rollup_state;
    bool m_rollup_state_isSet;

};

}

#endif /* SWGILSDemodSettings_H_ */
