/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGMorseDecoderSettings.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGMorseDecoderSettings::SWGMorseDecoderSettings(QString* json) {
    init();
    this->fromJson(*json);
}

SWGMorseDecoderSettings::SWGMorseDecoderSettings() {
    title = nullptr;
    m_title_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = nullptr;
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    udp_enabled = 0;
    m_udp_enabled_isSet = false;
    udp_address = nullptr;
    m_udp_address_isSet = false;
    udp_port = 0;
    m_udp_port_isSet = false;
    log_filed_name = nullptr;
    m_log_filed_name_isSet = false;
    log_enabled = 0;
    m_log_enabled_isSet = false;
    _auto = 0;
    m__auto_isSet = false;
    show_threshold = 0;
    m_show_threshold_isSet = false;
    reverse_api_feature_set_index = 0;
    m_reverse_api_feature_set_index_isSet = false;
    reverse_api_feature_index = 0;
    m_reverse_api_feature_index_isSet = false;
    scope_config = nullptr;
    m_scope_config_isSet = false;
    rollup_state = nullptr;
    m_rollup_state_isSet = false;
}

SWGMorseDecoderSettings::~SWGMorseDecoderSettings() {
    this->cleanup();
}

void
SWGMorseDecoderSettings::init() {
    title = new QString("");
    m_title_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = new QString("");
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    udp_enabled = 0;
    m_udp_enabled_isSet = false;
    udp_address = new QString("");
    m_udp_address_isSet = false;
    udp_port = 0;
    m_udp_port_isSet = false;
    log_filed_name = new QString("");
    m_log_filed_name_isSet = false;
    log_enabled = 0;
    m_log_enabled_isSet = false;
    _auto = 0;
    m__auto_isSet = false;
    show_threshold = 0;
    m_show_threshold_isSet = false;
    reverse_api_feature_set_index = 0;
    m_reverse_api_feature_set_index_isSet = false;
    reverse_api_feature_index = 0;
    m_reverse_api_feature_index_isSet = false;
    scope_config = new SWGGLScope();
    m_scope_config_isSet = false;
    rollup_state = new SWGRollupState();
    m_rollup_state_isSet = false;
}

void
SWGMorseDecoderSettings::cleanup() {
    if(title != nullptr) { 
        delete title;
    }


    if(reverse_api_address != nullptr) { 
        delete reverse_api_address;
    }


    if(udp_address != nullptr) { 
        delete udp_address;
    }

    if(log_filed_name != nullptr) { 
        delete log_filed_name;
    }





    if(scope_config != nullptr) { 
        delete scope_config;
    }
    if(rollup_state != nullptr) { 
        delete rollup_state;
    }
}

SWGMorseDecoderSettings*
SWGMorseDecoderSettings::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGMorseDecoderSettings::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&title, pJson["title"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&rgb_color, pJson["rgbColor"], "qint32", "");
    
    ::SWGSDRangel::setValue(&use_reverse_api, pJson["useReverseAPI"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_address, pJson["reverseAPIAddress"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&reverse_api_port, pJson["reverseAPIPort"], "qint32", "");
    
    ::SWGSDRangel::setValue(&udp_enabled, pJson["udpEnabled"], "qint32", "");
    
    ::SWGSDRangel::setValue(&udp_address, pJson["udpAddress"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&udp_port, pJson["udpPort"], "qint32", "");
    
    ::SWGSDRangel::setValue(&log_filed_name, pJson["logFiledName"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&log_enabled, pJson["logEnabled"], "qint32", "");
    
    ::SWGSDRangel::setValue(&_auto, pJson["auto"], "qint32", "");
    
    ::SWGSDRangel::setValue(&show_threshold, pJson["showThreshold"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_feature_set_index, pJson["reverseAPIFeatureSetIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_feature_index, pJson["reverseAPIFeatureIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&scope_config, pJson["scopeConfig"], "SWGGLScope", "SWGGLScope");
    
    ::SWGSDRangel::setValue(&rollup_state, pJson["rollupState"], "SWGRollupState", "SWGRollupState");
    
}

QString
SWGMorseDecoderSettings::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGMorseDecoderSettings::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(title != nullptr && *title != QString("")){
        toJsonValue(QString("title"), title, obj, QString("QString"));
    }
    if(m_rgb_color_isSet){
        obj->insert("rgbColor", QJsonValue(rgb_color));
    }
    if(m_use_reverse_api_isSet){
        obj->insert("useReverseAPI", QJsonValue(use_reverse_api));
    }
    if(reverse_api_address != nullptr && *reverse_api_address != QString("")){
        toJsonValue(QString("reverseAPIAddress"), reverse_api_address, obj, QString("QString"));
    }
    if(m_reverse_api_port_isSet){
        obj->insert("reverseAPIPort", QJsonValue(reverse_api_port));
    }
    if(m_udp_enabled_isSet){
        obj->insert("udpEnabled", QJsonValue(udp_enabled));
    }
    if(udp_address != nullptr && *udp_address != QString("")){
        toJsonValue(QString("udpAddress"), udp_address, obj, QString("QString"));
    }
    if(m_udp_port_isSet){
        obj->insert("udpPort", QJsonValue(udp_port));
    }
    if(log_filed_name != nullptr && *log_filed_name != QString("")){
        toJsonValue(QString("logFiledName"), log_filed_name, obj, QString("QString"));
    }
    if(m_log_enabled_isSet){
        obj->insert("logEnabled", QJsonValue(log_enabled));
    }
    if(m__auto_isSet){
        obj->insert("auto", QJsonValue(_auto));
    }
    if(m_show_threshold_isSet){
        obj->insert("showThreshold", QJsonValue(show_threshold));
    }
    if(m_reverse_api_feature_set_index_isSet){
        obj->insert("reverseAPIFeatureSetIndex", QJsonValue(reverse_api_feature_set_index));
    }
    if(m_reverse_api_feature_index_isSet){
        obj->insert("reverseAPIFeatureIndex", QJsonValue(reverse_api_feature_index));
    }
    if((scope_config != nullptr) && (scope_config->isSet())){
        toJsonValue(QString("scopeConfig"), scope_config, obj, QString("SWGGLScope"));
    }
    if((rollup_state != nullptr) && (rollup_state->isSet())){
        toJsonValue(QString("rollupState"), rollup_state, obj, QString("SWGRollupState"));
    }

    return obj;
}

QString*
SWGMorseDecoderSettings::getTitle() {
    return title;
}
void
SWGMorseDecoderSettings::setTitle(QString* title) {
    this->title = title;
    this->m_title_isSet = true;
}

qint32
SWGMorseDecoderSettings::getRgbColor() {
    return rgb_color;
}
void
SWGMorseDecoderSettings::setRgbColor(qint32 rgb_color) {
    this->rgb_color = rgb_color;
    this->m_rgb_color_isSet = true;
}

qint32
SWGMorseDecoderSettings::getUseReverseApi() {
    return use_reverse_api;
}
void
SWGMorseDecoderSettings::setUseReverseApi(qint32 use_reverse_api) {
    this->use_reverse_api = use_reverse_api;
    this->m_use_reverse_api_isSet = true;
}

QString*
SWGMorseDecoderSettings::getReverseApiAddress() {
    return reverse_api_address;
}
void
SWGMorseDecoderSettings::setReverseApiAddress(QString* reverse_api_address) {
    this->reverse_api_address = reverse_api_address;
    this->m_reverse_api_address_isSet = true;
}

qint32
SWGMorseDecoderSettings::getReverseApiPort() {
    return reverse_api_port;
}
void
SWGMorseDecoderSettings::setReverseApiPort(qint32 reverse_api_port) {
    this->reverse_api_port = reverse_api_port;
    this->m_reverse_api_port_isSet = true;
}

qint32
SWGMorseDecoderSettings::getUdpEnabled() {
    return udp_enabled;
}
void
SWGMorseDecoderSettings::setUdpEnabled(qint32 udp_enabled) {
    this->udp_enabled = udp_enabled;
    this->m_udp_enabled_isSet = true;
}

QString*
SWGMorseDecoderSettings::getUdpAddress() {
    return udp_address;
}
void
SWGMorseDecoderSettings::setUdpAddress(QString* udp_address) {
    this->udp_address = udp_address;
    this->m_udp_address_isSet = true;
}

qint32
SWGMorseDecoderSettings::getUdpPort() {
    return udp_port;
}
void
SWGMorseDecoderSettings::setUdpPort(qint32 udp_port) {
    this->udp_port = udp_port;
    this->m_udp_port_isSet = true;
}

QString*
SWGMorseDecoderSettings::getLogFiledName() {
    return log_filed_name;
}
void
SWGMorseDecoderSettings::setLogFiledName(QString* log_filed_name) {
    this->log_filed_name = log_filed_name;
    this->m_log_filed_name_isSet = true;
}

qint32
SWGMorseDecoderSettings::getLogEnabled() {
    return log_enabled;
}
void
SWGMorseDecoderSettings::setLogEnabled(qint32 log_enabled) {
    this->log_enabled = log_enabled;
    this->m_log_enabled_isSet = true;
}

qint32
SWGMorseDecoderSettings::getAuto() {
    return _auto;
}
void
SWGMorseDecoderSettings::setAuto(qint32 _auto) {
    this->_auto = _auto;
    this->m__auto_isSet = true;
}

qint32
SWGMorseDecoderSettings::getShowThreshold() {
    return show_threshold;
}
void
SWGMorseDecoderSettings::setShowThreshold(qint32 show_threshold) {
    this->show_threshold = show_threshold;
    this->m_show_threshold_isSet = true;
}

qint32
SWGMorseDecoderSettings::getReverseApiFeatureSetIndex() {
    return reverse_api_feature_set_index;
}
void
SWGMorseDecoderSettings::setReverseApiFeatureSetIndex(qint32 reverse_api_feature_set_index) {
    this->reverse_api_feature_set_index = reverse_api_feature_set_index;
    this->m_reverse_api_feature_set_index_isSet = true;
}

qint32
SWGMorseDecoderSettings::getReverseApiFeatureIndex() {
    return reverse_api_feature_index;
}
void
SWGMorseDecoderSettings::setReverseApiFeatureIndex(qint32 reverse_api_feature_index) {
    this->reverse_api_feature_index = reverse_api_feature_index;
    this->m_reverse_api_feature_index_isSet = true;
}

SWGGLScope*
SWGMorseDecoderSettings::getScopeConfig() {
    return scope_config;
}
void
SWGMorseDecoderSettings::setScopeConfig(SWGGLScope* scope_config) {
    this->scope_config = scope_config;
    this->m_scope_config_isSet = true;
}

SWGRollupState*
SWGMorseDecoderSettings::getRollupState() {
    return rollup_state;
}
void
SWGMorseDecoderSettings::setRollupState(SWGRollupState* rollup_state) {
    this->rollup_state = rollup_state;
    this->m_rollup_state_isSet = true;
}


bool
SWGMorseDecoderSettings::isSet(){
    bool isObjectUpdated = false;
    do{
        if(title && *title != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_rgb_color_isSet){
            isObjectUpdated = true; break;
        }
        if(m_use_reverse_api_isSet){
            isObjectUpdated = true; break;
        }
        if(reverse_api_address && *reverse_api_address != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_port_isSet){
            isObjectUpdated = true; break;
        }
        if(m_udp_enabled_isSet){
            isObjectUpdated = true; break;
        }
        if(udp_address && *udp_address != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_udp_port_isSet){
            isObjectUpdated = true; break;
        }
        if(log_filed_name && *log_filed_name != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_log_enabled_isSet){
            isObjectUpdated = true; break;
        }
        if(m__auto_isSet){
            isObjectUpdated = true; break;
        }
        if(m_show_threshold_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_feature_set_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_feature_index_isSet){
            isObjectUpdated = true; break;
        }
        if(scope_config && scope_config->isSet()){
            isObjectUpdated = true; break;
        }
        if(rollup_state && rollup_state->isSet()){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

