/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGPSK31ModActions.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGPSK31ModActions::SWGPSK31ModActions(QString* json) {
    init();
    this->fromJson(*json);
}

SWGPSK31ModActions::SWGPSK31ModActions() {
    tx = 0;
    m_tx_isSet = false;
    payload = nullptr;
    m_payload_isSet = false;
}

SWGPSK31ModActions::~SWGPSK31ModActions() {
    this->cleanup();
}

void
SWGPSK31ModActions::init() {
    tx = 0;
    m_tx_isSet = false;
    payload = new SWGPSK31ModActions_payload();
    m_payload_isSet = false;
}

void
SWGPSK31ModActions::cleanup() {

    if(payload != nullptr) { 
        delete payload;
    }
}

SWGPSK31ModActions*
SWGPSK31ModActions::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGPSK31ModActions::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&tx, pJson["tx"], "qint32", "");
    
    ::SWGSDRangel::setValue(&payload, pJson["payload"], "SWGPSK31ModActions_payload", "SWGPSK31ModActions_payload");
    
}

QString
SWGPSK31ModActions::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGPSK31ModActions::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_tx_isSet){
        obj->insert("tx", QJsonValue(tx));
    }
    if((payload != nullptr) && (payload->isSet())){
        toJsonValue(QString("payload"), payload, obj, QString("SWGPSK31ModActions_payload"));
    }

    return obj;
}

qint32
SWGPSK31ModActions::getTx() {
    return tx;
}
void
SWGPSK31ModActions::setTx(qint32 tx) {
    this->tx = tx;
    this->m_tx_isSet = true;
}

SWGPSK31ModActions_payload*
SWGPSK31ModActions::getPayload() {
    return payload;
}
void
SWGPSK31ModActions::setPayload(SWGPSK31ModActions_payload* payload) {
    this->payload = payload;
    this->m_payload_isSet = true;
}


bool
SWGPSK31ModActions::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_tx_isSet){
            isObjectUpdated = true; break;
        }
        if(payload && payload->isSet()){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

