/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

/*
 * SWGSDRPlayV3Settings.h
 *
 * SDRplayV3
 */

#ifndef SWGSDRPlayV3Settings_H_
#define SWGSDRPlayV3Settings_H_

#include <QJsonObject>


#include <QString>

#include "SWGObject.h"
#include "export.h"

namespace SWGSDRangel {

class SWG_API SWGSDRPlayV3Settings: public SWGObject {
public:
    SWGSDRPlayV3Settings();
    SWGSDRPlayV3Settings(QString* json);
    virtual ~SWGSDRPlayV3Settings();
    void init();
    void cleanup();

    virtual QString asJson () override;
    virtual QJsonObject* asJsonObject() override;
    virtual void fromJsonObject(QJsonObject &json) override;
    virtual SWGSDRPlayV3Settings* fromJson(QString &jsonString) override;

    qint64 getCenterFrequency();
    void setCenterFrequency(qint64 center_frequency);

    qint32 getLOppmTenths();
    void setLOppmTenths(qint32 l_oppm_tenths);

    qint32 getIfFrequencyIndex();
    void setIfFrequencyIndex(qint32 if_frequency_index);

    qint32 getBandwidthIndex();
    void setBandwidthIndex(qint32 bandwidth_index);

    qint32 getDevSampleRate();
    void setDevSampleRate(qint32 dev_sample_rate);

    qint32 getLog2Decim();
    void setLog2Decim(qint32 log2_decim);

    qint32 getFcPos();
    void setFcPos(qint32 fc_pos);

    qint32 getDcBlock();
    void setDcBlock(qint32 dc_block);

    qint32 getIqCorrection();
    void setIqCorrection(qint32 iq_correction);

    qint32 getLnaIndex();
    void setLnaIndex(qint32 lna_index);

    qint32 getLnaGain();
    void setLnaGain(qint32 lna_gain);

    qint32 getIfAgc();
    void setIfAgc(qint32 if_agc);

    qint32 getIfGain();
    void setIfGain(qint32 if_gain);

    qint32 getAmNotch();
    void setAmNotch(qint32 am_notch);

    qint32 getFmNotch();
    void setFmNotch(qint32 fm_notch);

    qint32 getDabNotch();
    void setDabNotch(qint32 dab_notch);

    qint32 getExtRef();
    void setExtRef(qint32 ext_ref);

    qint32 getTuner();
    void setTuner(qint32 tuner);

    qint32 getAntenna();
    void setAntenna(qint32 antenna);

    qint32 getTransverterMode();
    void setTransverterMode(qint32 transverter_mode);

    qint64 getTransverterDeltaFrequency();
    void setTransverterDeltaFrequency(qint64 transverter_delta_frequency);

    qint32 getIqOrder();
    void setIqOrder(qint32 iq_order);

    qint32 getBiasTee();
    void setBiasTee(qint32 bias_tee);

    qint32 getUseReverseApi();
    void setUseReverseApi(qint32 use_reverse_api);

    QString* getReverseApiAddress();
    void setReverseApiAddress(QString* reverse_api_address);

    qint32 getReverseApiPort();
    void setReverseApiPort(qint32 reverse_api_port);

    qint32 getReverseApiDeviceIndex();
    void setReverseApiDeviceIndex(qint32 reverse_api_device_index);


    virtual bool isSet() override;

private:
    qint64 center_frequency;
    bool m_center_frequency_isSet;

    qint32 l_oppm_tenths;
    bool m_l_oppm_tenths_isSet;

    qint32 if_frequency_index;
    bool m_if_frequency_index_isSet;

    qint32 bandwidth_index;
    bool m_bandwidth_index_isSet;

    qint32 dev_sample_rate;
    bool m_dev_sample_rate_isSet;

    qint32 log2_decim;
    bool m_log2_decim_isSet;

    qint32 fc_pos;
    bool m_fc_pos_isSet;

    qint32 dc_block;
    bool m_dc_block_isSet;

    qint32 iq_correction;
    bool m_iq_correction_isSet;

    qint32 lna_index;
    bool m_lna_index_isSet;

    qint32 lna_gain;
    bool m_lna_gain_isSet;

    qint32 if_agc;
    bool m_if_agc_isSet;

    qint32 if_gain;
    bool m_if_gain_isSet;

    qint32 am_notch;
    bool m_am_notch_isSet;

    qint32 fm_notch;
    bool m_fm_notch_isSet;

    qint32 dab_notch;
    bool m_dab_notch_isSet;

    qint32 ext_ref;
    bool m_ext_ref_isSet;

    qint32 tuner;
    bool m_tuner_isSet;

    qint32 antenna;
    bool m_antenna_isSet;

    qint32 transverter_mode;
    bool m_transverter_mode_isSet;

    qint64 transverter_delta_frequency;
    bool m_transverter_delta_frequency_isSet;

    qint32 iq_order;
    bool m_iq_order_isSet;

    qint32 bias_tee;
    bool m_bias_tee_isSet;

    qint32 use_reverse_api;
    bool m_use_reverse_api_isSet;

    QString* reverse_api_address;
    bool m_reverse_api_address_isSet;

    qint32 reverse_api_port;
    bool m_reverse_api_port_isSet;

    qint32 reverse_api_device_index;
    bool m_reverse_api_device_index_isSet;

};

}

#endif /* SWGSDRPlayV3Settings_H_ */
