/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGSigMFFileInputActions.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGSigMFFileInputActions::SWGSigMFFileInputActions(QString* json) {
    init();
    this->fromJson(*json);
}

SWGSigMFFileInputActions::SWGSigMFFileInputActions() {
    play_track = 0;
    m_play_track_isSet = false;
    play_record = 0;
    m_play_record_isSet = false;
    seek_track = 0;
    m_seek_track_isSet = false;
    seek_track_millis = 0;
    m_seek_track_millis_isSet = false;
    seek_record_millis = 0;
    m_seek_record_millis_isSet = false;
}

SWGSigMFFileInputActions::~SWGSigMFFileInputActions() {
    this->cleanup();
}

void
SWGSigMFFileInputActions::init() {
    play_track = 0;
    m_play_track_isSet = false;
    play_record = 0;
    m_play_record_isSet = false;
    seek_track = 0;
    m_seek_track_isSet = false;
    seek_track_millis = 0;
    m_seek_track_millis_isSet = false;
    seek_record_millis = 0;
    m_seek_record_millis_isSet = false;
}

void
SWGSigMFFileInputActions::cleanup() {





}

SWGSigMFFileInputActions*
SWGSigMFFileInputActions::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGSigMFFileInputActions::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&play_track, pJson["playTrack"], "qint32", "");
    
    ::SWGSDRangel::setValue(&play_record, pJson["playRecord"], "qint32", "");
    
    ::SWGSDRangel::setValue(&seek_track, pJson["seekTrack"], "qint32", "");
    
    ::SWGSDRangel::setValue(&seek_track_millis, pJson["seekTrackMillis"], "qint32", "");
    
    ::SWGSDRangel::setValue(&seek_record_millis, pJson["seekRecordMillis"], "qint32", "");
    
}

QString
SWGSigMFFileInputActions::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGSigMFFileInputActions::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_play_track_isSet){
        obj->insert("playTrack", QJsonValue(play_track));
    }
    if(m_play_record_isSet){
        obj->insert("playRecord", QJsonValue(play_record));
    }
    if(m_seek_track_isSet){
        obj->insert("seekTrack", QJsonValue(seek_track));
    }
    if(m_seek_track_millis_isSet){
        obj->insert("seekTrackMillis", QJsonValue(seek_track_millis));
    }
    if(m_seek_record_millis_isSet){
        obj->insert("seekRecordMillis", QJsonValue(seek_record_millis));
    }

    return obj;
}

qint32
SWGSigMFFileInputActions::getPlayTrack() {
    return play_track;
}
void
SWGSigMFFileInputActions::setPlayTrack(qint32 play_track) {
    this->play_track = play_track;
    this->m_play_track_isSet = true;
}

qint32
SWGSigMFFileInputActions::getPlayRecord() {
    return play_record;
}
void
SWGSigMFFileInputActions::setPlayRecord(qint32 play_record) {
    this->play_record = play_record;
    this->m_play_record_isSet = true;
}

qint32
SWGSigMFFileInputActions::getSeekTrack() {
    return seek_track;
}
void
SWGSigMFFileInputActions::setSeekTrack(qint32 seek_track) {
    this->seek_track = seek_track;
    this->m_seek_track_isSet = true;
}

qint32
SWGSigMFFileInputActions::getSeekTrackMillis() {
    return seek_track_millis;
}
void
SWGSigMFFileInputActions::setSeekTrackMillis(qint32 seek_track_millis) {
    this->seek_track_millis = seek_track_millis;
    this->m_seek_track_millis_isSet = true;
}

qint32
SWGSigMFFileInputActions::getSeekRecordMillis() {
    return seek_record_millis;
}
void
SWGSigMFFileInputActions::setSeekRecordMillis(qint32 seek_record_millis) {
    this->seek_record_millis = seek_record_millis;
    this->m_seek_record_millis_isSet = true;
}


bool
SWGSigMFFileInputActions::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_play_track_isSet){
            isObjectUpdated = true; break;
        }
        if(m_play_record_isSet){
            isObjectUpdated = true; break;
        }
        if(m_seek_track_isSet){
            isObjectUpdated = true; break;
        }
        if(m_seek_track_millis_isSet){
            isObjectUpdated = true; break;
        }
        if(m_seek_record_millis_isSet){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

