/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGSimplePTTSettings.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGSimplePTTSettings::SWGSimplePTTSettings(QString* json) {
    init();
    this->fromJson(*json);
}

SWGSimplePTTSettings::SWGSimplePTTSettings() {
    title = nullptr;
    m_title_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    rx_device_set_index = 0;
    m_rx_device_set_index_isSet = false;
    tx_device_set_index = 0;
    m_tx_device_set_index_isSet = false;
    rx2_tx_delay_ms = 0;
    m_rx2_tx_delay_ms_isSet = false;
    tx2_rx_delay_ms = 0;
    m_tx2_rx_delay_ms_isSet = false;
    vox = 0;
    m_vox_isSet = false;
    vox_enable = 0;
    m_vox_enable_isSet = false;
    vox_level = 0;
    m_vox_level_isSet = false;
    vox_hold = 0;
    m_vox_hold_isSet = false;
    audio_device_name = nullptr;
    m_audio_device_name_isSet = false;
    gpio_control = 0;
    m_gpio_control_isSet = false;
    rx2tx_gpio_enable = 0;
    m_rx2tx_gpio_enable_isSet = false;
    rx2tx_gpio_mask = 0;
    m_rx2tx_gpio_mask_isSet = false;
    rx2tx_gpio_values = 0;
    m_rx2tx_gpio_values_isSet = false;
    rx2tx_command_enable = 0;
    m_rx2tx_command_enable_isSet = false;
    rx2tx_command = nullptr;
    m_rx2tx_command_isSet = false;
    tx2rx_gpio_enable = 0;
    m_tx2rx_gpio_enable_isSet = false;
    tx2rx_gpio_mask = 0;
    m_tx2rx_gpio_mask_isSet = false;
    tx2rx_gpio_values = 0;
    m_tx2rx_gpio_values_isSet = false;
    tx2rx_command_enable = 0;
    m_tx2rx_command_enable_isSet = false;
    tx2rx_command = nullptr;
    m_tx2rx_command_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = nullptr;
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_feature_set_index = 0;
    m_reverse_api_feature_set_index_isSet = false;
    reverse_api_feature_index = 0;
    m_reverse_api_feature_index_isSet = false;
    rollup_state = nullptr;
    m_rollup_state_isSet = false;
}

SWGSimplePTTSettings::~SWGSimplePTTSettings() {
    this->cleanup();
}

void
SWGSimplePTTSettings::init() {
    title = new QString("");
    m_title_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    rx_device_set_index = 0;
    m_rx_device_set_index_isSet = false;
    tx_device_set_index = 0;
    m_tx_device_set_index_isSet = false;
    rx2_tx_delay_ms = 0;
    m_rx2_tx_delay_ms_isSet = false;
    tx2_rx_delay_ms = 0;
    m_tx2_rx_delay_ms_isSet = false;
    vox = 0;
    m_vox_isSet = false;
    vox_enable = 0;
    m_vox_enable_isSet = false;
    vox_level = 0;
    m_vox_level_isSet = false;
    vox_hold = 0;
    m_vox_hold_isSet = false;
    audio_device_name = new QString("");
    m_audio_device_name_isSet = false;
    gpio_control = 0;
    m_gpio_control_isSet = false;
    rx2tx_gpio_enable = 0;
    m_rx2tx_gpio_enable_isSet = false;
    rx2tx_gpio_mask = 0;
    m_rx2tx_gpio_mask_isSet = false;
    rx2tx_gpio_values = 0;
    m_rx2tx_gpio_values_isSet = false;
    rx2tx_command_enable = 0;
    m_rx2tx_command_enable_isSet = false;
    rx2tx_command = new QString("");
    m_rx2tx_command_isSet = false;
    tx2rx_gpio_enable = 0;
    m_tx2rx_gpio_enable_isSet = false;
    tx2rx_gpio_mask = 0;
    m_tx2rx_gpio_mask_isSet = false;
    tx2rx_gpio_values = 0;
    m_tx2rx_gpio_values_isSet = false;
    tx2rx_command_enable = 0;
    m_tx2rx_command_enable_isSet = false;
    tx2rx_command = new QString("");
    m_tx2rx_command_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = new QString("");
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_feature_set_index = 0;
    m_reverse_api_feature_set_index_isSet = false;
    reverse_api_feature_index = 0;
    m_reverse_api_feature_index_isSet = false;
    rollup_state = new SWGRollupState();
    m_rollup_state_isSet = false;
}

void
SWGSimplePTTSettings::cleanup() {
    if(title != nullptr) { 
        delete title;
    }









    if(audio_device_name != nullptr) { 
        delete audio_device_name;
    }





    if(rx2tx_command != nullptr) { 
        delete rx2tx_command;
    }




    if(tx2rx_command != nullptr) { 
        delete tx2rx_command;
    }

    if(reverse_api_address != nullptr) { 
        delete reverse_api_address;
    }



    if(rollup_state != nullptr) { 
        delete rollup_state;
    }
}

SWGSimplePTTSettings*
SWGSimplePTTSettings::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGSimplePTTSettings::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&title, pJson["title"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&rgb_color, pJson["rgbColor"], "qint32", "");
    
    ::SWGSDRangel::setValue(&rx_device_set_index, pJson["rxDeviceSetIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&tx_device_set_index, pJson["txDeviceSetIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&rx2_tx_delay_ms, pJson["rx2TxDelayMs"], "qint32", "");
    
    ::SWGSDRangel::setValue(&tx2_rx_delay_ms, pJson["tx2RxDelayMs"], "qint32", "");
    
    ::SWGSDRangel::setValue(&vox, pJson["vox"], "qint32", "");
    
    ::SWGSDRangel::setValue(&vox_enable, pJson["voxEnable"], "qint32", "");
    
    ::SWGSDRangel::setValue(&vox_level, pJson["voxLevel"], "qint32", "");
    
    ::SWGSDRangel::setValue(&vox_hold, pJson["voxHold"], "qint32", "");
    
    ::SWGSDRangel::setValue(&audio_device_name, pJson["audioDeviceName"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&gpio_control, pJson["gpioControl"], "qint32", "");
    
    ::SWGSDRangel::setValue(&rx2tx_gpio_enable, pJson["rx2txGPIOEnable"], "qint32", "");
    
    ::SWGSDRangel::setValue(&rx2tx_gpio_mask, pJson["rx2txGPIOMask"], "qint32", "");
    
    ::SWGSDRangel::setValue(&rx2tx_gpio_values, pJson["rx2txGPIOValues"], "qint32", "");
    
    ::SWGSDRangel::setValue(&rx2tx_command_enable, pJson["rx2txCommandEnable"], "qint32", "");
    
    ::SWGSDRangel::setValue(&rx2tx_command, pJson["rx2txCommand"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&tx2rx_gpio_enable, pJson["tx2rxGPIOEnable"], "qint32", "");
    
    ::SWGSDRangel::setValue(&tx2rx_gpio_mask, pJson["tx2rxGPIOMask"], "qint32", "");
    
    ::SWGSDRangel::setValue(&tx2rx_gpio_values, pJson["tx2rxGPIOValues"], "qint32", "");
    
    ::SWGSDRangel::setValue(&tx2rx_command_enable, pJson["tx2rxCommandEnable"], "qint32", "");
    
    ::SWGSDRangel::setValue(&tx2rx_command, pJson["tx2rxCommand"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&use_reverse_api, pJson["useReverseAPI"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_address, pJson["reverseAPIAddress"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&reverse_api_port, pJson["reverseAPIPort"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_feature_set_index, pJson["reverseAPIFeatureSetIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_feature_index, pJson["reverseAPIFeatureIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&rollup_state, pJson["rollupState"], "SWGRollupState", "SWGRollupState");
    
}

QString
SWGSimplePTTSettings::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGSimplePTTSettings::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(title != nullptr && *title != QString("")){
        toJsonValue(QString("title"), title, obj, QString("QString"));
    }
    if(m_rgb_color_isSet){
        obj->insert("rgbColor", QJsonValue(rgb_color));
    }
    if(m_rx_device_set_index_isSet){
        obj->insert("rxDeviceSetIndex", QJsonValue(rx_device_set_index));
    }
    if(m_tx_device_set_index_isSet){
        obj->insert("txDeviceSetIndex", QJsonValue(tx_device_set_index));
    }
    if(m_rx2_tx_delay_ms_isSet){
        obj->insert("rx2TxDelayMs", QJsonValue(rx2_tx_delay_ms));
    }
    if(m_tx2_rx_delay_ms_isSet){
        obj->insert("tx2RxDelayMs", QJsonValue(tx2_rx_delay_ms));
    }
    if(m_vox_isSet){
        obj->insert("vox", QJsonValue(vox));
    }
    if(m_vox_enable_isSet){
        obj->insert("voxEnable", QJsonValue(vox_enable));
    }
    if(m_vox_level_isSet){
        obj->insert("voxLevel", QJsonValue(vox_level));
    }
    if(m_vox_hold_isSet){
        obj->insert("voxHold", QJsonValue(vox_hold));
    }
    if(audio_device_name != nullptr && *audio_device_name != QString("")){
        toJsonValue(QString("audioDeviceName"), audio_device_name, obj, QString("QString"));
    }
    if(m_gpio_control_isSet){
        obj->insert("gpioControl", QJsonValue(gpio_control));
    }
    if(m_rx2tx_gpio_enable_isSet){
        obj->insert("rx2txGPIOEnable", QJsonValue(rx2tx_gpio_enable));
    }
    if(m_rx2tx_gpio_mask_isSet){
        obj->insert("rx2txGPIOMask", QJsonValue(rx2tx_gpio_mask));
    }
    if(m_rx2tx_gpio_values_isSet){
        obj->insert("rx2txGPIOValues", QJsonValue(rx2tx_gpio_values));
    }
    if(m_rx2tx_command_enable_isSet){
        obj->insert("rx2txCommandEnable", QJsonValue(rx2tx_command_enable));
    }
    if(rx2tx_command != nullptr && *rx2tx_command != QString("")){
        toJsonValue(QString("rx2txCommand"), rx2tx_command, obj, QString("QString"));
    }
    if(m_tx2rx_gpio_enable_isSet){
        obj->insert("tx2rxGPIOEnable", QJsonValue(tx2rx_gpio_enable));
    }
    if(m_tx2rx_gpio_mask_isSet){
        obj->insert("tx2rxGPIOMask", QJsonValue(tx2rx_gpio_mask));
    }
    if(m_tx2rx_gpio_values_isSet){
        obj->insert("tx2rxGPIOValues", QJsonValue(tx2rx_gpio_values));
    }
    if(m_tx2rx_command_enable_isSet){
        obj->insert("tx2rxCommandEnable", QJsonValue(tx2rx_command_enable));
    }
    if(tx2rx_command != nullptr && *tx2rx_command != QString("")){
        toJsonValue(QString("tx2rxCommand"), tx2rx_command, obj, QString("QString"));
    }
    if(m_use_reverse_api_isSet){
        obj->insert("useReverseAPI", QJsonValue(use_reverse_api));
    }
    if(reverse_api_address != nullptr && *reverse_api_address != QString("")){
        toJsonValue(QString("reverseAPIAddress"), reverse_api_address, obj, QString("QString"));
    }
    if(m_reverse_api_port_isSet){
        obj->insert("reverseAPIPort", QJsonValue(reverse_api_port));
    }
    if(m_reverse_api_feature_set_index_isSet){
        obj->insert("reverseAPIFeatureSetIndex", QJsonValue(reverse_api_feature_set_index));
    }
    if(m_reverse_api_feature_index_isSet){
        obj->insert("reverseAPIFeatureIndex", QJsonValue(reverse_api_feature_index));
    }
    if((rollup_state != nullptr) && (rollup_state->isSet())){
        toJsonValue(QString("rollupState"), rollup_state, obj, QString("SWGRollupState"));
    }

    return obj;
}

QString*
SWGSimplePTTSettings::getTitle() {
    return title;
}
void
SWGSimplePTTSettings::setTitle(QString* title) {
    this->title = title;
    this->m_title_isSet = true;
}

qint32
SWGSimplePTTSettings::getRgbColor() {
    return rgb_color;
}
void
SWGSimplePTTSettings::setRgbColor(qint32 rgb_color) {
    this->rgb_color = rgb_color;
    this->m_rgb_color_isSet = true;
}

qint32
SWGSimplePTTSettings::getRxDeviceSetIndex() {
    return rx_device_set_index;
}
void
SWGSimplePTTSettings::setRxDeviceSetIndex(qint32 rx_device_set_index) {
    this->rx_device_set_index = rx_device_set_index;
    this->m_rx_device_set_index_isSet = true;
}

qint32
SWGSimplePTTSettings::getTxDeviceSetIndex() {
    return tx_device_set_index;
}
void
SWGSimplePTTSettings::setTxDeviceSetIndex(qint32 tx_device_set_index) {
    this->tx_device_set_index = tx_device_set_index;
    this->m_tx_device_set_index_isSet = true;
}

qint32
SWGSimplePTTSettings::getRx2TxDelayMs() {
    return rx2_tx_delay_ms;
}
void
SWGSimplePTTSettings::setRx2TxDelayMs(qint32 rx2_tx_delay_ms) {
    this->rx2_tx_delay_ms = rx2_tx_delay_ms;
    this->m_rx2_tx_delay_ms_isSet = true;
}

qint32
SWGSimplePTTSettings::getTx2RxDelayMs() {
    return tx2_rx_delay_ms;
}
void
SWGSimplePTTSettings::setTx2RxDelayMs(qint32 tx2_rx_delay_ms) {
    this->tx2_rx_delay_ms = tx2_rx_delay_ms;
    this->m_tx2_rx_delay_ms_isSet = true;
}

qint32
SWGSimplePTTSettings::getVox() {
    return vox;
}
void
SWGSimplePTTSettings::setVox(qint32 vox) {
    this->vox = vox;
    this->m_vox_isSet = true;
}

qint32
SWGSimplePTTSettings::getVoxEnable() {
    return vox_enable;
}
void
SWGSimplePTTSettings::setVoxEnable(qint32 vox_enable) {
    this->vox_enable = vox_enable;
    this->m_vox_enable_isSet = true;
}

qint32
SWGSimplePTTSettings::getVoxLevel() {
    return vox_level;
}
void
SWGSimplePTTSettings::setVoxLevel(qint32 vox_level) {
    this->vox_level = vox_level;
    this->m_vox_level_isSet = true;
}

qint32
SWGSimplePTTSettings::getVoxHold() {
    return vox_hold;
}
void
SWGSimplePTTSettings::setVoxHold(qint32 vox_hold) {
    this->vox_hold = vox_hold;
    this->m_vox_hold_isSet = true;
}

QString*
SWGSimplePTTSettings::getAudioDeviceName() {
    return audio_device_name;
}
void
SWGSimplePTTSettings::setAudioDeviceName(QString* audio_device_name) {
    this->audio_device_name = audio_device_name;
    this->m_audio_device_name_isSet = true;
}

qint32
SWGSimplePTTSettings::getGpioControl() {
    return gpio_control;
}
void
SWGSimplePTTSettings::setGpioControl(qint32 gpio_control) {
    this->gpio_control = gpio_control;
    this->m_gpio_control_isSet = true;
}

qint32
SWGSimplePTTSettings::getRx2txGpioEnable() {
    return rx2tx_gpio_enable;
}
void
SWGSimplePTTSettings::setRx2txGpioEnable(qint32 rx2tx_gpio_enable) {
    this->rx2tx_gpio_enable = rx2tx_gpio_enable;
    this->m_rx2tx_gpio_enable_isSet = true;
}

qint32
SWGSimplePTTSettings::getRx2txGpioMask() {
    return rx2tx_gpio_mask;
}
void
SWGSimplePTTSettings::setRx2txGpioMask(qint32 rx2tx_gpio_mask) {
    this->rx2tx_gpio_mask = rx2tx_gpio_mask;
    this->m_rx2tx_gpio_mask_isSet = true;
}

qint32
SWGSimplePTTSettings::getRx2txGpioValues() {
    return rx2tx_gpio_values;
}
void
SWGSimplePTTSettings::setRx2txGpioValues(qint32 rx2tx_gpio_values) {
    this->rx2tx_gpio_values = rx2tx_gpio_values;
    this->m_rx2tx_gpio_values_isSet = true;
}

qint32
SWGSimplePTTSettings::getRx2txCommandEnable() {
    return rx2tx_command_enable;
}
void
SWGSimplePTTSettings::setRx2txCommandEnable(qint32 rx2tx_command_enable) {
    this->rx2tx_command_enable = rx2tx_command_enable;
    this->m_rx2tx_command_enable_isSet = true;
}

QString*
SWGSimplePTTSettings::getRx2txCommand() {
    return rx2tx_command;
}
void
SWGSimplePTTSettings::setRx2txCommand(QString* rx2tx_command) {
    this->rx2tx_command = rx2tx_command;
    this->m_rx2tx_command_isSet = true;
}

qint32
SWGSimplePTTSettings::getTx2rxGpioEnable() {
    return tx2rx_gpio_enable;
}
void
SWGSimplePTTSettings::setTx2rxGpioEnable(qint32 tx2rx_gpio_enable) {
    this->tx2rx_gpio_enable = tx2rx_gpio_enable;
    this->m_tx2rx_gpio_enable_isSet = true;
}

qint32
SWGSimplePTTSettings::getTx2rxGpioMask() {
    return tx2rx_gpio_mask;
}
void
SWGSimplePTTSettings::setTx2rxGpioMask(qint32 tx2rx_gpio_mask) {
    this->tx2rx_gpio_mask = tx2rx_gpio_mask;
    this->m_tx2rx_gpio_mask_isSet = true;
}

qint32
SWGSimplePTTSettings::getTx2rxGpioValues() {
    return tx2rx_gpio_values;
}
void
SWGSimplePTTSettings::setTx2rxGpioValues(qint32 tx2rx_gpio_values) {
    this->tx2rx_gpio_values = tx2rx_gpio_values;
    this->m_tx2rx_gpio_values_isSet = true;
}

qint32
SWGSimplePTTSettings::getTx2rxCommandEnable() {
    return tx2rx_command_enable;
}
void
SWGSimplePTTSettings::setTx2rxCommandEnable(qint32 tx2rx_command_enable) {
    this->tx2rx_command_enable = tx2rx_command_enable;
    this->m_tx2rx_command_enable_isSet = true;
}

QString*
SWGSimplePTTSettings::getTx2rxCommand() {
    return tx2rx_command;
}
void
SWGSimplePTTSettings::setTx2rxCommand(QString* tx2rx_command) {
    this->tx2rx_command = tx2rx_command;
    this->m_tx2rx_command_isSet = true;
}

qint32
SWGSimplePTTSettings::getUseReverseApi() {
    return use_reverse_api;
}
void
SWGSimplePTTSettings::setUseReverseApi(qint32 use_reverse_api) {
    this->use_reverse_api = use_reverse_api;
    this->m_use_reverse_api_isSet = true;
}

QString*
SWGSimplePTTSettings::getReverseApiAddress() {
    return reverse_api_address;
}
void
SWGSimplePTTSettings::setReverseApiAddress(QString* reverse_api_address) {
    this->reverse_api_address = reverse_api_address;
    this->m_reverse_api_address_isSet = true;
}

qint32
SWGSimplePTTSettings::getReverseApiPort() {
    return reverse_api_port;
}
void
SWGSimplePTTSettings::setReverseApiPort(qint32 reverse_api_port) {
    this->reverse_api_port = reverse_api_port;
    this->m_reverse_api_port_isSet = true;
}

qint32
SWGSimplePTTSettings::getReverseApiFeatureSetIndex() {
    return reverse_api_feature_set_index;
}
void
SWGSimplePTTSettings::setReverseApiFeatureSetIndex(qint32 reverse_api_feature_set_index) {
    this->reverse_api_feature_set_index = reverse_api_feature_set_index;
    this->m_reverse_api_feature_set_index_isSet = true;
}

qint32
SWGSimplePTTSettings::getReverseApiFeatureIndex() {
    return reverse_api_feature_index;
}
void
SWGSimplePTTSettings::setReverseApiFeatureIndex(qint32 reverse_api_feature_index) {
    this->reverse_api_feature_index = reverse_api_feature_index;
    this->m_reverse_api_feature_index_isSet = true;
}

SWGRollupState*
SWGSimplePTTSettings::getRollupState() {
    return rollup_state;
}
void
SWGSimplePTTSettings::setRollupState(SWGRollupState* rollup_state) {
    this->rollup_state = rollup_state;
    this->m_rollup_state_isSet = true;
}


bool
SWGSimplePTTSettings::isSet(){
    bool isObjectUpdated = false;
    do{
        if(title && *title != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_rgb_color_isSet){
            isObjectUpdated = true; break;
        }
        if(m_rx_device_set_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_tx_device_set_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_rx2_tx_delay_ms_isSet){
            isObjectUpdated = true; break;
        }
        if(m_tx2_rx_delay_ms_isSet){
            isObjectUpdated = true; break;
        }
        if(m_vox_isSet){
            isObjectUpdated = true; break;
        }
        if(m_vox_enable_isSet){
            isObjectUpdated = true; break;
        }
        if(m_vox_level_isSet){
            isObjectUpdated = true; break;
        }
        if(m_vox_hold_isSet){
            isObjectUpdated = true; break;
        }
        if(audio_device_name && *audio_device_name != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_gpio_control_isSet){
            isObjectUpdated = true; break;
        }
        if(m_rx2tx_gpio_enable_isSet){
            isObjectUpdated = true; break;
        }
        if(m_rx2tx_gpio_mask_isSet){
            isObjectUpdated = true; break;
        }
        if(m_rx2tx_gpio_values_isSet){
            isObjectUpdated = true; break;
        }
        if(m_rx2tx_command_enable_isSet){
            isObjectUpdated = true; break;
        }
        if(rx2tx_command && *rx2tx_command != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_tx2rx_gpio_enable_isSet){
            isObjectUpdated = true; break;
        }
        if(m_tx2rx_gpio_mask_isSet){
            isObjectUpdated = true; break;
        }
        if(m_tx2rx_gpio_values_isSet){
            isObjectUpdated = true; break;
        }
        if(m_tx2rx_command_enable_isSet){
            isObjectUpdated = true; break;
        }
        if(tx2rx_command && *tx2rx_command != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_use_reverse_api_isSet){
            isObjectUpdated = true; break;
        }
        if(reverse_api_address && *reverse_api_address != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_port_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_feature_set_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_feature_index_isSet){
            isObjectUpdated = true; break;
        }
        if(rollup_state && rollup_state->isSet()){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

