'\"
'\" Generated from file '/home/aku/Projects/Tcllib/tklib/embedded/man/files/modules/widgetl/widget_listentry\&.n' by tcllib/doctools with format 'nroff'
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "widget_listentry" n 0\&.1 tklib "widget::listentry widget"
.BS
.SH NAME
widget_listentry \- widget::listentry widget
.SH SYNOPSIS
package require \fBTcl  8\&.5\fR
.sp
package require \fBTk  8\&.5\fR
.sp
package require \fBwidget::listentry  ?0\&.1?\fR
.sp
package require \fBwidget::validator  ?0\&.1?\fR
.sp
package require \fBwidget::scrolledwindow \fR
.sp
package require \fBsnit \fR
.sp
package require \fBtooltip \fR
.sp
package require \fBimg::png \fR
.sp
package require \fBmsgcat \fR
.sp
\fBwidget::listentry\fR \fIpathname\fR ?options?
.sp
\fBwidgetCmd\fR \fBdestroy\fR
.sp
\fBwidgetCmd\fR \fBconfigure\fR
.sp
\fBwidgetCmd\fR \fBconfigure\fR \fIoption\fR \fIvalue\fR \&.\&.\&.
.sp
\fBwidgetCmd\fR \fBconfigure\fR \fIoption\fR
.sp
\fBwidgetCmd\fR \fBcget\fR \fIoption\fR
.sp
\fI{*}cmdprefix\fR \fBget\fR
.sp
\fI{*}cmdprefix\fR \fBset\fR \fIvalues\fR
.sp
\fI{*}cmdprefix\fR \fItext\fR \fIerrvar\fR
.sp
\fI{*}cmdprefix\fR \fItext\fR
.sp
\fI{*}cmdprefix\fR \fIcookievar\fR
.sp
.BE
.SH DESCRIPTION
This package provides a megawidget for the interactive entry of
ordered and unordered lists\&.
For a simpler and more restricted megawidget please see the
package \fBwidget::listsimple\fR\&.
.SH "CLASS API"
The widget class supports a single command, for the creation of widgets\&.
.TP
\fBwidget::listentry\fR \fIpathname\fR ?options?
This command creates and configures new instances of the widget\&.
.sp
For details on the available options please see section
\fBWidget Options\fR\&.
.sp
The result of the command is the pathname of the new widget\&.
.PP
.SH "INSTANCE API"
All widget instances supported the following methods\&.
.TP
\fBwidgetCmd\fR \fBdestroy\fR
This method destroys the widget\&.
Any further access to the widget will generate errors\&.
.sp
The result of the command is the empty string\&.
.TP
\fBwidgetCmd\fR \fBconfigure\fR
This method comes in three variants\&. This variant here returns a list
containing the current configuration of the widget, i\&.e\&. the values
for all options\&.
.sp
For details on the available options please see section
\fBWidget Options\fR\&.
.TP
\fBwidgetCmd\fR \fBconfigure\fR \fIoption\fR \fIvalue\fR \&.\&.\&.
This method comes in three variants\&. This variant here reconfigures
the widget, setting the specified options to the given values\&.
.sp
\fINote\fR that it is not possible to change the
construction-time only options\&.
.sp
For details on the available options please see section
\fBWidget General Options\fR\&.
.sp
The result of the command is the empty string\&.
.TP
\fBwidgetCmd\fR \fBconfigure\fR \fIoption\fR
This method comes in three variants\&. This variant here is an alias
for the method \fBcget\fR below and identical to it\&.
.TP
\fBwidgetCmd\fR \fBcget\fR \fIoption\fR
This method returns the current value of the specified \fIoption\fR\&.
.sp
For details on the available options please see section
\fBWidget Options\fR\&.
.PP
.SH "WIDGET OPTIONS"
This section explains all the options available to instances of
\fBwidget::listentry\fR\&. Please note that a few of the options
can be set only at instance construction time\&. The majority of the
options can however be set both during construction- and runtime\&.
.SS "WIDGET CONSTRUCTION-TIME ONLY OPTIONS"
.TP
\fB-ordered\fR boolean
This options tells the new widget instance whether the list it manages
is ordered or not\&. If it is ordered the widget will show buttons with
which the selected entries can be moved around, editing the order\&.
.sp
The default is \fBfalse\fR, indicating an unordered list\&.
.TP
\fB-allow-duplicates\fR boolean
This options tells the new widget instance whether we are allowed to
add a string to the list multiple times, or not\&.
.sp
The default is \fBfalse\fR, indicating that duplicates are not
allowed\&.
.TP
\fB-values\fR cmdprefix
This option specifies a callback for the management of a predefined
list of strings a user may enter\&.
.sp
If specified the widget will use a combobox instead of a plain
entry field and fill its list during widget construction using the data
delivered by this callback\&.
The callback will be further invoked whenever a new value is entered
into the main list, to save the extended list of predefined values\&.
.sp
The signature of this callback is
.RS
.TP
\fI{*}cmdprefix\fR \fBget\fR
In this form the callback is expected to return a list of strings\&.
The strings are loaded into the list of the internal combobox for
quick access by the user\&.
.sp
It will be invoked once, during widget construction, to load the
list of predefined strings a user may enter\&.
.TP
\fI{*}cmdprefix\fR \fBset\fR \fIvalues\fR
In this form the callback is given a list of new strings and
expected to save them somewhere for future use\&.
.sp
The return value of the callback is ignored\&.
.sp
This form is invoked whenever the user entered a new string
into the main list\&. The order of strings in \fIvalues\fR represents
the order used to show them in the combobox's list\&.
.RE
.TP
\fB-validate\fR cmdprefix
This option specifies a callback which is invoked after every change of
the contents of the internal entry field\&. The signature of this callback is
.RS
.TP
\fI{*}cmdprefix\fR \fItext\fR \fIerrvar\fR
where \fItext\fR is the string to validate, and \fIerrvar\fR the name of
a variable the callback can store an error message into when it detects
invalid data\&.
.sp
The widget expects that the callback returns a boolean value, where
\fBtrue\fR indicates that \fItext\fR is valid\&.
.RE
.IP
The default validation, when no callback was specified, will treat the
empty string as invalid, and everything else as valid\&.
.sp
\fIPlease note\fR that the widget will prevent the entry of
duplicate values into the main list, regardless of the validity of the
input otherwise\&. This is in keeping with that this widget is meant for
the entry of unordered lists, essentially a set of strings\&.
.TP
\fB-transform\fR cmdprefix
This option specifies a callback which is invoked whenever a newly
entered element is moved from the entry field to the main list, or the
entry field is validated, as part of a check for duplicates, if such are
not allowed\&. The callback is given the text in the entry field and has
to return the text which is actually added to, or checked against the list\&.
.sp
The use case for this callback is essentially
\fIinput normalization\fR\&. The most simple case of such would be, for
example the use of
.CS

string tolower
.CE
.IP to impose a standard letter
case on the data\&. More complex example can be thought of, like rewriting
of multiple syntaxes of input to a canonical form\&.
The signature of this callback is
.RS
.TP
\fI{*}cmdprefix\fR \fItext\fR
where \fItext\fR is the string to transform\&.
.sp
The widget expects that the callback returns the transformed string\&.
.RE
.sp
The default is to not transform the entered strings\&.
.TP
\fB-browse\fR cmdprefix
If this option is specified the widget will display a "Search" button
and invoke the callback provided by the option whenever the user clicks
on that button\&.
The signature of the callback is
.RS
.TP
\fI{*}cmdprefix\fR \fIcookievar\fR
where the cookie variable provides access to context information the
callback may wish to preserve between invokations\&. The initial value
stored in the variable is the empty string\&. After that it is whatever
the callback wishes to store\&.
.sp
The widget expects that the callback returns a list of strings,
which are then added to the list, modulo validity and duplicate checks\&.
.RE
.sp
By default there is no browse callback and no button shown\&.
.PP
.SS "WIDGET GENERAL OPTIONS"
.TP
\fB-listvariable\fR varname
This option specifies the variable holding the list to be manipulated by
the widget\&. Any changes to the list outside of the widget are automatically
imported into the widget\&. Similarly, all changes made to the list by the
widget are automatically exported to this variable\&.
.TP
\fB-state\fR normal|disabled
This option specifies the status of the widget, \fBnormal\fR (= active),
or \fBdisabled\fR\&. A disabled widget can not be edited\&.
.sp
The default is \fBnormal\fR\&.
.TP
\fB-height\fR integer
This option specifies the height of the internal listbox, in lines\&.
.sp
The default is \fB20\fR\&.
.TP
\fB-skin-add\fR string
.TP
\fB-skin-remove\fR string
.TP
\fB-skin-up\fR string
.TP
\fB-skin-down\fR string
.TP
\fB-skin-browse\fR string
.TP
\fB-skin-tip-add\fR string
.TP
\fB-skin-tip-remove\fR string
.TP
\fB-skin-tip-up\fR string
.TP
\fB-skin-tip-down\fR string
.TP
\fB-skin-tip-browse\fR string
.TP
\fB-skin-tip-main\fR string
.TP
\fB-skin-tip-entry\fR string
.TP
\fB-skin-tip-list\fR string
.TP
\fB-skin-tip-empty\fR string
.TP
\fB-skin-tip-duplicate\fR string
.TP
\fB-skin-tip-add-none\fR string
.TP
\fB-skin-tip-remove-none\fR string
.TP
\fB-skin-img-add\fR image
.TP
\fB-skin-img-remove\fR image
.TP
\fB-skin-img-up\fR string
.TP
\fB-skin-img-down\fR string
.TP
\fB-skin-img-browse\fR string
.TP
\fB-skin-invalid-color\fR color
These options all modify the appearance of the widget, i\&.e\&. its skin\&.
.sp
All options taking a string argument influence the various labels
shown, with the \fB-skin-tip-*\fR options influencing the tooltips
shown on hovering the over various parts in particular\&.
.sp
All the strings are run through \fBmsgcat\fR first, enabling
text localization through message catalogs\&. The default values are keys
into the message catalogs which are part of the package itself\&.
.sp
The options taking images modify the images shown on the buttons
for adding and removing elements of the list\&. They default to the PNG
images distributed with the package itself\&.
.sp
The single option taking a color value modifies the color used to
highlight invalid data entered into the internal entry field of the
widget\&. This option defaults to \fByellow\fR\&.
.PP
.SH EXAMPLE
.CS


.CE
.SH KEYWORDS
data entry lists, data entry ordered list, data entry set of strings, data entry unordered list, list entry panel, set entry panel, widget