/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */

import { CloudErrorMapper, BaseResourceMapper } from "@azure/ms-rest-azure-js";
import * as msRest from "@azure/ms-rest-js";

export const CloudError = CloudErrorMapper;
export const BaseResource = BaseResourceMapper;

export const DateTimeInterval: msRest.CompositeMapper = {
  serializedName: "DateTimeInterval",
  type: {
    name: "Composite",
    className: "DateTimeInterval",
    modelProperties: {
      start: {
        required: true,
        serializedName: "start",
        type: {
          name: "DateTime"
        }
      },
      end: {
        required: true,
        serializedName: "end",
        type: {
          name: "DateTime"
        }
      }
    }
  }
};

export const ResourceChangesRequestParametersInterval: msRest.CompositeMapper = {
  serializedName: "ResourceChangesRequestParameters_interval",
  type: {
    name: "Composite",
    className: "ResourceChangesRequestParametersInterval",
    modelProperties: {
      ...DateTimeInterval.type.modelProperties
    }
  }
};

export const ResourceChangesRequestParameters: msRest.CompositeMapper = {
  serializedName: "ResourceChangesRequestParameters",
  type: {
    name: "Composite",
    className: "ResourceChangesRequestParameters",
    modelProperties: {
      resourceIds: {
        serializedName: "resourceIds",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "String"
            }
          }
        }
      },
      subscriptionId: {
        serializedName: "subscriptionId",
        type: {
          name: "String"
        }
      },
      interval: {
        required: true,
        serializedName: "interval",
        type: {
          name: "Composite",
          className: "ResourceChangesRequestParametersInterval"
        }
      },
      skipToken: {
        serializedName: "$skipToken",
        type: {
          name: "String"
        }
      },
      top: {
        serializedName: "$top",
        constraints: {
          InclusiveMaximum: 1000,
          InclusiveMinimum: 1
        },
        type: {
          name: "Number"
        }
      },
      table: {
        serializedName: "table",
        type: {
          name: "String"
        }
      },
      fetchPropertyChanges: {
        serializedName: "fetchPropertyChanges",
        type: {
          name: "Boolean"
        }
      },
      fetchSnapshots: {
        serializedName: "fetchSnapshots",
        type: {
          name: "Boolean"
        }
      }
    }
  }
};

export const ResourceSnapshotData: msRest.CompositeMapper = {
  serializedName: "ResourceSnapshotData",
  type: {
    name: "Composite",
    className: "ResourceSnapshotData",
    modelProperties: {
      snapshotId: {
        serializedName: "snapshotId",
        type: {
          name: "String"
        }
      },
      timestamp: {
        required: true,
        serializedName: "timestamp",
        type: {
          name: "DateTime"
        }
      },
      content: {
        serializedName: "content",
        type: {
          name: "Object"
        }
      }
    }
  }
};

export const ResourceChangeDataBeforeSnapshot: msRest.CompositeMapper = {
  serializedName: "ResourceChangeData_beforeSnapshot",
  type: {
    name: "Composite",
    className: "ResourceChangeDataBeforeSnapshot",
    modelProperties: {
      ...ResourceSnapshotData.type.modelProperties
    }
  }
};

export const ResourceChangeDataAfterSnapshot: msRest.CompositeMapper = {
  serializedName: "ResourceChangeData_afterSnapshot",
  type: {
    name: "Composite",
    className: "ResourceChangeDataAfterSnapshot",
    modelProperties: {
      ...ResourceSnapshotData.type.modelProperties
    }
  }
};

export const ResourcePropertyChange: msRest.CompositeMapper = {
  serializedName: "ResourcePropertyChange",
  type: {
    name: "Composite",
    className: "ResourcePropertyChange",
    modelProperties: {
      propertyName: {
        required: true,
        serializedName: "propertyName",
        type: {
          name: "String"
        }
      },
      beforeValue: {
        serializedName: "beforeValue",
        type: {
          name: "String"
        }
      },
      afterValue: {
        serializedName: "afterValue",
        type: {
          name: "String"
        }
      },
      changeCategory: {
        required: true,
        serializedName: "changeCategory",
        type: {
          name: "Enum",
          allowedValues: ["User", "System"]
        }
      },
      propertyChangeType: {
        required: true,
        serializedName: "propertyChangeType",
        type: {
          name: "Enum",
          allowedValues: ["Insert", "Update", "Remove"]
        }
      }
    }
  }
};

export const ResourceChangeData: msRest.CompositeMapper = {
  serializedName: "ResourceChangeData",
  type: {
    name: "Composite",
    className: "ResourceChangeData",
    modelProperties: {
      resourceId: {
        serializedName: "resourceId",
        type: {
          name: "String"
        }
      },
      changeId: {
        required: true,
        serializedName: "changeId",
        type: {
          name: "String"
        }
      },
      beforeSnapshot: {
        required: true,
        serializedName: "beforeSnapshot",
        type: {
          name: "Composite",
          className: "ResourceChangeDataBeforeSnapshot"
        }
      },
      afterSnapshot: {
        required: true,
        serializedName: "afterSnapshot",
        type: {
          name: "Composite",
          className: "ResourceChangeDataAfterSnapshot"
        }
      },
      changeType: {
        serializedName: "changeType",
        type: {
          name: "Enum",
          allowedValues: ["Create", "Update", "Delete"]
        }
      },
      propertyChanges: {
        serializedName: "propertyChanges",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "Composite",
              className: "ResourcePropertyChange"
            }
          }
        }
      }
    }
  }
};

export const ResourceChangeList: msRest.CompositeMapper = {
  serializedName: "ResourceChangeList",
  type: {
    name: "Composite",
    className: "ResourceChangeList",
    modelProperties: {
      changes: {
        serializedName: "changes",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "Composite",
              className: "ResourceChangeData"
            }
          }
        }
      },
      skipToken: {
        serializedName: "$skipToken",
        type: {
          name: "Object"
        }
      }
    }
  }
};

export const ResourceChangeDetailsRequestParameters: msRest.CompositeMapper = {
  serializedName: "ResourceChangeDetailsRequestParameters",
  type: {
    name: "Composite",
    className: "ResourceChangeDetailsRequestParameters",
    modelProperties: {
      resourceIds: {
        required: true,
        serializedName: "resourceIds",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "String"
            }
          }
        }
      },
      changeIds: {
        required: true,
        serializedName: "changeIds",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "String"
            }
          }
        }
      }
    }
  }
};

export const ErrorDetails: msRest.CompositeMapper = {
  serializedName: "ErrorDetails",
  type: {
    name: "Composite",
    className: "ErrorDetails",
    modelProperties: {
      code: {
        required: true,
        serializedName: "code",
        type: {
          name: "String"
        }
      },
      message: {
        required: true,
        serializedName: "message",
        type: {
          name: "String"
        }
      }
    },
    additionalProperties: {
      type: {
        name: "Object"
      }
    }
  }
};

export const ErrorModel: msRest.CompositeMapper = {
  serializedName: "Error",
  type: {
    name: "Composite",
    className: "ErrorModel",
    modelProperties: {
      code: {
        required: true,
        serializedName: "code",
        type: {
          name: "String"
        }
      },
      message: {
        required: true,
        serializedName: "message",
        type: {
          name: "String"
        }
      },
      details: {
        serializedName: "details",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "Composite",
              className: "ErrorDetails",
              additionalProperties: {
                type: {
                  name: "Object"
                }
              }
            }
          }
        }
      }
    }
  }
};

export const ErrorResponse: msRest.CompositeMapper = {
  serializedName: "ErrorResponse",
  type: {
    name: "Composite",
    className: "ErrorResponse",
    modelProperties: {
      error: {
        required: true,
        serializedName: "error",
        type: {
          name: "Composite",
          className: "ErrorModel"
        }
      }
    }
  }
};

export const QueryRequestOptions: msRest.CompositeMapper = {
  serializedName: "QueryRequestOptions",
  type: {
    name: "Composite",
    className: "QueryRequestOptions",
    modelProperties: {
      skipToken: {
        serializedName: "$skipToken",
        type: {
          name: "String"
        }
      },
      top: {
        serializedName: "$top",
        constraints: {
          InclusiveMaximum: 1000,
          InclusiveMinimum: 1
        },
        type: {
          name: "Number"
        }
      },
      skip: {
        serializedName: "$skip",
        constraints: {
          InclusiveMinimum: 0
        },
        type: {
          name: "Number"
        }
      },
      resultFormat: {
        serializedName: "resultFormat",
        defaultValue: "objectArray",
        type: {
          name: "Enum",
          allowedValues: ["table", "objectArray"]
        }
      },
      allowPartialScopes: {
        serializedName: "allowPartialScopes",
        defaultValue: false,
        type: {
          name: "Boolean"
        }
      }
    }
  }
};

export const FacetRequestOptions: msRest.CompositeMapper = {
  serializedName: "FacetRequestOptions",
  type: {
    name: "Composite",
    className: "FacetRequestOptions",
    modelProperties: {
      sortBy: {
        serializedName: "sortBy",
        type: {
          name: "String"
        }
      },
      sortOrder: {
        serializedName: "sortOrder",
        defaultValue: "desc",
        type: {
          name: "Enum",
          allowedValues: ["asc", "desc"]
        }
      },
      filter: {
        serializedName: "filter",
        type: {
          name: "String"
        }
      },
      top: {
        serializedName: "$top",
        constraints: {
          InclusiveMaximum: 1000,
          InclusiveMinimum: 1
        },
        type: {
          name: "Number"
        }
      }
    }
  }
};

export const FacetRequest: msRest.CompositeMapper = {
  serializedName: "FacetRequest",
  type: {
    name: "Composite",
    className: "FacetRequest",
    modelProperties: {
      expression: {
        required: true,
        serializedName: "expression",
        type: {
          name: "String"
        }
      },
      options: {
        serializedName: "options",
        type: {
          name: "Composite",
          className: "FacetRequestOptions"
        }
      }
    }
  }
};

export const QueryRequest: msRest.CompositeMapper = {
  serializedName: "QueryRequest",
  type: {
    name: "Composite",
    className: "QueryRequest",
    modelProperties: {
      subscriptions: {
        serializedName: "subscriptions",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "String"
            }
          }
        }
      },
      managementGroups: {
        serializedName: "managementGroups",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "String"
            }
          }
        }
      },
      query: {
        required: true,
        serializedName: "query",
        type: {
          name: "String"
        }
      },
      options: {
        serializedName: "options",
        type: {
          name: "Composite",
          className: "QueryRequestOptions"
        }
      },
      facets: {
        serializedName: "facets",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "Composite",
              className: "FacetRequest"
            }
          }
        }
      }
    }
  }
};

export const Facet: msRest.CompositeMapper = {
  serializedName: "Facet",
  type: {
    name: "Composite",
    polymorphicDiscriminator: {
      serializedName: "resultType",
      clientName: "resultType"
    },
    uberParent: "Facet",
    className: "Facet",
    modelProperties: {
      expression: {
        required: true,
        serializedName: "expression",
        type: {
          name: "String"
        }
      },
      resultType: {
        required: true,
        serializedName: "resultType",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const QueryResponse: msRest.CompositeMapper = {
  serializedName: "QueryResponse",
  type: {
    name: "Composite",
    className: "QueryResponse",
    modelProperties: {
      totalRecords: {
        required: true,
        serializedName: "totalRecords",
        type: {
          name: "Number"
        }
      },
      count: {
        required: true,
        serializedName: "count",
        type: {
          name: "Number"
        }
      },
      resultTruncated: {
        required: true,
        serializedName: "resultTruncated",
        type: {
          name: "Enum",
          allowedValues: ["true", "false"]
        }
      },
      skipToken: {
        serializedName: "$skipToken",
        type: {
          name: "String"
        }
      },
      data: {
        required: true,
        serializedName: "data",
        type: {
          name: "Object"
        }
      },
      facets: {
        serializedName: "facets",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "Composite",
              className: "Facet"
            }
          }
        }
      }
    }
  }
};

export const Column: msRest.CompositeMapper = {
  serializedName: "Column",
  type: {
    name: "Composite",
    className: "Column",
    modelProperties: {
      name: {
        required: true,
        serializedName: "name",
        type: {
          name: "String"
        }
      },
      type: {
        required: true,
        serializedName: "type",
        type: {
          name: "Enum",
          allowedValues: ["string", "integer", "number", "boolean", "object"]
        }
      }
    }
  }
};

export const Table: msRest.CompositeMapper = {
  serializedName: "Table",
  type: {
    name: "Composite",
    className: "Table",
    modelProperties: {
      columns: {
        required: true,
        serializedName: "columns",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "Composite",
              className: "Column"
            }
          }
        }
      },
      rows: {
        required: true,
        serializedName: "rows",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "Sequence",
              element: {
                type: {
                  name: "Object"
                }
              }
            }
          }
        }
      }
    }
  }
};

export const FacetResult: msRest.CompositeMapper = {
  serializedName: "FacetResult",
  type: {
    name: "Composite",
    polymorphicDiscriminator: Facet.type.polymorphicDiscriminator,
    uberParent: "Facet",
    className: "FacetResult",
    modelProperties: {
      ...Facet.type.modelProperties,
      totalRecords: {
        required: true,
        serializedName: "totalRecords",
        type: {
          name: "Number"
        }
      },
      count: {
        required: true,
        serializedName: "count",
        type: {
          name: "Number"
        }
      },
      data: {
        required: true,
        serializedName: "data",
        type: {
          name: "Object"
        }
      }
    }
  }
};

export const FacetError: msRest.CompositeMapper = {
  serializedName: "FacetError",
  type: {
    name: "Composite",
    polymorphicDiscriminator: Facet.type.polymorphicDiscriminator,
    uberParent: "Facet",
    className: "FacetError",
    modelProperties: {
      ...Facet.type.modelProperties,
      errors: {
        required: true,
        serializedName: "errors",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "Composite",
              className: "ErrorDetails",
              additionalProperties: {
                type: {
                  name: "Object"
                }
              }
            }
          }
        }
      }
    }
  }
};

export const OperationDisplay: msRest.CompositeMapper = {
  serializedName: "Operation_display",
  type: {
    name: "Composite",
    className: "OperationDisplay",
    modelProperties: {
      provider: {
        serializedName: "provider",
        type: {
          name: "String"
        }
      },
      resource: {
        serializedName: "resource",
        type: {
          name: "String"
        }
      },
      operation: {
        serializedName: "operation",
        type: {
          name: "String"
        }
      },
      description: {
        serializedName: "description",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const Operation: msRest.CompositeMapper = {
  serializedName: "Operation",
  type: {
    name: "Composite",
    className: "Operation",
    modelProperties: {
      name: {
        serializedName: "name",
        type: {
          name: "String"
        }
      },
      display: {
        serializedName: "display",
        type: {
          name: "Composite",
          className: "OperationDisplay"
        }
      },
      origin: {
        serializedName: "origin",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const ResourcesHistoryRequestOptions: msRest.CompositeMapper = {
  serializedName: "ResourcesHistoryRequestOptions",
  type: {
    name: "Composite",
    className: "ResourcesHistoryRequestOptions",
    modelProperties: {
      interval: {
        serializedName: "interval",
        type: {
          name: "Composite",
          className: "DateTimeInterval"
        }
      },
      top: {
        serializedName: "$top",
        type: {
          name: "Number"
        }
      },
      skip: {
        serializedName: "$skip",
        type: {
          name: "Number"
        }
      },
      skipToken: {
        serializedName: "$skipToken",
        type: {
          name: "String"
        }
      },
      resultFormat: {
        serializedName: "resultFormat",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const ResourcesHistoryRequest: msRest.CompositeMapper = {
  serializedName: "ResourcesHistoryRequest",
  type: {
    name: "Composite",
    className: "ResourcesHistoryRequest",
    modelProperties: {
      subscriptions: {
        serializedName: "subscriptions",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "String"
            }
          }
        }
      },
      query: {
        serializedName: "query",
        type: {
          name: "String"
        }
      },
      options: {
        serializedName: "options",
        type: {
          name: "Composite",
          className: "ResourcesHistoryRequestOptions"
        }
      },
      managementGroupId: {
        serializedName: "managementGroupId",
        type: {
          name: "String"
        }
      }
    }
  }
};

export const OperationListResult: msRest.CompositeMapper = {
  serializedName: "OperationListResult",
  type: {
    name: "Composite",
    className: "OperationListResult",
    modelProperties: {
      value: {
        serializedName: "",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "Composite",
              className: "Operation"
            }
          }
        }
      }
    }
  }
};

export const discriminators = {
  Facet: Facet,
  "Facet.FacetResult": FacetResult,
  "Facet.FacetError": FacetError
};
