/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
import { __assign } from "tslib";
import * as msRest from "@azure/ms-rest-js";
import * as Mappers from "../models/subscriptionOperationsMappers";
import * as Parameters from "../models/parameters";
/** Class representing a SubscriptionOperations. */
var SubscriptionOperations = /** @class */ (function () {
    /**
     * Create a SubscriptionOperations.
     * @param {SubscriptionClientContext} client Reference to the service client.
     */
    function SubscriptionOperations(client) {
        this.client = client;
    }
    SubscriptionOperations.prototype.cancel = function (subscriptionId, options, callback) {
        return this.client.sendOperationRequest({
            subscriptionId: subscriptionId,
            options: options
        }, cancelOperationSpec, callback);
    };
    SubscriptionOperations.prototype.rename = function (subscriptionId, body, options, callback) {
        return this.client.sendOperationRequest({
            subscriptionId: subscriptionId,
            body: body,
            options: options
        }, renameOperationSpec, callback);
    };
    SubscriptionOperations.prototype.enable = function (subscriptionId, options, callback) {
        return this.client.sendOperationRequest({
            subscriptionId: subscriptionId,
            options: options
        }, enableOperationSpec, callback);
    };
    return SubscriptionOperations;
}());
export { SubscriptionOperations };
// Operation Specifications
var serializer = new msRest.Serializer(Mappers);
var cancelOperationSpec = {
    httpMethod: "POST",
    path: "subscriptions/{subscriptionId}/providers/Microsoft.Subscription/cancel",
    urlParameters: [
        Parameters.subscriptionId
    ],
    queryParameters: [
        Parameters.apiVersion1
    ],
    headerParameters: [
        Parameters.acceptLanguage
    ],
    responses: {
        200: {
            bodyMapper: Mappers.CanceledSubscriptionId
        },
        default: {
            bodyMapper: Mappers.ErrorResponse
        }
    },
    serializer: serializer
};
var renameOperationSpec = {
    httpMethod: "POST",
    path: "subscriptions/{subscriptionId}/providers/Microsoft.Subscription/rename",
    urlParameters: [
        Parameters.subscriptionId
    ],
    queryParameters: [
        Parameters.apiVersion1
    ],
    headerParameters: [
        Parameters.acceptLanguage
    ],
    requestBody: {
        parameterPath: "body",
        mapper: __assign(__assign({}, Mappers.SubscriptionName), { required: true })
    },
    responses: {
        200: {
            bodyMapper: Mappers.RenamedSubscriptionId
        },
        default: {
            bodyMapper: Mappers.ErrorResponse
        }
    },
    serializer: serializer
};
var enableOperationSpec = {
    httpMethod: "POST",
    path: "subscriptions/{subscriptionId}/providers/Microsoft.Subscription/enable",
    urlParameters: [
        Parameters.subscriptionId
    ],
    queryParameters: [
        Parameters.apiVersion1
    ],
    headerParameters: [
        Parameters.acceptLanguage
    ],
    responses: {
        200: {
            bodyMapper: Mappers.EnabledSubscriptionId
        },
        default: {
            bodyMapper: Mappers.ErrorResponse
        }
    },
    serializer: serializer
};
//# sourceMappingURL=subscriptionOperations.js.map