import { AccountEntity } from "@azure/msal-common";
export interface IPartitionManager {
    /**
     * This function should return the correct key from which to read
     * the specific user's information from cache.
     *
     * Example: Your application may be partitioning the user's cache
     * information for each user using the homeAccountId and thus
     * this function would return the homeAccountId for
     * the user in question
     *
     * Visit the [RedisTestApp](https://github.com/AzureAD/microsoft-authentication-library-for-js/tree/dev/samples/msal-node-samples/RedisTestApp) to see it in action.
     *
     * @returns Promise<string>
     */
    getKey(): Promise<string>;
    /**
     * This function should return the correct key being used to save each
     * user's cache information to cache - given an AccountEntity
     *
     * Example: Your application may be partitioning the user's cache
     * information for each user using the homeAccountId thus
     * this function would return the homeAccountId from
     * the provided AccountEntity
     *
     * Visit the [RedisTestApp](https://github.com/AzureAD/microsoft-authentication-library-for-js/tree/dev/samples/msal-node-samples/RedisTestApp) to see it in action.
     *
     * @param accountEntity: AccountEntity
     * @returns Promise<string>
     */
    extractKey(accountEntity: AccountEntity): Promise<string>;
}
//# sourceMappingURL=IPartitionManager.d.ts.map