/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
import { __extends } from "tslib";
import * as Models from "./models";
import * as Mappers from "./models/mappers";
import * as operations from "./operations";
import { SubscriptionClientContext } from "./subscriptionClientContext";
var SubscriptionClient = /** @class */ (function (_super) {
    __extends(SubscriptionClient, _super);
    /**
     * Initializes a new instance of the SubscriptionClient class.
     * @param credentials Credentials needed for the client to connect to Azure. Credentials
     * implementing the TokenCredential interface from the @azure/identity package are recommended. For
     * more information about these credentials, see
     * {@link https://www.npmjs.com/package/@azure/identity}. Credentials implementing the
     * ServiceClientCredentials interface from the older packages @azure/ms-rest-nodeauth and
     * @azure/ms-rest-browserauth are also supported.
     * @param [options] The parameter options
     */
    function SubscriptionClient(credentials, options) {
        var _this = _super.call(this, credentials, options) || this;
        _this.subscriptions = new operations.Subscriptions(_this);
        _this.tenants = new operations.Tenants(_this);
        _this.subscription = new operations.SubscriptionOperations(_this);
        _this.operations = new operations.Operations(_this);
        _this.alias = new operations.Alias(_this);
        return _this;
    }
    return SubscriptionClient;
}(SubscriptionClientContext));
// Operation Specifications
export { SubscriptionClient, SubscriptionClientContext, Models as SubscriptionModels, Mappers as SubscriptionMappers };
export * from "./operations";
//# sourceMappingURL=subscriptionClient.js.map