// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
import { __extends } from "tslib";
import { ApiKeyCredentials } from "@azure/ms-rest-js";
/**
 * Creates a new CognitiveServicesCredentials object.
 *
 * @constructor
 * @param {string} subscriptionKey   The CognitiveServices subscription key
 */
var CognitiveServicesCredentials = /** @class */ (function (_super) {
    __extends(CognitiveServicesCredentials, _super);
    function CognitiveServicesCredentials(subscriptionKey) {
        var _this = this;
        if (!subscriptionKey || (subscriptionKey && typeof subscriptionKey.valueOf() !== "string")) {
            throw new Error("subscriptionKey cannot be null or undefined and must be of type string.");
        }
        var options = {
            inHeader: {
                "Ocp-Apim-Subscription-Key": subscriptionKey,
                "X-BingApis-SDK-Client": "node-SDK"
            }
        };
        _this = _super.call(this, options) || this;
        return _this;
    }
    return CognitiveServicesCredentials;
}(ApiKeyCredentials));
export { CognitiveServicesCredentials };
//# sourceMappingURL=cognitiveServicesCredentials.js.map