"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.YARGS_HELPERS = void 0;
exports.makeConfig = makeConfig;
const cloud_assembly_schema_1 = require("@aws-cdk/cloud-assembly-schema");
// eslint-disable-next-line import/no-extraneous-dependencies
const user_input_gen_1 = require("@aws-cdk/user-input-gen");
const cdk_from_cfn = require("cdk-from-cfn");
const deploy_1 = require("../commands/deploy");
const init_1 = require("../commands/init");
const package_manager_1 = require("../commands/init/package-manager");
const language_1 = require("../commands/language");
exports.YARGS_HELPERS = new user_input_gen_1.CliHelpers('./util/yargs-helpers');
/**
 * Source of truth for all CDK CLI commands. `user-input-gen` translates this into:
 *
 * - the `yargs` definition in `lib/parse-command-line-arguments.ts`.
 * - the `UserInput` type in `lib/user-input.ts`.
 * - the `convertXxxToUserInput` functions in `lib/convert-to-user-input.ts`.
 */
async function makeConfig() {
    return {
        globalOptions: {
            'app': { type: 'string', alias: 'a', desc: 'REQUIRED WHEN RUNNING APP: command-line for executing your app or a cloud assembly directory (e.g. "node bin/my-app.js"). Can also be specified in cdk.json or ~/.cdk.json', requiresArg: true },
            'build': { type: 'string', desc: 'Command-line for a pre-synth build' },
            'context': { type: 'array', alias: 'c', desc: 'Add contextual string parameter (KEY=VALUE)' },
            'plugin': { type: 'array', alias: 'p', desc: 'Name or path of a node package that extend the CDK features. Can be specified multiple times' },
            'trace': { type: 'boolean', desc: 'Print trace for stack warnings' },
            'strict': { type: 'boolean', desc: 'Do not construct stacks with warnings' },
            'lookups': { type: 'boolean', desc: 'Perform context lookups (synthesis fails if this is disabled and context lookups need to be performed)', default: true },
            'ignore-errors': { type: 'boolean', default: false, desc: 'Ignores synthesis errors, which will likely produce an invalid output' },
            'json': { type: 'boolean', alias: 'j', desc: 'Use JSON output instead of YAML when templates are printed to STDOUT', default: false },
            'verbose': { type: 'boolean', alias: 'v', desc: 'Show debug logs (specify multiple times to increase verbosity)', default: false, count: true },
            'debug': { type: 'boolean', desc: 'Debug the CDK app. Log additional information during synthesis, such as creation stack traces of tokens (sets CDK_DEBUG, will slow down synthesis)', default: false },
            'profile': { type: 'string', desc: 'Use the indicated AWS profile as the default environment', requiresArg: true },
            'proxy': { type: 'string', desc: 'Use the indicated proxy. Will read from HTTPS_PROXY environment variable if not specified', requiresArg: true },
            'ca-bundle-path': { type: 'string', desc: 'Path to CA certificate to use when validating HTTPS requests. Will read from AWS_CA_BUNDLE environment variable if not specified', requiresArg: true },
            'ec2creds': { type: 'boolean', alias: 'i', default: undefined, desc: 'Force trying to fetch EC2 instance credentials. Default: guess EC2 instance status' },
            'version-reporting': { type: 'boolean', desc: 'Disable CLI telemetry and do not include the "AWS::CDK::Metadata" resource in synthesized templates (enabled by default)', default: undefined, alias: 'telemetry' },
            'path-metadata': { type: 'boolean', desc: 'Include "aws:cdk:path" CloudFormation metadata for each resource (enabled by default)', default: undefined },
            'asset-metadata': { type: 'boolean', desc: 'Include "aws:asset:*" CloudFormation metadata for resources that uses assets (enabled by default)', default: undefined },
            'role-arn': { type: 'string', alias: 'r', desc: 'ARN of Role to use when invoking CloudFormation', default: undefined, requiresArg: true },
            'staging': { type: 'boolean', desc: 'Copy assets to the output directory (use --no-staging to disable the copy of assets which allows local debugging via the SAM CLI to reference the original source files)', default: true },
            'output': { type: 'string', alias: 'o', desc: 'Emits the synthesized cloud assembly into a directory (default: cdk.out)', requiresArg: true },
            'notices': { type: 'boolean', desc: 'Show relevant notices' },
            'no-color': { type: 'boolean', desc: 'Removes colors and other style from console output', default: false },
            'ci': { type: 'boolean', desc: 'Force CI detection. If CI=true then logs will be sent to stdout instead of stderr', default: exports.YARGS_HELPERS.isCI() },
            'unstable': { type: 'array', desc: 'Opt in to unstable features. The flag indicates that the scope and API of a feature might still change. Otherwise the feature is generally production ready and fully supported. Can be specified multiple times.', default: [] },
            'telemetry-file': { type: 'string', desc: 'Send telemetry data to a local file.', default: undefined },
            'yes': { type: 'boolean', alias: 'y', desc: 'Automatically answer interactive prompts with the recommended response. This includes confirming actions.', default: false },
        },
        commands: {
            'list': {
                arg: {
                    name: 'STACKS',
                    variadic: true,
                },
                aliases: ['ls'],
                description: 'Lists all stacks in the app',
                options: {
                    'long': { type: 'boolean', default: false, alias: 'l', desc: 'Display environment information for each stack' },
                    'show-dependencies': { type: 'boolean', default: false, alias: 'd', desc: 'Display stack dependency information for each stack' },
                },
            },
            'synth': {
                arg: {
                    name: 'STACKS',
                    variadic: true,
                },
                aliases: ['synthesize'],
                description: 'Synthesizes and prints the CloudFormation template for this stack',
                options: {
                    exclusively: { type: 'boolean', alias: 'e', desc: 'Only synthesize requested stacks, don\'t include dependencies' },
                    validation: { type: 'boolean', desc: 'After synthesis, validate stacks with the "validateOnSynth" attribute set (can also be controlled with CDK_VALIDATION)', default: true },
                    quiet: { type: 'boolean', alias: 'q', desc: 'Do not output CloudFormation Template to stdout', default: false },
                },
            },
            'bootstrap': {
                arg: {
                    name: 'ENVIRONMENTS',
                    variadic: true,
                },
                description: 'Deploys the CDK toolkit stack into an AWS environment',
                options: {
                    'bootstrap-bucket-name': { type: 'string', alias: ['b', 'toolkit-bucket-name'], desc: 'The name of the CDK toolkit bucket; bucket will be created and must not exist', default: undefined },
                    'bootstrap-kms-key-id': { type: 'string', desc: 'AWS KMS master key ID used for the SSE-KMS encryption (specify AWS_MANAGED_KEY to use an AWS-managed key)', default: undefined, conflicts: 'bootstrap-customer-key' },
                    'example-permissions-boundary': { type: 'boolean', alias: 'epb', desc: 'Use the example permissions boundary.', default: undefined, conflicts: 'custom-permissions-boundary' },
                    'custom-permissions-boundary': { type: 'string', alias: 'cpb', desc: 'Use the permissions boundary specified by name.', default: undefined, conflicts: 'example-permissions-boundary' },
                    'bootstrap-customer-key': { type: 'boolean', desc: 'Create a Customer Master Key (CMK) for the bootstrap bucket (you will be charged but can customize permissions, modern bootstrapping only)', default: undefined, conflicts: 'bootstrap-kms-key-id' },
                    'qualifier': { type: 'string', desc: 'String which must be unique for each bootstrap stack. You must configure it on your CDK app if you change this from the default.', default: undefined },
                    'public-access-block-configuration': { type: 'boolean', desc: 'Block public access configuration on CDK toolkit bucket (enabled by default) ', default: undefined },
                    'deny-external-id': { type: 'boolean', desc: 'Block AssumeRole access to all boostrapped roles if an ExternalId is provided (enabled by default) ', default: undefined },
                    'tags': { type: 'array', alias: 't', desc: 'Tags to add for the stack (KEY=VALUE)', default: [] },
                    'execute': { type: 'boolean', desc: 'Whether to execute ChangeSet (--no-execute will NOT execute the ChangeSet)', default: true },
                    'trust': { type: 'array', desc: 'The AWS account IDs that should be trusted to perform deployments into this environment (may be repeated, modern bootstrapping only)', default: [] },
                    'trust-for-lookup': { type: 'array', desc: 'The AWS account IDs that should be trusted to look up values in this environment (may be repeated, modern bootstrapping only)', default: [] },
                    'untrust': { type: 'array', desc: 'The AWS account IDs that should not be trusted by this environment (may be repeated, modern bootstrapping only)', default: [] },
                    'cloudformation-execution-policies': { type: 'array', desc: 'The Managed Policy ARNs that should be attached to the role performing deployments into this environment (may be repeated, modern bootstrapping only)', default: [] },
                    'force': { alias: 'f', type: 'boolean', desc: 'Always bootstrap even if it would downgrade template version', default: false },
                    'termination-protection': { type: 'boolean', default: undefined, desc: 'Toggle CloudFormation termination protection on the bootstrap stacks' },
                    'show-template': { type: 'boolean', desc: 'Instead of actual bootstrapping, print the current CLI\'s bootstrapping template to stdout for customization', default: false },
                    'toolkit-stack-name': { type: 'string', desc: 'The name of the CDK toolkit stack to create', requiresArg: true },
                    'template': { type: 'string', requiresArg: true, desc: 'Use the template from the given file instead of the built-in one (use --show-template to obtain an example)' },
                    'previous-parameters': { type: 'boolean', default: true, desc: 'Use previous values for existing parameters (you must specify all parameters on every deployment if this is disabled)' },
                },
            },
            'gc': {
                description: 'Garbage collect assets. Options detailed here: https://github.com/aws/aws-cdk-cli/tree/main/packages/aws-cdk#cdk-gc',
                arg: {
                    name: 'ENVIRONMENTS',
                    variadic: true,
                },
                options: {
                    'action': { type: 'string', desc: 'The action (or sub-action) you want to perform. Valid entires are "print", "tag", "delete-tagged", "full".', default: 'full' },
                    'type': { type: 'string', desc: 'Specify either ecr, s3, or all', default: 'all' },
                    'rollback-buffer-days': { type: 'number', desc: 'Delete assets that have been marked as isolated for this many days', default: 0 },
                    'created-buffer-days': { type: 'number', desc: 'Never delete assets younger than this (in days)', default: 1 },
                    'confirm': { type: 'boolean', desc: 'Confirm via manual prompt before deletion', default: true },
                    'toolkit-stack-name': { type: 'string', desc: 'The name of the CDK toolkit stack, if different from the default "CDKToolkit"', requiresArg: true, conflicts: 'bootstrap-stack-name' },
                    'bootstrap-stack-name': { type: 'string', desc: 'The name of the CDK toolkit stack, if different from the default "CDKToolkit" (deprecated, use --toolkit-stack-name)', deprecated: 'use --toolkit-stack-name', requiresArg: true, conflicts: 'toolkit-stack-name' }, // TODO: remove when garbage collection is GA
                },
            },
            'flags': {
                description: 'View and toggle feature flags.',
                arg: {
                    name: 'FLAGNAME',
                    variadic: true,
                },
                options: {
                    value: { type: 'string', desc: 'The value the user would like to set the feature flag configuration to', requiresArg: true },
                    set: { type: 'boolean', desc: 'Signifies the user would like to modify their feature flag configuration', requiresArg: false },
                    all: { type: 'boolean', desc: 'Modify or view all feature flags', requiresArg: false },
                    unconfigured: { type: 'boolean', desc: 'Modify unconfigured feature flags', requiresArg: false },
                    recommended: { type: 'boolean', desc: 'Change flags to recommended states', requiresArg: false },
                    default: { type: 'boolean', desc: 'Change flags to default state', requiresArg: false },
                    interactive: { type: 'boolean', alias: ['i'], desc: 'Interactive option for the flags command' },
                    safe: { type: 'boolean', desc: 'Enable all feature flags that do not impact the user\'s application', requiresArg: false },
                    concurrency: { type: 'number', alias: ['n'], desc: 'Maximum number of simultaneous synths to execute.', default: 4, requiresArg: true },
                },
            },
            'deploy': {
                description: 'Deploys the stack(s) named STACKS into your AWS account',
                options: {
                    'all': { type: 'boolean', desc: 'Deploy all available stacks', default: false },
                    'build-exclude': { type: 'array', alias: 'E', desc: 'Do not rebuild asset with the given ID. Can be specified multiple times', default: [] },
                    'exclusively': { type: 'boolean', alias: 'e', desc: 'Only deploy requested stacks, don\'t include dependencies' },
                    'require-approval': { type: 'string', choices: [cloud_assembly_schema_1.RequireApproval.NEVER, cloud_assembly_schema_1.RequireApproval.ANYCHANGE, cloud_assembly_schema_1.RequireApproval.BROADENING], desc: 'What security-sensitive changes need manual approval' },
                    'notification-arns': { type: 'array', desc: 'ARNs of SNS topics that CloudFormation will notify with stack related events. These will be added to ARNs specified with the \'notificationArns\' stack property.' },
                    // @deprecated(v2) -- tags are part of the Cloud Assembly and tags specified here will be overwritten on the next deployment
                    'tags': { type: 'array', alias: 't', desc: 'Tags to add to the stack (KEY=VALUE), overrides tags from Cloud Assembly (deprecated)' },
                    'execute': { type: 'boolean', desc: 'Whether to execute ChangeSet (--no-execute will NOT execute the ChangeSet) (deprecated)', deprecated: true },
                    'change-set-name': { type: 'string', desc: 'Name of the CloudFormation change set to create (only if method is not direct)' },
                    'method': {
                        alias: 'm',
                        type: 'string',
                        choices: ['direct', 'change-set', 'prepare-change-set'],
                        requiresArg: true,
                        desc: 'How to perform the deployment. Direct is a bit faster but lacks progress information',
                    },
                    'import-existing-resources': { type: 'boolean', desc: 'Indicates if the stack set imports resources that already exist.', default: false },
                    'force': { alias: 'f', type: 'boolean', desc: 'Always deploy stack even if templates are identical', default: false },
                    'parameters': { type: 'array', desc: 'Additional parameters passed to CloudFormation at deploy time (STACK:KEY=VALUE)', default: {} },
                    'outputs-file': { type: 'string', alias: 'O', desc: 'Path to file where stack outputs will be written as JSON', requiresArg: true },
                    'previous-parameters': { type: 'boolean', default: true, desc: 'Use previous values for existing parameters (you must specify all parameters on every deployment if this is disabled)' },
                    'toolkit-stack-name': { type: 'string', desc: 'The name of the existing CDK toolkit stack (only used for app using legacy synthesis)', requiresArg: true },
                    'progress': { type: 'string', choices: [deploy_1.StackActivityProgress.BAR, deploy_1.StackActivityProgress.EVENTS], desc: 'Display mode for stack activity events' },
                    'rollback': {
                        type: 'boolean',
                        desc: "Rollback stack to stable state on failure. Defaults to 'true', iterate more rapidly with --no-rollback or -R. " +
                            'Note: do **not** disable this flag for deployments with resource replacements, as that will always fail',
                        negativeAlias: 'R',
                    },
                    'hotswap': {
                        type: 'boolean',
                        desc: "Attempts to perform a 'hotswap' deployment, " +
                            'but does not fall back to a full deployment if that is not possible. ' +
                            'Instead, changes to any non-hotswappable properties are ignored.' +
                            'Do not use this in production environments',
                    },
                    'hotswap-fallback': {
                        type: 'boolean',
                        desc: "Attempts to perform a 'hotswap' deployment, " +
                            'which skips CloudFormation and updates the resources directly, ' +
                            'and falls back to a full deployment if that is not possible. ' +
                            'Do not use this in production environments',
                    },
                    'hotswap-ecs-minimum-healthy-percent': {
                        type: 'string',
                        desc: 'Lower limit on the number of your service\'s tasks that must remain in the RUNNING state during a deployment, as a percentage of the desiredCount',
                    },
                    'hotswap-ecs-maximum-healthy-percent': {
                        type: 'string',
                        desc: 'Upper limit on the number of your service\'s tasks that are allowed in the RUNNING or PENDING state during a deployment, as a percentage of the desiredCount',
                    },
                    'hotswap-ecs-stabilization-timeout-seconds': {
                        type: 'string',
                        desc: 'Number of seconds to wait for a single service to reach stable state, where the desiredCount is equal to the runningCount',
                    },
                    'watch': {
                        type: 'boolean',
                        desc: 'Continuously observe the project files, ' +
                            'and deploy the given stack(s) automatically when changes are detected. ' +
                            'Implies --hotswap by default',
                    },
                    'logs': {
                        type: 'boolean',
                        default: true,
                        desc: 'Show CloudWatch log events from all resources in the selected Stacks in the terminal. ' +
                            "'true' by default, use --no-logs to turn off. " +
                            "Only in effect if specified alongside the '--watch' option",
                    },
                    'concurrency': { type: 'number', desc: 'Maximum number of simultaneous deployments (dependency permitting) to execute.', default: 1, requiresArg: true },
                    'asset-parallelism': { type: 'boolean', desc: 'Whether to build/publish assets in parallel' },
                    'asset-prebuild': { type: 'boolean', desc: 'Whether to build all assets before deploying the first stack (useful for failing Docker builds)', default: true },
                    'ignore-no-stacks': { type: 'boolean', desc: 'Whether to deploy if the app contains no stacks', default: false },
                },
                arg: {
                    name: 'STACKS',
                    variadic: true,
                },
            },
            'rollback': {
                description: 'Rolls back the stack(s) named STACKS to their last stable state',
                arg: {
                    name: 'STACKS',
                    variadic: true,
                },
                options: {
                    'all': { type: 'boolean', default: false, desc: 'Roll back all available stacks' },
                    'toolkit-stack-name': { type: 'string', desc: 'The name of the CDK toolkit stack the environment is bootstrapped with', requiresArg: true },
                    'force': {
                        alias: 'f',
                        type: 'boolean',
                        desc: 'Orphan all resources for which the rollback operation fails.',
                    },
                    'validate-bootstrap-version': {
                        type: 'boolean',
                        desc: 'Whether to validate the bootstrap stack version. Defaults to \'true\', disable with --no-validate-bootstrap-version.',
                    },
                    'orphan': {
                        // alias: 'o' conflicts with --output
                        type: 'array',
                        desc: 'Orphan the given resources, identified by their logical ID (can be specified multiple times)',
                        default: [],
                    },
                },
            },
            'import': {
                description: 'Import existing resource(s) into the given STACK',
                arg: {
                    name: 'STACK',
                    variadic: false,
                },
                options: {
                    'execute': { type: 'boolean', desc: 'Whether to execute ChangeSet (--no-execute will NOT execute the ChangeSet)', default: true },
                    'change-set-name': { type: 'string', desc: 'Name of the CloudFormation change set to create' },
                    'toolkit-stack-name': { type: 'string', desc: 'The name of the CDK toolkit stack to create', requiresArg: true },
                    'rollback': {
                        type: 'boolean',
                        desc: "Rollback stack to stable state on failure. Defaults to 'true', iterate more rapidly with --no-rollback or -R. " +
                            'Note: do **not** disable this flag for deployments with resource replacements, as that will always fail',
                    },
                    'force': {
                        alias: 'f',
                        type: 'boolean',
                        desc: 'Do not abort if the template diff includes updates or deletes. This is probably safe but we\'re not sure, let us know how it goes.',
                    },
                    'record-resource-mapping': {
                        type: 'string',
                        alias: 'r',
                        requiresArg: true,
                        desc: 'If specified, CDK will generate a mapping of existing physical resources to CDK resources to be imported as. The mapping ' +
                            'will be written in the given file path. No actual import operation will be performed',
                    },
                    'resource-mapping': {
                        type: 'string',
                        alias: 'm',
                        requiresArg: true,
                        desc: 'If specified, CDK will use the given file to map physical resources to CDK resources for import, instead of interactively ' +
                            'asking the user. Can be run from scripts',
                    },
                },
            },
            'watch': {
                description: "Shortcut for 'deploy --watch'",
                arg: {
                    name: 'STACKS',
                    variadic: true,
                },
                options: {
                    'build-exclude': { type: 'array', alias: 'E', desc: 'Do not rebuild asset with the given ID. Can be specified multiple times', default: [] },
                    'exclusively': { type: 'boolean', alias: 'e', desc: 'Only deploy requested stacks, don\'t include dependencies' },
                    'change-set-name': { type: 'string', desc: 'Name of the CloudFormation change set to create' },
                    'force': { alias: 'f', type: 'boolean', desc: 'Always deploy stack even if templates are identical', default: false },
                    'toolkit-stack-name': { type: 'string', desc: 'The name of the existing CDK toolkit stack (only used for app using legacy synthesis)', requiresArg: true },
                    'progress': { type: 'string', choices: [deploy_1.StackActivityProgress.BAR, deploy_1.StackActivityProgress.EVENTS], desc: 'Display mode for stack activity events' },
                    'rollback': {
                        type: 'boolean',
                        desc: "Rollback stack to stable state on failure. Defaults to 'true', iterate more rapidly with --no-rollback or -R. " +
                            'Note: do **not** disable this flag for deployments with resource replacements, as that will always fail',
                        negativeAlias: 'R',
                    },
                    'hotswap': {
                        type: 'boolean',
                        desc: "Attempts to perform a 'hotswap' deployment, " +
                            'but does not fall back to a full deployment if that is not possible. ' +
                            'Instead, changes to any non-hotswappable properties are ignored.' +
                            "'true' by default, use --no-hotswap to turn off",
                    },
                    'hotswap-fallback': {
                        type: 'boolean',
                        desc: "Attempts to perform a 'hotswap' deployment, " +
                            'which skips CloudFormation and updates the resources directly, ' +
                            'and falls back to a full deployment if that is not possible.',
                    },
                    'hotswap-ecs-minimum-healthy-percent': {
                        type: 'string',
                        desc: 'Lower limit on the number of your service\'s tasks that must remain in the RUNNING state during a deployment, as a percentage of the desiredCount',
                    },
                    'hotswap-ecs-maximum-healthy-percent': {
                        type: 'string',
                        desc: 'Upper limit on the number of your service\'s tasks that are allowed in the RUNNING or PENDING state during a deployment, as a percentage of the desiredCount',
                    },
                    'hotswap-ecs-stabilization-timeout-seconds': {
                        type: 'string',
                        desc: 'Number of seconds to wait for a single service to reach stable state, where the desiredCount is equal to the runningCount',
                    },
                    'logs': {
                        type: 'boolean',
                        default: true,
                        desc: 'Show CloudWatch log events from all resources in the selected Stacks in the terminal. ' +
                            "'true' by default, use --no-logs to turn off",
                    },
                    'concurrency': { type: 'number', desc: 'Maximum number of simultaneous deployments (dependency permitting) to execute.', default: 1, requiresArg: true },
                },
            },
            'destroy': {
                description: 'Destroy the stack(s) named STACKS',
                arg: {
                    name: 'STACKS',
                    variadic: true,
                },
                options: {
                    all: { type: 'boolean', default: false, desc: 'Destroy all available stacks' },
                    exclusively: { type: 'boolean', alias: 'e', desc: 'Only destroy requested stacks, don\'t include dependees' },
                    force: { type: 'boolean', alias: 'f', desc: 'Do not ask for confirmation before destroying the stacks' },
                },
            },
            'diff': {
                description: 'Compares the specified stack with the deployed stack or a local template file, and returns with status 1 if any difference is found',
                arg: {
                    name: 'STACKS',
                    variadic: true,
                },
                options: {
                    'exclusively': { type: 'boolean', alias: 'e', desc: 'Only diff requested stacks, don\'t include dependencies' },
                    'context-lines': { type: 'number', desc: 'Number of context lines to include in arbitrary JSON diff rendering', default: 3, requiresArg: true },
                    'template': { type: 'string', desc: 'The path to the CloudFormation template to compare with', requiresArg: true },
                    'strict': { type: 'boolean', desc: 'Do not filter out AWS::CDK::Metadata resources, mangled non-ASCII characters, or the CheckBootstrapVersionRule', default: false },
                    'security-only': { type: 'boolean', desc: 'Only diff for broadened security changes', default: false },
                    'fail': { type: 'boolean', desc: 'Fail with exit code 1 in case of diff' },
                    'processed': { type: 'boolean', desc: 'Whether to compare against the template with Transforms already processed', default: false },
                    'quiet': { type: 'boolean', alias: 'q', desc: 'Do not print stack name and default message when there is no diff to stdout', default: false },
                    'change-set': { type: 'boolean', alias: 'changeset', desc: 'Whether to create a changeset to analyze resource replacements. In this mode, diff will use the deploy role instead of the lookup role.', default: true },
                    'import-existing-resources': { type: 'boolean', desc: 'Whether or not the change set imports resources that already exist', default: false },
                    'include-moves': { type: 'boolean', desc: 'Whether to include moves in the diff', default: false },
                },
            },
            'drift': {
                description: 'Detect drifts in the given CloudFormation stack(s)',
                arg: {
                    name: 'STACKS',
                    variadic: true,
                },
                options: {
                    fail: { type: 'boolean', desc: 'Fail with exit code 1 if drift is detected' },
                },
            },
            'metadata': {
                description: 'Returns all metadata associated with this stack',
                arg: {
                    name: 'STACK',
                    variadic: false,
                },
            },
            'acknowledge': {
                aliases: ['ack'],
                description: 'Acknowledge a notice so that it does not show up anymore',
                arg: {
                    name: 'ID',
                    variadic: false,
                },
            },
            'notices': {
                description: 'Returns a list of relevant notices',
                options: {
                    unacknowledged: { type: 'boolean', alias: 'u', default: false, desc: 'Returns a list of unacknowledged notices' },
                },
            },
            'init': {
                description: 'Create a new, empty CDK project from a template.',
                arg: {
                    name: 'TEMPLATE',
                    variadic: false,
                },
                options: {
                    'language': { type: 'string', alias: 'l', desc: 'The language to be used for the new project (default can be configured in ~/.cdk.json)', choices: await (0, init_1.availableInitLanguages)() },
                    'list': { type: 'boolean', desc: 'List the available templates' },
                    'generate-only': { type: 'boolean', default: false, desc: 'If true, only generates project files, without executing additional operations such as setting up a git repo, installing dependencies or compiling the project' },
                    'lib-version': { type: 'string', alias: 'V', default: undefined, desc: 'The version of the CDK library (aws-cdk-lib) to initialize built-in templates with. Defaults to the version that was current when this CLI was built.' },
                    'from-path': { type: 'string', desc: 'Path to a local custom template directory or multi-template repository', requiresArg: true, conflicts: ['lib-version'] },
                    'template-path': { type: 'string', desc: 'Path to a specific template within a multi-template repository', requiresArg: true },
                    'package-manager': { type: 'string', desc: 'The package manager to use to install dependencies. Only applicable for TypeScript and JavaScript projects. Defaults to npm in TypeScript and JavaScript projects.', choices: package_manager_1.JS_PACKAGE_MANAGERS.map(({ name }) => name) },
                },
                implies: { 'template-path': 'from-path' },
            },
            'migrate': {
                description: 'Migrate existing AWS resources into a CDK app',
                options: {
                    'stack-name': { type: 'string', alias: 'n', desc: 'The name assigned to the stack created in the new project. The name of the app will be based off this name as well.', requiresArg: true },
                    'language': {
                        type: 'string',
                        default: 'typescript',
                        alias: 'l',
                        desc: 'The language to be used for the new project',
                        choices: [...new Set(cdk_from_cfn.supported_languages().flatMap((lang) => [lang, (0, language_1.getLanguageAlias)(lang)]))],
                    },
                    'account': { type: 'string', desc: 'The account to retrieve the CloudFormation stack template from' },
                    'region': { type: 'string', desc: 'The region to retrieve the CloudFormation stack template from' },
                    'from-path': { type: 'string', desc: 'The path to the CloudFormation template to migrate. Use this for locally stored templates' },
                    'from-stack': { type: 'boolean', desc: 'Use this flag to retrieve the template for an existing CloudFormation stack' },
                    'output-path': { type: 'string', desc: 'The output path for the migrated CDK app' },
                    'from-scan': {
                        type: 'string',
                        desc: 'Determines if a new scan should be created, or the last successful existing scan should be used ' +
                            '\n options are "new" or "most-recent"',
                    },
                    'filter': {
                        type: 'array',
                        desc: 'Filters the resource scan based on the provided criteria in the following format: "key1=value1,key2=value2"' +
                            '\n This field can be passed multiple times for OR style filtering: ' +
                            '\n filtering options: ' +
                            '\n resource-identifier: A key-value pair that identifies the target resource. i.e. {"ClusterName", "myCluster"}' +
                            '\n resource-type-prefix: A string that represents a type-name prefix. i.e. "AWS::DynamoDB::"' +
                            '\n tag-key: a string that matches resources with at least one tag with the provided key. i.e. "myTagKey"' +
                            '\n tag-value: a string that matches resources with at least one tag with the provided value. i.e. "myTagValue"',
                    },
                    'compress': { type: 'boolean', desc: 'Use this flag to zip the generated CDK app' },
                },
            },
            'context': {
                description: 'Manage cached context values',
                options: {
                    reset: { alias: 'e', desc: 'The context key (or its index) to reset', type: 'string', requiresArg: true, default: undefined },
                    force: { alias: 'f', desc: 'Ignore missing key error', type: 'boolean', default: false },
                    clear: { desc: 'Clear all context', type: 'boolean', default: false },
                },
            },
            'docs': {
                aliases: ['doc'],
                description: 'Opens the reference documentation in a browser',
                options: {
                    browser: {
                        alias: 'b',
                        desc: 'the command to use to open the browser, using %u as a placeholder for the path of the file to open',
                        type: 'string',
                        default: exports.YARGS_HELPERS.browserForPlatform(),
                    },
                },
            },
            'doctor': {
                description: 'Check your set-up for potential problems',
            },
            'refactor': {
                description: 'Moves resources between stacks or within the same stack',
                options: {
                    'additional-stack-name': {
                        type: 'array',
                        requiresArg: true,
                        desc: 'Names of deployed stacks to be considered for resource comparison.',
                    },
                    'dry-run': {
                        type: 'boolean',
                        desc: 'Do not perform any changes, just show what would be done',
                        default: false,
                    },
                    'override-file': {
                        type: 'string',
                        requiresArg: true,
                        desc: 'A file that declares overrides to be applied to the list of mappings computed by the CLI.',
                    },
                    'revert': {
                        type: 'boolean',
                        default: false,
                        desc: 'If specified, the command will revert the refactor operation. This is only valid if a mapping file was provided.',
                    },
                    'force': {
                        type: 'boolean',
                        default: false,
                        desc: 'Whether to do the refactor without asking for confirmation',
                    },
                },
                arg: {
                    name: 'STACKS',
                    variadic: true,
                },
            },
            'cli-telemetry': {
                description: 'Enable or disable anonymous telemetry',
                options: {
                    enable: {
                        type: 'boolean',
                        desc: 'Enable anonymous telemetry',
                        conflicts: 'disable',
                    },
                    disable: {
                        type: 'boolean',
                        desc: 'Disable anonymous telemetry',
                        conflicts: 'enable',
                    },
                    status: {
                        type: 'boolean',
                        desc: 'Report telemetry opt-in/out status',
                        conflicts: ['enable', 'disable'],
                    },
                },
            },
        },
    };
}
//# sourceMappingURL=data:application/json;base64,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