"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkForPlatformWarnings = checkForPlatformWarnings;
exports.isVersionBetween = isVersionBetween;
const os = require("os");
const fs = require("fs-extra");
async function checkForPlatformWarnings(ioHelper) {
    if (await hasDockerCopyBug()) {
        await ioHelper.defaults.warn('`cdk synth` may hang in Docker on Linux 5.6-5.10. See https://github.com/aws/aws-cdk/issues/21379 for workarounds.');
    }
}
async function hasDockerCopyBug() {
    return await runningInDocker() && os.platform() === 'linux' && isVersionBetween(os.release(), '5.6', '5.10');
}
async function runningInDocker() {
    return fs.pathExists('/.dockerenv');
}
function isVersionBetween(version, lower, upper) {
    const ver = splitVersion(version);
    const lo = splitVersion(lower);
    const up = splitVersion(upper);
    while (lo.length < ver.length) {
        lo.push(0);
    }
    while (up.length < ver.length) {
        up.push(9999999);
    }
    let n = ver.length;
    for (let i = 0; i < n; i++) {
        if (lo[i] < ver[i] && ver[i] < up[i]) {
            return true;
        }
        if (lo[i] > ver[i] || ver[i] > up[i]) {
            return false;
        }
    }
    return false;
}
function splitVersion(version) {
    return `${version}`.split('.')
        .map(x => parseInt(x, 10))
        .map(x => isNaN(x) ? 0 : x);
}
//# sourceMappingURL=data:application/json;base64,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