import type { Duration } from '@aws-cdk/toolkit-lib';
import type { ErrorDetails } from './schema';
import * as make from '../../api-private';
export interface EventResult extends Duration {
    error?: ErrorDetails;
}
export interface EventStart {
}
/**
 * Private message types specific to the CLI
 */
export declare const CLI_PRIVATE_IO: {
    CDK_CLI_I1000: make.IoMessageMaker<EventStart>;
    CDK_CLI_I1001: make.IoMessageMaker<EventResult>;
    CDK_CLI_I2000: make.IoMessageMaker<EventStart>;
    CDK_CLI_I2001: make.IoMessageMaker<EventResult>;
    CDK_CLI_I3000: make.IoMessageMaker<EventStart>;
    CDK_CLI_I3001: make.IoMessageMaker<EventResult>;
};
/**
 * Payload type of the end message must extend Duration
 */
export declare const CLI_PRIVATE_SPAN: {
    SYNTH_ASSEMBLY: {
        name: string;
        start: make.IoMessageMaker<EventStart>;
        end: make.IoMessageMaker<EventResult>;
    };
    COMMAND: {
        name: string;
        start: make.IoMessageMaker<EventStart>;
        end: make.IoMessageMaker<EventResult>;
    };
    DEPLOY: {
        name: string;
        start: make.IoMessageMaker<EventStart>;
        end: make.IoMessageMaker<EventResult>;
    };
};
export declare const CLI_TELEMETRY_CODES: make.IoMessageMaker<EventResult>[];
