"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SdkProvider = void 0;
exports.cached = cached;
exports.enableTracing = enableTracing;
const aws_auth_1 = require("../api/aws-auth");
const io_host_1 = require("../cli/io-host");
const singleton_plugin_host_1 = require("../cli/singleton-plugin-host");
/**
 * @deprecated
 */
function cached(obj, sym, fn) {
    if (!(sym in obj)) {
        obj[sym] = fn();
    }
    return obj[sym];
}
/**
 * Enable tracing in the CDK
 *
 * @deprecated cannot be enabled from outside the CDK
 */
function enableTracing(_enabled) {
    // noop
}
/**
 * @deprecated
 */
class SdkProvider {
    static async withAwsCliCompatibleDefaults(options = {}) {
        return aws_auth_1.SdkProvider.withAwsCliCompatibleDefaults({
            ...options,
            ioHelper: io_host_1.CliIoHost.instance().asIoHelper(),
            pluginHost: singleton_plugin_host_1.GLOBAL_PLUGIN_HOST,
        }, options.profile);
    }
    constructor(defaultCredentialProvider, defaultRegion, requestHandler = {}, logger) {
        return new aws_auth_1.SdkProvider(defaultCredentialProvider, defaultRegion, {
            pluginHost: singleton_plugin_host_1.GLOBAL_PLUGIN_HOST,
            ioHelper: io_host_1.CliIoHost.instance().asIoHelper(),
            requestHandler: requestHandler, // this is fine it's passed through to the SDK
            logger,
        });
    }
}
exports.SdkProvider = SdkProvider;
//# sourceMappingURL=data:application/json;base64,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