# Look for jthread, use our own if not found

FIND_PACKAGE(PkgConfig)
pkg_check_modules(PC_JTHREAD QUIET jthread)

FIND_PATH(JTHREAD_INCLUDE_DIR jthread.h
	HINTS ${PC_JTHREAD_INCLUDEDIR} ${PC_JTHREAD_INCLUDE_DIRS})

FIND_LIBRARY(JTHREAD_LIBRARY NAMES jthread)

IF(JTHREAD_LIBRARY AND JTHREAD_INCLUDE_DIR)
	SET( JTHREAD_FOUND TRUE )
ENDIF(JTHREAD_LIBRARY AND JTHREAD_INCLUDE_DIR)

IF(JTHREAD_FOUND)
	MESSAGE(STATUS "Found system jthread header file in ${JTHREAD_INCLUDE_DIR}")
	MESSAGE(STATUS "Found system jthread library ${JTHREAD_LIBRARY}")
ELSE(JTHREAD_FOUND)
	SET(JTHREAD_INCLUDE_DIR "${PROJECT_SOURCE_DIR}/jthread")
	SET(JTHREAD_LIBRARY jthread)
	MESSAGE(STATUS "Using project jthread library")
ENDIF(JTHREAD_FOUND)
