/************************************************************************
* Minetest-c55
* Copyright (C) 2010-2011 celeron55, Perttu Ahola <celeron55@gmail.com>
*
* content_burntimes.h
* voxelands - 3d voxel world sandbox game
* Copyright (C) Lisa 'darkrose' Milne 2014 <lisa@ltmnet.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
* See the GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
*
* License updated from GPLv2 or later to GPLv3 or later by Lisa Milne
* for Voxelands.
************************************************************************/

#define BT_DEFAULT 1.0
/* Burning Time DEFAULT */
/* 1.0 == one item cooked */

#define BT_BED 8.0
/* Beds' heads and feet */

#define BT_BOOKSHELF 5.0
/* Book shelves */

#define BT_BUSH 0.1  /* 10 for an item */
/* Fern, jungle grass, etc. */

#define BT_CAMP_BED 0.5 /* 2 hay */
/* Camp bed's head and foot */

#define BT_CAMP_FIRE 1.0   /* 1 item */
/* Camp fire */

#define BT_CARPET 0.1 /* 1/16th of a cotton */
/* Carpets */

#define BT_CACTUS 0.5   /* 10 for an item */
/* Cactus' trunk */

#define BT_CHAIR 2.5   /* 1/4th of a wood */
/* Wooden chairs */

#define BT_CLOCK 0.5 /* something less than half a wood */
/* Wall clock */

#define BT_COAL 10.0 /* 10 items */
/* Coal and charcoal lumps */

#define BT_COAL_BLOCK 99.0 /* 1 stack */
/* Coal and charcoal blocks */

#define BT_COLUMN 1.5   /* about 1 wood */
/* Wooden columns */

#define BT_COUCH 0.75   /* 3 cotton */
/* Couches and armchairs */

#define BT_COTTON 0.25  /* 4 for an item */
/* Cotton */

#define BT_DOOR 1.25  /* 2 hatches */
/* Wooden right and left doors, windowed or not */

#define BT_DOOR_GLASS 1.50 /* somehow better than wooden door */
/* Glass right and left doors */

#define BT_FENCE 1.5 /* about 1/3rd of a wood */
/* Fences, gates, etc. */

#define BT_FLOWER 0.1   /* 1/4th of a carpet*/
/* Blossoms, flowers, etc. */

#define BT_FRUIT 0.1   /* slightly worse than a cactus */
/* Apples, cactus fruit, etc. */

#define BT_GRASS 0.1   /* 1/4th of a carpet*/
/* Wild grass, flower stem, etc.*/

#define BT_HATCH 2.0 /* 1/16th of a wood */
/* Hatches, windowed or not */

#define BT_HAY 0.25  /* 4 for an item */
/* Hay */

#define BT_LADDER 1.0   /* 1/4th of a hatch */
/* Wooden ladders */

#define BT_LAVA 99.0 /* 1 stack */
/* Lava and lava source */

#define BT_LAVA_BUCKET 99.0   /* 1 stack */
/* Lava bucket*/

#define BT_LEAF 0.1   /* 1/4th of a carpet*/
/* Tree leaves */

#define BT_PAINTING 0.625  /* 1/16th of a wood */
/* Paintings and painting canvas */

#define BT_PLANK 0.1 /* 10 for an item */
/* Planks */

#define BT_SAPLING 0.1  /* 20 for an item */
/* Tree saplings */

#define BT_SCAFFOLDING 1.5 /* 1/3rd of a wood */
/* Scaffoldings */

#define BT_SEED 0.1   /* 1/4th of a stick */
/* Vegetable's seeds */

#define BT_SIGN 0.625   /* 1/16th of a wood */
/* Wooden signs, lockable or not */

#define BT_SLAB 1.0  /* half a wood */
/* Wooden slabs */

#define BT_SPONGE 0.2   /* 5 for an item */
/* Sponges */

#define BT_STAIR 2.0 /* half a wood */
/* Wooden stairs */

#define BT_STICK 0.1 /* half a plank or 20 for an item */
/* Sticks */

#define BT_TABLE 2.5   /* 1/4th of a wood */
/* Tables */

#define BT_TILE 0.5   /* 1/16th of a wood */
/* Wood tile */

#define BT_TORCH 0.1 /* 1/4th of a stick */
/* Torches */

#define BT_TREE 10.0 /* one stack */
/* Tree trunks */

#define BT_TRELLIS 0.5   /* 1/16th of a wood */
/* Trellises */

#define BT_WOOD 2.0 /* 2 items */
/* Wood, jungle wood, etc. */

#define BT_YOUNG_TREE 1.0   /* 1/9th of a wood */
/* Young tree trunks */
