/************************************************************************
* content_clothesitem.cpp
* voxelands - 3d voxel world sandbox game
* Copyright (C) Lisa Milne 2014 <lisa@ltmnet.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
* See the GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
************************************************************************/

#include "content_clothesitem.h"
#include "content_craftitem.h"
#include "content_craft.h"
#include "content_list.h"
#include "content_mapnode.h"
#include "intl.h"

struct ClothesItemFeatures g_content_clothesitem_features[4096];

ClothesItemFeatures *content_clothesitem_features(content_t i)
{
	uint32_t j;
	if ((i&CONTENT_CLOTHESITEM_MASK) != CONTENT_CLOTHESITEM_MASK)
		return &g_content_clothesitem_features[0];

	j = (i&~CONTENT_CLOTHESITEM_MASK);
	if (j > 4095)
		return &g_content_clothesitem_features[0];

	return &g_content_clothesitem_features[j];
}

void content_clothesitem_init()
{
	content_t i;
	ClothesItemFeatures *f = NULL;
	int k;

	for (k=0; k<4096; k++) {
		g_content_clothesitem_features[k].content = CONTENT_IGNORE;
		g_content_clothesitem_features[k].texture = std::string("unknown_item.png");
		g_content_clothesitem_features[k].overlay_texture = std::string("");
		g_content_clothesitem_features[k].description = (char*)"";
		g_content_clothesitem_features[k].type = CT_NONE;
		g_content_clothesitem_features[k].armour = 0.;
		g_content_clothesitem_features[k].warmth = 0.;
		g_content_clothesitem_features[k].vacuum = 0.;
		g_content_clothesitem_features[k].suffocate = 0.;
		g_content_clothesitem_features[k].durability = 5;
		g_content_clothesitem_features[k].effect = 1.;
	}

	i = CONTENT_CLOTHESITEM_SPACESUIT_PANTS;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->texture = "clothes_pants_space.png";
	f->overlay_texture = "clothes_player_pants_space.png";
	f->description = gettext("Space Suit Pants");
	f->type = CT_PANTS;
	f->armour = 0.10;
	f->warmth = 0.20;
	f->vacuum = 1.0;
	f->durability = 20;
	{
		u16 r[9] = {
			CONTENT_CRAFTITEM_CANVAS_SHEET,	CONTENT_CRAFTITEM_CANVAS_SHEET,	CONTENT_CRAFTITEM_CANVAS_SHEET,
			CONTENT_CRAFTITEM_IRON_INGOT,	CONTENT_IGNORE,			CONTENT_CRAFTITEM_IRON_INGOT,
			CONTENT_CRAFTITEM_CANVAS_SHEET,	CONTENT_IGNORE,			CONTENT_CRAFTITEM_CANVAS_SHEET
		};
		crafting::setRecipe(r,i,1);
	}
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_SPACESUIT_SHIRT;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->texture = "clothes_shirt_space.png";
	f->overlay_texture = "clothes_player_shirt_space.png";
	f->description = gettext("Space Suit Shirt");
	f->type = CT_JACKET;
	f->armour = 0.10;
	f->warmth = 0.20;
	f->vacuum = 1.0;
	f->durability = 20;
	{
		u16 r[9] = {
			CONTENT_CRAFTITEM_CANVAS_SHEET,	CONTENT_CRAFTITEM_CANVAS_SHEET,	CONTENT_CRAFTITEM_CANVAS_SHEET,
			CONTENT_CRAFTITEM_IRON_INGOT,	CONTENT_CRAFTITEM_CANVAS_SHEET,	CONTENT_CRAFTITEM_IRON_INGOT,
			CONTENT_IGNORE,			CONTENT_CRAFTITEM_CANVAS_SHEET,	CONTENT_IGNORE
		};
		crafting::setRecipe(r,i,1);
	}
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_SPACESUIT_HELMET;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->texture = "clothes_helmet_space.png";
	f->overlay_texture = "clothes_player_helmet_space.png";
	f->description = gettext("Space Suit Helmet");
	f->type = CT_HAT;
	f->armour = 0.05;
	f->warmth = 0.15;
	f->vacuum = 1.0;
	f->suffocate = 1.0;
	f->durability = 20;
	crafting::setHelmetRecipe(CONTENT_CRAFTITEM_CANVAS_SHEET,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_SPACESUIT_BOOTS;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->texture = "clothes_boots_space.png";
	f->overlay_texture = "clothes_player_boots_space.png";
	f->description = gettext("Space Suit Boots");
	f->type = CT_BOOTS;
	f->armour = 0.05;
	f->warmth = 0.20;
	f->vacuum = 1.0;
	f->durability = 20;
	crafting::setBootsRecipe(CONTENT_CRAFTITEM_CANVAS_SHEET,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	// cotton t-shirts
	i = CONTENT_CLOTHESITEM_COTTON_TSHIRT;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_SHIRT;
	f->texture = "clothes_tshirt_cotton_white.png";
	f->overlay_texture = "clothes_player_tshirt_cotton_white.png";
	f->description = gettext("Cotton T-Shirt");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	crafting::setTShirtRecipe(CONTENT_CRAFTITEM_COTTON_SHEET,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_TSHIRT_BLUE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_SHIRT;
	f->texture = "clothes_tshirt_cotton_blue.png";
	f->overlay_texture = "clothes_player_tshirt_cotton_blue.png";
	f->description = gettext("Blue Cotton T-Shirt");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	crafting::setTShirtRecipe(CONTENT_CRAFTITEM_COTTON_SHEET_BLUE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_TSHIRT_GREEN;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_SHIRT;
	f->texture = "clothes_tshirt_cotton_green.png";
	f->overlay_texture = "clothes_player_tshirt_cotton_green.png";
	f->description = gettext("Green Cotton T-Shirt");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	crafting::setTShirtRecipe(CONTENT_CRAFTITEM_COTTON_SHEET_GREEN,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_TSHIRT_ORANGE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_SHIRT;
	f->texture = "clothes_tshirt_cotton_orange.png";
	f->overlay_texture = "clothes_player_tshirt_cotton_orange.png";
	f->description = gettext("Orange Cotton Tshirt");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	crafting::setTShirtRecipe(CONTENT_CRAFTITEM_COTTON_SHEET_ORANGE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_TSHIRT_PURPLE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_SHIRT;
	f->texture = "clothes_tshirt_cotton_purple.png";
	f->overlay_texture = "clothes_player_tshirt_cotton_purple.png";
	f->description = gettext("Purple Cotton T-Shirt");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	crafting::setTShirtRecipe(CONTENT_CRAFTITEM_COTTON_SHEET_PURPLE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_TSHIRT_RED;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_SHIRT;
	f->texture = "clothes_tshirt_cotton_red.png";
	f->overlay_texture = "clothes_player_tshirt_cotton_red.png";
	f->description = gettext("Red Cotton T-Shirt");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	crafting::setTShirtRecipe(CONTENT_CRAFTITEM_COTTON_SHEET_RED,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_TSHIRT_YELLOW;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_SHIRT;
	f->texture = "clothes_tshirt_cotton_yellow.png";
	f->overlay_texture = "clothes_player_tshirt_cotton_yellow.png";
	f->description = gettext("Yellow Cotton T-Shirt");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	crafting::setTShirtRecipe(CONTENT_CRAFTITEM_COTTON_SHEET_YELLOW,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_TSHIRT_BLACK;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_SHIRT;
	f->texture = "clothes_tshirt_cotton_black.png";
	f->overlay_texture = "clothes_player_tshirt_cotton_black.png";
	f->description = gettext("Black Cotton T-Shirt");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	crafting::setTShirtRecipe(CONTENT_CRAFTITEM_COTTON_SHEET_BLACK,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	// cotton shirts
	i = CONTENT_CLOTHESITEM_COTTON_SHIRT;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_SHIRT;
	f->texture = "clothes_shirt_cotton_white.png";
	f->overlay_texture = "clothes_player_shirt_cotton_white.png";
	f->description = gettext("Cotton Shirt");
	f->armour = 0.0;
	f->warmth = 0.05;
	f->vacuum = 0.0;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_COTTON_SHEET,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_SHIRT_BLUE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_SHIRT;
	f->texture = "clothes_shirt_cotton_blue.png";
	f->overlay_texture = "clothes_player_shirt_cotton_blue.png";
	f->description = gettext("Blue Cotton Shirt");
	f->armour = 0.0;
	f->warmth = 0.05;
	f->vacuum = 0.0;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_COTTON_SHEET_BLUE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_SHIRT_GREEN;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_SHIRT;
	f->texture = "clothes_shirt_cotton_green.png";
	f->overlay_texture = "clothes_player_shirt_cotton_green.png";
	f->description = gettext("Green Cotton Shirt");
	f->armour = 0.0;
	f->warmth = 0.05;
	f->vacuum = 0.0;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_COTTON_SHEET_GREEN,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_SHIRT_ORANGE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_SHIRT;
	f->texture = "clothes_shirt_cotton_orange.png";
	f->overlay_texture = "clothes_player_shirt_cotton_orange.png";
	f->description = gettext("Orange Cotton Shirt");
	f->armour = 0.0;
	f->warmth = 0.05;
	f->vacuum = 0.0;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_COTTON_SHEET_ORANGE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_SHIRT_PURPLE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_SHIRT;
	f->texture = "clothes_shirt_cotton_purple.png";
	f->overlay_texture = "clothes_player_shirt_cotton_purple.png";
	f->description = gettext("Purple Cotton Shirt");
	f->armour = 0.0;
	f->warmth = 0.05;
	f->vacuum = 0.0;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_COTTON_SHEET_PURPLE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_SHIRT_RED;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_SHIRT;
	f->texture = "clothes_shirt_cotton_red.png";
	f->overlay_texture = "clothes_player_shirt_cotton_red.png";
	f->description = gettext("Red Cotton Shirt");
	f->armour = 0.0;
	f->warmth = 0.05;
	f->vacuum = 0.0;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_COTTON_SHEET_RED,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_SHIRT_YELLOW;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_SHIRT;
	f->texture = "clothes_shirt_cotton_yellow.png";
	f->overlay_texture = "clothes_player_shirt_cotton_yellow.png";
	f->description = gettext("Yellow Cotton Shirt");
	f->armour = 0.0;
	f->warmth = 0.05;
	f->vacuum = 0.0;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_COTTON_SHEET_YELLOW,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_SHIRT_BLACK;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_SHIRT;
	f->texture = "clothes_shirt_cotton_black.png";
	f->overlay_texture = "clothes_player_shirt_cotton_black.png";
	f->description = gettext("Black Cotton Shirt");
	f->armour = 0.0;
	f->warmth = 0.05;
	f->vacuum = 0.0;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_COTTON_SHEET_BLACK,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	// cotton shorts
	i = CONTENT_CLOTHESITEM_COTTON_SHORTS;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_shorts_cotton_white.png";
	f->overlay_texture = "clothes_player_shorts_cotton_white.png";
	f->description = gettext("Cotton Shorts");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	f->durability = 4;
	crafting::setShortsRecipe(CONTENT_CRAFTITEM_COTTON_SHEET,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_SHORTS_BLUE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_shorts_cotton_blue.png";
	f->overlay_texture = "clothes_player_shorts_cotton_blue.png";
	f->description = gettext("Blue Cotton Shorts");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	f->durability = 4;
	crafting::setShortsRecipe(CONTENT_CRAFTITEM_COTTON_SHEET_BLUE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_SHORTS_GREEN;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_shorts_cotton_green.png";
	f->overlay_texture = "clothes_player_shorts_cotton_green.png";
	f->description = gettext("Green Cotton Shorts");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	f->durability = 4;
	crafting::setShortsRecipe(CONTENT_CRAFTITEM_COTTON_SHEET_GREEN,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_SHORTS_ORANGE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_shorts_cotton_orange.png";
	f->overlay_texture = "clothes_player_shorts_cotton_orange.png";
	f->description = gettext("Orange Cotton Shorts");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	f->durability = 4;
	crafting::setShortsRecipe(CONTENT_CRAFTITEM_COTTON_SHEET_ORANGE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_SHORTS_PURPLE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_shorts_cotton_purple.png";
	f->overlay_texture = "clothes_player_shorts_cotton_purple.png";
	f->description = gettext("Purple Cotton Shorts");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	f->durability = 4;
	crafting::setShortsRecipe(CONTENT_CRAFTITEM_COTTON_SHEET_PURPLE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_SHORTS_RED;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_shorts_cotton_red.png";
	f->overlay_texture = "clothes_player_shorts_cotton_red.png";
	f->description = gettext("Red Cotton Shorts");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	f->durability = 4;
	crafting::setShortsRecipe(CONTENT_CRAFTITEM_COTTON_SHEET_RED,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_SHORTS_YELLOW;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_shorts_cotton_yellow.png";
	f->overlay_texture = "clothes_player_shorts_cotton_yellow.png";
	f->description = gettext("Yellow Cotton Shorts");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	f->durability = 4;
	crafting::setShortsRecipe(CONTENT_CRAFTITEM_COTTON_SHEET_YELLOW,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_SHORTS_BLACK;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_shorts_cotton_black.png";
	f->overlay_texture = "clothes_player_shorts_cotton_black.png";
	f->description = gettext("Black Cotton Shorts");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	f->durability = 4;
	crafting::setShortsRecipe(CONTENT_CRAFTITEM_COTTON_SHEET_BLACK,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	// cotton hats
	i = CONTENT_CLOTHESITEM_COTTON_HAT;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_hat_cotton_white.png";
	f->overlay_texture = "clothes_player_hat_cotton_white.png";
	f->description = gettext("Cotton Hat");
	f->armour = 0.0;
	f->warmth = 0.05;
	f->vacuum = 0.0;
	crafting::setHatRecipe(CONTENT_CRAFTITEM_COTTON_SHEET,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_HAT_BLUE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_hat_cotton_blue.png";
	f->overlay_texture = "clothes_player_hat_cotton_blue.png";
	f->description = gettext("Blue Cotton Hat");
	f->armour = 0.0;
	f->warmth = 0.05;
	f->vacuum = 0.0;
	crafting::setHatRecipe(CONTENT_CRAFTITEM_COTTON_SHEET_BLUE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_HAT_GREEN;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_hat_cotton_green.png";
	f->overlay_texture = "clothes_player_hat_cotton_green.png";
	f->description = gettext("Green Cotton Hat");
	f->armour = 0.0;
	f->warmth = 0.05;
	f->vacuum = 0.0;
	crafting::setHatRecipe(CONTENT_CRAFTITEM_COTTON_SHEET_GREEN,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_HAT_ORANGE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_hat_cotton_orange.png";
	f->overlay_texture = "clothes_player_hat_cotton_orange.png";
	f->description = gettext("Orange Cotton Hat");
	f->armour = 0.0;
	f->warmth = 0.05;
	f->vacuum = 0.0;
	crafting::setHatRecipe(CONTENT_CRAFTITEM_COTTON_SHEET_ORANGE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_HAT_PURPLE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_hat_cotton_purple.png";
	f->overlay_texture = "clothes_player_hat_cotton_purple.png";
	f->description = gettext("Purple Cotton Hat");
	f->armour = 0.0;
	f->warmth = 0.05;
	f->vacuum = 0.0;
	crafting::setHatRecipe(CONTENT_CRAFTITEM_COTTON_SHEET_PURPLE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_HAT_RED;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_hat_cotton_red.png";
	f->overlay_texture = "clothes_player_hat_cotton_red.png";
	f->description = gettext("Red Cotton Hat");
	f->armour = 0.0;
	f->warmth = 0.05;
	f->vacuum = 0.0;
	crafting::setHatRecipe(CONTENT_CRAFTITEM_COTTON_SHEET_RED,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_HAT_YELLOW;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_hat_cotton_yellow.png";
	f->overlay_texture = "clothes_player_hat_cotton_yellow.png";
	f->description = gettext("Yellow Cotton Hat");
	f->armour = 0.0;
	f->warmth = 0.05;
	f->vacuum = 0.0;
	crafting::setHatRecipe(CONTENT_CRAFTITEM_COTTON_SHEET_YELLOW,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_HAT_BLACK;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_hat_cotton_black.png";
	f->overlay_texture = "clothes_player_hat_cotton_black.png";
	f->description = gettext("Black Cotton Hat");
	f->armour = 0.0;
	f->warmth = 0.05;
	f->vacuum = 0.0;
	crafting::setHatRecipe(CONTENT_CRAFTITEM_COTTON_SHEET_BLACK,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	// cotton ties
	i = CONTENT_CLOTHESITEM_COTTON_TIE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_DECORATIVE;
	f->texture = "clothes_tie_cotton_white.png";
	f->overlay_texture = "clothes_player_tie_cotton_white.png";
	f->description = gettext("Cotton Tie");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	crafting::set1over1Recipe(CONTENT_CRAFTITEM_COTTON_SHEET,CONTENT_CRAFTITEM_COTTON_SHEET,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_TIE_BLUE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_DECORATIVE;
	f->texture = "clothes_tie_cotton_blue.png";
	f->overlay_texture = "clothes_player_tie_cotton_blue.png";
	f->description = gettext("Blue Cotton Tie");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	crafting::set1over1Recipe(CONTENT_CRAFTITEM_COTTON_SHEET_BLUE,CONTENT_CRAFTITEM_COTTON_SHEET_BLUE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_TIE_GREEN;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_DECORATIVE;
	f->texture = "clothes_tie_cotton_green.png";
	f->overlay_texture = "clothes_player_tie_cotton_green.png";
	f->description = gettext("Green Cotton Tie");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	crafting::set1over1Recipe(CONTENT_CRAFTITEM_COTTON_SHEET_GREEN,CONTENT_CRAFTITEM_COTTON_SHEET_GREEN,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_TIE_ORANGE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_DECORATIVE;
	f->texture = "clothes_tie_cotton_orange.png";
	f->overlay_texture = "clothes_player_tie_cotton_orange.png";
	f->description = gettext("Orange Cotton Tie");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	crafting::set1over1Recipe(CONTENT_CRAFTITEM_COTTON_SHEET_ORANGE,CONTENT_CRAFTITEM_COTTON_SHEET_ORANGE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_TIE_PURPLE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_DECORATIVE;
	f->texture = "clothes_tie_cotton_purple.png";
	f->overlay_texture = "clothes_player_tie_cotton_purple.png";
	f->description = gettext("Purple Cotton Tie");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	crafting::set1over1Recipe(CONTENT_CRAFTITEM_COTTON_SHEET_PURPLE,CONTENT_CRAFTITEM_COTTON_SHEET_PURPLE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_TIE_RED;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_DECORATIVE;
	f->texture = "clothes_tie_cotton_red.png";
	f->overlay_texture = "clothes_player_tie_cotton_red.png";
	f->description = gettext("Red Cotton Tie");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	crafting::set1over1Recipe(CONTENT_CRAFTITEM_COTTON_SHEET_RED,CONTENT_CRAFTITEM_COTTON_SHEET_RED,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_TIE_YELLOW;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_DECORATIVE;
	f->texture = "clothes_tie_cotton_yellow.png";
	f->overlay_texture = "clothes_player_tie_cotton_yellow.png";
	f->description = gettext("Yellow Cotton Tie");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	crafting::set1over1Recipe(CONTENT_CRAFTITEM_COTTON_SHEET_YELLOW,CONTENT_CRAFTITEM_COTTON_SHEET_YELLOW,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COTTON_TIE_BLACK;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_DECORATIVE;
	f->texture = "clothes_tie_cotton_black.png";
	f->overlay_texture = "clothes_player_tie_cotton_black.png";
	f->description = gettext("Black Cotton Tie");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	crafting::set1over1Recipe(CONTENT_CRAFTITEM_COTTON_SHEET_BLACK,CONTENT_CRAFTITEM_COTTON_SHEET_BLACK,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	// canvas shirt
	i = CONTENT_CLOTHESITEM_CANVAS_SHIRT;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_SHIRT;
	f->texture = "clothes_shirt_canvas_white.png";
	f->overlay_texture = "clothes_player_shirt_canvas_white.png";
	f->description = gettext("Canvas Shirt");
	f->armour = 0.0;
	f->warmth = 0.45;
	f->vacuum = 0.0;
	f->durability = 6;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_CANVAS_SHEET,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_CANVAS_SHIRT_BLUE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_SHIRT;
	f->texture = "clothes_shirt_canvas_blue.png";
	f->overlay_texture = "clothes_player_shirt_canvas_blue.png";
	f->description = gettext("Blue Canvas Shirt");
	f->armour = 0.0;
	f->warmth = 0.45;
	f->vacuum = 0.0;
	f->durability = 6;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_CANVAS_SHEET_BLUE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_CANVAS_SHIRT_GREEN;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_SHIRT;
	f->texture = "clothes_shirt_canvas_green.png";
	f->overlay_texture = "clothes_player_shirt_canvas_green.png";
	f->description = gettext("Green Canvas Shirt");
	f->armour = 0.0;
	f->warmth = 0.45;
	f->vacuum = 0.0;
	f->durability = 6;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_CANVAS_SHEET_GREEN,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_CANVAS_SHIRT_ORANGE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_SHIRT;
	f->texture = "clothes_shirt_canvas_orange.png";
	f->overlay_texture = "clothes_player_shirt_canvas_orange.png";
	f->description = gettext("Orange Canvas Shirt");
	f->armour = 0.0;
	f->warmth = 0.45;
	f->vacuum = 0.0;
	f->durability = 6;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_CANVAS_SHEET_ORANGE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_CANVAS_SHIRT_PURPLE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_SHIRT;
	f->texture = "clothes_shirt_canvas_purple.png";
	f->overlay_texture = "clothes_player_shirt_canvas_purple.png";
	f->description = gettext("Purple Canvas Shirt");
	f->armour = 0.0;
	f->warmth = 0.45;
	f->vacuum = 0.0;
	f->durability = 6;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_CANVAS_SHEET_PURPLE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_CANVAS_SHIRT_RED;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_SHIRT;
	f->texture = "clothes_shirt_canvas_red.png";
	f->overlay_texture = "clothes_player_shirt_canvas_red.png";
	f->description = gettext("Red Canvas Shirt");
	f->armour = 0.0;
	f->warmth = 0.45;
	f->vacuum = 0.0;
	f->durability = 6;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_CANVAS_SHEET_RED,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_CANVAS_SHIRT_YELLOW;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_SHIRT;
	f->texture = "clothes_shirt_canvas_yellow.png";
	f->overlay_texture = "clothes_player_shirt_canvas_yellow.png";
	f->description = gettext("Yellow Canvas Shirt");
	f->armour = 0.0;
	f->warmth = 0.45;
	f->vacuum = 0.0;
	f->durability = 6;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_CANVAS_SHEET_YELLOW,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_CANVAS_SHIRT_BLACK;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_SHIRT;
	f->texture = "clothes_shirt_canvas_black.png";
	f->overlay_texture = "clothes_player_shirt_canvas_black.png";
	f->description = gettext("Black Canvas Shirt");
	f->armour = 0.0;
	f->warmth = 0.45;
	f->vacuum = 0.0;
	f->durability = 6;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_CANVAS_SHEET_BLACK,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	// canvas pants / jeans
	i = CONTENT_CLOTHESITEM_CANVAS_PANTS;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_pants_canvas_white.png";
	f->overlay_texture = "clothes_player_pants_canvas_white.png";
	f->description = gettext("Canvas Pants");
	f->armour = 0.0;
	f->warmth = 0.45;
	f->vacuum = 0.0;
	f->durability = 6;
	crafting::setPantsRecipe(CONTENT_CRAFTITEM_CANVAS_SHEET,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_CANVAS_PANTS_BLUE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_pants_canvas_blue.png";
	f->overlay_texture = "clothes_player_pants_canvas_blue.png";
	f->description = gettext("Blue Canvas Pants");
	f->armour = 0.0;
	f->warmth = 0.45;
	f->vacuum = 0.0;
	f->durability = 6;
	crafting::setPantsRecipe(CONTENT_CRAFTITEM_CANVAS_SHEET_BLUE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_CANVAS_PANTS_GREEN;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_pants_canvas_green.png";
	f->overlay_texture = "clothes_player_pants_canvas_green.png";
	f->description = gettext("Green Canvas Pants");
	f->armour = 0.0;
	f->warmth = 0.45;
	f->vacuum = 0.0;
	f->durability = 6;
	crafting::setPantsRecipe(CONTENT_CRAFTITEM_CANVAS_SHEET_GREEN,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_CANVAS_PANTS_ORANGE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_pants_canvas_orange.png";
	f->overlay_texture = "clothes_player_pants_canvas_orange.png";
	f->description = gettext("Orange Canvas Pants");
	f->armour = 0.0;
	f->warmth = 0.45;
	f->vacuum = 0.0;
	f->durability = 6;
	crafting::setPantsRecipe(CONTENT_CRAFTITEM_CANVAS_SHEET_ORANGE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_CANVAS_PANTS_PURPLE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_pants_canvas_purple.png";
	f->overlay_texture = "clothes_player_pants_canvas_purple.png";
	f->description = gettext("Purple Canvas Pants");
	f->armour = 0.0;
	f->warmth = 0.45;
	f->vacuum = 0.0;
	f->durability = 6;
	crafting::setPantsRecipe(CONTENT_CRAFTITEM_CANVAS_SHEET_PURPLE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_CANVAS_PANTS_RED;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_pants_canvas_red.png";
	f->overlay_texture = "clothes_player_pants_canvas_red.png";
	f->description = gettext("Red Canvas Pants");
	f->armour = 0.0;
	f->warmth = 0.45;
	f->vacuum = 0.0;
	f->durability = 6;
	crafting::setPantsRecipe(CONTENT_CRAFTITEM_CANVAS_SHEET_RED,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_CANVAS_PANTS_YELLOW;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_pants_canvas_yellow.png";
	f->overlay_texture = "clothes_player_pants_canvas_yellow.png";
	f->description = gettext("Yellow Canvas Pants");
	f->armour = 0.0;
	f->warmth = 0.45;
	f->vacuum = 0.0;
	f->durability = 6;
	crafting::setPantsRecipe(CONTENT_CRAFTITEM_CANVAS_SHEET_YELLOW,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_CANVAS_PANTS_BLACK;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_pants_canvas_black.png";
	f->overlay_texture = "clothes_player_pants_canvas_black.png";
	f->description = gettext("Black Canvas Pants");
	f->armour = 0.0;
	f->warmth = 0.45;
	f->vacuum = 0.0;
	f->durability = 6;
	crafting::setPantsRecipe(CONTENT_CRAFTITEM_CANVAS_SHEET_BLACK,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	// canvas shoes
	i = CONTENT_CLOTHESITEM_CANVAS_SHOES;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_shoes_canvas_white.png";
	f->overlay_texture = "clothes_player_shoes_canvas_white.png";
	f->description = gettext("Canvas Shoes");
	f->armour = 0.05;
	f->warmth = 0.45;
	f->vacuum = 0.0;
	crafting::setShoesRecipe(CONTENT_CRAFTITEM_CANVAS_SHEET,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_CANVAS_SHOES_BLUE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_shoes_canvas_blue.png";
	f->overlay_texture = "clothes_player_shoes_canvas_blue.png";
	f->description = gettext("Blue Canvas Shoes");
	f->armour = 0.05;
	f->warmth = 0.45;
	f->vacuum = 0.0;
	crafting::setShoesRecipe(CONTENT_CRAFTITEM_CANVAS_SHEET_BLUE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_CANVAS_SHOES_GREEN;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_shoes_canvas_green.png";
	f->overlay_texture = "clothes_player_shoes_canvas_green.png";
	f->description = gettext("Green Canvas Shoes");
	f->armour = 0.05;
	f->warmth = 0.45;
	f->vacuum = 0.0;
	crafting::setShoesRecipe(CONTENT_CRAFTITEM_CANVAS_SHEET_GREEN,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_CANVAS_SHOES_ORANGE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_shoes_canvas_orange.png";
	f->overlay_texture = "clothes_player_shoes_canvas_orange.png";
	f->description = gettext("Orange Canvas Shoes");
	f->armour = 0.05;
	f->warmth = 0.45;
	f->vacuum = 0.0;
	crafting::setShoesRecipe(CONTENT_CRAFTITEM_CANVAS_SHEET_ORANGE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_CANVAS_SHOES_PURPLE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_shoes_canvas_purple.png";
	f->overlay_texture = "clothes_player_shoes_canvas_purple.png";
	f->description = gettext("Purple Canvas Shoes");
	f->armour = 0.05;
	f->warmth = 0.45;
	f->vacuum = 0.0;
	crafting::setShoesRecipe(CONTENT_CRAFTITEM_CANVAS_SHEET_PURPLE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_CANVAS_SHOES_RED;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_shoes_canvas_red.png";
	f->overlay_texture = "clothes_player_shoes_canvas_red.png";
	f->description = gettext("Red Canvas Shoes");
	f->armour = 0.05;
	f->warmth = 0.45;
	f->vacuum = 0.0;
	crafting::setShoesRecipe(CONTENT_CRAFTITEM_CANVAS_SHEET_RED,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_CANVAS_SHOES_YELLOW;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_shoes_canvas_yellow.png";
	f->overlay_texture = "clothes_player_shoes_canvas_yellow.png";
	f->description = gettext("Yellow Canvas Shoes");
	f->armour = 0.05;
	f->warmth = 0.45;
	f->vacuum = 0.0;
	crafting::setShoesRecipe(CONTENT_CRAFTITEM_CANVAS_SHEET_YELLOW,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_CANVAS_SHOES_BLACK;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_shoes_canvas_black.png";
	f->overlay_texture = "clothes_player_shoes_canvas_black.png";
	f->description = gettext("Black Canvas Shoes");
	f->armour = 0.05;
	f->warmth = 0.45;
	f->vacuum = 0.0;
	crafting::setShoesRecipe(CONTENT_CRAFTITEM_CANVAS_SHEET_BLACK,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	// canvas belt
	i = CONTENT_CLOTHESITEM_CANVAS_BELT;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BELT;
	f->texture = "clothes_belt_canvas_white.png";
	f->overlay_texture = "clothes_player_belt_canvas_white.png";
	f->description = gettext("Canvas Belt");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	crafting::setRow1Recipe(CONTENT_CRAFTITEM_CANVAS_SHEET,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_CANVAS_BELT_BLUE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BELT;
	f->texture = "clothes_belt_canvas_blue.png";
	f->overlay_texture = "clothes_player_belt_canvas_blue.png";
	f->description = gettext("Blue Canvas Belt");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	crafting::setRow1Recipe(CONTENT_CRAFTITEM_CANVAS_SHEET_BLUE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_CANVAS_BELT_GREEN;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BELT;
	f->texture = "clothes_belt_canvas_green.png";
	f->overlay_texture = "clothes_player_belt_canvas_green.png";
	f->description = gettext("Green Canvas Belt");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	crafting::setRow1Recipe(CONTENT_CRAFTITEM_CANVAS_SHEET_GREEN,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_CANVAS_BELT_ORANGE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BELT;
	f->texture = "clothes_belt_canvas_orange.png";
	f->overlay_texture = "clothes_player_belt_canvas_orange.png";
	f->description = gettext("Orange Canvas Belt");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	crafting::setRow1Recipe(CONTENT_CRAFTITEM_CANVAS_SHEET_ORANGE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_CANVAS_BELT_PURPLE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BELT;
	f->texture = "clothes_belt_canvas_purple.png";
	f->overlay_texture = "clothes_player_belt_canvas_purple.png";
	f->description = gettext("Purple Canvas Belt");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	crafting::setRow1Recipe(CONTENT_CRAFTITEM_CANVAS_SHEET_PURPLE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_CANVAS_BELT_RED;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BELT;
	f->texture = "clothes_belt_canvas_red.png";
	f->overlay_texture = "clothes_player_belt_canvas_red.png";
	f->description = gettext("Red Canvas Belt");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	crafting::setRow1Recipe(CONTENT_CRAFTITEM_CANVAS_SHEET_RED,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_CANVAS_BELT_YELLOW;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BELT;
	f->texture = "clothes_belt_canvas_yellow.png";
	f->overlay_texture = "clothes_player_belt_canvas_yellow.png";
	f->description = gettext("Yellow Canvas Belt");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	crafting::setRow1Recipe(CONTENT_CRAFTITEM_CANVAS_SHEET_YELLOW,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_CANVAS_BELT_BLACK;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BELT;
	f->texture = "clothes_belt_canvas_black.png";
	f->overlay_texture = "clothes_player_belt_canvas_black.png";
	f->description = gettext("Black Canvas Belt");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	crafting::setRow1Recipe(CONTENT_CRAFTITEM_CANVAS_SHEET_BLACK,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	// leather shirts
	i = CONTENT_CLOTHESITEM_LEATHER_JACKET;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_JACKET;
	f->texture = "clothes_jacket_leather_brown.png";
	f->overlay_texture = "clothes_player_jacket_leather_brown.png";
	f->description = gettext("Leather Jacket");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_LEATHER,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_JACKET_WHITE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_JACKET;
	f->texture = "clothes_jacket_leather_white.png";
	f->overlay_texture = "clothes_player_jacket_leather_white.png";
	f->description = gettext("White Leather Jacket");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_LEATHER_WHITE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_JACKET_BLUE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_JACKET;
	f->texture = "clothes_jacket_leather_blue.png";
	f->overlay_texture = "clothes_player_jacket_leather_blue.png";
	f->description = gettext("Blue Leather Jacket");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_LEATHER_BLUE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_JACKET_GREEN;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_JACKET;
	f->texture = "clothes_jacket_leather_green.png";
	f->overlay_texture = "clothes_player_jacket_leather_green.png";
	f->description = gettext("Green Leather Jacket");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_LEATHER_GREEN,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_JACKET_ORANGE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_JACKET;
	f->texture = "clothes_jacket_leather_orange.png";
	f->overlay_texture = "clothes_player_jacket_leather_orange.png";
	f->description = gettext("Orange Leather Jacket");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_LEATHER_ORANGE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_JACKET_PURPLE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_JACKET;
	f->texture = "clothes_jacket_leather_purple.png";
	f->overlay_texture = "clothes_player_jacket_leather_purple.png";
	f->description = gettext("Purple Leather Jacket");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_LEATHER_PURPLE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_JACKET_RED;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_JACKET;
	f->texture = "clothes_jacket_leather_red.png";
	f->overlay_texture = "clothes_player_jacket_leather_red.png";
	f->description = gettext("Red Leather Jacket");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_LEATHER_RED,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_JACKET_YELLOW;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_JACKET;
	f->texture = "clothes_jacket_leather_yellow.png";
	f->overlay_texture = "clothes_player_jacket_leather_yellow.png";
	f->description = gettext("Yellow Leather Jacket");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_LEATHER_YELLOW,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_JACKET_BLACK;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_JACKET;
	f->texture = "clothes_jacket_leather_black.png";
	f->overlay_texture = "clothes_player_jacket_leather_black.png";
	f->description = gettext("Black Leather Jacket");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_LEATHER_BLACK,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	// leather pants
	i = CONTENT_CLOTHESITEM_LEATHER_PANTS;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_pants_leather_brown.png";
	f->overlay_texture = "clothes_player_pants_leather_brown.png";
	f->description = gettext("Leather Pants");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setPantsRecipe(CONTENT_CRAFTITEM_LEATHER,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_PANTS_WHITE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_pants_leather_white.png";
	f->overlay_texture = "clothes_player_pants_leather_white.png";
	f->description = gettext("White Leather Pants");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setPantsRecipe(CONTENT_CRAFTITEM_LEATHER_WHITE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_PANTS_BLUE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_pants_leather_blue.png";
	f->overlay_texture = "clothes_player_pants_leather_blue.png";
	f->description = gettext("Blue Leather Pants");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setPantsRecipe(CONTENT_CRAFTITEM_LEATHER_BLUE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_PANTS_GREEN;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_pants_leather_green.png";
	f->overlay_texture = "clothes_player_pants_leather_green.png";
	f->description = gettext("Green Leather Pants");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setPantsRecipe(CONTENT_CRAFTITEM_LEATHER_GREEN,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_PANTS_ORANGE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_pants_leather_orange.png";
	f->overlay_texture = "clothes_player_pants_leather_orange.png";
	f->description = gettext("Orange Leather Pants");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setPantsRecipe(CONTENT_CRAFTITEM_LEATHER_ORANGE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_PANTS_PURPLE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_pants_leather_purple.png";
	f->overlay_texture = "clothes_player_pants_leather_purple.png";
	f->description = gettext("Purple Leather Pants");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setPantsRecipe(CONTENT_CRAFTITEM_LEATHER_PURPLE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_PANTS_RED;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_pants_leather_red.png";
	f->overlay_texture = "clothes_player_pants_leather_red.png";
	f->description = gettext("Red Leather Pants");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setPantsRecipe(CONTENT_CRAFTITEM_LEATHER_RED,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_PANTS_YELLOW;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_pants_leather_yellow.png";
	f->overlay_texture = "clothes_player_pants_leather_yellow.png";
	f->description = gettext("Yellow Leather Pants");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setPantsRecipe(CONTENT_CRAFTITEM_LEATHER_YELLOW,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_PANTS_BLACK;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_pants_leather_black.png";
	f->overlay_texture = "clothes_player_pants_leather_black.png";
	f->description = gettext("Black Leather Pants");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setPantsRecipe(CONTENT_CRAFTITEM_LEATHER_BLACK,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	// leather hats
	i = CONTENT_CLOTHESITEM_LEATHER_HAT;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_hat_leather_brown.png";
	f->overlay_texture = "clothes_player_hat_leather_brown.png";
	f->description = gettext("Leather Hat");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	crafting::setHatRecipe(CONTENT_CRAFTITEM_LEATHER,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_HAT_WHITE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_hat_leather_white.png";
	f->overlay_texture = "clothes_player_hat_leather_white.png";
	f->description = gettext("White Leather Hat");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	crafting::setHatRecipe(CONTENT_CRAFTITEM_LEATHER_WHITE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_HAT_BLUE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_hat_leather_blue.png";
	f->overlay_texture = "clothes_player_hat_leather_blue.png";
	f->description = gettext("Blue Leather Hat");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	crafting::setHatRecipe(CONTENT_CRAFTITEM_LEATHER_BLUE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_HAT_GREEN;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_hat_leather_green.png";
	f->overlay_texture = "clothes_player_hat_leather_green.png";
	f->description = gettext("Green Leather Hat");
	f->armour = 1.0;
	f->warmth = 1.0;
	f->vacuum = 0.1;
	crafting::setHatRecipe(CONTENT_CRAFTITEM_LEATHER_GREEN,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_HAT_ORANGE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_hat_leather_orange.png";
	f->overlay_texture = "clothes_player_hat_leather_orange.png";
	f->description = gettext("Orange Leather Hat");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	crafting::setHatRecipe(CONTENT_CRAFTITEM_LEATHER_ORANGE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_HAT_PURPLE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_hat_leather_purple.png";
	f->overlay_texture = "clothes_player_hat_leather_purple.png";
	f->description = gettext("Purple Leather Hat");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	crafting::setHatRecipe(CONTENT_CRAFTITEM_LEATHER_PURPLE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_HAT_RED;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_hat_leather_red.png";
	f->overlay_texture = "clothes_player_hat_leather_red.png";
	f->description = gettext("Red Leather Hat");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	crafting::setHatRecipe(CONTENT_CRAFTITEM_LEATHER_RED,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_HAT_YELLOW;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_hat_leather_yellow.png";
	f->overlay_texture = "clothes_player_hat_leather_yellow.png";
	f->description = gettext("Yellow Leather Hat");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	crafting::setHatRecipe(CONTENT_CRAFTITEM_LEATHER_YELLOW,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_HAT_BLACK;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_hat_leather_black.png";
	f->overlay_texture = "clothes_player_hat_leather_black.png";
	f->description = gettext("Black Leather Hat");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	crafting::setHatRecipe(CONTENT_CRAFTITEM_LEATHER_BLACK,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	// leather helmets
	i = CONTENT_CLOTHESITEM_LEATHER_HELMET;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_helmet_leather_brown.png";
	f->overlay_texture = "clothes_player_helmet_leather_brown.png";
	f->description = gettext("Leather Helmet");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setHelmetRecipe(CONTENT_CRAFTITEM_LEATHER,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_HELMET_WHITE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_helmet_leather_white.png";
	f->overlay_texture = "clothes_player_helmet_leather_white.png";
	f->description = gettext("White Leather Helmet");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setHelmetRecipe(CONTENT_CRAFTITEM_LEATHER_WHITE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_HELMET_BLUE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_helmet_leather_blue.png";
	f->overlay_texture = "clothes_player_helmet_leather_blue.png";
	f->description = gettext("Blue Leather Helmet");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setHelmetRecipe(CONTENT_CRAFTITEM_LEATHER_BLUE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_HELMET_GREEN;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_helmet_leather_green.png";
	f->overlay_texture = "clothes_player_helmet_leather_green.png";
	f->description = gettext("Green Leather Helmet");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setHelmetRecipe(CONTENT_CRAFTITEM_LEATHER_GREEN,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_HELMET_ORANGE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_helmet_leather_orange.png";
	f->overlay_texture = "clothes_player_helmet_leather_orange.png";
	f->description = gettext("Orange Leather Helmet");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setHelmetRecipe(CONTENT_CRAFTITEM_LEATHER_ORANGE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_HELMET_PURPLE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_helmet_leather_purple.png";
	f->overlay_texture = "clothes_player_helmet_leather_purple.png";
	f->description = gettext("Purple Leather Helmet");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setHelmetRecipe(CONTENT_CRAFTITEM_LEATHER_PURPLE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_HELMET_RED;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_helmet_leather_red.png";
	f->overlay_texture = "clothes_player_helmet_leather_red.png";
	f->description = gettext("Red Leather Helmet");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setHelmetRecipe(CONTENT_CRAFTITEM_LEATHER_RED,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_HELMET_YELLOW;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_helmet_leather_yellow.png";
	f->overlay_texture = "clothes_player_helmet_leather_yellow.png";
	f->description = gettext("Yellow Leather Helmet");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setHelmetRecipe(CONTENT_CRAFTITEM_LEATHER_YELLOW,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_HELMET_BLACK;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_helmet_leather_black.png";
	f->overlay_texture = "clothes_player_helmet_leather_black.png";
	f->description = gettext("Black Leather Helmet");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setHelmetRecipe(CONTENT_CRAFTITEM_LEATHER_BLACK,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	// leather shoes
	i = CONTENT_CLOTHESITEM_LEATHER_SHOES;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_shoes_leather_brown.png";
	f->overlay_texture = "clothes_player_shoes_leather_brown.png";
	f->description = gettext("Leather Shoes");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 6;
	crafting::setShoesRecipe(CONTENT_CRAFTITEM_LEATHER,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_SHOES_WHITE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_shoes_leather_white.png";
	f->overlay_texture = "clothes_player_shoes_leather_white.png";
	f->description = gettext("White Leather Shoes");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 6;
	crafting::setShoesRecipe(CONTENT_CRAFTITEM_LEATHER_WHITE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_SHOES_BLUE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_shoes_leather_blue.png";
	f->overlay_texture = "clothes_player_shoes_leather_blue.png";
	f->description = gettext("Blue Leather Shoes");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 6;
	crafting::setShoesRecipe(CONTENT_CRAFTITEM_LEATHER_BLUE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_SHOES_GREEN;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_shoes_leather_green.png";
	f->overlay_texture = "clothes_player_shoes_leather_green.png";
	f->description = gettext("Green Leather Shoes");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 6;
	crafting::setShoesRecipe(CONTENT_CRAFTITEM_LEATHER_GREEN,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_SHOES_ORANGE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_shoes_leather_orange.png";
	f->overlay_texture = "clothes_player_shoes_leather_orange.png";
	f->description = gettext("Orange Leather Shoes");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 6;
	crafting::setShoesRecipe(CONTENT_CRAFTITEM_LEATHER_ORANGE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_SHOES_PURPLE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_shoes_leather_purple.png";
	f->overlay_texture = "clothes_player_shoes_leather_purple.png";
	f->description = gettext("Purple Leather Shoes");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 6;
	crafting::setShoesRecipe(CONTENT_CRAFTITEM_LEATHER_PURPLE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_SHOES_RED;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_shoes_leather_red.png";
	f->overlay_texture = "clothes_player_shoes_leather_red.png";
	f->description = gettext("Red Leather Shoes");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 6;
	crafting::setShoesRecipe(CONTENT_CRAFTITEM_LEATHER_RED,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_SHOES_YELLOW;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_shoes_leather_yellow.png";
	f->overlay_texture = "clothes_player_shoes_leather_yellow.png";
	f->description = gettext("Yellow Leather Shoes");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 6;
	crafting::setShoesRecipe(CONTENT_CRAFTITEM_LEATHER_YELLOW,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_SHOES_BLACK;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_shoes_leather_black.png";
	f->overlay_texture = "clothes_player_shoes_leather_black.png";
	f->description = gettext("Black Leather Shoes");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 6;
	crafting::setShoesRecipe(CONTENT_CRAFTITEM_LEATHER_BLACK,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	// leather boots
	i = CONTENT_CLOTHESITEM_LEATHER_BOOTS;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_boots_leather_brown.png";
	f->overlay_texture = "clothes_player_boots_leather_brown.png";
	f->description = gettext("Leather Boots");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setBootsRecipe(CONTENT_CRAFTITEM_LEATHER,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_BOOTS_WHITE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_boots_leather_white.png";
	f->overlay_texture = "clothes_player_boots_leather_white.png";
	f->description = gettext("White Leather Boots");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setBootsRecipe(CONTENT_CRAFTITEM_LEATHER_WHITE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_BOOTS_BLUE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_boots_leather_blue.png";
	f->overlay_texture = "clothes_player_boots_leather_blue.png";
	f->description = gettext("Blue Leather Boots");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setBootsRecipe(CONTENT_CRAFTITEM_LEATHER_BLUE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_BOOTS_GREEN;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_boots_leather_green.png";
	f->overlay_texture = "clothes_player_boots_leather_green.png";
	f->description = gettext("Green Leather Boots");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setBootsRecipe(CONTENT_CRAFTITEM_LEATHER_GREEN,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_BOOTS_ORANGE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_boots_leather_orange.png";
	f->overlay_texture = "clothes_player_boots_leather_orange.png";
	f->description = gettext("Orange Leather Boots");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setBootsRecipe(CONTENT_CRAFTITEM_LEATHER_ORANGE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_BOOTS_PURPLE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_boots_leather_purple.png";
	f->overlay_texture = "clothes_player_boots_leather_purple.png";
	f->description = gettext("Purple Leather Boots");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setBootsRecipe(CONTENT_CRAFTITEM_LEATHER_PURPLE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_BOOTS_RED;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_boots_leather_red.png";
	f->overlay_texture = "clothes_player_boots_leather_red.png";
	f->description = gettext("Red Leather Boots");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setBootsRecipe(CONTENT_CRAFTITEM_LEATHER_RED,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_BOOTS_YELLOW;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_boots_leather_yellow.png";
	f->overlay_texture = "clothes_player_boots_leather_yellow.png";
	f->description = gettext("Yellow Leather Boots");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setBootsRecipe(CONTENT_CRAFTITEM_LEATHER_YELLOW,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_BOOTS_BLACK;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_boots_leather_black.png";
	f->overlay_texture = "clothes_player_boots_leather_black.png";
	f->description = gettext("Black Leather Boots");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 8;
	crafting::setBootsRecipe(CONTENT_CRAFTITEM_LEATHER_BLACK,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	// leather belt
	i = CONTENT_CLOTHESITEM_LEATHER_BELT;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BELT;
	f->texture = "clothes_belt_leather_brown.png";
	f->overlay_texture = "clothes_player_belt_leather_brown.png";
	f->description = gettext("Leather Belt");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 6;
	crafting::setRow1Recipe(CONTENT_CRAFTITEM_LEATHER,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_BELT_WHITE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BELT;
	f->texture = "clothes_belt_leather_white.png";
	f->overlay_texture = "clothes_player_belt_leather_white.png";
	f->description = gettext("White Leather Belt");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 6;
	crafting::setRow1Recipe(CONTENT_CRAFTITEM_LEATHER_WHITE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_BELT_BLUE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BELT;
	f->texture = "clothes_belt_leather_blue.png";
	f->overlay_texture = "clothes_player_belt_leather_blue.png";
	f->description = gettext("Blue Leather Belt");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 6;
	crafting::setRow1Recipe(CONTENT_CRAFTITEM_LEATHER_BLUE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_BELT_GREEN;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BELT;
	f->texture = "clothes_belt_leather_green.png";
	f->overlay_texture = "clothes_player_belt_leather_green.png";
	f->description = gettext("Green Leather Belt");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 6;
	crafting::setRow1Recipe(CONTENT_CRAFTITEM_LEATHER_GREEN,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_BELT_ORANGE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BELT;
	f->texture = "clothes_belt_leather_orange.png";
	f->overlay_texture = "clothes_player_belt_leather_orange.png";
	f->description = gettext("Orange Leather Belt");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 6;
	crafting::setRow1Recipe(CONTENT_CRAFTITEM_LEATHER_ORANGE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_BELT_PURPLE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BELT;
	f->texture = "clothes_belt_leather_purple.png";
	f->overlay_texture = "clothes_player_belt_leather_purple.png";
	f->description = gettext("Purple Leather Belt");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 6;
	crafting::setRow1Recipe(CONTENT_CRAFTITEM_LEATHER_PURPLE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_BELT_RED;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BELT;
	f->texture = "clothes_belt_leather_red.png";
	f->overlay_texture = "clothes_player_belt_leather_red.png";
	f->description = gettext("Red Leather Belt");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 6;
	crafting::setRow1Recipe(CONTENT_CRAFTITEM_LEATHER_RED,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_BELT_YELLOW;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BELT;
	f->texture = "clothes_belt_leather_yellow.png";
	f->overlay_texture = "clothes_player_belt_leather_yellow.png";
	f->description = gettext("Yellow Leather Belt");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 6;
	crafting::setRow1Recipe(CONTENT_CRAFTITEM_LEATHER_YELLOW,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_LEATHER_BELT_BLACK;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BELT;
	f->texture = "clothes_belt_leather_black.png";
	f->overlay_texture = "clothes_player_belt_leather_black.png";
	f->description = gettext("Black Leather Belt");
	f->armour = 1.0;
	f->warmth = 0.6;
	f->vacuum = 0.1;
	f->durability = 6;
	crafting::setRow1Recipe(CONTENT_CRAFTITEM_LEATHER_BLACK,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	// fur jackets
	i = CONTENT_CLOTHESITEM_FUR_JACKET;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_JACKET;
	f->texture = "clothes_jacket_fur_brown.png";
	f->overlay_texture = "clothes_player_jacket_fur_brown.png";
	f->description = gettext("Fur Coat");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_FUR,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_JACKET_WHITE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_JACKET;
	f->texture = "clothes_jacket_fur_white.png";
	f->overlay_texture = "clothes_player_jacket_fur_white.png";
	f->description = gettext("White Fur Coat");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_FUR_WHITE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_JACKET_BLUE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_JACKET;
	f->texture = "clothes_jacket_fur_blue.png";
	f->overlay_texture = "clothes_player_jacket_fur_blue.png";
	f->description = gettext("Blue Fur Coat");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_FUR_BLUE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_JACKET_GREEN;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_JACKET;
	f->texture = "clothes_jacket_fur_green.png";
	f->overlay_texture = "clothes_player_jacket_fur_green.png";
	f->description = gettext("Green Fur Coat");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_FUR_GREEN,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_JACKET_ORANGE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_JACKET;
	f->texture = "clothes_jacket_fur_orange.png";
	f->overlay_texture = "clothes_player_jacket_fur_orange.png";
	f->description = gettext("Orange Fur Coat");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_FUR_ORANGE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_JACKET_PURPLE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_JACKET;
	f->texture = "clothes_jacket_fur_purple.png";
	f->overlay_texture = "clothes_player_jacket_fur_purple.png";
	f->description = gettext("Purple Fur Coat");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_FUR_PURPLE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_JACKET_RED;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_JACKET;
	f->texture = "clothes_jacket_fur_red.png";
	f->overlay_texture = "clothes_player_jacket_fur_red.png";
	f->description = gettext("Red Fur Coat");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_FUR_RED,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_JACKET_YELLOW;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_JACKET;
	f->texture = "clothes_jacket_fur_yellow.png";
	f->overlay_texture = "clothes_player_jacket_fur_yellow.png";
	f->description = gettext("Yellow Fur Coat");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_FUR_YELLOW,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_JACKET_BLACK;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_JACKET;
	f->texture = "clothes_jacket_fur_black.png";
	f->overlay_texture = "clothes_player_jacket_fur_black.png";
	f->description = gettext("Black Fur Coat");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_FUR_BLACK,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	// fur pants
	i = CONTENT_CLOTHESITEM_FUR_PANTS;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_pants_fur_brown.png";
	f->overlay_texture = "clothes_player_pants_fur_brown.png";
	f->description = gettext("Fur Pants");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setPantsRecipe(CONTENT_CRAFTITEM_FUR,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_PANTS_WHITE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_pants_fur_white.png";
	f->overlay_texture = "clothes_player_pants_fur_white.png";
	f->description = gettext("White Fur Pants");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setPantsRecipe(CONTENT_CRAFTITEM_FUR_WHITE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_PANTS_BLUE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_pants_fur_blue.png";
	f->overlay_texture = "clothes_player_pants_fur_blue.png";
	f->description = gettext("Blue Fur Pants");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setPantsRecipe(CONTENT_CRAFTITEM_FUR_BLUE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_PANTS_GREEN;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_pants_fur_green.png";
	f->overlay_texture = "clothes_player_pants_fur_green.png";
	f->description = gettext("Green Fur Pants");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setPantsRecipe(CONTENT_CRAFTITEM_FUR_GREEN,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_PANTS_ORANGE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_pants_fur_orange.png";
	f->overlay_texture = "clothes_player_pants_fur_orange.png";
	f->description = gettext("Orange Fur Pants");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setPantsRecipe(CONTENT_CRAFTITEM_FUR_ORANGE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_PANTS_PURPLE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_pants_fur_purple.png";
	f->overlay_texture = "clothes_player_pants_fur_purple.png";
	f->description = gettext("Purple Fur Pants");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setPantsRecipe(CONTENT_CRAFTITEM_FUR_PURPLE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_PANTS_RED;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_pants_fur_red.png";
	f->overlay_texture = "clothes_player_pants_fur_red.png";
	f->description = gettext("Red Fur Pants");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setPantsRecipe(CONTENT_CRAFTITEM_FUR_RED,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_PANTS_YELLOW;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_pants_fur_yellow.png";
	f->overlay_texture = "clothes_player_pants_fur_yellow.png";
	f->description = gettext("Yellow Fur Pants");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setPantsRecipe(CONTENT_CRAFTITEM_FUR_YELLOW,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_PANTS_BLACK;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_pants_fur_black.png";
	f->overlay_texture = "clothes_player_pants_fur_black.png";
	f->description = gettext("Black Fur Pants");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setPantsRecipe(CONTENT_CRAFTITEM_FUR_BLACK,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	// fur hats
	i = CONTENT_CLOTHESITEM_FUR_HAT;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_hat_fur_brown.png";
	f->overlay_texture = "clothes_player_hat_fur_brown.png";
	f->description = gettext("Fur Hat");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setHatRecipe(CONTENT_CRAFTITEM_FUR,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_HAT_WHITE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_hat_fur_white.png";
	f->overlay_texture = "clothes_player_hat_fur_white.png";
	f->description = gettext("White Fur Hat");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setHatRecipe(CONTENT_CRAFTITEM_FUR_WHITE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_HAT_BLUE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_hat_fur_blue.png";
	f->overlay_texture = "clothes_player_hat_fur_blue.png";
	f->description = gettext("Blue Fur Hat");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setHatRecipe(CONTENT_CRAFTITEM_FUR_BLUE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_HAT_GREEN;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_hat_fur_green.png";
	f->overlay_texture = "clothes_player_hat_fur_green.png";
	f->description = gettext("Green Fur Hat");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setHatRecipe(CONTENT_CRAFTITEM_FUR_GREEN,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_HAT_ORANGE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_hat_fur_orange.png";
	f->overlay_texture = "clothes_player_hat_fur_orange.png";
	f->description = gettext("Orange Fur Hat");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setHatRecipe(CONTENT_CRAFTITEM_FUR_ORANGE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_HAT_PURPLE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_hat_fur_purple.png";
	f->overlay_texture = "clothes_player_hat_fur_purple.png";
	f->description = gettext("Purple Fur Hat");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setHatRecipe(CONTENT_CRAFTITEM_FUR_PURPLE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_HAT_RED;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_hat_fur_red.png";
	f->overlay_texture = "clothes_player_hat_fur_red.png";
	f->description = gettext("Red Fur Hat");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setHatRecipe(CONTENT_CRAFTITEM_FUR_RED,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_HAT_YELLOW;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_hat_fur_yellow.png";
	f->overlay_texture = "clothes_player_hat_fur_yellow.png";
	f->description = gettext("Yellow Fur Hat");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setHatRecipe(CONTENT_CRAFTITEM_FUR_YELLOW,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_HAT_BLACK;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_hat_fur_black.png";
	f->overlay_texture = "clothes_player_hat_fur_black.png";
	f->description = gettext("Black Fur Hat");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setHatRecipe(CONTENT_CRAFTITEM_FUR_BLACK,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	// fur shoes
	i = CONTENT_CLOTHESITEM_FUR_SHOES;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_shoes_fur_brown.png";
	f->overlay_texture = "clothes_player_shoes_fur_brown.png";
	f->description = gettext("Fur Shoes");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	crafting::setShoesRecipe(CONTENT_CRAFTITEM_FUR,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_SHOES_WHITE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_shoes_fur_white.png";
	f->overlay_texture = "clothes_player_shoes_fur_white.png";
	f->description = gettext("White Fur Shoes");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	crafting::setShoesRecipe(CONTENT_CRAFTITEM_FUR_WHITE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_SHOES_BLUE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_shoes_fur_blue.png";
	f->overlay_texture = "clothes_player_shoes_fur_blue.png";
	f->description = gettext("Blue Fur Shoes");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	crafting::setShoesRecipe(CONTENT_CRAFTITEM_FUR_BLUE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_SHOES_GREEN;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_shoes_fur_green.png";
	f->overlay_texture = "clothes_player_shoes_fur_green.png";
	f->description = gettext("Green Fur Shoes");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	crafting::setShoesRecipe(CONTENT_CRAFTITEM_FUR_GREEN,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_SHOES_ORANGE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_shoes_fur_orange.png";
	f->overlay_texture = "clothes_player_shoes_fur_orange.png";
	f->description = gettext("Orange Fur Shoes");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	crafting::setShoesRecipe(CONTENT_CRAFTITEM_FUR_ORANGE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_SHOES_PURPLE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_shoes_fur_purple.png";
	f->overlay_texture = "clothes_player_shoes_fur_purple.png";
	f->description = gettext("Purple Fur Shoes");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	crafting::setShoesRecipe(CONTENT_CRAFTITEM_FUR_PURPLE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_SHOES_RED;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_shoes_fur_red.png";
	f->overlay_texture = "clothes_player_shoes_fur_red.png";
	f->description = gettext("Red Fur Shoes");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	crafting::setShoesRecipe(CONTENT_CRAFTITEM_FUR_RED,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_SHOES_YELLOW;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_shoes_fur_yellow.png";
	f->overlay_texture = "clothes_player_shoes_fur_yellow.png";
	f->description = gettext("Yellow Fur Shoes");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	crafting::setShoesRecipe(CONTENT_CRAFTITEM_FUR_YELLOW,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_SHOES_BLACK;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_shoes_fur_black.png";
	f->overlay_texture = "clothes_player_shoes_fur_black.png";
	f->description = gettext("Black Fur Shoes");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	crafting::setShoesRecipe(CONTENT_CRAFTITEM_FUR_BLACK,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	// fur boots
	i = CONTENT_CLOTHESITEM_FUR_BOOTS;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_boots_fur_brown.png";
	f->overlay_texture = "clothes_player_boots_fur_brown.png";
	f->description = gettext("Fur Boots");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setBootsRecipe(CONTENT_CRAFTITEM_FUR,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_BOOTS_WHITE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_boots_fur_white.png";
	f->overlay_texture = "clothes_player_boots_fur_white.png";
	f->description = gettext("White Fur Boots");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setBootsRecipe(CONTENT_CRAFTITEM_FUR_WHITE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_BOOTS_BLUE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_boots_fur_blue.png";
	f->overlay_texture = "clothes_player_boots_fur_blue.png";
	f->description = gettext("Blue Fur Boots");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setBootsRecipe(CONTENT_CRAFTITEM_FUR_BLUE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_BOOTS_GREEN;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_boots_fur_green.png";
	f->overlay_texture = "clothes_player_boots_fur_green.png";
	f->description = gettext("Green Fur Boots");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setBootsRecipe(CONTENT_CRAFTITEM_FUR_GREEN,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_BOOTS_ORANGE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_boots_fur_orange.png";
	f->overlay_texture = "clothes_player_boots_fur_orange.png";
	f->description = gettext("Orange Fur Boots");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setBootsRecipe(CONTENT_CRAFTITEM_FUR_ORANGE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_BOOTS_PURPLE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_boots_fur_purple.png";
	f->overlay_texture = "clothes_player_boots_fur_purple.png";
	f->description = gettext("Purple Fur Boots");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setBootsRecipe(CONTENT_CRAFTITEM_FUR_PURPLE,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_BOOTS_RED;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_boots_fur_red.png";
	f->overlay_texture = "clothes_player_boots_fur_red.png";
	f->description = gettext("Red Fur Boots");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setBootsRecipe(CONTENT_CRAFTITEM_FUR_RED,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_BOOTS_YELLOW;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_boots_fur_yellow.png";
	f->overlay_texture = "clothes_player_boots_fur_yellow.png";
	f->description = gettext("Yellow Fur Boots");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setBootsRecipe(CONTENT_CRAFTITEM_FUR_YELLOW,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_FUR_BOOTS_BLACK;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_boots_fur_black.png";
	f->overlay_texture = "clothes_player_boots_fur_black.png";
	f->description = gettext("Black Fur Boots");
	f->armour = 0.4;
	f->warmth = 1.0;
	f->vacuum = 0.05;
	f->durability = 6;
	crafting::setBootsRecipe(CONTENT_CRAFTITEM_FUR_BLACK,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	// necklaces / medallions
	i = CONTENT_CLOTHESITEM_LEATHER_NECKLACE;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_DECORATIVE;
	f->texture = "clothes_necklace_leather.png";
	f->overlay_texture = "clothes_player_necklace_leather.png";
	f->description = gettext("Leather Necklace");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	f->durability = 8;
	crafting::set1To1Recipe(CONTENT_CRAFTITEM_LEATHER,i);
	crafting::set1To1Recipe(CONTENT_CRAFTITEM_LEATHER_WHITE,i);
	crafting::set1To1Recipe(CONTENT_CRAFTITEM_LEATHER_BLUE,i);
	crafting::set1To1Recipe(CONTENT_CRAFTITEM_LEATHER_GREEN,i);
	crafting::set1To1Recipe(CONTENT_CRAFTITEM_LEATHER_ORANGE,i);
	crafting::set1To1Recipe(CONTENT_CRAFTITEM_LEATHER_PURPLE,i);
	crafting::set1To1Recipe(CONTENT_CRAFTITEM_LEATHER_RED,i);
	crafting::set1To1Recipe(CONTENT_CRAFTITEM_LEATHER_YELLOW,i);
	crafting::set1To1Recipe(CONTENT_CRAFTITEM_LEATHER_BLACK,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_GOLD_MEDALLION;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_MEDALLION;
	f->texture = "clothes_medallion_gold.png";
	f->overlay_texture = "clothes_player_medallion_gold.png";
	f->description = gettext("Gold Medallion");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	f->effect = 1.8;
	f->durability = 8;
	crafting::set1over1Recipe(CONTENT_CLOTHESITEM_LEATHER_NECKLACE,CONTENT_CRAFTITEM_GOLD_INGOT,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COPPER_MEDALLION;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_MEDALLION;
	f->texture = "clothes_medallion_copper.png";
	f->overlay_texture = "clothes_player_medallion_copper.png";
	f->description = gettext("Copper Medallion");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	f->effect = 1.4;
	f->durability = 8;
	crafting::set1over1Recipe(CONTENT_CLOTHESITEM_LEATHER_NECKLACE,CONTENT_CRAFTITEM_COPPER_INGOT,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_SILVER_MEDALLION;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_MEDALLION;
	f->texture = "clothes_medallion_silver.png";
	f->overlay_texture = "clothes_player_medallion_silver.png";
	f->description = gettext("Silver Medallion");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	f->effect = 2.0;
	f->durability = 8;
	crafting::set1over1Recipe(CONTENT_CLOTHESITEM_LEATHER_NECKLACE,CONTENT_CRAFTITEM_SILVER_INGOT,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_TIN_MEDALLION;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_MEDALLION;
	f->texture = "clothes_medallion_tin.png";
	f->overlay_texture = "clothes_player_medallion_tin.png";
	f->description = gettext("Tin Medallion");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	f->effect = 1.2;
	f->durability = 8;
	crafting::set1over1Recipe(CONTENT_CLOTHESITEM_LEATHER_NECKLACE,CONTENT_CRAFTITEM_TIN_INGOT,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_IRON_MEDALLION;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_MEDALLION;
	f->texture = "clothes_medallion_iron.png";
	f->overlay_texture = "clothes_player_medallion_iron.png";
	f->description = gettext("Iron Medallion");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	f->effect = 1.6;
	f->durability = 8;
	crafting::set1over1Recipe(CONTENT_CLOTHESITEM_LEATHER_NECKLACE,CONTENT_CRAFTITEM_IRON_INGOT,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_QUARTZ_MEDALLION;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_MEDALLION;
	f->texture = "clothes_medallion_quartz.png";
	f->overlay_texture = "clothes_player_medallion_quartz.png";
	f->description = gettext("Quartz Medallion");
	f->armour = 0.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	f->effect = 2.2;
	f->durability = 8;
	crafting::set1over1Recipe(CONTENT_CLOTHESITEM_LEATHER_NECKLACE,CONTENT_CRAFTITEM_QUARTZ,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	// armour
	i = CONTENT_CLOTHESITEM_IRON_HELMET;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_helmet_iron.png";
	f->overlay_texture = "clothes_player_helmet_iron.png";
	f->description = gettext("Iron Helmet");
	f->armour = 1.0;
	f->warmth = 0.0;
	f->vacuum = 0.1;
	f->durability = 10;
	crafting::setHatRecipe(CONTENT_CRAFTITEM_IRON_INGOT,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_IRON_SHIRT;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_JACKET;
	f->texture = "clothes_shirt_iron.png";
	f->overlay_texture = "clothes_player_shirt_iron.png";
	f->description = gettext("Iron Chest Armour");
	f->armour = 1.0;
	f->warmth = 0.0;
	f->vacuum = 0.1;
	f->durability = 10;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_IRON_INGOT,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_IRON_PANTS;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_pants_iron.png";
	f->overlay_texture = "clothes_player_pants_iron.png";
	f->description = gettext("Iron Pants");
	f->armour = 1.0;
	f->warmth = 0.0;
	f->vacuum = 0.1;
	f->durability = 10;
	crafting::setPantsRecipe(CONTENT_CRAFTITEM_IRON_INGOT,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_IRON_BOOTS;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_boots_iron.png";
	f->overlay_texture = "clothes_player_boots_iron.png";
	f->description = gettext("Iron Boots");
	f->armour = 1.0;
	f->warmth = 0.0;
	f->vacuum = 0.1;
	f->durability = 10;
	crafting::setBootsRecipe(CONTENT_CRAFTITEM_IRON_INGOT,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COPPER_HELMET;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_HAT;
	f->texture = "clothes_helmet_copper.png";
	f->overlay_texture = "clothes_player_helmet_copper.png";
	f->description = gettext("Copper Helmet");
	f->armour = 1.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	crafting::setHatRecipe(CONTENT_CRAFTITEM_COPPER_INGOT,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COPPER_SHIRT;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_JACKET;
	f->texture = "clothes_shirt_copper.png";
	f->overlay_texture = "clothes_player_shirt_copper.png";
	f->description = gettext("Copper Chest Armour");
	f->armour = 1.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	crafting::setShirtRecipe(CONTENT_CRAFTITEM_COPPER_INGOT,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COPPER_PANTS;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_PANTS;
	f->texture = "clothes_pants_copper.png";
	f->overlay_texture = "clothes_player_pants_copper.png";
	f->description = gettext("Copper Pants");
	f->armour = 1.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	crafting::setPantsRecipe(CONTENT_CRAFTITEM_COPPER_INGOT,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_CLOTHESITEM_COPPER_BOOTS;
	f = &g_content_clothesitem_features[(i&~CONTENT_CLOTHESITEM_MASK)];
	f->content = i;
	f->type = CT_BOOTS;
	f->texture = "clothes_boots_copper.png";
	f->overlay_texture = "clothes_player_boots_copper.png";
	f->description = gettext("Copper Boots");
	f->armour = 1.0;
	f->warmth = 0.0;
	f->vacuum = 0.0;
	crafting::setBootsRecipe(CONTENT_CRAFTITEM_COPPER_INGOT,i);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);
}
