/************************************************************************
* Minetest-c55
* Copyright (C) 2010 celeron55, Perttu Ahola <celeron55@gmail.com>
*
* content_mapnode_door.cpp
* Copyright (C) Lisa 'darkrose' Milne 2014 <lisa@ltmnet.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
* See the GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
************************************************************************/

#include "content_mapnode.h"
#include "content_nodebox.h"
#include "content_list.h"
#include "content_craft.h"
#include "content_nodemeta.h"
#include "intl.h"
#include "content_burntimes.h"

void content_mapnode_door(bool repeat)
{
	content_t i;
	ContentFeatures *f = NULL;

	// doors
	i = CONTENT_WOOD_DOOR_LB;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Wood Door");
	f->setAllTextures("door_wood_b.png");
	f->setTexture(2,"door_wood_b.png^[transformFX");
	f->setTexture(3,"door_wood_b.png^[transformFX");
	f->setTexture(4,"door_wood_b.png^[transformFX");
	f->setInventoryTexture("door_wood_inv.png");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i+1)+" 1";
	f->onact_also_affects = v3s16(0,1,0);
	f->onpunch_replace_node = CONTENT_WOOD_DOOR_LB_OPEN;
	f->sound_punch = "env-dooropen";
	f->flammable = 1; // can be replaced by fire if the node under it is set on fire
	f->fuel_time = BT_DOOR;
	content_nodebox_door(f);
	f->type = CMT_WOOD;
	f->dig_time = 0.75;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	i = CONTENT_WOOD_DOOR_LT;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Wood Door");
	f->setAllTextures("door_wood_t.png");
	f->setTexture(2,"door_wood_t.png^[transformFX");
	f->setTexture(3,"door_wood_t.png^[transformFX");
	f->setTexture(4,"door_wood_t.png^[transformFX");
	f->setInventoryTexture("door_wood_inv.png");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i)+" 1";
	f->onuse_replace_node = CONTENT_WOOD_DOOR_RT;
	f->onact_also_affects = v3s16(0,-1,0);
	f->onpunch_replace_node = CONTENT_WOOD_DOOR_LT_OPEN;
	f->sound_punch = "env-dooropen";
	f->flammable = 1; // can be replaced by fire if the node under it is set on fire
	f->fuel_time = BT_DOOR;
	content_nodebox_door(f);
	f->type = CMT_WOOD;
	f->dig_time = 0.75;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	crafting::set1over1Recipe(CONTENT_WOOD_HATCH,CONTENT_WOOD_HATCH,CONTENT_WOOD_DOOR_LT);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_IRON_DOOR_LB;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Iron Door");
	f->setAllTextures("door_iron_b.png");
	f->setTexture(2,"door_iron_b.png^[transformFX");
	f->setTexture(3,"door_iron_b.png^[transformFX");
	f->setTexture(4,"door_iron_b.png^[transformFX");
	f->setInventoryTexture("door_iron_inv.png");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i+1)+" 1";
	f->onact_also_affects = v3s16(0,1,0);
	f->onpunch_replace_node = CONTENT_IRON_DOOR_LB_OPEN;
	f->sound_punch = "env-dooropen";
	content_nodebox_door(f);
	f->type = CMT_STONE;
	f->dig_time = 2.0;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	f->energy_type = CET_DEVICE;
	if (f->initial_metadata == NULL)
		f->initial_metadata = new DoorNodeMetadata();
	i = CONTENT_IRON_DOOR_LT;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Iron Door");
	f->setAllTextures("door_iron_t.png");
	f->setTexture(2,"door_iron_t.png^[transformFX");
	f->setTexture(3,"door_iron_t.png^[transformFX");
	f->setTexture(4,"door_iron_t.png^[transformFX");
	f->setInventoryTexture("door_iron_inv.png");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i)+" 1";
	f->onuse_replace_node = CONTENT_IRON_DOOR_RT;
	f->onact_also_affects = v3s16(0,-1,0);
	f->onpunch_replace_node = CONTENT_IRON_DOOR_LT_OPEN;
	f->sound_punch = "env-dooropen";
	content_nodebox_door(f);
	f->type = CMT_STONE;
	f->dig_time = 2.0;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	f->energy_type = CET_DEVICE;
	if (f->initial_metadata == NULL)
		f->initial_metadata = new DoorNodeMetadata();
	crafting::set1over1Recipe(CONTENT_IRON_HATCH,CONTENT_IRON_HATCH,CONTENT_IRON_DOOR_LT);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_GLASS_DOOR_LB;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Glass Door");
	f->setAllTextures("door_glass_b.png");
	f->setTexture(2,"door_glass_b.png^[transformFX");
	f->setTexture(3,"door_glass_b.png^[transformFX");
	f->setTexture(4,"door_glass_b.png^[transformFX");
#ifndef SERVER
	f->setAllTextureTypes(MATERIAL_ALPHA_BLEND);
#endif
	f->setInventoryTexture("door_glass_inv.png");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->sunlight_propagates = true;
	f->air_equivalent = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i+1)+" 1";
	f->onact_also_affects = v3s16(0,1,0);
	f->onpunch_replace_node = CONTENT_GLASS_DOOR_LB_OPEN;
	f->sound_punch = "env-dooropen";
	content_nodebox_door(f);
	f->type = CMT_GLASS;
	f->dig_time = 0.15;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	i = CONTENT_GLASS_DOOR_LT;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Glass Door");
	f->setAllTextures("door_glass_t.png");
	f->setTexture(2,"door_glass_t.png^[transformFX");
	f->setTexture(3,"door_glass_t.png^[transformFX");
	f->setTexture(4,"door_glass_t.png^[transformFX");
#ifndef SERVER
	f->setAllTextureTypes(MATERIAL_ALPHA_BLEND);
#endif
	f->setInventoryTexture("door_glass_inv.png");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i)+" 1";
	f->onuse_replace_node = CONTENT_GLASS_DOOR_RT;
	f->onact_also_affects = v3s16(0,-1,0);
	f->onpunch_replace_node = CONTENT_GLASS_DOOR_LT_OPEN;
	f->sound_punch = "env-dooropen";
	content_nodebox_door(f);
	f->type = CMT_GLASS;
	f->dig_time = 0.15;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	crafting::set1over1Recipe(CONTENT_GLASS_PANE,CONTENT_GLASS_PANE,CONTENT_GLASS_DOOR_LT);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_WOOD_W_DOOR_LB;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Wood Windowed Door");
	f->setAllTextures("door_wood_wb.png");
	f->setTexture(2,"door_wood_wb.png^[transformFX");
	f->setTexture(3,"door_wood_wb.png^[transformFX");
	f->setTexture(4,"door_wood_wb.png^[transformFX");
	f->setInventoryTexture("door_wood_w_inv.png");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i+1)+" 1";
	f->onact_also_affects = v3s16(0,1,0);
	f->onpunch_replace_node = CONTENT_WOOD_W_DOOR_LB_OPEN;
	f->sound_punch = "env-dooropen";
	f->flammable = 1; // can be replaced by fire if the node under it is set on fire
	f->fuel_time = BT_DOOR;
	content_nodebox_door(f);
	f->type = CMT_WOOD;
	f->dig_time = 0.75;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	i = CONTENT_WOOD_W_DOOR_LT;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Wood Windowed Door");
	f->setAllTextures("door_wood_wt.png");
	f->setTexture(2,"door_wood_wt.png^[transformFX");
	f->setTexture(3,"door_wood_wt.png^[transformFX");
	f->setTexture(4,"door_wood_wt.png^[transformFX");
	f->setInventoryTexture("door_wood_w_inv.png");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i)+" 1";
	f->onuse_replace_node = CONTENT_WOOD_W_DOOR_RT;
	f->onact_also_affects = v3s16(0,-1,0);
	f->onpunch_replace_node = CONTENT_WOOD_W_DOOR_LT_OPEN;
	f->sound_punch = "env-dooropen";
	f->flammable = 1; // can be replaced by fire if the node under it is set on fire
	f->fuel_time = BT_DOOR;
	content_nodebox_doorw(f);
	f->type = CMT_WOOD;
	f->dig_time = 0.75;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	crafting::set1over1Recipe(CONTENT_WOOD_W_HATCH,CONTENT_WOOD_HATCH,CONTENT_WOOD_W_DOOR_LT);
	crafting::set1over1Recipe(CONTENT_GLASS,CONTENT_WOOD_DOOR_LT,CONTENT_WOOD_W_DOOR_LT);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_IRON_W_DOOR_LB;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Iron Windowed Door");
	f->setAllTextures("door_iron_wb.png");
	f->setTexture(2,"door_iron_wb.png^[transformFX");
	f->setTexture(3,"door_iron_wb.png^[transformFX");
	f->setTexture(4,"door_iron_wb.png^[transformFX");
	f->setInventoryTexture("door_iron_w_inv.png");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i+1)+" 1";
	f->onact_also_affects = v3s16(0,1,0);
	f->onpunch_replace_node = CONTENT_IRON_W_DOOR_LB_OPEN;
	f->sound_punch = "env-dooropen";
	content_nodebox_door(f);
	f->type = CMT_STONE;
	f->dig_time = 2.0;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	f->energy_type = CET_DEVICE;
	if (f->initial_metadata == NULL)
		f->initial_metadata = new DoorNodeMetadata();
	i = CONTENT_IRON_W_DOOR_LT;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Iron Windowed Door");
	f->setAllTextures("door_iron_wt.png");
	f->setTexture(2,"door_iron_wt.png^[transformFX");
	f->setTexture(3,"door_iron_wt.png^[transformFX");
	f->setTexture(4,"door_iron_wt.png^[transformFX");
	f->setInventoryTexture("door_iron_w_inv.png");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i)+" 1";
	f->onuse_replace_node = CONTENT_IRON_W_DOOR_RT;
	f->onact_also_affects = v3s16(0,-1,0);
	f->onpunch_replace_node = CONTENT_IRON_W_DOOR_LT_OPEN;
	f->sound_punch = "env-dooropen";
	content_nodebox_doorw(f);
	f->type = CMT_STONE;
	f->dig_time = 2.0;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	f->energy_type = CET_DEVICE;
	if (f->initial_metadata == NULL)
		f->initial_metadata = new DoorNodeMetadata();
	crafting::set1over1Recipe(CONTENT_IRON_W_HATCH,CONTENT_IRON_HATCH,CONTENT_IRON_W_DOOR_LT);
	crafting::set1over1Recipe(CONTENT_GLASS,CONTENT_IRON_DOOR_LT,CONTENT_IRON_W_DOOR_LT);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	// right doors
	i = CONTENT_WOOD_DOOR_RB;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Right Hanging Wood Door");
	f->setAllTextures("door_wood_b.png^[transformFX");
	f->setTexture(2,"door_wood_b.png");
	f->setTexture(3,"door_wood_b.png");
	f->setTexture(4,"door_wood_b.png");
	f->setInventoryTexture("door_wood_inv.png^[transformFX");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i+1)+" 1";
	f->onact_also_affects = v3s16(0,1,0);
	f->onpunch_replace_node = CONTENT_WOOD_DOOR_RB_OPEN;
	f->sound_punch = "env-dooropen";
	f->flammable = 1; // can be replaced by fire if the node under it is set on fire
	f->fuel_time = BT_DOOR;
	content_nodebox_door(f);
	f->type = CMT_WOOD;
	f->dig_time = 0.75;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	i = CONTENT_WOOD_DOOR_RT;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Right Hanging Wood Door");
	f->setAllTextures("door_wood_t.png^[transformFX");
	f->setTexture(2,"door_wood_t.png");
	f->setTexture(3,"door_wood_t.png");
	f->setTexture(4,"door_wood_t.png");
	f->setInventoryTexture("door_wood_inv.png^[transformFX");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i)+" 1";
	f->onuse_replace_node = CONTENT_WOOD_DOOR_LT;
	f->onact_also_affects = v3s16(0,-1,0);
	f->onpunch_replace_node = CONTENT_WOOD_DOOR_RT_OPEN;
	f->sound_punch = "env-dooropen";
	f->flammable = 1; // can be replaced by fire if the node under it is set on fire
	f->fuel_time = BT_DOOR;
	content_nodebox_door(f);
	f->type = CMT_WOOD;
	f->dig_time = 0.75;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	content_list_add("creative",i,1,0);

	i = CONTENT_GLASS_DOOR_RB;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Right Hanging Glass Door");
	f->setAllTextures("door_glass_b.png^[transformFX");
	f->setTexture(2,"door_glass_b.png");
	f->setTexture(3,"door_glass_b.png");
	f->setTexture(4,"door_glass_b.png");
#ifndef SERVER
	f->setAllTextureTypes(MATERIAL_ALPHA_BLEND);
#endif
	f->setInventoryTexture("door_glass_inv.png^[transformFX");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i+1)+" 1";
	f->onact_also_affects = v3s16(0,1,0);
	f->onpunch_replace_node = CONTENT_GLASS_DOOR_RB_OPEN;
	f->sound_punch = "env-dooropen";
	f->fuel_time = BT_DOOR_GLASS;
	content_nodebox_door(f);
	f->type = CMT_GLASS;
	f->dig_time = 0.15;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	i = CONTENT_GLASS_DOOR_RT;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Right Hanging Glass Door");
	f->setAllTextures("door_glass_t.png^[transformFX");
	f->setTexture(2,"door_glass_t.png");
	f->setTexture(3,"door_glass_t.png");
	f->setTexture(4,"door_glass_t.png");
#ifndef SERVER
	f->setAllTextureTypes(MATERIAL_ALPHA_BLEND);
#endif
	f->setInventoryTexture("door_glass_inv.png^[transformFX");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i)+" 1";
	f->onuse_replace_node = CONTENT_GLASS_DOOR_LT;
	f->onact_also_affects = v3s16(0,-1,0);
	f->onpunch_replace_node = CONTENT_GLASS_DOOR_RT_OPEN;
	f->sound_punch = "env-dooropen";
	f->fuel_time = BT_DOOR_GLASS;
	content_nodebox_door(f);
	f->type = CMT_GLASS;
	f->dig_time = 0.15;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	content_list_add("creative",i,1,0);

	i = CONTENT_IRON_DOOR_RB;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Right Hanging Iron Door");
	f->setAllTextures("door_iron_b.png^[transformFX");
	f->setTexture(2,"door_iron_b.png");
	f->setTexture(3,"door_iron_b.png");
	f->setTexture(4,"door_iron_b.png");
	f->setInventoryTexture("door_iron_inv.png^[transformFX");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i+1)+" 1";
	f->onact_also_affects = v3s16(0,1,0);
	f->onpunch_replace_node = CONTENT_IRON_DOOR_RB_OPEN;
	f->sound_punch = "env-dooropen";
	content_nodebox_door(f);
	f->type = CMT_STONE;
	f->dig_time = 2.0;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	f->energy_type = CET_DEVICE;
	if (f->initial_metadata == NULL)
		f->initial_metadata = new DoorNodeMetadata();
	i = CONTENT_IRON_DOOR_RT;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Right Hanging Iron Door");
	f->setAllTextures("door_iron_t.png^[transformFX");
	f->setTexture(2,"door_iron_t.png");
	f->setTexture(3,"door_iron_t.png");
	f->setTexture(4,"door_iron_t.png");
	f->setInventoryTexture("door_iron_inv.png^[transformFX");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i)+" 1";
	f->onuse_replace_node = CONTENT_IRON_DOOR_LT;
	f->onact_also_affects = v3s16(0,-1,0);
	f->onpunch_replace_node = CONTENT_IRON_DOOR_RT_OPEN;
	f->sound_punch = "env-dooropen";
	content_nodebox_door(f);
	f->type = CMT_STONE;
	f->dig_time = 2.0;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	f->energy_type = CET_DEVICE;
	if (f->initial_metadata == NULL)
		f->initial_metadata = new DoorNodeMetadata();
	content_list_add("creative",i,1,0);

	i = CONTENT_WOOD_W_DOOR_RB;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Right Hanging Wood Windowed Door");
	f->setAllTextures("door_wood_wb.png^[transformFX");
	f->setTexture(2,"door_wood_wb.png");
	f->setTexture(3,"door_wood_wb.png");
	f->setTexture(4,"door_wood_wb.png");
	f->setInventoryTexture("door_wood_w_inv.png^[transformFX");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i+1)+" 1";
	f->onact_also_affects = v3s16(0,1,0);
	f->onpunch_replace_node = CONTENT_WOOD_W_DOOR_RB_OPEN;
	f->sound_punch = "env-dooropen";
	f->flammable = 1; // can be replaced by fire if the node under it is set on fire
	f->fuel_time = BT_DOOR;
	content_nodebox_door(f);
	f->type = CMT_WOOD;
	f->dig_time = 0.75;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	i = CONTENT_WOOD_W_DOOR_RT;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Right Hanging Wood Windowed Door");
	f->setAllTextures("door_wood_wt.png^[transformFX");
	f->setTexture(2,"door_wood_wt.png");
	f->setTexture(3,"door_wood_wt.png");
	f->setTexture(4,"door_wood_wt.png");
	f->setInventoryTexture("door_wood_w_inv.png^[transformFX");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i)+" 1";
	f->onuse_replace_node = CONTENT_WOOD_W_DOOR_LT;
	f->onact_also_affects = v3s16(0,-1,0);
	f->onpunch_replace_node = CONTENT_WOOD_W_DOOR_RT_OPEN;
	f->sound_punch = "env-dooropen";
	f->flammable = 1; // can be replaced by fire if the node under it is set on fire
	f->fuel_time = BT_DOOR;
	content_nodebox_doorw(f);
	f->type = CMT_WOOD;
	f->dig_time = 0.75;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	content_list_add("creative",i,1,0);

	i = CONTENT_IRON_W_DOOR_RB;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Right Hanging Iron Windowed Door");
	f->setAllTextures("door_iron_wb.png^[transformFX");
	f->setTexture(2,"door_iron_wb.png");
	f->setTexture(3,"door_iron_wb.png");
	f->setTexture(4,"door_iron_wb.png");
	f->setInventoryTexture("door_iron_w_inv.png^[transformFX");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i+1)+" 1";
	f->onact_also_affects = v3s16(0,1,0);
	f->onpunch_replace_node = CONTENT_IRON_W_DOOR_RB_OPEN;
	f->sound_punch = "env-dooropen";
	content_nodebox_door(f);
	f->type = CMT_STONE;
	f->dig_time = 2.0;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	f->energy_type = CET_DEVICE;
	if (f->initial_metadata == NULL)
		f->initial_metadata = new DoorNodeMetadata();
	i = CONTENT_IRON_W_DOOR_RT;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Right Hanging Iron Windowed Door");
	f->setAllTextures("door_iron_wt.png^[transformFX");
	f->setTexture(2,"door_iron_wt.png");
	f->setTexture(3,"door_iron_wt.png");
	f->setTexture(4,"door_iron_wt.png");
	f->setInventoryTexture("door_iron_w_inv.png^[transformFX");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i)+" 1";
	f->onuse_replace_node = CONTENT_IRON_W_DOOR_LT;
	f->onact_also_affects = v3s16(0,-1,0);
	f->onpunch_replace_node = CONTENT_IRON_W_DOOR_RT_OPEN;
	f->sound_punch = "env-dooropen";
	content_nodebox_doorw(f);
	f->type = CMT_STONE;
	f->dig_time = 2.0;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	f->energy_type = CET_DEVICE;
	if (f->initial_metadata == NULL)
		f->initial_metadata = new DoorNodeMetadata();
	crafting::set1To1Recipe(CONTENT_IRON_W_DOOR_LT,CONTENT_IRON_W_DOOR_RT);
	crafting::set1over1Recipe(CONTENT_GLASS,CONTENT_IRON_DOOR_RT,CONTENT_IRON_W_DOOR_RT);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	// open doors
	i = CONTENT_WOOD_DOOR_LB_OPEN;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Wood Door");
	f->setAllTextures("door_wood_b.png");
	f->setTexture(3,"door_wood_b.png^[transformFX");
	f->setInventoryTexture("door_wood_inv.png");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(CONTENT_WOOD_DOOR_LT)+" 1";
	f->onact_also_affects = v3s16(0,1,0);
	f->onpunch_replace_node = CONTENT_WOOD_DOOR_LB;
	f->sound_punch = "env-doorclose";
	f->flammable = 1; // can be replaced by fire if the node under it is set on fire
	f->fuel_time = BT_DOOR;
	content_nodebox_doorol(f);
	f->type = CMT_WOOD;
	f->dig_time = 0.75;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	i = CONTENT_WOOD_DOOR_LT_OPEN;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Wood Door");
	f->setAllTextures("door_wood_t.png");
	f->setTexture(3,"door_wood_t.png^[transformFX");
	f->setInventoryTexture("door_wood_inv.png");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(CONTENT_WOOD_DOOR_LT)+" 1";
	f->onact_also_affects = v3s16(0,-1,0);
	f->onpunch_replace_node = CONTENT_WOOD_DOOR_LT;
	f->sound_punch = "env-doorclose";
	f->flammable = 1; // can be replaced by fire if the node under it is set on fire
	f->fuel_time = BT_DOOR;
	content_nodebox_doorol(f);
	f->type = CMT_WOOD;
	f->dig_time = 0.75;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;

	i = CONTENT_GLASS_DOOR_LB_OPEN;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Glass Door");
	f->setAllTextures("door_glass_b.png");
	f->setTexture(3,"door_glass_b.png^[transformFX");
#ifndef SERVER
	f->setAllTextureTypes(MATERIAL_ALPHA_BLEND);
#endif
	f->setInventoryTexture("door_glass_inv.png");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i+1)+" 1";
	f->onact_also_affects = v3s16(0,1,0);
	f->onpunch_replace_node = CONTENT_GLASS_DOOR_LB;
	f->sound_punch = "env-doorclose";
	f->fuel_time = BT_DOOR_GLASS;
	content_nodebox_doorol(f);
	f->type = CMT_WOOD;
	f->dig_time = 0.15;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	i = CONTENT_GLASS_DOOR_LT_OPEN;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Glass Door");
	f->setAllTextures("door_glass_t.png");
	f->setTexture(3,"door_glass_t.png^[transformFX");
#ifndef SERVER
	f->setAllTextureTypes(MATERIAL_ALPHA_BLEND);
#endif
	f->setInventoryTexture("door_glass_inv.png");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i)+" 1";
	f->onact_also_affects = v3s16(0,-1,0);
	f->onpunch_replace_node = CONTENT_GLASS_DOOR_LT;
	f->sound_punch = "env-doorclose";
	f->fuel_time = BT_DOOR_GLASS;
	content_nodebox_doorol(f);
	f->type = CMT_WOOD;
	f->dig_time = 0.15;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;

	i = CONTENT_IRON_DOOR_LB_OPEN;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Iron Door");
	f->setAllTextures("door_iron_b.png");
	f->setTexture(3,"door_iron_b.png^[transformFX");
	f->setInventoryTexture("door_iron_inv.png");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(CONTENT_IRON_DOOR_LT)+" 1";
	f->onact_also_affects = v3s16(0,1,0);
	f->onpunch_replace_node = CONTENT_IRON_DOOR_LB;
	f->sound_punch = "env-doorclose";
	content_nodebox_doorol(f);
	f->type = CMT_STONE;
	f->dig_time = 2.0;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	f->energy_type = CET_DEVICE;
	if (f->initial_metadata == NULL)
		f->initial_metadata = new DoorNodeMetadata();
	i = CONTENT_IRON_DOOR_LT_OPEN;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Iron Door");
	f->setAllTextures("door_iron_t.png");
	f->setTexture(3,"door_iron_t.png^[transformFX");
	f->setInventoryTexture("door_iron_inv.png");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(CONTENT_IRON_DOOR_LT)+" 1";
	f->onact_also_affects = v3s16(0,-1,0);
	f->onpunch_replace_node = CONTENT_IRON_DOOR_LT;
	f->sound_punch = "env-doorclose";
	content_nodebox_doorol(f);
	f->type = CMT_STONE;
	f->dig_time = 2.0;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	f->energy_type = CET_DEVICE;
	if (f->initial_metadata == NULL)
		f->initial_metadata = new DoorNodeMetadata();

	i = CONTENT_WOOD_W_DOOR_LB_OPEN;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Wood Windowed Door");
	f->setAllTextures("door_wood_wb.png");
	f->setTexture(3,"door_wood_wb.png^[transformFX");
	f->setInventoryTexture("door_wood_w_inv.png");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(CONTENT_WOOD_W_DOOR_LT)+" 1";
	f->onact_also_affects = v3s16(0,1,0);
	f->onpunch_replace_node = CONTENT_WOOD_W_DOOR_LB;
	f->sound_punch = "env-doorclose";
	f->flammable = 1; // can be replaced by fire if the node under it is set on fire
	f->fuel_time = BT_DOOR;
	content_nodebox_doorol(f);
	f->type = CMT_WOOD;
	f->dig_time = 0.75;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	i = CONTENT_WOOD_W_DOOR_LT_OPEN;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Wood Windowed Door");
	f->setAllTextures("door_wood_wt.png");
	f->setTexture(3,"door_wood_wt.png^[transformFX");
	f->setInventoryTexture("door_wood_w_inv.png");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(CONTENT_WOOD_W_DOOR_LT)+" 1";
	f->onact_also_affects = v3s16(0,-1,0);
	f->onpunch_replace_node = CONTENT_WOOD_W_DOOR_LT;
	f->sound_punch = "env-doorclose";
	f->flammable = 1; // can be replaced by fire if the node under it is set on fire
	f->fuel_time = BT_DOOR;
	content_nodebox_doorwol(f);
	f->type = CMT_WOOD;
	f->dig_time = 0.75;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;

	i = CONTENT_IRON_W_DOOR_LB_OPEN;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Iron Windowed Door");
	f->setAllTextures("door_iron_wb.png");
	f->setTexture(3,"door_iron_wb.png^[transformFX");
	f->setInventoryTexture("door_iron_w_inv.png");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(CONTENT_IRON_W_DOOR_LT)+" 1";
	f->onact_also_affects = v3s16(0,1,0);
	f->onpunch_replace_node = CONTENT_IRON_W_DOOR_LB;
	f->sound_punch = "env-doorclose";
	content_nodebox_doorol(f);
	f->type = CMT_STONE;
	f->dig_time = 2.0;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	f->energy_type = CET_DEVICE;
	if (f->initial_metadata == NULL)
		f->initial_metadata = new DoorNodeMetadata();
	i = CONTENT_IRON_W_DOOR_LT_OPEN;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Iron Windowed Door");
	f->setAllTextures("door_iron_wt.png");
	f->setTexture(3,"door_iron_wt.png^[transformFX");
	f->setInventoryTexture("door_iron_w_inv.png");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(CONTENT_IRON_W_DOOR_LT)+" 1";
	f->onact_also_affects = v3s16(0,-1,0);
	f->onpunch_replace_node = CONTENT_IRON_W_DOOR_LT;
	f->sound_punch = "env-doorclose";
	content_nodebox_doorwol(f);
	f->type = CMT_STONE;
	f->dig_time = 2.0;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	f->energy_type = CET_DEVICE;
	if (f->initial_metadata == NULL)
		f->initial_metadata = new DoorNodeMetadata();

	// right open doors
	i = CONTENT_WOOD_DOOR_RB_OPEN;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Right Hanging Wood Door");
	f->setAllTextures("door_wood_b.png");
	f->setTexture(3,"door_wood_b.png^[transformFX");
	f->setTexture(4,"door_wood_b.png^[transformFX");
	f->setTexture(5,"door_wood_b.png^[transformFX");
	f->setInventoryTexture("door_wood_inv.png^[transformFX");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(CONTENT_WOOD_DOOR_RT)+" 1";
	f->onact_also_affects = v3s16(0,1,0);
	f->onpunch_replace_node = CONTENT_WOOD_DOOR_RB;
	f->sound_punch = "env-doorclose";
	f->flammable = 1; // can be replaced by fire if the node under it is set on fire
	f->fuel_time = BT_DOOR;
	content_nodebox_dooror(f);
	f->type = CMT_WOOD;
	f->dig_time = 0.75;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	i = CONTENT_WOOD_DOOR_RT_OPEN;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Right Hanging Wood Door");
	f->setAllTextures("door_wood_t.png");
	f->setTexture(3,"door_wood_t.png^[transformFX");
	f->setTexture(4,"door_wood_t.png^[transformFX");
	f->setTexture(5,"door_wood_t.png^[transformFX");
	f->setInventoryTexture("door_wood_inv.png^[transformFX");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(CONTENT_WOOD_DOOR_RT)+" 1";
	f->onact_also_affects = v3s16(0,-1,0);
	f->onpunch_replace_node = CONTENT_WOOD_DOOR_RT;
	f->sound_punch = "env-doorclose";
	f->flammable = 1; // can be replaced by fire if the node under it is set on fire
	f->fuel_time = BT_DOOR;
	content_nodebox_dooror(f);
	f->type = CMT_WOOD;
	f->dig_time = 0.75;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;

	i = CONTENT_GLASS_DOOR_RB_OPEN;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Right Hanging Glass Door");
	f->setAllTextures("door_glass_b.png");
	f->setTexture(2,"door_glass_b.png^[transformFX");
	f->setTexture(3,"door_glass_b.png^[transformFX");
	f->setTexture(4,"door_glass_b.png^[transformFX");
#ifndef SERVER
	f->setAllTextureTypes(MATERIAL_ALPHA_BLEND);
#endif
	f->setInventoryTexture("door_glass_inv.png^[transformFX");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i+1)+" 1";
	f->onact_also_affects = v3s16(0,1,0);
	f->onpunch_replace_node = CONTENT_GLASS_DOOR_RB;
	f->sound_punch = "env-doorclose";
	f->fuel_time = BT_DOOR_GLASS;
	content_nodebox_dooror(f);
	f->type = CMT_GLASS;
	f->dig_time = 0.15;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	i = CONTENT_GLASS_DOOR_RT_OPEN;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Right Hanging Glass Door");
	f->setAllTextures("door_glass_t.png");
	f->setTexture(2,"door_glass_t.png^[transformFX");
	f->setTexture(3,"door_glass_t.png^[transformFX");
	f->setTexture(4,"door_glass_t.png^[transformFX");
#ifndef SERVER
	f->setAllTextureTypes(MATERIAL_ALPHA_BLEND);
#endif
	f->setInventoryTexture("door_glass_inv.png^[transformFX");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i)+" 1";
	f->onact_also_affects = v3s16(0,-1,0);
	f->onpunch_replace_node = CONTENT_GLASS_DOOR_RT;
	f->sound_punch = "env-doorclose";
	content_nodebox_dooror(f);
	f->type = CMT_GLASS;
	f->dig_time = 0.15;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;

	i = CONTENT_IRON_DOOR_RB_OPEN;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Right Hanging Iron Door");
	f->setAllTextures("door_iron_b.png");
	f->setTexture(3,"door_iron_b.png^[transformFX");
	f->setTexture(4,"door_iron_b.png^[transformFX");
	f->setTexture(5,"door_iron_b.png^[transformFX");
	f->setInventoryTexture("door_iron_inv.png^[transformFX");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(CONTENT_IRON_DOOR_RT)+" 1";
	f->onact_also_affects = v3s16(0,1,0);
	f->onpunch_replace_node = CONTENT_IRON_DOOR_RB;
	f->sound_punch = "env-doorclose";
	content_nodebox_dooror(f);
	f->type = CMT_STONE;
	f->dig_time = 2.0;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	f->energy_type = CET_DEVICE;
	if (f->initial_metadata == NULL)
		f->initial_metadata = new DoorNodeMetadata();
	i = CONTENT_IRON_DOOR_RT_OPEN;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Right Hanging Iron Door");
	f->setAllTextures("door_iron_b.png");
	f->setTexture(3,"door_iron_t.png^[transformFX");
	f->setTexture(4,"door_iron_t.png^[transformFX");
	f->setTexture(5,"door_iron_t.png^[transformFX");
	f->setInventoryTexture("door_iron_inv.png^[transformFX");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(CONTENT_IRON_DOOR_RT)+" 1";
	f->onact_also_affects = v3s16(0,-1,0);
	f->onpunch_replace_node = CONTENT_IRON_DOOR_RT;
	f->sound_punch = "env-doorclose";
	content_nodebox_dooror(f);
	f->type = CMT_STONE;
	f->dig_time = 2.0;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	f->energy_type = CET_DEVICE;
	if (f->initial_metadata == NULL)
		f->initial_metadata = new DoorNodeMetadata();

	i = CONTENT_WOOD_W_DOOR_RB_OPEN;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Right Hanging Wood Windowed Door");
	f->setAllTextures("door_wood_wb.png");
	f->setTexture(3,"door_wood_wb.png^[transformFX");
	f->setTexture(4,"door_wood_wb.png^[transformFX");
	f->setTexture(5,"door_wood_wb.png^[transformFX");
	f->setInventoryTexture("door_wood_w_inv.png^[transformFX");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(CONTENT_WOOD_W_DOOR_RT)+" 1";
	f->onact_also_affects = v3s16(0,1,0);
	f->onpunch_replace_node = CONTENT_WOOD_W_DOOR_RB;
	f->sound_punch = "env-doorclose";
	f->flammable = 1; // can be replaced by fire if the node under it is set on fire
	f->fuel_time = BT_DOOR;
	content_nodebox_dooror(f);
	f->type = CMT_WOOD;
	f->dig_time = 0.75;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	i = CONTENT_WOOD_W_DOOR_RT_OPEN;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Right Hanging Wood Windowed Door");
	f->setAllTextures("door_wood_wt.png");
	f->setTexture(3,"door_wood_wt.png^[transformFX");
	f->setTexture(4,"door_wood_wt.png^[transformFX");
	f->setTexture(5,"door_wood_wt.png^[transformFX");
	f->setInventoryTexture("door_wood_w_inv.png^[transformFX");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(CONTENT_WOOD_W_DOOR_RT)+" 1";
	f->onact_also_affects = v3s16(0,-1,0);
	f->onpunch_replace_node = CONTENT_WOOD_W_DOOR_RT;
	f->sound_punch = "env-doorclose";
	f->flammable = 1; // can be replaced by fire if the node under it is set on fire
	f->fuel_time = BT_DOOR;
	content_nodebox_doorwor(f);
	f->type = CMT_WOOD;
	f->dig_time = 0.75;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;

	i = CONTENT_IRON_W_DOOR_RB_OPEN;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Right Hanging Iron Windowed Door");
	f->setAllTextures("door_iron_wb.png");
	f->setTexture(3,"door_iron_wb.png^[transformFX");
	f->setTexture(4,"door_iron_wb.png^[transformFX");
	f->setTexture(5,"door_iron_wb.png^[transformFX");
	f->setInventoryTexture("door_iron_w_inv.png^[transformFX");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(CONTENT_IRON_W_DOOR_RT)+" 1";
	f->onact_also_affects = v3s16(0,1,0);
	f->onpunch_replace_node = CONTENT_IRON_W_DOOR_RB;
	f->sound_punch = "env-doorclose";
	content_nodebox_dooror(f);
	f->type = CMT_STONE;
	f->dig_time = 2.0;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	f->energy_type = CET_DEVICE;
	if (f->initial_metadata == NULL)
		f->initial_metadata = new DoorNodeMetadata();
	i = CONTENT_IRON_W_DOOR_RT_OPEN;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Right Hanging Iron Windowed Door");
	f->setAllTextures("door_iron_wt.png");
	f->setTexture(3,"door_iron_wt.png^[transformFX");
	f->setTexture(4,"door_iron_wt.png^[transformFX");
	f->setTexture(5,"door_iron_wt.png^[transformFX");
	f->setInventoryTexture("door_iron_w_inv.png^[transformFX");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(CONTENT_IRON_W_DOOR_RT)+" 1";
	f->onact_also_affects = v3s16(0,-1,0);
	f->onpunch_replace_node = CONTENT_IRON_W_DOOR_RT;
	f->sound_punch = "env-doorclose";
	content_nodebox_doorwor(f);
	f->type = CMT_STONE;
	f->dig_time = 2.0;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	f->energy_type = CET_DEVICE;
	if (f->initial_metadata == NULL)
		f->initial_metadata = new DoorNodeMetadata();

	// hatches
	i = CONTENT_WOOD_HATCH;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Wood Hatch");
	f->setAllTextures("hatch_wood.png");
	f->rotate_tile_with_nodebox = true;
	f->setInventoryTexture("hatch_wood_inv.png");
	f->wield_nodebox = false;
	f->air_equivalent = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i)+" 1";
	f->onpunch_replace_node = CONTENT_WOOD_HATCH_OPEN;
	f->sound_punch = "env-dooropen";
	f->flammable = 1; // can be replaced by fire if the node under it is set on fire
	f->fuel_time = BT_HATCH;
	content_nodebox_hatch(f);
	f->type = CMT_WOOD;
	f->dig_time = 0.75;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	crafting::setSoftBlockRecipe(CONTENT_CRAFTITEM_WOOD_PLANK,CONTENT_WOOD_HATCH);
	crafting::setSoftBlockRecipe(CONTENT_CRAFTITEM_JUNGLE_PLANK,CONTENT_WOOD_HATCH);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_IRON_HATCH;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Iron Hatch");
	f->setAllTextures("hatch_iron.png");
	f->rotate_tile_with_nodebox = true;
	f->setInventoryTexture("hatch_iron_inv.png");
	f->wield_nodebox = false;
	f->air_equivalent = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i)+" 1";
	f->onpunch_replace_node = CONTENT_IRON_HATCH_OPEN;
	f->sound_punch = "env-dooropen";
	content_nodebox_hatch(f);
	f->type = CMT_STONE;
	f->dig_time = 2.0;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	f->energy_type = CET_DEVICE;
	if (f->initial_metadata == NULL)
		f->initial_metadata = new DoorNodeMetadata();
	crafting::setSoftBlockRecipe(CONTENT_CRAFTITEM_IRON_INGOT,CONTENT_IRON_HATCH);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_WOOD_W_HATCH;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Wood Windowed Hatch");
	f->setAllTextures("hatch_wood_w.png");
	f->rotate_tile_with_nodebox = true;
	f->setInventoryTexture("hatch_wood_w_inv.png");
	f->wield_nodebox = false;
	f->air_equivalent = true;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i)+" 1";
	f->onpunch_replace_node = CONTENT_WOOD_W_HATCH_OPEN;
	f->sound_punch = "env-dooropen";
	f->flammable = 1; // can be replaced by fire if the node under it is set on fire
	f->fuel_time = BT_HATCH;
	content_nodebox_hatchw(f);
	f->type = CMT_WOOD;
	f->dig_time = 0.75;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	crafting::set1over1Recipe(CONTENT_GLASS,CONTENT_WOOD_HATCH,CONTENT_WOOD_W_HATCH);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_IRON_W_HATCH;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Iron Windowed Hatch");
	f->setAllTextures("hatch_iron_w.png");
	f->rotate_tile_with_nodebox = true;
	f->setInventoryTexture("hatch_iron_w_inv.png");
	f->wield_nodebox = false;
	f->air_equivalent = true;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i)+" 1";
	f->onpunch_replace_node = CONTENT_IRON_W_HATCH_OPEN;
	f->sound_punch = "env-dooropen";
	content_nodebox_hatchw(f);
	f->type = CMT_STONE;
	f->dig_time = 2.0;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	f->energy_type = CET_DEVICE;
	if (f->initial_metadata == NULL)
		f->initial_metadata = new DoorNodeMetadata();
	crafting::set1over1Recipe(CONTENT_GLASS,CONTENT_IRON_HATCH,CONTENT_IRON_W_HATCH);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	// gates
	i = CONTENT_WOOD_GATE;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Wood Gate");
	f->setAllTextures("wood.png");
	f->rotate_tile_with_nodebox = true;
	f->air_equivalent = true;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i)+" 1";
	f->onpunch_replace_node = CONTENT_WOOD_GATE_OPEN;
	f->sound_punch = "env-dooropen";
	f->flammable = 1; // can be replaced by fire if the node under it is set on fire
	f->fuel_time = BT_FENCE;
	content_nodebox_gate(f);
	f->setInventoryTextureNodeBox(i,"wood.png","wood.png","wood.png");
	f->type = CMT_WOOD;
	f->dig_time = 0.75;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	crafting::setGateRecipe(CONTENT_CRAFTITEM_WOOD_PLANK,CONTENT_WOOD,CONTENT_WOOD_GATE);
	crafting::setGateRecipe(CONTENT_CRAFTITEM_JUNGLE_PLANK,CONTENT_JUNGLEWOOD,CONTENT_WOOD_GATE);
	crafting::setGateRecipe(CONTENT_CRAFTITEM_WOOD_PLANK,CONTENT_JUNGLEWOOD,CONTENT_WOOD_GATE);
	crafting::setGateRecipe(CONTENT_CRAFTITEM_JUNGLE_PLANK,CONTENT_WOOD,CONTENT_WOOD_GATE);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	i = CONTENT_IRON_GATE;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Iron Gate");
	f->setAllTextures("iron_sheet.png");
	f->rotate_tile_with_nodebox = true;
	f->setInventoryTexture("gate_iron_inv.png");
	f->wield_nodebox = false;
	f->air_equivalent = true;
	f->jumpable = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->is_ground_content = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(i)+" 1";
	f->onpunch_replace_node = CONTENT_IRON_GATE_OPEN;
	f->sound_punch = "env-dooropen";
	content_nodebox_gate(f);
	f->type = CMT_STONE;
	f->dig_time = 2.0;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	f->energy_type = CET_DEVICE;
	if (f->initial_metadata == NULL)
		f->initial_metadata = new DoorNodeMetadata();
	crafting::setGateRecipe(CONTENT_CRAFTITEM_IRON_INGOT,CONTENT_IRON,CONTENT_IRON_GATE);
	content_list_add("craftguide",i,1,0);
	content_list_add("creative",i,1,0);

	// open hatches
	i = CONTENT_WOOD_HATCH_OPEN;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Wood Hatch");
	f->setAllTextures("hatch_wood.png");
	f->setTexture(2,"hatch_wood.png^[transformR90");
	f->setTexture(3,"hatch_wood.png^[transformR90");
	f->rotate_tile_with_nodebox = true;
	f->setInventoryTexture("hatch_wood_inv.png");
	f->wield_nodebox = false;
	f->air_equivalent = true;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->climbable = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(CONTENT_WOOD_HATCH)+" 1";
	f->onpunch_replace_node = CONTENT_WOOD_HATCH;
	f->sound_punch = "env-doorclose";
	f->flammable = 1; // can be replaced by fire if the node under it is set on fire
	f->fuel_time = BT_HATCH;
	content_nodebox_hatcho(f);
	f->type = CMT_WOOD;
	f->dig_time = 0.75;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;

	i = CONTENT_IRON_HATCH_OPEN;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Iron Hatch");
	f->setAllTextures("hatch_iron.png");
	f->setTexture(2,"hatch_iron.png^[transformR90");
	f->setTexture(3,"hatch_iron.png^[transformR90");
	f->rotate_tile_with_nodebox = true;
	f->setInventoryTexture("hatch_iron_inv.png");
	f->wield_nodebox = false;
	f->air_equivalent = true;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->climbable = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(CONTENT_IRON_HATCH)+" 1";
	f->onpunch_replace_node = CONTENT_IRON_HATCH;
	f->sound_punch = "env-doorclose";
	content_nodebox_hatcho(f);
	f->type = CMT_STONE;
	f->dig_time = 2.0;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	f->energy_type = CET_DEVICE;
	if (f->initial_metadata == NULL)
		f->initial_metadata = new DoorNodeMetadata();

	i = CONTENT_WOOD_W_HATCH_OPEN;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Wood Hatch");
	f->setAllTextures("hatch_wood_w.png");
	f->setTexture(2,"hatch_wood.png^[transformR90");
	f->setTexture(3,"hatch_wood.png^[transformR90");
	f->rotate_tile_with_nodebox = true;
	f->setInventoryTexture("hatch_wood_w_inv.png");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->air_equivalent = true;
	f->light_propagates = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->climbable = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(CONTENT_WOOD_W_HATCH)+" 1";
	f->onpunch_replace_node = CONTENT_WOOD_W_HATCH;
	f->sound_punch = "env-doorclose";
	f->flammable = 1; // can be replaced by fire if the node under it is set on fire
	f->fuel_time = BT_HATCH;
	content_nodebox_hatchwo(f);
	f->type = CMT_WOOD;
	f->dig_time = 0.75;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;

	i = CONTENT_IRON_W_HATCH_OPEN;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Iron Hatch");
	f->setAllTextures("hatch_iron_w.png");
	f->setTexture(2,"hatch_iron.png^[transformR90");
	f->setTexture(3,"hatch_iron.png^[transformR90");
	f->rotate_tile_with_nodebox = true;
	f->setInventoryTexture("hatch_iron_w_inv.png");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->draw_type = CDT_NODEBOX;
	f->climbable = true;
	f->dug_item = std::string("MaterialItem2 ")+itos(CONTENT_IRON_W_HATCH)+" 1";
	f->onpunch_replace_node = CONTENT_IRON_W_HATCH;
	f->sound_punch = "env-doorclose";
	content_nodebox_hatchwo(f);
	f->type = CMT_STONE;
	f->dig_time = 2.0;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	f->energy_type = CET_DEVICE;
	if (f->initial_metadata == NULL)
		f->initial_metadata = new DoorNodeMetadata();

	// open gates
	i = CONTENT_WOOD_GATE_OPEN;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Wood Gate");
	f->setAllTextures("wood.png");
	f->rotate_tile_with_nodebox = true;
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->walkable = false;
	f->draw_type = CDT_NODEBOX;
	f->dug_item = std::string("MaterialItem2 ")+itos(CONTENT_WOOD_GATE)+" 1";
	f->onpunch_replace_node = CONTENT_WOOD_GATE;
	f->sound_punch = "env-doorclose";
	f->flammable = 1; // can be replaced by fire if the node under it is set on fire
	f->fuel_time = BT_FENCE;
	content_nodebox_gateo(f);
	f->type = CMT_WOOD;
	f->dig_time = 0.75;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;

	i = CONTENT_IRON_GATE_OPEN;
	f = &content_features(i);
	f->param2_type = CPT_FACEDIR_SIMPLE;
	f->description = gettext("Iron Gate");
	f->setAllTextures("iron_sheet.png");
	f->rotate_tile_with_nodebox = true;
	f->setInventoryTexture("gate_iron_inv.png");
	f->wield_nodebox = false;
	f->param_type = CPT_LIGHT;
	f->light_propagates = true;
	f->air_equivalent = true;
	f->sunlight_propagates = true;
	f->walkable = false;
	f->draw_type = CDT_NODEBOX;
	f->dug_item = std::string("MaterialItem2 ")+itos(CONTENT_IRON_GATE)+" 1";
	f->onpunch_replace_node = CONTENT_IRON_GATE;
	f->sound_punch = "env-doorclose";
	content_nodebox_gateo(f);
	f->type = CMT_STONE;
	f->dig_time = 2.0;
	f->pressure_type = CST_SOLID;
	f->suffocation_per_second = 0;
	f->energy_type = CET_DEVICE;
	if (f->initial_metadata == NULL)
		f->initial_metadata = new DoorNodeMetadata();
}
