/************************************************************************
* Minetest-c55
* Copyright (C) 2010 celeron55, Perttu Ahola <celeron55@gmail.com>
*
* strfnd.h
* voxelands - 3d voxel world sandbox game
* Copyright (C) Lisa 'darkrose' Milne 2014 <lisa@ltmnet.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
* See the GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
*
* License updated from GPLv2 or later to GPLv3 or later by Lisa Milne
* for Voxelands.
************************************************************************/

#ifndef STRFND_HEADER
#define STRFND_HEADER

#include <string>

std::string trim(const std::string &str);

class Strfnd{
	std::string tek;
	unsigned int p;
public:
	void start(std::string niinq)
	{
		tek = niinq;
		p=0;
	}
	unsigned int where()
	{
		return p;
	}
	void to(unsigned int i)
	{
		p = i;
	}
	std::string what()
	{
		return tek;
	}
	std::string next(std::string plop)
	{
		size_t n;
		std::string palautus;
		if (p < tek.size()) {
			if ((n = tek.find(plop, p)) == std::string::npos || plop == "")
				n = tek.size();
			palautus = tek.substr(p, n-p);
			p = n + plop.length();
		}
		return palautus;
	}
	std::string end()
	{
		return tek.substr(p,tek.size()-p);
	}
	bool atend()
	{
		if (p>=tek.size())
			return true;
		return false;
	}
	Strfnd(std::string s)
	{
		start(s);
	}
};

class WStrfnd{
	std::wstring tek;
	unsigned int p;
public:
	void start(std::wstring niinq){
		tek = niinq;
		p=0;
	}
	unsigned int where(){
		return p;
	}
	void to(unsigned int i){
		p = i;
	}
	std::wstring what(){
		return tek;
	}
	std::wstring next(std::wstring plop){
		//std::cout<<"tek=\""<<tek<<"\" plop=\""<<plop<<"\""<<std::endl;
		size_t n;
		std::wstring palautus;
		if (p < tek.size())
		{
			//std::cout<<"\tp<tek.size()"<<std::endl;
			if ((n = tek.find(plop, p)) == std::wstring::npos || plop == L"")
			{
				//std::cout<<"\t\tn == string::npos || plop == \"\""<<std::endl;
				n = tek.size();
			}
			else
			{
				//std::cout<<"\t\tn != string::npos"<<std::endl;
			}
			palautus = tek.substr(p, n-p);
			p = n + plop.length();
		}
		//else
			//std::cout<<"\tp>=tek.size()"<<std::endl;
		//std::cout<<"palautus=\""<<palautus<<"\""<<std::endl;
		return palautus;
	}
	std::wstring end()
	{
		return tek.substr(p,tek.size()-p);
	}
	bool atend(){
		if(p>=tek.size()) return true;
		return false;
	}
	WStrfnd(std::wstring s){
		start(s);
	}
};

inline std::string trim(const std::string &s)
{
	std::string str = s;
	while(
			str.length()>0
			&&
			(
			str.substr(0,               1)==" "     ||
			str.substr(0,               1)=="\t"    ||
			str.substr(0,               1)=="\r"    ||
			str.substr(0,               1)=="\n"    ||
			str.substr(str.length()-1,  1)==" "     ||
			str.substr(str.length()-1,  1)=="\t"    ||
			str.substr(str.length()-1,  1)=="\r"    ||
			str.substr(str.length()-1,  1)=="\n"
			)
		)
	{
		if      (str.substr(0,              1)==" ")
			str = str.substr(1,str.length()-1);
		else if (str.substr(0,              1)=="\t")
			str = str.substr(1,str.length()-1);
		else if (str.substr(0,              1)=="\r")
			str = str.substr(1,str.length()-1);
		else if (str.substr(0,              1)=="\n")
			str = str.substr(1,str.length()-1);
		else if (str.substr(str.length()-1, 1)==" ")
			str = str.substr(0,str.length()-1);
		else if (str.substr(str.length()-1, 1)=="\t")
			str = str.substr(0,str.length()-1);
		else if (str.substr(str.length()-1, 1)=="\r")
			str = str.substr(0,str.length()-1);
		else if (str.substr(str.length()-1, 1)=="\n")
			str = str.substr(0,str.length()-1);
	}
	return str;
}

#endif

