/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGAPTDemodActions_aos.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGAPTDemodActions_aos::SWGAPTDemodActions_aos(QString* json) {
    init();
    this->fromJson(*json);
}

SWGAPTDemodActions_aos::SWGAPTDemodActions_aos() {
    satellite_name = nullptr;
    m_satellite_name_isSet = false;
    north_to_south_pass = 0;
    m_north_to_south_pass_isSet = false;
    tle = nullptr;
    m_tle_isSet = false;
    date_time = nullptr;
    m_date_time_isSet = false;
}

SWGAPTDemodActions_aos::~SWGAPTDemodActions_aos() {
    this->cleanup();
}

void
SWGAPTDemodActions_aos::init() {
    satellite_name = new QString("");
    m_satellite_name_isSet = false;
    north_to_south_pass = 0;
    m_north_to_south_pass_isSet = false;
    tle = new QString("");
    m_tle_isSet = false;
    date_time = new QString("");
    m_date_time_isSet = false;
}

void
SWGAPTDemodActions_aos::cleanup() {
    if(satellite_name != nullptr) { 
        delete satellite_name;
    }

    if(tle != nullptr) { 
        delete tle;
    }
    if(date_time != nullptr) { 
        delete date_time;
    }
}

SWGAPTDemodActions_aos*
SWGAPTDemodActions_aos::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGAPTDemodActions_aos::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&satellite_name, pJson["satelliteName"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&north_to_south_pass, pJson["northToSouthPass"], "qint32", "");
    
    ::SWGSDRangel::setValue(&tle, pJson["tle"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&date_time, pJson["dateTime"], "QString", "QString");
    
}

QString
SWGAPTDemodActions_aos::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGAPTDemodActions_aos::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(satellite_name != nullptr && *satellite_name != QString("")){
        toJsonValue(QString("satelliteName"), satellite_name, obj, QString("QString"));
    }
    if(m_north_to_south_pass_isSet){
        obj->insert("northToSouthPass", QJsonValue(north_to_south_pass));
    }
    if(tle != nullptr && *tle != QString("")){
        toJsonValue(QString("tle"), tle, obj, QString("QString"));
    }
    if(date_time != nullptr && *date_time != QString("")){
        toJsonValue(QString("dateTime"), date_time, obj, QString("QString"));
    }

    return obj;
}

QString*
SWGAPTDemodActions_aos::getSatelliteName() {
    return satellite_name;
}
void
SWGAPTDemodActions_aos::setSatelliteName(QString* satellite_name) {
    this->satellite_name = satellite_name;
    this->m_satellite_name_isSet = true;
}

qint32
SWGAPTDemodActions_aos::getNorthToSouthPass() {
    return north_to_south_pass;
}
void
SWGAPTDemodActions_aos::setNorthToSouthPass(qint32 north_to_south_pass) {
    this->north_to_south_pass = north_to_south_pass;
    this->m_north_to_south_pass_isSet = true;
}

QString*
SWGAPTDemodActions_aos::getTle() {
    return tle;
}
void
SWGAPTDemodActions_aos::setTle(QString* tle) {
    this->tle = tle;
    this->m_tle_isSet = true;
}

QString*
SWGAPTDemodActions_aos::getDateTime() {
    return date_time;
}
void
SWGAPTDemodActions_aos::setDateTime(QString* date_time) {
    this->date_time = date_time;
    this->m_date_time_isSet = true;
}


bool
SWGAPTDemodActions_aos::isSet(){
    bool isObjectUpdated = false;
    do{
        if(satellite_name && *satellite_name != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_north_to_south_pass_isSet){
            isObjectUpdated = true; break;
        }
        if(tle && *tle != QString("")){
            isObjectUpdated = true; break;
        }
        if(date_time && *date_time != QString("")){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

