/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGChannelSettings.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGChannelSettings::SWGChannelSettings(QString* json) {
    init();
    this->fromJson(*json);
}

SWGChannelSettings::SWGChannelSettings() {
    channel_type = nullptr;
    m_channel_type_isSet = false;
    direction = 0;
    m_direction_isSet = false;
    originator_device_set_index = 0;
    m_originator_device_set_index_isSet = false;
    originator_channel_index = 0;
    m_originator_channel_index_isSet = false;
    adsb_demod_settings = nullptr;
    m_adsb_demod_settings_isSet = false;
    ais_demod_settings = nullptr;
    m_ais_demod_settings_isSet = false;
    ais_mod_settings = nullptr;
    m_ais_mod_settings_isSet = false;
    am_demod_settings = nullptr;
    m_am_demod_settings_isSet = false;
    am_mod_settings = nullptr;
    m_am_mod_settings_isSet = false;
    apt_demod_settings = nullptr;
    m_apt_demod_settings_isSet = false;
    atv_demod_settings = nullptr;
    m_atv_demod_settings_isSet = false;
    atv_mod_settings = nullptr;
    m_atv_mod_settings_isSet = false;
    beam_steering_cw_mod_settings = nullptr;
    m_beam_steering_cw_mod_settings_isSet = false;
    bfm_demod_settings = nullptr;
    m_bfm_demod_settings_isSet = false;
    channel_analyzer_settings = nullptr;
    m_channel_analyzer_settings_isSet = false;
    channel_power_settings = nullptr;
    m_channel_power_settings_isSet = false;
    chirp_chat_demod_settings = nullptr;
    m_chirp_chat_demod_settings_isSet = false;
    chirp_chat_mod_settings = nullptr;
    m_chirp_chat_mod_settings_isSet = false;
    datv_mod_settings = nullptr;
    m_datv_mod_settings_isSet = false;
    datv_demod_settings = nullptr;
    m_datv_demod_settings_isSet = false;
    dab_demod_settings = nullptr;
    m_dab_demod_settings_isSet = false;
    doa2_settings = nullptr;
    m_doa2_settings_isSet = false;
    dsc_demod_settings = nullptr;
    m_dsc_demod_settings_isSet = false;
    dsd_demod_settings = nullptr;
    m_dsd_demod_settings_isSet = false;
    end_of_train_demod_settings = nullptr;
    m_end_of_train_demod_settings_isSet = false;
    file_sink_settings = nullptr;
    m_file_sink_settings_isSet = false;
    file_source_settings = nullptr;
    m_file_source_settings_isSet = false;
    free_dv_demod_settings = nullptr;
    m_free_dv_demod_settings_isSet = false;
    free_dv_mod_settings = nullptr;
    m_free_dv_mod_settings_isSet = false;
    freq_scanner_settings = nullptr;
    m_freq_scanner_settings_isSet = false;
    freq_tracker_settings = nullptr;
    m_freq_tracker_settings_isSet = false;
    ft8_demod_settings = nullptr;
    m_ft8_demod_settings_isSet = false;
    heat_map_settings = nullptr;
    m_heat_map_settings_isSet = false;
    ils_demod_settings = nullptr;
    m_ils_demod_settings_isSet = false;
    interferometer_settings = nullptr;
    m_interferometer_settings_isSet = false;
    ieee_802_15_4_mod_settings = nullptr;
    m_ieee_802_15_4_mod_settings_isSet = false;
    m17_demod_settings = nullptr;
    m_m17_demod_settings_isSet = false;
    m17_mod_settings = nullptr;
    m_m17_mod_settings_isSet = false;
    navtex_demod_settings = nullptr;
    m_navtex_demod_settings_isSet = false;
    nfm_demod_settings = nullptr;
    m_nfm_demod_settings_isSet = false;
    nfm_mod_settings = nullptr;
    m_nfm_mod_settings_isSet = false;
    noise_figure_settings = nullptr;
    m_noise_figure_settings_isSet = false;
    local_sink_settings = nullptr;
    m_local_sink_settings_isSet = false;
    local_source_settings = nullptr;
    m_local_source_settings_isSet = false;
    packet_demod_settings = nullptr;
    m_packet_demod_settings_isSet = false;
    packet_mod_settings = nullptr;
    m_packet_mod_settings_isSet = false;
    pager_demod_settings = nullptr;
    m_pager_demod_settings_isSet = false;
    psk31_mod_settings = nullptr;
    m_psk31_mod_settings_isSet = false;
    radio_astronomy_settings = nullptr;
    m_radio_astronomy_settings_isSet = false;
    radio_clock_settings = nullptr;
    m_radio_clock_settings_isSet = false;
    radiosonde_demod_settings = nullptr;
    m_radiosonde_demod_settings_isSet = false;
    remote_sink_settings = nullptr;
    m_remote_sink_settings_isSet = false;
    remote_source_settings = nullptr;
    m_remote_source_settings_isSet = false;
    remote_tcp_sink_settings = nullptr;
    m_remote_tcp_sink_settings_isSet = false;
    rtty_demod_settings = nullptr;
    m_rtty_demod_settings_isSet = false;
    rtty_mod_settings = nullptr;
    m_rtty_mod_settings_isSet = false;
    sig_mf_file_sink_settings = nullptr;
    m_sig_mf_file_sink_settings_isSet = false;
    ssb_mod_settings = nullptr;
    m_ssb_mod_settings_isSet = false;
    ssb_demod_settings = nullptr;
    m_ssb_demod_settings_isSet = false;
    udp_source_settings = nullptr;
    m_udp_source_settings_isSet = false;
    udp_sink_settings = nullptr;
    m_udp_sink_settings_isSet = false;
    vor_demod_settings = nullptr;
    m_vor_demod_settings_isSet = false;
    wdsp_rx_settings = nullptr;
    m_wdsp_rx_settings_isSet = false;
    wfm_demod_settings = nullptr;
    m_wfm_demod_settings_isSet = false;
    wfm_mod_settings = nullptr;
    m_wfm_mod_settings_isSet = false;
}

SWGChannelSettings::~SWGChannelSettings() {
    this->cleanup();
}

void
SWGChannelSettings::init() {
    channel_type = new QString("");
    m_channel_type_isSet = false;
    direction = 0;
    m_direction_isSet = false;
    originator_device_set_index = 0;
    m_originator_device_set_index_isSet = false;
    originator_channel_index = 0;
    m_originator_channel_index_isSet = false;
    adsb_demod_settings = new SWGADSBDemodSettings();
    m_adsb_demod_settings_isSet = false;
    ais_demod_settings = new SWGAISDemodSettings();
    m_ais_demod_settings_isSet = false;
    ais_mod_settings = new SWGAISModSettings();
    m_ais_mod_settings_isSet = false;
    am_demod_settings = new SWGAMDemodSettings();
    m_am_demod_settings_isSet = false;
    am_mod_settings = new SWGAMModSettings();
    m_am_mod_settings_isSet = false;
    apt_demod_settings = new SWGAPTDemodSettings();
    m_apt_demod_settings_isSet = false;
    atv_demod_settings = new SWGATVDemodSettings();
    m_atv_demod_settings_isSet = false;
    atv_mod_settings = new SWGATVModSettings();
    m_atv_mod_settings_isSet = false;
    beam_steering_cw_mod_settings = new SWGBeamSteeringCWModSettings();
    m_beam_steering_cw_mod_settings_isSet = false;
    bfm_demod_settings = new SWGBFMDemodSettings();
    m_bfm_demod_settings_isSet = false;
    channel_analyzer_settings = new SWGChannelAnalyzerSettings();
    m_channel_analyzer_settings_isSet = false;
    channel_power_settings = new SWGChannelPowerSettings();
    m_channel_power_settings_isSet = false;
    chirp_chat_demod_settings = new SWGChirpChatDemodSettings();
    m_chirp_chat_demod_settings_isSet = false;
    chirp_chat_mod_settings = new SWGChirpChatModSettings();
    m_chirp_chat_mod_settings_isSet = false;
    datv_mod_settings = new SWGDATVModSettings();
    m_datv_mod_settings_isSet = false;
    datv_demod_settings = new SWGDATVDemodSettings();
    m_datv_demod_settings_isSet = false;
    dab_demod_settings = new SWGDABDemodSettings();
    m_dab_demod_settings_isSet = false;
    doa2_settings = new SWGDOA2Settings();
    m_doa2_settings_isSet = false;
    dsc_demod_settings = new SWGDSCDemodSettings();
    m_dsc_demod_settings_isSet = false;
    dsd_demod_settings = new SWGDSDDemodSettings();
    m_dsd_demod_settings_isSet = false;
    end_of_train_demod_settings = new SWGEndOfTrainDemodSettings();
    m_end_of_train_demod_settings_isSet = false;
    file_sink_settings = new SWGFileSinkSettings();
    m_file_sink_settings_isSet = false;
    file_source_settings = new SWGFileSourceSettings();
    m_file_source_settings_isSet = false;
    free_dv_demod_settings = new SWGFreeDVDemodSettings();
    m_free_dv_demod_settings_isSet = false;
    free_dv_mod_settings = new SWGFreeDVModSettings();
    m_free_dv_mod_settings_isSet = false;
    freq_scanner_settings = new SWGFreqScannerSettings();
    m_freq_scanner_settings_isSet = false;
    freq_tracker_settings = new SWGFreqTrackerSettings();
    m_freq_tracker_settings_isSet = false;
    ft8_demod_settings = new SWGFT8DemodSettings();
    m_ft8_demod_settings_isSet = false;
    heat_map_settings = new SWGHeatMapSettings();
    m_heat_map_settings_isSet = false;
    ils_demod_settings = new SWGILSDemodSettings();
    m_ils_demod_settings_isSet = false;
    interferometer_settings = new SWGInterferometerSettings();
    m_interferometer_settings_isSet = false;
    ieee_802_15_4_mod_settings = new SWGIEEE_802_15_4_ModSettings();
    m_ieee_802_15_4_mod_settings_isSet = false;
    m17_demod_settings = new SWGM17DemodSettings();
    m_m17_demod_settings_isSet = false;
    m17_mod_settings = new SWGM17ModSettings();
    m_m17_mod_settings_isSet = false;
    navtex_demod_settings = new SWGNavtexDemodSettings();
    m_navtex_demod_settings_isSet = false;
    nfm_demod_settings = new SWGNFMDemodSettings();
    m_nfm_demod_settings_isSet = false;
    nfm_mod_settings = new SWGNFMModSettings();
    m_nfm_mod_settings_isSet = false;
    noise_figure_settings = new SWGNoiseFigureSettings();
    m_noise_figure_settings_isSet = false;
    local_sink_settings = new SWGLocalSinkSettings();
    m_local_sink_settings_isSet = false;
    local_source_settings = new SWGLocalSourceSettings();
    m_local_source_settings_isSet = false;
    packet_demod_settings = new SWGPacketDemodSettings();
    m_packet_demod_settings_isSet = false;
    packet_mod_settings = new SWGPacketModSettings();
    m_packet_mod_settings_isSet = false;
    pager_demod_settings = new SWGPagerDemodSettings();
    m_pager_demod_settings_isSet = false;
    psk31_mod_settings = new SWGPSK31ModSettings();
    m_psk31_mod_settings_isSet = false;
    radio_astronomy_settings = new SWGRadioAstronomySettings();
    m_radio_astronomy_settings_isSet = false;
    radio_clock_settings = new SWGRadioClockSettings();
    m_radio_clock_settings_isSet = false;
    radiosonde_demod_settings = new SWGRadiosondeDemodSettings();
    m_radiosonde_demod_settings_isSet = false;
    remote_sink_settings = new SWGRemoteSinkSettings();
    m_remote_sink_settings_isSet = false;
    remote_source_settings = new SWGRemoteSourceSettings();
    m_remote_source_settings_isSet = false;
    remote_tcp_sink_settings = new SWGRemoteTCPSinkSettings();
    m_remote_tcp_sink_settings_isSet = false;
    rtty_demod_settings = new SWGRTTYDemodSettings();
    m_rtty_demod_settings_isSet = false;
    rtty_mod_settings = new SWGRTTYModSettings();
    m_rtty_mod_settings_isSet = false;
    sig_mf_file_sink_settings = new SWGSigMFFileSinkSettings();
    m_sig_mf_file_sink_settings_isSet = false;
    ssb_mod_settings = new SWGSSBModSettings();
    m_ssb_mod_settings_isSet = false;
    ssb_demod_settings = new SWGSSBDemodSettings();
    m_ssb_demod_settings_isSet = false;
    udp_source_settings = new SWGUDPSourceSettings();
    m_udp_source_settings_isSet = false;
    udp_sink_settings = new SWGUDPSinkSettings();
    m_udp_sink_settings_isSet = false;
    vor_demod_settings = new SWGVORDemodSettings();
    m_vor_demod_settings_isSet = false;
    wdsp_rx_settings = new SWGWDSPRxSettings();
    m_wdsp_rx_settings_isSet = false;
    wfm_demod_settings = new SWGWFMDemodSettings();
    m_wfm_demod_settings_isSet = false;
    wfm_mod_settings = new SWGWFMModSettings();
    m_wfm_mod_settings_isSet = false;
}

void
SWGChannelSettings::cleanup() {
    if(channel_type != nullptr) { 
        delete channel_type;
    }



    if(adsb_demod_settings != nullptr) { 
        delete adsb_demod_settings;
    }
    if(ais_demod_settings != nullptr) { 
        delete ais_demod_settings;
    }
    if(ais_mod_settings != nullptr) { 
        delete ais_mod_settings;
    }
    if(am_demod_settings != nullptr) { 
        delete am_demod_settings;
    }
    if(am_mod_settings != nullptr) { 
        delete am_mod_settings;
    }
    if(apt_demod_settings != nullptr) { 
        delete apt_demod_settings;
    }
    if(atv_demod_settings != nullptr) { 
        delete atv_demod_settings;
    }
    if(atv_mod_settings != nullptr) { 
        delete atv_mod_settings;
    }
    if(beam_steering_cw_mod_settings != nullptr) { 
        delete beam_steering_cw_mod_settings;
    }
    if(bfm_demod_settings != nullptr) { 
        delete bfm_demod_settings;
    }
    if(channel_analyzer_settings != nullptr) { 
        delete channel_analyzer_settings;
    }
    if(channel_power_settings != nullptr) { 
        delete channel_power_settings;
    }
    if(chirp_chat_demod_settings != nullptr) { 
        delete chirp_chat_demod_settings;
    }
    if(chirp_chat_mod_settings != nullptr) { 
        delete chirp_chat_mod_settings;
    }
    if(datv_mod_settings != nullptr) { 
        delete datv_mod_settings;
    }
    if(datv_demod_settings != nullptr) { 
        delete datv_demod_settings;
    }
    if(dab_demod_settings != nullptr) { 
        delete dab_demod_settings;
    }
    if(doa2_settings != nullptr) { 
        delete doa2_settings;
    }
    if(dsc_demod_settings != nullptr) { 
        delete dsc_demod_settings;
    }
    if(dsd_demod_settings != nullptr) { 
        delete dsd_demod_settings;
    }
    if(end_of_train_demod_settings != nullptr) { 
        delete end_of_train_demod_settings;
    }
    if(file_sink_settings != nullptr) { 
        delete file_sink_settings;
    }
    if(file_source_settings != nullptr) { 
        delete file_source_settings;
    }
    if(free_dv_demod_settings != nullptr) { 
        delete free_dv_demod_settings;
    }
    if(free_dv_mod_settings != nullptr) { 
        delete free_dv_mod_settings;
    }
    if(freq_scanner_settings != nullptr) { 
        delete freq_scanner_settings;
    }
    if(freq_tracker_settings != nullptr) { 
        delete freq_tracker_settings;
    }
    if(ft8_demod_settings != nullptr) { 
        delete ft8_demod_settings;
    }
    if(heat_map_settings != nullptr) { 
        delete heat_map_settings;
    }
    if(ils_demod_settings != nullptr) { 
        delete ils_demod_settings;
    }
    if(interferometer_settings != nullptr) { 
        delete interferometer_settings;
    }
    if(ieee_802_15_4_mod_settings != nullptr) { 
        delete ieee_802_15_4_mod_settings;
    }
    if(m17_demod_settings != nullptr) { 
        delete m17_demod_settings;
    }
    if(m17_mod_settings != nullptr) { 
        delete m17_mod_settings;
    }
    if(navtex_demod_settings != nullptr) { 
        delete navtex_demod_settings;
    }
    if(nfm_demod_settings != nullptr) { 
        delete nfm_demod_settings;
    }
    if(nfm_mod_settings != nullptr) { 
        delete nfm_mod_settings;
    }
    if(noise_figure_settings != nullptr) { 
        delete noise_figure_settings;
    }
    if(local_sink_settings != nullptr) { 
        delete local_sink_settings;
    }
    if(local_source_settings != nullptr) { 
        delete local_source_settings;
    }
    if(packet_demod_settings != nullptr) { 
        delete packet_demod_settings;
    }
    if(packet_mod_settings != nullptr) { 
        delete packet_mod_settings;
    }
    if(pager_demod_settings != nullptr) { 
        delete pager_demod_settings;
    }
    if(psk31_mod_settings != nullptr) { 
        delete psk31_mod_settings;
    }
    if(radio_astronomy_settings != nullptr) { 
        delete radio_astronomy_settings;
    }
    if(radio_clock_settings != nullptr) { 
        delete radio_clock_settings;
    }
    if(radiosonde_demod_settings != nullptr) { 
        delete radiosonde_demod_settings;
    }
    if(remote_sink_settings != nullptr) { 
        delete remote_sink_settings;
    }
    if(remote_source_settings != nullptr) { 
        delete remote_source_settings;
    }
    if(remote_tcp_sink_settings != nullptr) { 
        delete remote_tcp_sink_settings;
    }
    if(rtty_demod_settings != nullptr) { 
        delete rtty_demod_settings;
    }
    if(rtty_mod_settings != nullptr) { 
        delete rtty_mod_settings;
    }
    if(sig_mf_file_sink_settings != nullptr) { 
        delete sig_mf_file_sink_settings;
    }
    if(ssb_mod_settings != nullptr) { 
        delete ssb_mod_settings;
    }
    if(ssb_demod_settings != nullptr) { 
        delete ssb_demod_settings;
    }
    if(udp_source_settings != nullptr) { 
        delete udp_source_settings;
    }
    if(udp_sink_settings != nullptr) { 
        delete udp_sink_settings;
    }
    if(vor_demod_settings != nullptr) { 
        delete vor_demod_settings;
    }
    if(wdsp_rx_settings != nullptr) { 
        delete wdsp_rx_settings;
    }
    if(wfm_demod_settings != nullptr) { 
        delete wfm_demod_settings;
    }
    if(wfm_mod_settings != nullptr) { 
        delete wfm_mod_settings;
    }
}

SWGChannelSettings*
SWGChannelSettings::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGChannelSettings::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&channel_type, pJson["channelType"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&direction, pJson["direction"], "qint32", "");
    
    ::SWGSDRangel::setValue(&originator_device_set_index, pJson["originatorDeviceSetIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&originator_channel_index, pJson["originatorChannelIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&adsb_demod_settings, pJson["ADSBDemodSettings"], "SWGADSBDemodSettings", "SWGADSBDemodSettings");
    
    ::SWGSDRangel::setValue(&ais_demod_settings, pJson["AISDemodSettings"], "SWGAISDemodSettings", "SWGAISDemodSettings");
    
    ::SWGSDRangel::setValue(&ais_mod_settings, pJson["AISModSettings"], "SWGAISModSettings", "SWGAISModSettings");
    
    ::SWGSDRangel::setValue(&am_demod_settings, pJson["AMDemodSettings"], "SWGAMDemodSettings", "SWGAMDemodSettings");
    
    ::SWGSDRangel::setValue(&am_mod_settings, pJson["AMModSettings"], "SWGAMModSettings", "SWGAMModSettings");
    
    ::SWGSDRangel::setValue(&apt_demod_settings, pJson["APTDemodSettings"], "SWGAPTDemodSettings", "SWGAPTDemodSettings");
    
    ::SWGSDRangel::setValue(&atv_demod_settings, pJson["ATVDemodSettings"], "SWGATVDemodSettings", "SWGATVDemodSettings");
    
    ::SWGSDRangel::setValue(&atv_mod_settings, pJson["ATVModSettings"], "SWGATVModSettings", "SWGATVModSettings");
    
    ::SWGSDRangel::setValue(&beam_steering_cw_mod_settings, pJson["BeamSteeringCWModSettings"], "SWGBeamSteeringCWModSettings", "SWGBeamSteeringCWModSettings");
    
    ::SWGSDRangel::setValue(&bfm_demod_settings, pJson["BFMDemodSettings"], "SWGBFMDemodSettings", "SWGBFMDemodSettings");
    
    ::SWGSDRangel::setValue(&channel_analyzer_settings, pJson["ChannelAnalyzerSettings"], "SWGChannelAnalyzerSettings", "SWGChannelAnalyzerSettings");
    
    ::SWGSDRangel::setValue(&channel_power_settings, pJson["ChannelPowerSettings"], "SWGChannelPowerSettings", "SWGChannelPowerSettings");
    
    ::SWGSDRangel::setValue(&chirp_chat_demod_settings, pJson["ChirpChatDemodSettings"], "SWGChirpChatDemodSettings", "SWGChirpChatDemodSettings");
    
    ::SWGSDRangel::setValue(&chirp_chat_mod_settings, pJson["ChirpChatModSettings"], "SWGChirpChatModSettings", "SWGChirpChatModSettings");
    
    ::SWGSDRangel::setValue(&datv_mod_settings, pJson["DATVModSettings"], "SWGDATVModSettings", "SWGDATVModSettings");
    
    ::SWGSDRangel::setValue(&datv_demod_settings, pJson["DATVDemodSettings"], "SWGDATVDemodSettings", "SWGDATVDemodSettings");
    
    ::SWGSDRangel::setValue(&dab_demod_settings, pJson["DABDemodSettings"], "SWGDABDemodSettings", "SWGDABDemodSettings");
    
    ::SWGSDRangel::setValue(&doa2_settings, pJson["DOA2Settings"], "SWGDOA2Settings", "SWGDOA2Settings");
    
    ::SWGSDRangel::setValue(&dsc_demod_settings, pJson["DSCDemodSettings"], "SWGDSCDemodSettings", "SWGDSCDemodSettings");
    
    ::SWGSDRangel::setValue(&dsd_demod_settings, pJson["DSDDemodSettings"], "SWGDSDDemodSettings", "SWGDSDDemodSettings");
    
    ::SWGSDRangel::setValue(&end_of_train_demod_settings, pJson["EndOfTrainDemodSettings"], "SWGEndOfTrainDemodSettings", "SWGEndOfTrainDemodSettings");
    
    ::SWGSDRangel::setValue(&file_sink_settings, pJson["FileSinkSettings"], "SWGFileSinkSettings", "SWGFileSinkSettings");
    
    ::SWGSDRangel::setValue(&file_source_settings, pJson["FileSourceSettings"], "SWGFileSourceSettings", "SWGFileSourceSettings");
    
    ::SWGSDRangel::setValue(&free_dv_demod_settings, pJson["FreeDVDemodSettings"], "SWGFreeDVDemodSettings", "SWGFreeDVDemodSettings");
    
    ::SWGSDRangel::setValue(&free_dv_mod_settings, pJson["FreeDVModSettings"], "SWGFreeDVModSettings", "SWGFreeDVModSettings");
    
    ::SWGSDRangel::setValue(&freq_scanner_settings, pJson["FreqScannerSettings"], "SWGFreqScannerSettings", "SWGFreqScannerSettings");
    
    ::SWGSDRangel::setValue(&freq_tracker_settings, pJson["FreqTrackerSettings"], "SWGFreqTrackerSettings", "SWGFreqTrackerSettings");
    
    ::SWGSDRangel::setValue(&ft8_demod_settings, pJson["FT8DemodSettings"], "SWGFT8DemodSettings", "SWGFT8DemodSettings");
    
    ::SWGSDRangel::setValue(&heat_map_settings, pJson["HeatMapSettings"], "SWGHeatMapSettings", "SWGHeatMapSettings");
    
    ::SWGSDRangel::setValue(&ils_demod_settings, pJson["ILSDemodSettings"], "SWGILSDemodSettings", "SWGILSDemodSettings");
    
    ::SWGSDRangel::setValue(&interferometer_settings, pJson["InterferometerSettings"], "SWGInterferometerSettings", "SWGInterferometerSettings");
    
    ::SWGSDRangel::setValue(&ieee_802_15_4_mod_settings, pJson["IEEE_802_15_4_ModSettings"], "SWGIEEE_802_15_4_ModSettings", "SWGIEEE_802_15_4_ModSettings");
    
    ::SWGSDRangel::setValue(&m17_demod_settings, pJson["M17DemodSettings"], "SWGM17DemodSettings", "SWGM17DemodSettings");
    
    ::SWGSDRangel::setValue(&m17_mod_settings, pJson["M17ModSettings"], "SWGM17ModSettings", "SWGM17ModSettings");
    
    ::SWGSDRangel::setValue(&navtex_demod_settings, pJson["NavtexDemodSettings"], "SWGNavtexDemodSettings", "SWGNavtexDemodSettings");
    
    ::SWGSDRangel::setValue(&nfm_demod_settings, pJson["NFMDemodSettings"], "SWGNFMDemodSettings", "SWGNFMDemodSettings");
    
    ::SWGSDRangel::setValue(&nfm_mod_settings, pJson["NFMModSettings"], "SWGNFMModSettings", "SWGNFMModSettings");
    
    ::SWGSDRangel::setValue(&noise_figure_settings, pJson["NoiseFigureSettings"], "SWGNoiseFigureSettings", "SWGNoiseFigureSettings");
    
    ::SWGSDRangel::setValue(&local_sink_settings, pJson["LocalSinkSettings"], "SWGLocalSinkSettings", "SWGLocalSinkSettings");
    
    ::SWGSDRangel::setValue(&local_source_settings, pJson["LocalSourceSettings"], "SWGLocalSourceSettings", "SWGLocalSourceSettings");
    
    ::SWGSDRangel::setValue(&packet_demod_settings, pJson["PacketDemodSettings"], "SWGPacketDemodSettings", "SWGPacketDemodSettings");
    
    ::SWGSDRangel::setValue(&packet_mod_settings, pJson["PacketModSettings"], "SWGPacketModSettings", "SWGPacketModSettings");
    
    ::SWGSDRangel::setValue(&pager_demod_settings, pJson["PagerDemodSettings"], "SWGPagerDemodSettings", "SWGPagerDemodSettings");
    
    ::SWGSDRangel::setValue(&psk31_mod_settings, pJson["PSK31ModSettings"], "SWGPSK31ModSettings", "SWGPSK31ModSettings");
    
    ::SWGSDRangel::setValue(&radio_astronomy_settings, pJson["RadioAstronomySettings"], "SWGRadioAstronomySettings", "SWGRadioAstronomySettings");
    
    ::SWGSDRangel::setValue(&radio_clock_settings, pJson["RadioClockSettings"], "SWGRadioClockSettings", "SWGRadioClockSettings");
    
    ::SWGSDRangel::setValue(&radiosonde_demod_settings, pJson["RadiosondeDemodSettings"], "SWGRadiosondeDemodSettings", "SWGRadiosondeDemodSettings");
    
    ::SWGSDRangel::setValue(&remote_sink_settings, pJson["RemoteSinkSettings"], "SWGRemoteSinkSettings", "SWGRemoteSinkSettings");
    
    ::SWGSDRangel::setValue(&remote_source_settings, pJson["RemoteSourceSettings"], "SWGRemoteSourceSettings", "SWGRemoteSourceSettings");
    
    ::SWGSDRangel::setValue(&remote_tcp_sink_settings, pJson["RemoteTCPSinkSettings"], "SWGRemoteTCPSinkSettings", "SWGRemoteTCPSinkSettings");
    
    ::SWGSDRangel::setValue(&rtty_demod_settings, pJson["RTTYDemodSettings"], "SWGRTTYDemodSettings", "SWGRTTYDemodSettings");
    
    ::SWGSDRangel::setValue(&rtty_mod_settings, pJson["RTTYModSettings"], "SWGRTTYModSettings", "SWGRTTYModSettings");
    
    ::SWGSDRangel::setValue(&sig_mf_file_sink_settings, pJson["SigMFFileSinkSettings"], "SWGSigMFFileSinkSettings", "SWGSigMFFileSinkSettings");
    
    ::SWGSDRangel::setValue(&ssb_mod_settings, pJson["SSBModSettings"], "SWGSSBModSettings", "SWGSSBModSettings");
    
    ::SWGSDRangel::setValue(&ssb_demod_settings, pJson["SSBDemodSettings"], "SWGSSBDemodSettings", "SWGSSBDemodSettings");
    
    ::SWGSDRangel::setValue(&udp_source_settings, pJson["UDPSourceSettings"], "SWGUDPSourceSettings", "SWGUDPSourceSettings");
    
    ::SWGSDRangel::setValue(&udp_sink_settings, pJson["UDPSinkSettings"], "SWGUDPSinkSettings", "SWGUDPSinkSettings");
    
    ::SWGSDRangel::setValue(&vor_demod_settings, pJson["VORDemodSettings"], "SWGVORDemodSettings", "SWGVORDemodSettings");
    
    ::SWGSDRangel::setValue(&wdsp_rx_settings, pJson["WDSPRxSettings"], "SWGWDSPRxSettings", "SWGWDSPRxSettings");
    
    ::SWGSDRangel::setValue(&wfm_demod_settings, pJson["WFMDemodSettings"], "SWGWFMDemodSettings", "SWGWFMDemodSettings");
    
    ::SWGSDRangel::setValue(&wfm_mod_settings, pJson["WFMModSettings"], "SWGWFMModSettings", "SWGWFMModSettings");
    
}

QString
SWGChannelSettings::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGChannelSettings::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(channel_type != nullptr && *channel_type != QString("")){
        toJsonValue(QString("channelType"), channel_type, obj, QString("QString"));
    }
    if(m_direction_isSet){
        obj->insert("direction", QJsonValue(direction));
    }
    if(m_originator_device_set_index_isSet){
        obj->insert("originatorDeviceSetIndex", QJsonValue(originator_device_set_index));
    }
    if(m_originator_channel_index_isSet){
        obj->insert("originatorChannelIndex", QJsonValue(originator_channel_index));
    }
    if((adsb_demod_settings != nullptr) && (adsb_demod_settings->isSet())){
        toJsonValue(QString("ADSBDemodSettings"), adsb_demod_settings, obj, QString("SWGADSBDemodSettings"));
    }
    if((ais_demod_settings != nullptr) && (ais_demod_settings->isSet())){
        toJsonValue(QString("AISDemodSettings"), ais_demod_settings, obj, QString("SWGAISDemodSettings"));
    }
    if((ais_mod_settings != nullptr) && (ais_mod_settings->isSet())){
        toJsonValue(QString("AISModSettings"), ais_mod_settings, obj, QString("SWGAISModSettings"));
    }
    if((am_demod_settings != nullptr) && (am_demod_settings->isSet())){
        toJsonValue(QString("AMDemodSettings"), am_demod_settings, obj, QString("SWGAMDemodSettings"));
    }
    if((am_mod_settings != nullptr) && (am_mod_settings->isSet())){
        toJsonValue(QString("AMModSettings"), am_mod_settings, obj, QString("SWGAMModSettings"));
    }
    if((apt_demod_settings != nullptr) && (apt_demod_settings->isSet())){
        toJsonValue(QString("APTDemodSettings"), apt_demod_settings, obj, QString("SWGAPTDemodSettings"));
    }
    if((atv_demod_settings != nullptr) && (atv_demod_settings->isSet())){
        toJsonValue(QString("ATVDemodSettings"), atv_demod_settings, obj, QString("SWGATVDemodSettings"));
    }
    if((atv_mod_settings != nullptr) && (atv_mod_settings->isSet())){
        toJsonValue(QString("ATVModSettings"), atv_mod_settings, obj, QString("SWGATVModSettings"));
    }
    if((beam_steering_cw_mod_settings != nullptr) && (beam_steering_cw_mod_settings->isSet())){
        toJsonValue(QString("BeamSteeringCWModSettings"), beam_steering_cw_mod_settings, obj, QString("SWGBeamSteeringCWModSettings"));
    }
    if((bfm_demod_settings != nullptr) && (bfm_demod_settings->isSet())){
        toJsonValue(QString("BFMDemodSettings"), bfm_demod_settings, obj, QString("SWGBFMDemodSettings"));
    }
    if((channel_analyzer_settings != nullptr) && (channel_analyzer_settings->isSet())){
        toJsonValue(QString("ChannelAnalyzerSettings"), channel_analyzer_settings, obj, QString("SWGChannelAnalyzerSettings"));
    }
    if((channel_power_settings != nullptr) && (channel_power_settings->isSet())){
        toJsonValue(QString("ChannelPowerSettings"), channel_power_settings, obj, QString("SWGChannelPowerSettings"));
    }
    if((chirp_chat_demod_settings != nullptr) && (chirp_chat_demod_settings->isSet())){
        toJsonValue(QString("ChirpChatDemodSettings"), chirp_chat_demod_settings, obj, QString("SWGChirpChatDemodSettings"));
    }
    if((chirp_chat_mod_settings != nullptr) && (chirp_chat_mod_settings->isSet())){
        toJsonValue(QString("ChirpChatModSettings"), chirp_chat_mod_settings, obj, QString("SWGChirpChatModSettings"));
    }
    if((datv_mod_settings != nullptr) && (datv_mod_settings->isSet())){
        toJsonValue(QString("DATVModSettings"), datv_mod_settings, obj, QString("SWGDATVModSettings"));
    }
    if((datv_demod_settings != nullptr) && (datv_demod_settings->isSet())){
        toJsonValue(QString("DATVDemodSettings"), datv_demod_settings, obj, QString("SWGDATVDemodSettings"));
    }
    if((dab_demod_settings != nullptr) && (dab_demod_settings->isSet())){
        toJsonValue(QString("DABDemodSettings"), dab_demod_settings, obj, QString("SWGDABDemodSettings"));
    }
    if((doa2_settings != nullptr) && (doa2_settings->isSet())){
        toJsonValue(QString("DOA2Settings"), doa2_settings, obj, QString("SWGDOA2Settings"));
    }
    if((dsc_demod_settings != nullptr) && (dsc_demod_settings->isSet())){
        toJsonValue(QString("DSCDemodSettings"), dsc_demod_settings, obj, QString("SWGDSCDemodSettings"));
    }
    if((dsd_demod_settings != nullptr) && (dsd_demod_settings->isSet())){
        toJsonValue(QString("DSDDemodSettings"), dsd_demod_settings, obj, QString("SWGDSDDemodSettings"));
    }
    if((end_of_train_demod_settings != nullptr) && (end_of_train_demod_settings->isSet())){
        toJsonValue(QString("EndOfTrainDemodSettings"), end_of_train_demod_settings, obj, QString("SWGEndOfTrainDemodSettings"));
    }
    if((file_sink_settings != nullptr) && (file_sink_settings->isSet())){
        toJsonValue(QString("FileSinkSettings"), file_sink_settings, obj, QString("SWGFileSinkSettings"));
    }
    if((file_source_settings != nullptr) && (file_source_settings->isSet())){
        toJsonValue(QString("FileSourceSettings"), file_source_settings, obj, QString("SWGFileSourceSettings"));
    }
    if((free_dv_demod_settings != nullptr) && (free_dv_demod_settings->isSet())){
        toJsonValue(QString("FreeDVDemodSettings"), free_dv_demod_settings, obj, QString("SWGFreeDVDemodSettings"));
    }
    if((free_dv_mod_settings != nullptr) && (free_dv_mod_settings->isSet())){
        toJsonValue(QString("FreeDVModSettings"), free_dv_mod_settings, obj, QString("SWGFreeDVModSettings"));
    }
    if((freq_scanner_settings != nullptr) && (freq_scanner_settings->isSet())){
        toJsonValue(QString("FreqScannerSettings"), freq_scanner_settings, obj, QString("SWGFreqScannerSettings"));
    }
    if((freq_tracker_settings != nullptr) && (freq_tracker_settings->isSet())){
        toJsonValue(QString("FreqTrackerSettings"), freq_tracker_settings, obj, QString("SWGFreqTrackerSettings"));
    }
    if((ft8_demod_settings != nullptr) && (ft8_demod_settings->isSet())){
        toJsonValue(QString("FT8DemodSettings"), ft8_demod_settings, obj, QString("SWGFT8DemodSettings"));
    }
    if((heat_map_settings != nullptr) && (heat_map_settings->isSet())){
        toJsonValue(QString("HeatMapSettings"), heat_map_settings, obj, QString("SWGHeatMapSettings"));
    }
    if((ils_demod_settings != nullptr) && (ils_demod_settings->isSet())){
        toJsonValue(QString("ILSDemodSettings"), ils_demod_settings, obj, QString("SWGILSDemodSettings"));
    }
    if((interferometer_settings != nullptr) && (interferometer_settings->isSet())){
        toJsonValue(QString("InterferometerSettings"), interferometer_settings, obj, QString("SWGInterferometerSettings"));
    }
    if((ieee_802_15_4_mod_settings != nullptr) && (ieee_802_15_4_mod_settings->isSet())){
        toJsonValue(QString("IEEE_802_15_4_ModSettings"), ieee_802_15_4_mod_settings, obj, QString("SWGIEEE_802_15_4_ModSettings"));
    }
    if((m17_demod_settings != nullptr) && (m17_demod_settings->isSet())){
        toJsonValue(QString("M17DemodSettings"), m17_demod_settings, obj, QString("SWGM17DemodSettings"));
    }
    if((m17_mod_settings != nullptr) && (m17_mod_settings->isSet())){
        toJsonValue(QString("M17ModSettings"), m17_mod_settings, obj, QString("SWGM17ModSettings"));
    }
    if((navtex_demod_settings != nullptr) && (navtex_demod_settings->isSet())){
        toJsonValue(QString("NavtexDemodSettings"), navtex_demod_settings, obj, QString("SWGNavtexDemodSettings"));
    }
    if((nfm_demod_settings != nullptr) && (nfm_demod_settings->isSet())){
        toJsonValue(QString("NFMDemodSettings"), nfm_demod_settings, obj, QString("SWGNFMDemodSettings"));
    }
    if((nfm_mod_settings != nullptr) && (nfm_mod_settings->isSet())){
        toJsonValue(QString("NFMModSettings"), nfm_mod_settings, obj, QString("SWGNFMModSettings"));
    }
    if((noise_figure_settings != nullptr) && (noise_figure_settings->isSet())){
        toJsonValue(QString("NoiseFigureSettings"), noise_figure_settings, obj, QString("SWGNoiseFigureSettings"));
    }
    if((local_sink_settings != nullptr) && (local_sink_settings->isSet())){
        toJsonValue(QString("LocalSinkSettings"), local_sink_settings, obj, QString("SWGLocalSinkSettings"));
    }
    if((local_source_settings != nullptr) && (local_source_settings->isSet())){
        toJsonValue(QString("LocalSourceSettings"), local_source_settings, obj, QString("SWGLocalSourceSettings"));
    }
    if((packet_demod_settings != nullptr) && (packet_demod_settings->isSet())){
        toJsonValue(QString("PacketDemodSettings"), packet_demod_settings, obj, QString("SWGPacketDemodSettings"));
    }
    if((packet_mod_settings != nullptr) && (packet_mod_settings->isSet())){
        toJsonValue(QString("PacketModSettings"), packet_mod_settings, obj, QString("SWGPacketModSettings"));
    }
    if((pager_demod_settings != nullptr) && (pager_demod_settings->isSet())){
        toJsonValue(QString("PagerDemodSettings"), pager_demod_settings, obj, QString("SWGPagerDemodSettings"));
    }
    if((psk31_mod_settings != nullptr) && (psk31_mod_settings->isSet())){
        toJsonValue(QString("PSK31ModSettings"), psk31_mod_settings, obj, QString("SWGPSK31ModSettings"));
    }
    if((radio_astronomy_settings != nullptr) && (radio_astronomy_settings->isSet())){
        toJsonValue(QString("RadioAstronomySettings"), radio_astronomy_settings, obj, QString("SWGRadioAstronomySettings"));
    }
    if((radio_clock_settings != nullptr) && (radio_clock_settings->isSet())){
        toJsonValue(QString("RadioClockSettings"), radio_clock_settings, obj, QString("SWGRadioClockSettings"));
    }
    if((radiosonde_demod_settings != nullptr) && (radiosonde_demod_settings->isSet())){
        toJsonValue(QString("RadiosondeDemodSettings"), radiosonde_demod_settings, obj, QString("SWGRadiosondeDemodSettings"));
    }
    if((remote_sink_settings != nullptr) && (remote_sink_settings->isSet())){
        toJsonValue(QString("RemoteSinkSettings"), remote_sink_settings, obj, QString("SWGRemoteSinkSettings"));
    }
    if((remote_source_settings != nullptr) && (remote_source_settings->isSet())){
        toJsonValue(QString("RemoteSourceSettings"), remote_source_settings, obj, QString("SWGRemoteSourceSettings"));
    }
    if((remote_tcp_sink_settings != nullptr) && (remote_tcp_sink_settings->isSet())){
        toJsonValue(QString("RemoteTCPSinkSettings"), remote_tcp_sink_settings, obj, QString("SWGRemoteTCPSinkSettings"));
    }
    if((rtty_demod_settings != nullptr) && (rtty_demod_settings->isSet())){
        toJsonValue(QString("RTTYDemodSettings"), rtty_demod_settings, obj, QString("SWGRTTYDemodSettings"));
    }
    if((rtty_mod_settings != nullptr) && (rtty_mod_settings->isSet())){
        toJsonValue(QString("RTTYModSettings"), rtty_mod_settings, obj, QString("SWGRTTYModSettings"));
    }
    if((sig_mf_file_sink_settings != nullptr) && (sig_mf_file_sink_settings->isSet())){
        toJsonValue(QString("SigMFFileSinkSettings"), sig_mf_file_sink_settings, obj, QString("SWGSigMFFileSinkSettings"));
    }
    if((ssb_mod_settings != nullptr) && (ssb_mod_settings->isSet())){
        toJsonValue(QString("SSBModSettings"), ssb_mod_settings, obj, QString("SWGSSBModSettings"));
    }
    if((ssb_demod_settings != nullptr) && (ssb_demod_settings->isSet())){
        toJsonValue(QString("SSBDemodSettings"), ssb_demod_settings, obj, QString("SWGSSBDemodSettings"));
    }
    if((udp_source_settings != nullptr) && (udp_source_settings->isSet())){
        toJsonValue(QString("UDPSourceSettings"), udp_source_settings, obj, QString("SWGUDPSourceSettings"));
    }
    if((udp_sink_settings != nullptr) && (udp_sink_settings->isSet())){
        toJsonValue(QString("UDPSinkSettings"), udp_sink_settings, obj, QString("SWGUDPSinkSettings"));
    }
    if((vor_demod_settings != nullptr) && (vor_demod_settings->isSet())){
        toJsonValue(QString("VORDemodSettings"), vor_demod_settings, obj, QString("SWGVORDemodSettings"));
    }
    if((wdsp_rx_settings != nullptr) && (wdsp_rx_settings->isSet())){
        toJsonValue(QString("WDSPRxSettings"), wdsp_rx_settings, obj, QString("SWGWDSPRxSettings"));
    }
    if((wfm_demod_settings != nullptr) && (wfm_demod_settings->isSet())){
        toJsonValue(QString("WFMDemodSettings"), wfm_demod_settings, obj, QString("SWGWFMDemodSettings"));
    }
    if((wfm_mod_settings != nullptr) && (wfm_mod_settings->isSet())){
        toJsonValue(QString("WFMModSettings"), wfm_mod_settings, obj, QString("SWGWFMModSettings"));
    }

    return obj;
}

QString*
SWGChannelSettings::getChannelType() {
    return channel_type;
}
void
SWGChannelSettings::setChannelType(QString* channel_type) {
    this->channel_type = channel_type;
    this->m_channel_type_isSet = true;
}

qint32
SWGChannelSettings::getDirection() {
    return direction;
}
void
SWGChannelSettings::setDirection(qint32 direction) {
    this->direction = direction;
    this->m_direction_isSet = true;
}

qint32
SWGChannelSettings::getOriginatorDeviceSetIndex() {
    return originator_device_set_index;
}
void
SWGChannelSettings::setOriginatorDeviceSetIndex(qint32 originator_device_set_index) {
    this->originator_device_set_index = originator_device_set_index;
    this->m_originator_device_set_index_isSet = true;
}

qint32
SWGChannelSettings::getOriginatorChannelIndex() {
    return originator_channel_index;
}
void
SWGChannelSettings::setOriginatorChannelIndex(qint32 originator_channel_index) {
    this->originator_channel_index = originator_channel_index;
    this->m_originator_channel_index_isSet = true;
}

SWGADSBDemodSettings*
SWGChannelSettings::getAdsbDemodSettings() {
    return adsb_demod_settings;
}
void
SWGChannelSettings::setAdsbDemodSettings(SWGADSBDemodSettings* adsb_demod_settings) {
    this->adsb_demod_settings = adsb_demod_settings;
    this->m_adsb_demod_settings_isSet = true;
}

SWGAISDemodSettings*
SWGChannelSettings::getAisDemodSettings() {
    return ais_demod_settings;
}
void
SWGChannelSettings::setAisDemodSettings(SWGAISDemodSettings* ais_demod_settings) {
    this->ais_demod_settings = ais_demod_settings;
    this->m_ais_demod_settings_isSet = true;
}

SWGAISModSettings*
SWGChannelSettings::getAisModSettings() {
    return ais_mod_settings;
}
void
SWGChannelSettings::setAisModSettings(SWGAISModSettings* ais_mod_settings) {
    this->ais_mod_settings = ais_mod_settings;
    this->m_ais_mod_settings_isSet = true;
}

SWGAMDemodSettings*
SWGChannelSettings::getAmDemodSettings() {
    return am_demod_settings;
}
void
SWGChannelSettings::setAmDemodSettings(SWGAMDemodSettings* am_demod_settings) {
    this->am_demod_settings = am_demod_settings;
    this->m_am_demod_settings_isSet = true;
}

SWGAMModSettings*
SWGChannelSettings::getAmModSettings() {
    return am_mod_settings;
}
void
SWGChannelSettings::setAmModSettings(SWGAMModSettings* am_mod_settings) {
    this->am_mod_settings = am_mod_settings;
    this->m_am_mod_settings_isSet = true;
}

SWGAPTDemodSettings*
SWGChannelSettings::getAptDemodSettings() {
    return apt_demod_settings;
}
void
SWGChannelSettings::setAptDemodSettings(SWGAPTDemodSettings* apt_demod_settings) {
    this->apt_demod_settings = apt_demod_settings;
    this->m_apt_demod_settings_isSet = true;
}

SWGATVDemodSettings*
SWGChannelSettings::getAtvDemodSettings() {
    return atv_demod_settings;
}
void
SWGChannelSettings::setAtvDemodSettings(SWGATVDemodSettings* atv_demod_settings) {
    this->atv_demod_settings = atv_demod_settings;
    this->m_atv_demod_settings_isSet = true;
}

SWGATVModSettings*
SWGChannelSettings::getAtvModSettings() {
    return atv_mod_settings;
}
void
SWGChannelSettings::setAtvModSettings(SWGATVModSettings* atv_mod_settings) {
    this->atv_mod_settings = atv_mod_settings;
    this->m_atv_mod_settings_isSet = true;
}

SWGBeamSteeringCWModSettings*
SWGChannelSettings::getBeamSteeringCwModSettings() {
    return beam_steering_cw_mod_settings;
}
void
SWGChannelSettings::setBeamSteeringCwModSettings(SWGBeamSteeringCWModSettings* beam_steering_cw_mod_settings) {
    this->beam_steering_cw_mod_settings = beam_steering_cw_mod_settings;
    this->m_beam_steering_cw_mod_settings_isSet = true;
}

SWGBFMDemodSettings*
SWGChannelSettings::getBfmDemodSettings() {
    return bfm_demod_settings;
}
void
SWGChannelSettings::setBfmDemodSettings(SWGBFMDemodSettings* bfm_demod_settings) {
    this->bfm_demod_settings = bfm_demod_settings;
    this->m_bfm_demod_settings_isSet = true;
}

SWGChannelAnalyzerSettings*
SWGChannelSettings::getChannelAnalyzerSettings() {
    return channel_analyzer_settings;
}
void
SWGChannelSettings::setChannelAnalyzerSettings(SWGChannelAnalyzerSettings* channel_analyzer_settings) {
    this->channel_analyzer_settings = channel_analyzer_settings;
    this->m_channel_analyzer_settings_isSet = true;
}

SWGChannelPowerSettings*
SWGChannelSettings::getChannelPowerSettings() {
    return channel_power_settings;
}
void
SWGChannelSettings::setChannelPowerSettings(SWGChannelPowerSettings* channel_power_settings) {
    this->channel_power_settings = channel_power_settings;
    this->m_channel_power_settings_isSet = true;
}

SWGChirpChatDemodSettings*
SWGChannelSettings::getChirpChatDemodSettings() {
    return chirp_chat_demod_settings;
}
void
SWGChannelSettings::setChirpChatDemodSettings(SWGChirpChatDemodSettings* chirp_chat_demod_settings) {
    this->chirp_chat_demod_settings = chirp_chat_demod_settings;
    this->m_chirp_chat_demod_settings_isSet = true;
}

SWGChirpChatModSettings*
SWGChannelSettings::getChirpChatModSettings() {
    return chirp_chat_mod_settings;
}
void
SWGChannelSettings::setChirpChatModSettings(SWGChirpChatModSettings* chirp_chat_mod_settings) {
    this->chirp_chat_mod_settings = chirp_chat_mod_settings;
    this->m_chirp_chat_mod_settings_isSet = true;
}

SWGDATVModSettings*
SWGChannelSettings::getDatvModSettings() {
    return datv_mod_settings;
}
void
SWGChannelSettings::setDatvModSettings(SWGDATVModSettings* datv_mod_settings) {
    this->datv_mod_settings = datv_mod_settings;
    this->m_datv_mod_settings_isSet = true;
}

SWGDATVDemodSettings*
SWGChannelSettings::getDatvDemodSettings() {
    return datv_demod_settings;
}
void
SWGChannelSettings::setDatvDemodSettings(SWGDATVDemodSettings* datv_demod_settings) {
    this->datv_demod_settings = datv_demod_settings;
    this->m_datv_demod_settings_isSet = true;
}

SWGDABDemodSettings*
SWGChannelSettings::getDabDemodSettings() {
    return dab_demod_settings;
}
void
SWGChannelSettings::setDabDemodSettings(SWGDABDemodSettings* dab_demod_settings) {
    this->dab_demod_settings = dab_demod_settings;
    this->m_dab_demod_settings_isSet = true;
}

SWGDOA2Settings*
SWGChannelSettings::getDoa2Settings() {
    return doa2_settings;
}
void
SWGChannelSettings::setDoa2Settings(SWGDOA2Settings* doa2_settings) {
    this->doa2_settings = doa2_settings;
    this->m_doa2_settings_isSet = true;
}

SWGDSCDemodSettings*
SWGChannelSettings::getDscDemodSettings() {
    return dsc_demod_settings;
}
void
SWGChannelSettings::setDscDemodSettings(SWGDSCDemodSettings* dsc_demod_settings) {
    this->dsc_demod_settings = dsc_demod_settings;
    this->m_dsc_demod_settings_isSet = true;
}

SWGDSDDemodSettings*
SWGChannelSettings::getDsdDemodSettings() {
    return dsd_demod_settings;
}
void
SWGChannelSettings::setDsdDemodSettings(SWGDSDDemodSettings* dsd_demod_settings) {
    this->dsd_demod_settings = dsd_demod_settings;
    this->m_dsd_demod_settings_isSet = true;
}

SWGEndOfTrainDemodSettings*
SWGChannelSettings::getEndOfTrainDemodSettings() {
    return end_of_train_demod_settings;
}
void
SWGChannelSettings::setEndOfTrainDemodSettings(SWGEndOfTrainDemodSettings* end_of_train_demod_settings) {
    this->end_of_train_demod_settings = end_of_train_demod_settings;
    this->m_end_of_train_demod_settings_isSet = true;
}

SWGFileSinkSettings*
SWGChannelSettings::getFileSinkSettings() {
    return file_sink_settings;
}
void
SWGChannelSettings::setFileSinkSettings(SWGFileSinkSettings* file_sink_settings) {
    this->file_sink_settings = file_sink_settings;
    this->m_file_sink_settings_isSet = true;
}

SWGFileSourceSettings*
SWGChannelSettings::getFileSourceSettings() {
    return file_source_settings;
}
void
SWGChannelSettings::setFileSourceSettings(SWGFileSourceSettings* file_source_settings) {
    this->file_source_settings = file_source_settings;
    this->m_file_source_settings_isSet = true;
}

SWGFreeDVDemodSettings*
SWGChannelSettings::getFreeDvDemodSettings() {
    return free_dv_demod_settings;
}
void
SWGChannelSettings::setFreeDvDemodSettings(SWGFreeDVDemodSettings* free_dv_demod_settings) {
    this->free_dv_demod_settings = free_dv_demod_settings;
    this->m_free_dv_demod_settings_isSet = true;
}

SWGFreeDVModSettings*
SWGChannelSettings::getFreeDvModSettings() {
    return free_dv_mod_settings;
}
void
SWGChannelSettings::setFreeDvModSettings(SWGFreeDVModSettings* free_dv_mod_settings) {
    this->free_dv_mod_settings = free_dv_mod_settings;
    this->m_free_dv_mod_settings_isSet = true;
}

SWGFreqScannerSettings*
SWGChannelSettings::getFreqScannerSettings() {
    return freq_scanner_settings;
}
void
SWGChannelSettings::setFreqScannerSettings(SWGFreqScannerSettings* freq_scanner_settings) {
    this->freq_scanner_settings = freq_scanner_settings;
    this->m_freq_scanner_settings_isSet = true;
}

SWGFreqTrackerSettings*
SWGChannelSettings::getFreqTrackerSettings() {
    return freq_tracker_settings;
}
void
SWGChannelSettings::setFreqTrackerSettings(SWGFreqTrackerSettings* freq_tracker_settings) {
    this->freq_tracker_settings = freq_tracker_settings;
    this->m_freq_tracker_settings_isSet = true;
}

SWGFT8DemodSettings*
SWGChannelSettings::getFt8DemodSettings() {
    return ft8_demod_settings;
}
void
SWGChannelSettings::setFt8DemodSettings(SWGFT8DemodSettings* ft8_demod_settings) {
    this->ft8_demod_settings = ft8_demod_settings;
    this->m_ft8_demod_settings_isSet = true;
}

SWGHeatMapSettings*
SWGChannelSettings::getHeatMapSettings() {
    return heat_map_settings;
}
void
SWGChannelSettings::setHeatMapSettings(SWGHeatMapSettings* heat_map_settings) {
    this->heat_map_settings = heat_map_settings;
    this->m_heat_map_settings_isSet = true;
}

SWGILSDemodSettings*
SWGChannelSettings::getIlsDemodSettings() {
    return ils_demod_settings;
}
void
SWGChannelSettings::setIlsDemodSettings(SWGILSDemodSettings* ils_demod_settings) {
    this->ils_demod_settings = ils_demod_settings;
    this->m_ils_demod_settings_isSet = true;
}

SWGInterferometerSettings*
SWGChannelSettings::getInterferometerSettings() {
    return interferometer_settings;
}
void
SWGChannelSettings::setInterferometerSettings(SWGInterferometerSettings* interferometer_settings) {
    this->interferometer_settings = interferometer_settings;
    this->m_interferometer_settings_isSet = true;
}

SWGIEEE_802_15_4_ModSettings*
SWGChannelSettings::getIeee802154ModSettings() {
    return ieee_802_15_4_mod_settings;
}
void
SWGChannelSettings::setIeee802154ModSettings(SWGIEEE_802_15_4_ModSettings* ieee_802_15_4_mod_settings) {
    this->ieee_802_15_4_mod_settings = ieee_802_15_4_mod_settings;
    this->m_ieee_802_15_4_mod_settings_isSet = true;
}

SWGM17DemodSettings*
SWGChannelSettings::getM17DemodSettings() {
    return m17_demod_settings;
}
void
SWGChannelSettings::setM17DemodSettings(SWGM17DemodSettings* m17_demod_settings) {
    this->m17_demod_settings = m17_demod_settings;
    this->m_m17_demod_settings_isSet = true;
}

SWGM17ModSettings*
SWGChannelSettings::getM17ModSettings() {
    return m17_mod_settings;
}
void
SWGChannelSettings::setM17ModSettings(SWGM17ModSettings* m17_mod_settings) {
    this->m17_mod_settings = m17_mod_settings;
    this->m_m17_mod_settings_isSet = true;
}

SWGNavtexDemodSettings*
SWGChannelSettings::getNavtexDemodSettings() {
    return navtex_demod_settings;
}
void
SWGChannelSettings::setNavtexDemodSettings(SWGNavtexDemodSettings* navtex_demod_settings) {
    this->navtex_demod_settings = navtex_demod_settings;
    this->m_navtex_demod_settings_isSet = true;
}

SWGNFMDemodSettings*
SWGChannelSettings::getNfmDemodSettings() {
    return nfm_demod_settings;
}
void
SWGChannelSettings::setNfmDemodSettings(SWGNFMDemodSettings* nfm_demod_settings) {
    this->nfm_demod_settings = nfm_demod_settings;
    this->m_nfm_demod_settings_isSet = true;
}

SWGNFMModSettings*
SWGChannelSettings::getNfmModSettings() {
    return nfm_mod_settings;
}
void
SWGChannelSettings::setNfmModSettings(SWGNFMModSettings* nfm_mod_settings) {
    this->nfm_mod_settings = nfm_mod_settings;
    this->m_nfm_mod_settings_isSet = true;
}

SWGNoiseFigureSettings*
SWGChannelSettings::getNoiseFigureSettings() {
    return noise_figure_settings;
}
void
SWGChannelSettings::setNoiseFigureSettings(SWGNoiseFigureSettings* noise_figure_settings) {
    this->noise_figure_settings = noise_figure_settings;
    this->m_noise_figure_settings_isSet = true;
}

SWGLocalSinkSettings*
SWGChannelSettings::getLocalSinkSettings() {
    return local_sink_settings;
}
void
SWGChannelSettings::setLocalSinkSettings(SWGLocalSinkSettings* local_sink_settings) {
    this->local_sink_settings = local_sink_settings;
    this->m_local_sink_settings_isSet = true;
}

SWGLocalSourceSettings*
SWGChannelSettings::getLocalSourceSettings() {
    return local_source_settings;
}
void
SWGChannelSettings::setLocalSourceSettings(SWGLocalSourceSettings* local_source_settings) {
    this->local_source_settings = local_source_settings;
    this->m_local_source_settings_isSet = true;
}

SWGPacketDemodSettings*
SWGChannelSettings::getPacketDemodSettings() {
    return packet_demod_settings;
}
void
SWGChannelSettings::setPacketDemodSettings(SWGPacketDemodSettings* packet_demod_settings) {
    this->packet_demod_settings = packet_demod_settings;
    this->m_packet_demod_settings_isSet = true;
}

SWGPacketModSettings*
SWGChannelSettings::getPacketModSettings() {
    return packet_mod_settings;
}
void
SWGChannelSettings::setPacketModSettings(SWGPacketModSettings* packet_mod_settings) {
    this->packet_mod_settings = packet_mod_settings;
    this->m_packet_mod_settings_isSet = true;
}

SWGPagerDemodSettings*
SWGChannelSettings::getPagerDemodSettings() {
    return pager_demod_settings;
}
void
SWGChannelSettings::setPagerDemodSettings(SWGPagerDemodSettings* pager_demod_settings) {
    this->pager_demod_settings = pager_demod_settings;
    this->m_pager_demod_settings_isSet = true;
}

SWGPSK31ModSettings*
SWGChannelSettings::getPsk31ModSettings() {
    return psk31_mod_settings;
}
void
SWGChannelSettings::setPsk31ModSettings(SWGPSK31ModSettings* psk31_mod_settings) {
    this->psk31_mod_settings = psk31_mod_settings;
    this->m_psk31_mod_settings_isSet = true;
}

SWGRadioAstronomySettings*
SWGChannelSettings::getRadioAstronomySettings() {
    return radio_astronomy_settings;
}
void
SWGChannelSettings::setRadioAstronomySettings(SWGRadioAstronomySettings* radio_astronomy_settings) {
    this->radio_astronomy_settings = radio_astronomy_settings;
    this->m_radio_astronomy_settings_isSet = true;
}

SWGRadioClockSettings*
SWGChannelSettings::getRadioClockSettings() {
    return radio_clock_settings;
}
void
SWGChannelSettings::setRadioClockSettings(SWGRadioClockSettings* radio_clock_settings) {
    this->radio_clock_settings = radio_clock_settings;
    this->m_radio_clock_settings_isSet = true;
}

SWGRadiosondeDemodSettings*
SWGChannelSettings::getRadiosondeDemodSettings() {
    return radiosonde_demod_settings;
}
void
SWGChannelSettings::setRadiosondeDemodSettings(SWGRadiosondeDemodSettings* radiosonde_demod_settings) {
    this->radiosonde_demod_settings = radiosonde_demod_settings;
    this->m_radiosonde_demod_settings_isSet = true;
}

SWGRemoteSinkSettings*
SWGChannelSettings::getRemoteSinkSettings() {
    return remote_sink_settings;
}
void
SWGChannelSettings::setRemoteSinkSettings(SWGRemoteSinkSettings* remote_sink_settings) {
    this->remote_sink_settings = remote_sink_settings;
    this->m_remote_sink_settings_isSet = true;
}

SWGRemoteSourceSettings*
SWGChannelSettings::getRemoteSourceSettings() {
    return remote_source_settings;
}
void
SWGChannelSettings::setRemoteSourceSettings(SWGRemoteSourceSettings* remote_source_settings) {
    this->remote_source_settings = remote_source_settings;
    this->m_remote_source_settings_isSet = true;
}

SWGRemoteTCPSinkSettings*
SWGChannelSettings::getRemoteTcpSinkSettings() {
    return remote_tcp_sink_settings;
}
void
SWGChannelSettings::setRemoteTcpSinkSettings(SWGRemoteTCPSinkSettings* remote_tcp_sink_settings) {
    this->remote_tcp_sink_settings = remote_tcp_sink_settings;
    this->m_remote_tcp_sink_settings_isSet = true;
}

SWGRTTYDemodSettings*
SWGChannelSettings::getRttyDemodSettings() {
    return rtty_demod_settings;
}
void
SWGChannelSettings::setRttyDemodSettings(SWGRTTYDemodSettings* rtty_demod_settings) {
    this->rtty_demod_settings = rtty_demod_settings;
    this->m_rtty_demod_settings_isSet = true;
}

SWGRTTYModSettings*
SWGChannelSettings::getRttyModSettings() {
    return rtty_mod_settings;
}
void
SWGChannelSettings::setRttyModSettings(SWGRTTYModSettings* rtty_mod_settings) {
    this->rtty_mod_settings = rtty_mod_settings;
    this->m_rtty_mod_settings_isSet = true;
}

SWGSigMFFileSinkSettings*
SWGChannelSettings::getSigMfFileSinkSettings() {
    return sig_mf_file_sink_settings;
}
void
SWGChannelSettings::setSigMfFileSinkSettings(SWGSigMFFileSinkSettings* sig_mf_file_sink_settings) {
    this->sig_mf_file_sink_settings = sig_mf_file_sink_settings;
    this->m_sig_mf_file_sink_settings_isSet = true;
}

SWGSSBModSettings*
SWGChannelSettings::getSsbModSettings() {
    return ssb_mod_settings;
}
void
SWGChannelSettings::setSsbModSettings(SWGSSBModSettings* ssb_mod_settings) {
    this->ssb_mod_settings = ssb_mod_settings;
    this->m_ssb_mod_settings_isSet = true;
}

SWGSSBDemodSettings*
SWGChannelSettings::getSsbDemodSettings() {
    return ssb_demod_settings;
}
void
SWGChannelSettings::setSsbDemodSettings(SWGSSBDemodSettings* ssb_demod_settings) {
    this->ssb_demod_settings = ssb_demod_settings;
    this->m_ssb_demod_settings_isSet = true;
}

SWGUDPSourceSettings*
SWGChannelSettings::getUdpSourceSettings() {
    return udp_source_settings;
}
void
SWGChannelSettings::setUdpSourceSettings(SWGUDPSourceSettings* udp_source_settings) {
    this->udp_source_settings = udp_source_settings;
    this->m_udp_source_settings_isSet = true;
}

SWGUDPSinkSettings*
SWGChannelSettings::getUdpSinkSettings() {
    return udp_sink_settings;
}
void
SWGChannelSettings::setUdpSinkSettings(SWGUDPSinkSettings* udp_sink_settings) {
    this->udp_sink_settings = udp_sink_settings;
    this->m_udp_sink_settings_isSet = true;
}

SWGVORDemodSettings*
SWGChannelSettings::getVorDemodSettings() {
    return vor_demod_settings;
}
void
SWGChannelSettings::setVorDemodSettings(SWGVORDemodSettings* vor_demod_settings) {
    this->vor_demod_settings = vor_demod_settings;
    this->m_vor_demod_settings_isSet = true;
}

SWGWDSPRxSettings*
SWGChannelSettings::getWdspRxSettings() {
    return wdsp_rx_settings;
}
void
SWGChannelSettings::setWdspRxSettings(SWGWDSPRxSettings* wdsp_rx_settings) {
    this->wdsp_rx_settings = wdsp_rx_settings;
    this->m_wdsp_rx_settings_isSet = true;
}

SWGWFMDemodSettings*
SWGChannelSettings::getWfmDemodSettings() {
    return wfm_demod_settings;
}
void
SWGChannelSettings::setWfmDemodSettings(SWGWFMDemodSettings* wfm_demod_settings) {
    this->wfm_demod_settings = wfm_demod_settings;
    this->m_wfm_demod_settings_isSet = true;
}

SWGWFMModSettings*
SWGChannelSettings::getWfmModSettings() {
    return wfm_mod_settings;
}
void
SWGChannelSettings::setWfmModSettings(SWGWFMModSettings* wfm_mod_settings) {
    this->wfm_mod_settings = wfm_mod_settings;
    this->m_wfm_mod_settings_isSet = true;
}


bool
SWGChannelSettings::isSet(){
    bool isObjectUpdated = false;
    do{
        if(channel_type && *channel_type != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_direction_isSet){
            isObjectUpdated = true; break;
        }
        if(m_originator_device_set_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_originator_channel_index_isSet){
            isObjectUpdated = true; break;
        }
        if(adsb_demod_settings && adsb_demod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(ais_demod_settings && ais_demod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(ais_mod_settings && ais_mod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(am_demod_settings && am_demod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(am_mod_settings && am_mod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(apt_demod_settings && apt_demod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(atv_demod_settings && atv_demod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(atv_mod_settings && atv_mod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(beam_steering_cw_mod_settings && beam_steering_cw_mod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(bfm_demod_settings && bfm_demod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(channel_analyzer_settings && channel_analyzer_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(channel_power_settings && channel_power_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(chirp_chat_demod_settings && chirp_chat_demod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(chirp_chat_mod_settings && chirp_chat_mod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(datv_mod_settings && datv_mod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(datv_demod_settings && datv_demod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(dab_demod_settings && dab_demod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(doa2_settings && doa2_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(dsc_demod_settings && dsc_demod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(dsd_demod_settings && dsd_demod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(end_of_train_demod_settings && end_of_train_demod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(file_sink_settings && file_sink_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(file_source_settings && file_source_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(free_dv_demod_settings && free_dv_demod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(free_dv_mod_settings && free_dv_mod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(freq_scanner_settings && freq_scanner_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(freq_tracker_settings && freq_tracker_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(ft8_demod_settings && ft8_demod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(heat_map_settings && heat_map_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(ils_demod_settings && ils_demod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(interferometer_settings && interferometer_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(ieee_802_15_4_mod_settings && ieee_802_15_4_mod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(m17_demod_settings && m17_demod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(m17_mod_settings && m17_mod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(navtex_demod_settings && navtex_demod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(nfm_demod_settings && nfm_demod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(nfm_mod_settings && nfm_mod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(noise_figure_settings && noise_figure_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(local_sink_settings && local_sink_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(local_source_settings && local_source_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(packet_demod_settings && packet_demod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(packet_mod_settings && packet_mod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(pager_demod_settings && pager_demod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(psk31_mod_settings && psk31_mod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(radio_astronomy_settings && radio_astronomy_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(radio_clock_settings && radio_clock_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(radiosonde_demod_settings && radiosonde_demod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(remote_sink_settings && remote_sink_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(remote_source_settings && remote_source_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(remote_tcp_sink_settings && remote_tcp_sink_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(rtty_demod_settings && rtty_demod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(rtty_mod_settings && rtty_mod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(sig_mf_file_sink_settings && sig_mf_file_sink_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(ssb_mod_settings && ssb_mod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(ssb_demod_settings && ssb_demod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(udp_source_settings && udp_source_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(udp_sink_settings && udp_sink_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(vor_demod_settings && vor_demod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(wdsp_rx_settings && wdsp_rx_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(wfm_demod_settings && wfm_demod_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(wfm_mod_settings && wfm_mod_settings->isSet()){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

