/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGMorseDecoderActions.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGMorseDecoderActions::SWGMorseDecoderActions(QString* json) {
    init();
    this->fromJson(*json);
}

SWGMorseDecoderActions::SWGMorseDecoderActions() {
    device_id = 0;
    m_device_id_isSet = false;
    channel_id = 0;
    m_channel_id_isSet = false;
}

SWGMorseDecoderActions::~SWGMorseDecoderActions() {
    this->cleanup();
}

void
SWGMorseDecoderActions::init() {
    device_id = 0;
    m_device_id_isSet = false;
    channel_id = 0;
    m_channel_id_isSet = false;
}

void
SWGMorseDecoderActions::cleanup() {


}

SWGMorseDecoderActions*
SWGMorseDecoderActions::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGMorseDecoderActions::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&device_id, pJson["deviceId"], "qint32", "");
    
    ::SWGSDRangel::setValue(&channel_id, pJson["channelId"], "qint32", "");
    
}

QString
SWGMorseDecoderActions::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGMorseDecoderActions::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_device_id_isSet){
        obj->insert("deviceId", QJsonValue(device_id));
    }
    if(m_channel_id_isSet){
        obj->insert("channelId", QJsonValue(channel_id));
    }

    return obj;
}

qint32
SWGMorseDecoderActions::getDeviceId() {
    return device_id;
}
void
SWGMorseDecoderActions::setDeviceId(qint32 device_id) {
    this->device_id = device_id;
    this->m_device_id_isSet = true;
}

qint32
SWGMorseDecoderActions::getChannelId() {
    return channel_id;
}
void
SWGMorseDecoderActions::setChannelId(qint32 channel_id) {
    this->channel_id = channel_id;
    this->m_channel_id_isSet = true;
}


bool
SWGMorseDecoderActions::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_device_id_isSet){
            isObjectUpdated = true; break;
        }
        if(m_channel_id_isSet){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

