/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGSoapySDRReport.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGSoapySDRReport::SWGSoapySDRReport(QString* json) {
    init();
    this->fromJson(*json);
}

SWGSoapySDRReport::SWGSoapySDRReport() {
    device_settings_args = nullptr;
    m_device_settings_args_isSet = false;
    stream_settings_args = nullptr;
    m_stream_settings_args_isSet = false;
    has_dc_auto_correction = 0;
    m_has_dc_auto_correction_isSet = false;
    has_dc_offset_value = 0;
    m_has_dc_offset_value_isSet = false;
    has_iq_balance_value = 0;
    m_has_iq_balance_value_isSet = false;
    has_frequency_correction_value = 0;
    m_has_frequency_correction_value_isSet = false;
    antennas = nullptr;
    m_antennas_isSet = false;
    has_agc = 0;
    m_has_agc_isSet = false;
    gain_range = nullptr;
    m_gain_range_isSet = false;
    gain_settings = nullptr;
    m_gain_settings_isSet = false;
    frequency_settings = nullptr;
    m_frequency_settings_isSet = false;
    frequency_settings_args = nullptr;
    m_frequency_settings_args_isSet = false;
    rates_ranges = nullptr;
    m_rates_ranges_isSet = false;
    bandwidths_ranges = nullptr;
    m_bandwidths_ranges_isSet = false;
}

SWGSoapySDRReport::~SWGSoapySDRReport() {
    this->cleanup();
}

void
SWGSoapySDRReport::init() {
    device_settings_args = new QList<SWGArgInfo*>();
    m_device_settings_args_isSet = false;
    stream_settings_args = new QList<SWGArgInfo*>();
    m_stream_settings_args_isSet = false;
    has_dc_auto_correction = 0;
    m_has_dc_auto_correction_isSet = false;
    has_dc_offset_value = 0;
    m_has_dc_offset_value_isSet = false;
    has_iq_balance_value = 0;
    m_has_iq_balance_value_isSet = false;
    has_frequency_correction_value = 0;
    m_has_frequency_correction_value_isSet = false;
    antennas = new QList<QString*>();
    m_antennas_isSet = false;
    has_agc = 0;
    m_has_agc_isSet = false;
    gain_range = new SWGRangeFloat();
    m_gain_range_isSet = false;
    gain_settings = new QList<SWGSoapySDRGainSetting*>();
    m_gain_settings_isSet = false;
    frequency_settings = new QList<SWGSoapySDRFrequencySetting*>();
    m_frequency_settings_isSet = false;
    frequency_settings_args = new QList<SWGArgInfo*>();
    m_frequency_settings_args_isSet = false;
    rates_ranges = new QList<SWGRangeFloat*>();
    m_rates_ranges_isSet = false;
    bandwidths_ranges = new QList<SWGRangeFloat*>();
    m_bandwidths_ranges_isSet = false;
}

void
SWGSoapySDRReport::cleanup() {
    if(device_settings_args != nullptr) { 
        auto arr = device_settings_args;
        for(auto o: *arr) { 
            delete o;
        }
        delete device_settings_args;
    }
    if(stream_settings_args != nullptr) { 
        auto arr = stream_settings_args;
        for(auto o: *arr) { 
            delete o;
        }
        delete stream_settings_args;
    }




    if(antennas != nullptr) { 
        auto arr = antennas;
        for(auto o: *arr) { 
            delete o;
        }
        delete antennas;
    }

    if(gain_range != nullptr) { 
        delete gain_range;
    }
    if(gain_settings != nullptr) { 
        auto arr = gain_settings;
        for(auto o: *arr) { 
            delete o;
        }
        delete gain_settings;
    }
    if(frequency_settings != nullptr) { 
        auto arr = frequency_settings;
        for(auto o: *arr) { 
            delete o;
        }
        delete frequency_settings;
    }
    if(frequency_settings_args != nullptr) { 
        auto arr = frequency_settings_args;
        for(auto o: *arr) { 
            delete o;
        }
        delete frequency_settings_args;
    }
    if(rates_ranges != nullptr) { 
        auto arr = rates_ranges;
        for(auto o: *arr) { 
            delete o;
        }
        delete rates_ranges;
    }
    if(bandwidths_ranges != nullptr) { 
        auto arr = bandwidths_ranges;
        for(auto o: *arr) { 
            delete o;
        }
        delete bandwidths_ranges;
    }
}

SWGSoapySDRReport*
SWGSoapySDRReport::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGSoapySDRReport::fromJsonObject(QJsonObject &pJson) {
    
    ::SWGSDRangel::setValue(&device_settings_args, pJson["deviceSettingsArgs"], "QList", "SWGArgInfo");
    
    ::SWGSDRangel::setValue(&stream_settings_args, pJson["streamSettingsArgs"], "QList", "SWGArgInfo");
    ::SWGSDRangel::setValue(&has_dc_auto_correction, pJson["hasDCAutoCorrection"], "qint32", "");
    
    ::SWGSDRangel::setValue(&has_dc_offset_value, pJson["hasDCOffsetValue"], "qint32", "");
    
    ::SWGSDRangel::setValue(&has_iq_balance_value, pJson["hasIQBalanceValue"], "qint32", "");
    
    ::SWGSDRangel::setValue(&has_frequency_correction_value, pJson["hasFrequencyCorrectionValue"], "qint32", "");
    
    
    ::SWGSDRangel::setValue(&antennas, pJson["antennas"], "QList", "QString");
    ::SWGSDRangel::setValue(&has_agc, pJson["hasAGC"], "qint32", "");
    
    ::SWGSDRangel::setValue(&gain_range, pJson["gainRange"], "SWGRangeFloat", "SWGRangeFloat");
    
    
    ::SWGSDRangel::setValue(&gain_settings, pJson["gainSettings"], "QList", "SWGSoapySDRGainSetting");
    
    ::SWGSDRangel::setValue(&frequency_settings, pJson["frequencySettings"], "QList", "SWGSoapySDRFrequencySetting");
    
    ::SWGSDRangel::setValue(&frequency_settings_args, pJson["frequencySettingsArgs"], "QList", "SWGArgInfo");
    
    ::SWGSDRangel::setValue(&rates_ranges, pJson["ratesRanges"], "QList", "SWGRangeFloat");
    
    ::SWGSDRangel::setValue(&bandwidths_ranges, pJson["bandwidthsRanges"], "QList", "SWGRangeFloat");
}

QString
SWGSoapySDRReport::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGSoapySDRReport::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(device_settings_args && device_settings_args->size() > 0){
        toJsonArray((QList<void*>*)device_settings_args, obj, "deviceSettingsArgs", "SWGArgInfo");
    }
    if(stream_settings_args && stream_settings_args->size() > 0){
        toJsonArray((QList<void*>*)stream_settings_args, obj, "streamSettingsArgs", "SWGArgInfo");
    }
    if(m_has_dc_auto_correction_isSet){
        obj->insert("hasDCAutoCorrection", QJsonValue(has_dc_auto_correction));
    }
    if(m_has_dc_offset_value_isSet){
        obj->insert("hasDCOffsetValue", QJsonValue(has_dc_offset_value));
    }
    if(m_has_iq_balance_value_isSet){
        obj->insert("hasIQBalanceValue", QJsonValue(has_iq_balance_value));
    }
    if(m_has_frequency_correction_value_isSet){
        obj->insert("hasFrequencyCorrectionValue", QJsonValue(has_frequency_correction_value));
    }
    if(antennas && antennas->size() > 0){
        toJsonArray((QList<void*>*)antennas, obj, "antennas", "QString");
    }
    if(m_has_agc_isSet){
        obj->insert("hasAGC", QJsonValue(has_agc));
    }
    if((gain_range != nullptr) && (gain_range->isSet())){
        toJsonValue(QString("gainRange"), gain_range, obj, QString("SWGRangeFloat"));
    }
    if(gain_settings && gain_settings->size() > 0){
        toJsonArray((QList<void*>*)gain_settings, obj, "gainSettings", "SWGSoapySDRGainSetting");
    }
    if(frequency_settings && frequency_settings->size() > 0){
        toJsonArray((QList<void*>*)frequency_settings, obj, "frequencySettings", "SWGSoapySDRFrequencySetting");
    }
    if(frequency_settings_args && frequency_settings_args->size() > 0){
        toJsonArray((QList<void*>*)frequency_settings_args, obj, "frequencySettingsArgs", "SWGArgInfo");
    }
    if(rates_ranges && rates_ranges->size() > 0){
        toJsonArray((QList<void*>*)rates_ranges, obj, "ratesRanges", "SWGRangeFloat");
    }
    if(bandwidths_ranges && bandwidths_ranges->size() > 0){
        toJsonArray((QList<void*>*)bandwidths_ranges, obj, "bandwidthsRanges", "SWGRangeFloat");
    }

    return obj;
}

QList<SWGArgInfo*>*
SWGSoapySDRReport::getDeviceSettingsArgs() {
    return device_settings_args;
}
void
SWGSoapySDRReport::setDeviceSettingsArgs(QList<SWGArgInfo*>* device_settings_args) {
    this->device_settings_args = device_settings_args;
    this->m_device_settings_args_isSet = true;
}

QList<SWGArgInfo*>*
SWGSoapySDRReport::getStreamSettingsArgs() {
    return stream_settings_args;
}
void
SWGSoapySDRReport::setStreamSettingsArgs(QList<SWGArgInfo*>* stream_settings_args) {
    this->stream_settings_args = stream_settings_args;
    this->m_stream_settings_args_isSet = true;
}

qint32
SWGSoapySDRReport::getHasDcAutoCorrection() {
    return has_dc_auto_correction;
}
void
SWGSoapySDRReport::setHasDcAutoCorrection(qint32 has_dc_auto_correction) {
    this->has_dc_auto_correction = has_dc_auto_correction;
    this->m_has_dc_auto_correction_isSet = true;
}

qint32
SWGSoapySDRReport::getHasDcOffsetValue() {
    return has_dc_offset_value;
}
void
SWGSoapySDRReport::setHasDcOffsetValue(qint32 has_dc_offset_value) {
    this->has_dc_offset_value = has_dc_offset_value;
    this->m_has_dc_offset_value_isSet = true;
}

qint32
SWGSoapySDRReport::getHasIqBalanceValue() {
    return has_iq_balance_value;
}
void
SWGSoapySDRReport::setHasIqBalanceValue(qint32 has_iq_balance_value) {
    this->has_iq_balance_value = has_iq_balance_value;
    this->m_has_iq_balance_value_isSet = true;
}

qint32
SWGSoapySDRReport::getHasFrequencyCorrectionValue() {
    return has_frequency_correction_value;
}
void
SWGSoapySDRReport::setHasFrequencyCorrectionValue(qint32 has_frequency_correction_value) {
    this->has_frequency_correction_value = has_frequency_correction_value;
    this->m_has_frequency_correction_value_isSet = true;
}

QList<QString*>*
SWGSoapySDRReport::getAntennas() {
    return antennas;
}
void
SWGSoapySDRReport::setAntennas(QList<QString*>* antennas) {
    this->antennas = antennas;
    this->m_antennas_isSet = true;
}

qint32
SWGSoapySDRReport::getHasAgc() {
    return has_agc;
}
void
SWGSoapySDRReport::setHasAgc(qint32 has_agc) {
    this->has_agc = has_agc;
    this->m_has_agc_isSet = true;
}

SWGRangeFloat*
SWGSoapySDRReport::getGainRange() {
    return gain_range;
}
void
SWGSoapySDRReport::setGainRange(SWGRangeFloat* gain_range) {
    this->gain_range = gain_range;
    this->m_gain_range_isSet = true;
}

QList<SWGSoapySDRGainSetting*>*
SWGSoapySDRReport::getGainSettings() {
    return gain_settings;
}
void
SWGSoapySDRReport::setGainSettings(QList<SWGSoapySDRGainSetting*>* gain_settings) {
    this->gain_settings = gain_settings;
    this->m_gain_settings_isSet = true;
}

QList<SWGSoapySDRFrequencySetting*>*
SWGSoapySDRReport::getFrequencySettings() {
    return frequency_settings;
}
void
SWGSoapySDRReport::setFrequencySettings(QList<SWGSoapySDRFrequencySetting*>* frequency_settings) {
    this->frequency_settings = frequency_settings;
    this->m_frequency_settings_isSet = true;
}

QList<SWGArgInfo*>*
SWGSoapySDRReport::getFrequencySettingsArgs() {
    return frequency_settings_args;
}
void
SWGSoapySDRReport::setFrequencySettingsArgs(QList<SWGArgInfo*>* frequency_settings_args) {
    this->frequency_settings_args = frequency_settings_args;
    this->m_frequency_settings_args_isSet = true;
}

QList<SWGRangeFloat*>*
SWGSoapySDRReport::getRatesRanges() {
    return rates_ranges;
}
void
SWGSoapySDRReport::setRatesRanges(QList<SWGRangeFloat*>* rates_ranges) {
    this->rates_ranges = rates_ranges;
    this->m_rates_ranges_isSet = true;
}

QList<SWGRangeFloat*>*
SWGSoapySDRReport::getBandwidthsRanges() {
    return bandwidths_ranges;
}
void
SWGSoapySDRReport::setBandwidthsRanges(QList<SWGRangeFloat*>* bandwidths_ranges) {
    this->bandwidths_ranges = bandwidths_ranges;
    this->m_bandwidths_ranges_isSet = true;
}


bool
SWGSoapySDRReport::isSet(){
    bool isObjectUpdated = false;
    do{
        if(device_settings_args && (device_settings_args->size() > 0)){
            isObjectUpdated = true; break;
        }
        if(stream_settings_args && (stream_settings_args->size() > 0)){
            isObjectUpdated = true; break;
        }
        if(m_has_dc_auto_correction_isSet){
            isObjectUpdated = true; break;
        }
        if(m_has_dc_offset_value_isSet){
            isObjectUpdated = true; break;
        }
        if(m_has_iq_balance_value_isSet){
            isObjectUpdated = true; break;
        }
        if(m_has_frequency_correction_value_isSet){
            isObjectUpdated = true; break;
        }
        if(antennas && (antennas->size() > 0)){
            isObjectUpdated = true; break;
        }
        if(m_has_agc_isSet){
            isObjectUpdated = true; break;
        }
        if(gain_range && gain_range->isSet()){
            isObjectUpdated = true; break;
        }
        if(gain_settings && (gain_settings->size() > 0)){
            isObjectUpdated = true; break;
        }
        if(frequency_settings && (frequency_settings->size() > 0)){
            isObjectUpdated = true; break;
        }
        if(frequency_settings_args && (frequency_settings_args->size() > 0)){
            isObjectUpdated = true; break;
        }
        if(rates_ranges && (rates_ranges->size() > 0)){
            isObjectUpdated = true; break;
        }
        if(bandwidths_ranges && (bandwidths_ranges->size() > 0)){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

