/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGSpectrumHistogramMarker.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGSpectrumHistogramMarker::SWGSpectrumHistogramMarker(QString* json) {
    init();
    this->fromJson(*json);
}

SWGSpectrumHistogramMarker::SWGSpectrumHistogramMarker() {
    frequency = 0.0f;
    m_frequency_isSet = false;
    power = 0.0f;
    m_power_isSet = false;
    marker_type = 0;
    m_marker_type_isSet = false;
    marker_color = 0;
    m_marker_color_isSet = false;
    show = 0;
    m_show_isSet = false;
}

SWGSpectrumHistogramMarker::~SWGSpectrumHistogramMarker() {
    this->cleanup();
}

void
SWGSpectrumHistogramMarker::init() {
    frequency = 0.0f;
    m_frequency_isSet = false;
    power = 0.0f;
    m_power_isSet = false;
    marker_type = 0;
    m_marker_type_isSet = false;
    marker_color = 0;
    m_marker_color_isSet = false;
    show = 0;
    m_show_isSet = false;
}

void
SWGSpectrumHistogramMarker::cleanup() {





}

SWGSpectrumHistogramMarker*
SWGSpectrumHistogramMarker::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGSpectrumHistogramMarker::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&frequency, pJson["frequency"], "float", "");
    
    ::SWGSDRangel::setValue(&power, pJson["power"], "float", "");
    
    ::SWGSDRangel::setValue(&marker_type, pJson["markerType"], "qint32", "");
    
    ::SWGSDRangel::setValue(&marker_color, pJson["markerColor"], "qint32", "");
    
    ::SWGSDRangel::setValue(&show, pJson["show"], "qint32", "");
    
}

QString
SWGSpectrumHistogramMarker::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGSpectrumHistogramMarker::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_frequency_isSet){
        obj->insert("frequency", QJsonValue(frequency));
    }
    if(m_power_isSet){
        obj->insert("power", QJsonValue(power));
    }
    if(m_marker_type_isSet){
        obj->insert("markerType", QJsonValue(marker_type));
    }
    if(m_marker_color_isSet){
        obj->insert("markerColor", QJsonValue(marker_color));
    }
    if(m_show_isSet){
        obj->insert("show", QJsonValue(show));
    }

    return obj;
}

float
SWGSpectrumHistogramMarker::getFrequency() {
    return frequency;
}
void
SWGSpectrumHistogramMarker::setFrequency(float frequency) {
    this->frequency = frequency;
    this->m_frequency_isSet = true;
}

float
SWGSpectrumHistogramMarker::getPower() {
    return power;
}
void
SWGSpectrumHistogramMarker::setPower(float power) {
    this->power = power;
    this->m_power_isSet = true;
}

qint32
SWGSpectrumHistogramMarker::getMarkerType() {
    return marker_type;
}
void
SWGSpectrumHistogramMarker::setMarkerType(qint32 marker_type) {
    this->marker_type = marker_type;
    this->m_marker_type_isSet = true;
}

qint32
SWGSpectrumHistogramMarker::getMarkerColor() {
    return marker_color;
}
void
SWGSpectrumHistogramMarker::setMarkerColor(qint32 marker_color) {
    this->marker_color = marker_color;
    this->m_marker_color_isSet = true;
}

qint32
SWGSpectrumHistogramMarker::getShow() {
    return show;
}
void
SWGSpectrumHistogramMarker::setShow(qint32 show) {
    this->show = show;
    this->m_show_isSet = true;
}


bool
SWGSpectrumHistogramMarker::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_frequency_isSet){
            isObjectUpdated = true; break;
        }
        if(m_power_isSet){
            isObjectUpdated = true; break;
        }
        if(m_marker_type_isSet){
            isObjectUpdated = true; break;
        }
        if(m_marker_color_isSet){
            isObjectUpdated = true; break;
        }
        if(m_show_isSet){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

