// Base64 encoding and decoding (implementation)

#include "lib.h"

//
// Global variables
//

char base64_enct[] = {'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K',
                      'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V',
                      'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g',
                      'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r',
                      's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2',
                      '3', '4', '5', '6', '7', '8', '9', '+', '/'};

char *base64_dect = NULL;

int base64_modt[] = {0, 2, 1};

//
// Functions
//

char *base64_encode(const unsigned char *data, size_t input_length,
                    size_t *output_length) {
  *output_length = 4 * ((input_length + 2) / 3);
  char *encoded_data = salloc(*output_length);

  for (int i = 0, j = 0; i < input_length;) {
    uint32_t octet_a = i < input_length ? (unsigned char)data[i++] : 0;
    uint32_t octet_b = i < input_length ? (unsigned char)data[i++] : 0;
    uint32_t octet_c = i < input_length ? (unsigned char)data[i++] : 0;

    uint32_t triple = (octet_a << 0x10) + (octet_b << 0x08) + octet_c;

    encoded_data[j++] = base64_enct[(triple >> 3 * 6) & 0x3F];
    encoded_data[j++] = base64_enct[(triple >> 2 * 6) & 0x3F];
    encoded_data[j++] = base64_enct[(triple >> 1 * 6) & 0x3F];
    encoded_data[j++] = base64_enct[(triple >> 0 * 6) & 0x3F];
  }

  for (int i = 0; i < base64_modt[input_length % 3]; i++)
    encoded_data[*output_length - 1 - i] = '=';

  return encoded_data;
}

unsigned char *base64_decode(const char *data, size_t input_length,
                             size_t *output_length) {
  if (NULL == base64_dect)
    base64_build_dect();

  if (input_length % 4 != 0)
    return NULL;

  *output_length = input_length / 4 * 3;
  if (data[input_length - 1] == '=')
    (*output_length)--;
  if (data[input_length - 2] == '=')
    (*output_length)--;
  unsigned char *decoded_data = salloc(*output_length);

  for (int i = 0, j = 0; i < input_length;) {
    uint32_t sextet_a =
        data[i] == '=' ? 0 & i++ : base64_dect[(unsigned char)data[i++]];
    uint32_t sextet_b =
        data[i] == '=' ? 0 & i++ : base64_dect[(unsigned char)data[i++]];
    uint32_t sextet_c =
        data[i] == '=' ? 0 & i++ : base64_dect[(unsigned char)data[i++]];
    uint32_t sextet_d =
        data[i] == '=' ? 0 & i++ : base64_dect[(unsigned char)data[i++]];

    uint32_t triple = (sextet_a << 3 * 6) + (sextet_b << 2 * 6) +
                      (sextet_c << 1 * 6) + (sextet_d << 0 * 6);

    if (j < *output_length)
      decoded_data[j++] = (triple >> 2 * 8) & 0xFF;
    if (j < *output_length)
      decoded_data[j++] = (triple >> 1 * 8) & 0xFF;
    if (j < *output_length)
      decoded_data[j++] = (triple >> 0 * 8) & 0xFF;
  }

  return decoded_data;
}

void base64_build_dect() {
  base64_dect = malloc(256);

  for (int i = 0; i < 64; i++)
    base64_dect[(unsigned char)base64_enct[i]] = i;
}

void base64_cleanup() {
  if (NULL != base64_dect)
    free(base64_dect);
}
