/*
 * Decompiled with CFR 0.152.
 */
package jdbm.btree;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.List;
import jdbm.RecordManager;
import jdbm.btree.BTree;
import jdbm.extser.DataInput;
import jdbm.extser.DataOutput;
import jdbm.extser.IStreamSerializer;
import jdbm.extser.Stateless;
import jdbm.helper.ExtensibleSerializer;
import jdbm.helper.Serializer;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;
import jdbm.helper.compression.ByteArrayCompressor;
import jdbm.helper.compression.ByteArrayDecompressor;

public final class BPage<K extends Serializable, V extends Serializable>
implements Serializer {
    private static final boolean DEBUG = false;
    static final long serialVersionUID = 1L;
    transient BTree<K, V> _btree;
    protected transient long _btreeId;
    protected transient long _recid;
    protected boolean _isLeaf;
    protected Object[] _keys;
    protected Object[] _values;
    protected long[] _children;
    protected int _first;
    protected long _previous;
    protected long _next;

    public BTree<K, V> getBTree() {
        return this._btree;
    }

    public BPage() {
    }

    BPage(BTree<K, V> btree, BPage<K, V> root, BPage<K, V> overflow) throws IOException {
        this._btree = btree;
        this._btreeId = btree.getRecid();
        this._isLeaf = false;
        this._first = this._btree._pageSize - 2;
        this._keys = new Object[this._btree._pageSize];
        this._keys[this._btree._pageSize - 2] = overflow.getLargestKey();
        this._keys[this._btree._pageSize - 1] = root.getLargestKey();
        this._children = new long[this._btree._pageSize];
        this._children[this._btree._pageSize - 2] = overflow._recid;
        this._children[this._btree._pageSize - 1] = root._recid;
        this._recid = this._btree._insert(this, this);
    }

    BPage(BTree<K, V> btree, K key, V value) throws IOException {
        this._btree = btree;
        this._btreeId = btree.getRecid();
        this._isLeaf = true;
        this._first = btree._pageSize - 2;
        this._keys = new Object[this._btree._pageSize];
        this._keys[this._btree._pageSize - 2] = key;
        this._keys[this._btree._pageSize - 1] = null;
        this._values = new Object[this._btree._pageSize];
        this._values[this._btree._pageSize - 2] = value;
        this._values[this._btree._pageSize - 1] = null;
        this._recid = this._btree._insert(this, this);
    }

    BPage(BTree<K, V> btree, boolean isLeaf) throws IOException {
        this._btree = btree;
        this._btreeId = btree.getRecid();
        this._isLeaf = isLeaf;
        this._first = this._btree._pageSize / 2;
        this._keys = new Object[this._btree._pageSize];
        if (isLeaf) {
            this._values = new Object[this._btree._pageSize];
        } else {
            this._children = new long[this._btree._pageSize];
        }
        this._recid = this._btree._insert(this, this);
    }

    K getLargestKey() {
        return (K)((Serializable)this._keys[this._btree._pageSize - 1]);
    }

    boolean isEmpty() {
        if (this._isLeaf) {
            return this._first == this._values.length - 1;
        }
        return this._first == this._children.length - 1;
    }

    boolean isFull() {
        return this._first == 0;
    }

    TupleBrowser<K, V> find(int height, K key) throws IOException {
        int index = this.findChildren(key);
        if (--height == 0) {
            return new Browser(this, index);
        }
        BPage<K, V> child = this.childBPage(index);
        return child.find(height, key);
    }

    TupleBrowser<K, V> findFirst() throws IOException {
        if (this._isLeaf) {
            return new Browser(this, this._first);
        }
        BPage<K, V> child = this.childBPage(this._first);
        return child.findFirst();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void delete() throws IOException {
        if (this._isLeaf) {
            if (this._next != 0L) {
                BPage<K, V> nextBPage = this.loadBPage(this._next);
                if (nextBPage._previous != this._recid) throw new Error("Inconsistent data in BTree");
                nextBPage._previous = this._previous;
                this._btree._update(nextBPage._recid, nextBPage, nextBPage);
            }
            if (this._previous != 0L) {
                BPage<K, V> previousBPage = this.loadBPage(this._previous);
                if (previousBPage._next == this._recid) throw new Error("Inconsistent data in BTree");
                previousBPage._next = this._next;
                this._btree._update(previousBPage._recid, previousBPage, previousBPage);
            }
        } else {
            int left = this._first;
            int right = this._btree._pageSize - 1;
            for (int i = left; i <= right; ++i) {
                BPage<K, V> childBPage = this.loadBPage(this._children[i]);
                childBPage.delete();
            }
        }
        this._btree._delete(this._recid);
    }

    InsertResult<K, V> insert(int height, K key, V value, boolean replace) throws IOException {
        long overflow;
        InsertResult result;
        int index = this.findChildren(key);
        if (--height == 0) {
            result = new InsertResult();
            overflow = -1L;
            if (this.compare(key, (Serializable)this._keys[index]) == 0) {
                result._existing = (Serializable)this._values[index];
                if (replace) {
                    this._values[index] = value;
                    this._btree._update(this._recid, this, this);
                }
                return result;
            }
        } else {
            BPage<K, V> child = this.childBPage(index);
            result = child.insert(height, key, value, replace);
            if (result._existing != null) {
                return result;
            }
            if (result._overflow == null) {
                return result;
            }
            key = result._overflow.getLargestKey();
            overflow = result._overflow._recid;
            this._keys[index] = child.getLargestKey();
            result._overflow = null;
        }
        if (!this.isFull()) {
            if (height == 0) {
                BPage.insertEntry(this, index - 1, key, value);
            } else {
                BPage.insertChild(this, index - 1, key, overflow);
            }
            this._btree._update(this._recid, this, this);
            return result;
        }
        int half = this._btree._pageSize >> 1;
        BPage<K, V> newPage = new BPage<K, V>(this._btree, this._isLeaf);
        if (index < half) {
            if (height == 0) {
                BPage.copyEntries(this, 0, newPage, half, index);
                BPage.setEntry(newPage, half + index, key, value);
                BPage.copyEntries(this, index, newPage, half + index + 1, half - index - 1);
            } else {
                BPage.copyChildren(this, 0, newPage, half, index);
                BPage.setChild(newPage, half + index, key, overflow);
                BPage.copyChildren(this, index, newPage, half + index + 1, half - index - 1);
            }
        } else if (height == 0) {
            BPage.copyEntries(this, 0, newPage, half, half);
            BPage.copyEntries(this, half, this, half - 1, index - half);
            BPage.setEntry(this, index - 1, key, value);
        } else {
            BPage.copyChildren(this, 0, newPage, half, half);
            BPage.copyChildren(this, half, this, half - 1, index - half);
            BPage.setChild(this, index - 1, key, overflow);
        }
        this._first = half - 1;
        for (int i = 0; i < this._first; ++i) {
            if (height == 0) {
                BPage.setEntry(this, i, null, null);
                continue;
            }
            BPage.setChild(this, i, null, -1L);
        }
        if (this._isLeaf) {
            newPage._previous = this._previous;
            newPage._next = this._recid;
            if (this._previous != 0L) {
                BPage<K, V> previous = this.loadBPage(this._previous);
                previous._next = newPage._recid;
                this._btree._update(this._previous, previous, this);
            }
            this._previous = newPage._recid;
        }
        this._btree._update(this._recid, this, this);
        this._btree._update(newPage._recid, newPage, this);
        result._overflow = newPage;
        return result;
    }

    RemoveResult<V> remove(int height, K key) throws IOException {
        RemoveResult<V> result;
        int half = this._btree._pageSize / 2;
        int index = this.findChildren(key);
        if (--height == 0) {
            if (this.compare((Serializable)this._keys[index], key) != 0) {
                throw new IllegalArgumentException("Key not found: " + key);
            }
            result = new RemoveResult();
            result._value = (Serializable)this._values[index];
            BPage.removeEntry(this, index);
            this._btree._update(this._recid, this, this);
        } else {
            BPage<K, V> child = this.childBPage(index);
            result = child.remove(height, key);
            this._keys[index] = child.getLargestKey();
            this._btree._update(this._recid, this, this);
            if (result._underflow) {
                if (child._first != half + 1) {
                    throw new IllegalStateException("Error during underflow [1]");
                }
                if (index < this._children.length - 1) {
                    BPage<K, V> brother = this.childBPage(index + 1);
                    int bfirst = brother._first;
                    if (bfirst < half) {
                        int steal = (half - bfirst + 1) / 2;
                        brother._first += steal;
                        child._first -= steal;
                        if (child._isLeaf) {
                            BPage.copyEntries(child, half + 1, child, half + 1 - steal, half - 1);
                            BPage.copyEntries(brother, bfirst, child, 2 * half - steal, steal);
                        } else {
                            BPage.copyChildren(child, half + 1, child, half + 1 - steal, half - 1);
                            BPage.copyChildren(brother, bfirst, child, 2 * half - steal, steal);
                        }
                        for (int i = bfirst; i < bfirst + steal; ++i) {
                            if (brother._isLeaf) {
                                BPage.setEntry(brother, i, null, null);
                                continue;
                            }
                            BPage.setChild(brother, i, null, -1L);
                        }
                        this._keys[index] = child.getLargestKey();
                        this._btree._update(this._recid, this, this);
                        this._btree._update(brother._recid, brother, this);
                        this._btree._update(child._recid, child, this);
                    } else {
                        if (brother._first != half) {
                            throw new IllegalStateException("Error during underflow [2]");
                        }
                        brother._first = 1;
                        if (child._isLeaf) {
                            BPage.copyEntries(child, half + 1, brother, 1, half - 1);
                        } else {
                            BPage.copyChildren(child, half + 1, brother, 1, half - 1);
                        }
                        this._btree._update(brother._recid, brother, this);
                        if (this._isLeaf) {
                            BPage.copyEntries(this, this._first, this, this._first + 1, index - this._first);
                            BPage.setEntry(this, this._first, null, null);
                        } else {
                            BPage.copyChildren(this, this._first, this, this._first + 1, index - this._first);
                            BPage.setChild(this, this._first, null, -1L);
                        }
                        ++this._first;
                        this._btree._update(this._recid, this, this);
                        if (child._previous != 0L) {
                            BPage<K, V> prev = this.loadBPage(child._previous);
                            prev._next = child._next;
                            this._btree._update(prev._recid, prev, this);
                        }
                        if (child._next != 0L) {
                            BPage<K, V> next = this.loadBPage(child._next);
                            next._previous = child._previous;
                            this._btree._update(next._recid, next, this);
                        }
                        this._btree._delete(child._recid);
                    }
                } else {
                    BPage<K, V> brother = this.childBPage(index - 1);
                    int bfirst = brother._first;
                    if (bfirst < half) {
                        int steal = (half - bfirst + 1) / 2;
                        brother._first += steal;
                        child._first -= steal;
                        if (child._isLeaf) {
                            BPage.copyEntries(brother, 2 * half - steal, child, half + 1 - steal, steal);
                            BPage.copyEntries(brother, bfirst, brother, bfirst + steal, 2 * half - bfirst - steal);
                        } else {
                            BPage.copyChildren(brother, 2 * half - steal, child, half + 1 - steal, steal);
                            BPage.copyChildren(brother, bfirst, brother, bfirst + steal, 2 * half - bfirst - steal);
                        }
                        for (int i = bfirst; i < bfirst + steal; ++i) {
                            if (brother._isLeaf) {
                                BPage.setEntry(brother, i, null, null);
                                continue;
                            }
                            BPage.setChild(brother, i, null, -1L);
                        }
                        this._keys[index - 1] = brother.getLargestKey();
                        this._btree._update(this._recid, this, this);
                        this._btree._update(brother._recid, brother, this);
                        this._btree._update(child._recid, child, this);
                    } else {
                        if (brother._first != half) {
                            throw new IllegalStateException("Error during underflow [3]");
                        }
                        child._first = 1;
                        if (child._isLeaf) {
                            BPage.copyEntries(brother, half, child, 1, half);
                        } else {
                            BPage.copyChildren(brother, half, child, 1, half);
                        }
                        this._btree._update(child._recid, child, this);
                        if (this._isLeaf) {
                            BPage.copyEntries(this, this._first, this, this._first + 1, index - 1 - this._first);
                            BPage.setEntry(this, this._first, null, null);
                        } else {
                            BPage.copyChildren(this, this._first, this, this._first + 1, index - 1 - this._first);
                            BPage.setChild(this, this._first, null, -1L);
                        }
                        ++this._first;
                        this._btree._update(this._recid, this, this);
                        if (brother._previous != 0L) {
                            BPage<K, V> prev = this.loadBPage(brother._previous);
                            prev._next = brother._next;
                            this._btree._update(prev._recid, prev, this);
                        }
                        if (brother._next != 0L) {
                            BPage<K, V> next = this.loadBPage(brother._next);
                            next._previous = brother._previous;
                            this._btree._update(next._recid, next, this);
                        }
                        this._btree._delete(brother._recid);
                    }
                }
            }
        }
        result._underflow = this._first > half;
        return result;
    }

    private int findChildren(K key) {
        int left = this._first;
        int right = this._btree._pageSize - 1;
        while (left < right) {
            int middle = (left + right) / 2;
            if (this.compare((Serializable)this._keys[middle], key) < 0) {
                left = middle + 1;
                continue;
            }
            right = middle;
        }
        return right;
    }

    private static <K extends Serializable, V extends Serializable> void insertEntry(BPage<K, V> page, int index, K key, Object value) {
        Object[] keys = page._keys;
        Object[] values = page._values;
        int start = page._first;
        int count = index - page._first + 1;
        System.arraycopy(keys, start, keys, start - 1, count);
        System.arraycopy(values, start, values, start - 1, count);
        --page._first;
        keys[index] = key;
        values[index] = value;
    }

    private static void insertChild(BPage page, int index, Object key, long child) {
        Object[] keys = page._keys;
        long[] children = page._children;
        int start = page._first;
        int count = index - page._first + 1;
        System.arraycopy(keys, start, keys, start - 1, count);
        System.arraycopy(children, start, children, start - 1, count);
        --page._first;
        keys[index] = key;
        children[index] = child;
    }

    private static void removeEntry(BPage page, int index) {
        Object[] keys = page._keys;
        Object[] values = page._values;
        int start = page._first;
        int count = index - page._first;
        System.arraycopy(keys, start, keys, start + 1, count);
        keys[start] = null;
        System.arraycopy(values, start, values, start + 1, count);
        values[start] = null;
        ++page._first;
    }

    private static <K extends Serializable, V extends Serializable> void setEntry(BPage<K, V> page, int index, K key, V value) {
        page._keys[index] = key;
        page._values[index] = value;
    }

    private static <K extends Serializable, V extends Serializable> void setChild(BPage<K, V> page, int index, K key, long recid) {
        page._keys[index] = key;
        page._children[index] = recid;
    }

    private static <K extends Serializable, V extends Serializable> void copyEntries(BPage<K, V> source, int indexSource, BPage<K, V> dest, int indexDest, int count) {
        System.arraycopy(source._keys, indexSource, dest._keys, indexDest, count);
        System.arraycopy(source._values, indexSource, dest._values, indexDest, count);
    }

    private static <K extends Serializable, V extends Serializable> void copyChildren(BPage<K, V> source, int indexSource, BPage<K, V> dest, int indexDest, int count) {
        System.arraycopy(source._keys, indexSource, dest._keys, indexDest, count);
        System.arraycopy(source._children, indexSource, dest._children, indexDest, count);
    }

    BPage<K, V> childBPage(int index) throws IOException {
        return this.loadBPage(this._children[index]);
    }

    private BPage<K, V> loadBPage(long recid) throws IOException {
        BPage<K, V> child = this._btree._fetch(recid, this);
        child._recid = recid;
        child._btree = this._btree;
        child._btreeId = this._btree.getRecid();
        return child;
    }

    private final int compare(K value1, K value2) {
        if (value1 == null) {
            return 1;
        }
        if (value2 == null) {
            return -1;
        }
        return this._btree._comparator.compare(value1, value2);
    }

    static byte[] readByteArray(ObjectInput in) throws IOException {
        int len = in.readInt();
        if (len < 0) {
            return null;
        }
        byte[] buf = new byte[len];
        in.readFully(buf);
        return buf;
    }

    static void writeByteArray(ObjectOutput out, byte[] buf) throws IOException {
        if (buf == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(buf.length);
            out.write(buf);
        }
    }

    void dump(PrintStream out, int height) {
        int i;
        String prefix = "";
        for (i = 0; i < height; ++i) {
            prefix = prefix + "    ";
        }
        out.println(prefix + "-------------------------------------- BPage recid=" + this._recid);
        out.println(prefix + "first=" + this._first);
        for (i = 0; i < this._btree._pageSize; ++i) {
            if (this._isLeaf) {
                out.println(prefix + "Value [" + i + "] " + this._keys[i] + " " + this._values[i]);
                continue;
            }
            out.println(prefix + "BPage [" + i + "] " + this._keys[i] + " " + this._children[i]);
        }
        out.println(prefix + "--------------------------------------");
    }

    void dumpRecursive(PrintStream out, int height, int level) throws IOException {
        ++level;
        if (--height > 0) {
            for (int i = this._first; i < this._btree._pageSize; ++i) {
                if (this._children[i] == 0L) continue;
                BPage<K, V> child = this.childBPage(i);
                child.dump(out, level);
                child.dumpRecursive(out, height, level);
            }
        }
    }

    void dumpChildPageRecIDs(List out, int height) throws IOException {
        if (--height > 0) {
            for (int i = this._first; i < this._btree._pageSize; ++i) {
                if (this._children[i] == 0L) continue;
                BPage<K, V> child = this.childBPage(i);
                out.add(new Long(child._recid));
                child.dumpChildPageRecIDs(out, height);
            }
        }
    }

    private void assertConsistency(PrintStream out) {
        for (int i = this._first; i < this._btree._pageSize - 1; ++i) {
            if (this.compare((Serializable)this._keys[i], (Serializable)this._keys[i + 1]) < 0) continue;
            this.dump(out, 0);
            throw new Error("BPage not ordered");
        }
    }

    void assertConsistencyRecursive(PrintStream out, int height) throws IOException {
        this.assertConsistency(out);
        if (--height > 0) {
            for (int i = this._first; i < this._btree._pageSize && this._keys[i] != null; ++i) {
                BPage<K, V> child = this.childBPage(i);
                if (this.compare((Serializable)this._keys[i], child.getLargestKey()) != 0) {
                    this.dump(out, 0);
                    child.dump(out, 0);
                    throw new Error("Invalid child subordinate key");
                }
                child.assertConsistencyRecursive(out, height);
            }
        }
    }

    @Override
    public Object deserialize(byte[] serialized) throws IOException {
        int i;
        BPage<K, V> bpage = new BPage<K, V>();
        ByteArrayInputStream bais = new ByteArrayInputStream(serialized);
        ObjectInputStream ois = new ObjectInputStream(bais);
        bpage._isLeaf = ois.readBoolean();
        if (bpage._isLeaf) {
            bpage._previous = ois.readLong();
            bpage._next = ois.readLong();
        }
        bpage._first = ois.readInt();
        bpage._keys = new Object[this._btree._pageSize];
        ByteArrayDecompressor keyDecompressor = this._btree._keyCompressionProvider != null ? this._btree._keyCompressionProvider.getDecompressor(ois) : null;
        try {
            for (i = bpage._first; i < this._btree._pageSize; ++i) {
                if (this._btree._keySerializer == null) {
                    bpage._keys[i] = (Serializable)ois.readObject();
                    continue;
                }
                serialized = keyDecompressor != null ? keyDecompressor.decompressNextGroup() : BPage.readByteArray(ois);
                if (serialized == null) continue;
                bpage._keys[i] = (Serializable)this._btree._keySerializer.deserialize(serialized);
            }
        }
        catch (ClassNotFoundException except) {
            throw new IOException(except.getMessage());
        }
        if (bpage._isLeaf) {
            bpage._values = new Object[this._btree._pageSize];
            try {
                for (i = bpage._first; i < this._btree._pageSize; ++i) {
                    if (this._btree._valueSerializer == null) {
                        bpage._values[i] = (Serializable)ois.readObject();
                        continue;
                    }
                    serialized = BPage.readByteArray(ois);
                    if (serialized == null) continue;
                    bpage._values[i] = (Serializable)this._btree._valueSerializer.deserialize(serialized);
                }
            }
            catch (ClassNotFoundException except) {
                throw new IOException(except.getMessage());
            }
        } else {
            bpage._children = new long[this._btree._pageSize];
            for (i = bpage._first; i < this._btree._pageSize; ++i) {
                bpage._children[i] = ois.readLong();
            }
        }
        ois.close();
        bais.close();
        return bpage;
    }

    @Override
    public byte[] serialize(Object obj) throws IOException {
        byte[] serialized;
        int i;
        BPage bpage = (BPage)obj;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeBoolean(bpage._isLeaf);
        if (bpage._isLeaf) {
            oos.writeLong(bpage._previous);
            oos.writeLong(bpage._next);
        }
        oos.writeInt(bpage._first);
        ByteArrayCompressor keyCompressor = this._btree._keyCompressionProvider != null ? this._btree._keyCompressionProvider.getCompressor(oos) : null;
        for (i = bpage._first; i < this._btree._pageSize; ++i) {
            if (this._btree._keySerializer == null) {
                oos.writeObject(bpage._keys[i]);
                continue;
            }
            byte[] byArray = serialized = bpage._keys[i] != null ? this._btree._keySerializer.serialize(bpage._keys[i]) : null;
            if (keyCompressor != null) {
                keyCompressor.compressNextGroup(serialized);
                continue;
            }
            BPage.writeByteArray(oos, serialized);
        }
        if (keyCompressor != null) {
            keyCompressor.finishCompression();
        }
        if (bpage._isLeaf) {
            for (i = bpage._first; i < this._btree._pageSize; ++i) {
                if (this._btree._valueSerializer == null) {
                    oos.writeObject(bpage._values[i]);
                    continue;
                }
                if (bpage._values[i] != null) {
                    serialized = this._btree._valueSerializer.serialize(bpage._values[i]);
                    BPage.writeByteArray(oos, serialized);
                    continue;
                }
                BPage.writeByteArray(oos, null);
            }
        } else {
            for (i = bpage._first; i < this._btree._pageSize; ++i) {
                oos.writeLong(bpage._children[i]);
            }
        }
        oos.flush();
        byte[] data = baos.toByteArray();
        oos.close();
        baos.close();
        return data;
    }

    public static class Serializer0
    implements IStreamSerializer,
    Stateless {
        @Override
        public void serialize(DataOutput oos, Object obj) throws IOException {
            byte[] serialized;
            int i;
            ExtensibleSerializer ser = (ExtensibleSerializer)oos.getSerializationHandler();
            RecordManager recman = ser.getRecordManager();
            long recid = oos.getRecid();
            BPage bpage = (BPage)obj;
            BTree _btree = bpage._btree;
            if (_btree == null) {
                _btree = bpage._btree = BTree.load(recman, bpage._btreeId);
            }
            oos.writePackedLong(bpage._btreeId);
            oos.writeBoolean(bpage._isLeaf);
            if (bpage._isLeaf) {
                oos.writePackedLong(bpage._previous);
                oos.writePackedLong(bpage._next);
            }
            oos.writePackedInt(bpage._first);
            ByteArrayCompressor keyCompressor = _btree._keyCompressionProvider != null ? _btree._keyCompressionProvider.getCompressor(oos) : null;
            for (i = bpage._first; i < _btree._pageSize; ++i) {
                if (_btree._keySerializer == null) {
                    oos.serialize(bpage._keys[i]);
                    continue;
                }
                byte[] byArray = serialized = bpage._keys[i] != null ? _btree._keySerializer.serialize(bpage._keys[i]) : null;
                if (keyCompressor != null) {
                    keyCompressor.compressNextGroup(serialized);
                    continue;
                }
                oos.serialize(serialized);
            }
            if (keyCompressor != null) {
                keyCompressor.finishCompression();
            }
            if (bpage._isLeaf) {
                for (i = bpage._first; i < _btree._pageSize; ++i) {
                    if (_btree._valueSerializer == null) {
                        oos.serialize(bpage._values[i]);
                        continue;
                    }
                    if (bpage._values[i] != null) {
                        serialized = _btree._valueSerializer.serialize(bpage._values[i]);
                        oos.serialize(serialized);
                        continue;
                    }
                    oos.serialize(null);
                }
            } else {
                for (i = bpage._first; i < _btree._pageSize; ++i) {
                    oos.writePackedLong(bpage._children[i]);
                }
            }
        }

        @Override
        public Object deserialize(DataInput ois, Object obj) throws IOException {
            byte[] serialized;
            int i;
            ExtensibleSerializer ser = (ExtensibleSerializer)ois.getSerializationHandler();
            RecordManager recman = ser.getRecordManager();
            long recid = ois.getRecid();
            BPage bpage = (BPage)obj;
            BTree _btree = bpage._btree;
            bpage._btreeId = ois.readPackedLong();
            if (_btree == null) {
                _btree = bpage._btree = BTree.load(recman, bpage._btreeId);
            }
            bpage._isLeaf = ois.readBoolean();
            if (bpage._isLeaf) {
                bpage._previous = ois.readPackedLong();
                bpage._next = ois.readPackedLong();
            }
            bpage._first = ois.readPackedInt();
            bpage._keys = (Serializable[])new Object[_btree._pageSize];
            ByteArrayDecompressor keyDecompressor = _btree._keyCompressionProvider != null ? _btree._keyCompressionProvider.getDecompressor(ois) : null;
            for (i = bpage._first; i < _btree._pageSize; ++i) {
                if (_btree._keySerializer == null) {
                    bpage._keys[i] = (Serializable)ois.deserialize();
                    continue;
                }
                serialized = keyDecompressor != null ? keyDecompressor.decompressNextGroup() : (byte[])ois.deserialize();
                if (serialized == null) continue;
                bpage._keys[i] = (Serializable)_btree._keySerializer.deserialize(serialized);
            }
            if (bpage._isLeaf) {
                bpage._values = (Serializable[])new Object[_btree._pageSize];
                for (i = bpage._first; i < _btree._pageSize; ++i) {
                    if (_btree._valueSerializer == null) {
                        bpage._values[i] = (Serializable)ois.deserialize();
                        continue;
                    }
                    serialized = (byte[])ois.deserialize();
                    if (serialized == null) continue;
                    bpage._values[i] = (Serializable)_btree._valueSerializer.deserialize(serialized);
                }
            } else {
                bpage._children = new long[_btree._pageSize];
                for (i = bpage._first; i < _btree._pageSize; ++i) {
                    bpage._children[i] = ois.readPackedLong();
                }
            }
            return bpage;
        }
    }

    static class Browser<K extends Serializable, V extends Serializable>
    extends TupleBrowser<K, V> {
        private BPage<K, V> _page;
        private int _index;

        Browser(BPage<K, V> page, int index) {
            this._page = page;
            this._index = index;
        }

        @Override
        public boolean getNext(Tuple<K, V> tuple) throws IOException {
            if (this._index < this._page._btree._pageSize) {
                if (this._page._keys[this._index] == null) {
                    return false;
                }
            } else if (this._page._next != 0L) {
                this._page = ((BPage)this._page).loadBPage(this._page._next);
                this._index = this._page._first;
            }
            tuple.setKey((Serializable)this._page._keys[this._index]);
            tuple.setValue((Serializable)this._page._values[this._index]);
            ++this._index;
            return true;
        }

        @Override
        public boolean getPrevious(Tuple<K, V> tuple) throws IOException {
            if (this._index == this._page._first) {
                if (this._page._previous != 0L) {
                    this._page = ((BPage)this._page).loadBPage(this._page._previous);
                    this._index = this._page._btree._pageSize;
                } else {
                    return false;
                }
            }
            --this._index;
            tuple.setKey((Serializable)this._page._keys[this._index]);
            tuple.setValue((Serializable)this._page._values[this._index]);
            return true;
        }
    }

    static class RemoveResult<V> {
        boolean _underflow;
        V _value;

        RemoveResult() {
        }
    }

    static class InsertResult<K extends Serializable, V extends Serializable> {
        BPage<K, V> _overflow;
        V _existing;

        InsertResult() {
        }
    }
}

